/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Checkbox;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import rene.gui.IconBar;
import rene.gui.MyLabel;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.dialogs.ObjectEditDialog;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.TextObject;

class TextEditDialog
extends ObjectEditDialog {
    TextField X;
    TextField Y;
    Checkbox Fixed;
    IconBar TypeIB;

    public TextEditDialog(Frame frame, TextObject textObject) {
        super(frame, Zirkel.name("edit.text.title"), textObject);
    }

    public void addFirst(Panel panel) {
        TextObject textObject = (TextObject)this.O;
        this.X = new TextFieldAction(this, "X", "" + textObject.getX(), 30);
        panel.add(new MyLabel(Zirkel.name("edit.point.x")));
        panel.add(this.X);
        this.Y = new TextFieldAction(this, "Y", "" + textObject.getY(), 30);
        panel.add(new MyLabel(Zirkel.name("edit.point.y")));
        panel.add(this.Y);
        this.Fixed = new Checkbox("");
        this.Fixed.setState(textObject.fixed());
        panel.add(new MyLabel(Zirkel.name("edit.fixed")));
        panel.add(this.Fixed);
        if (textObject.fixed()) {
            this.X.setText(textObject.getEX());
            this.Y.setText(textObject.getEY());
        }
    }

    public void doAction(String string) {
        if ((string.equals("Y") || string.equals("X")) && this.Fixed != null) {
            this.Fixed.setState(true);
            super.doAction("OK");
        } else {
            super.doAction(string);
        }
    }

    public void setAction() {
        TextObject textObject = (TextObject)this.O;
        if (this.Fixed != null && this.Fixed.getState()) {
            textObject.setFixed(this.X.getText(), this.Y.getText());
        } else {
            try {
                double d2 = new Expression(this.X.getText(), textObject.getConstruction(), textObject).getValue();
                double d3 = new Expression(this.Y.getText(), textObject.getConstruction(), textObject).getValue();
                textObject.move(d2, d3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.Fixed != null && !this.Fixed.getState()) {
            textObject.setFixed(false);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.Fixed != null && this.Fixed.getState()) {
            this.X.requestFocus();
        } else {
            super.focusGained(focusEvent);
        }
    }

    public boolean showsValue() {
        return false;
    }
}

