# 2022-10-04 Triage Log

A great week, with 170 primary benchmark scenarios seeing improvement. Every PR
flagged by perf provided at least some wins, and perhaps more impressive: No
rollup PR's were flagged by perf this week! Furthermore, cjgillot fixed an issue
where incremental compilation was being unnecessarily hindered by our span and
lint system. Great work everyone!

Triage done by **@pnkfelix**.
Revision range: [d9297d22..02cd79af](https://perf.rust-lang.org/?start=d9297d22ad9edc2b56f0dd8734c1187a0c88be69&end=02cd79afb8080fce8c8ce35533c54d8ecf8f390e&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 1.2% | [0.4%, 1.9%] | 2     |
| Regressions ❌ <br /> (secondary) | 0.5% | [0.4%, 0.6%] | 6     |
| Improvements ✅ <br /> (primary) | -2.4% | [-31.0%, -0.2%] | 170   |
| Improvements ✅ <br /> (secondary) | -1.5% | [-5.8%, -0.3%] | 159   |
| All ❌✅ (primary) | -2.4% | [-31.0%, 1.9%] | 172   |


0 Regressions, 2 Improvements, 7 Mixed; 0 of them in rollups
54 artifact comparisons made in total

#### Regressions



#### Improvements

More lexer improvements [#102302](https://github.com/rust-lang/rust/pull/102302) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=837bf370de144a682041e68bb67469b9f68a55ce&end=6201eabde85db854c1ebb57624be5ec699246b50&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | 2.2% | [2.2%, 2.2%] | 1     |
| Improvements ✅ <br /> (primary) | -0.5% | [-1.0%, -0.2%] | 80    |
| Improvements ✅ <br /> (secondary) | -0.8% | [-1.8%, -0.3%] | 75    |
| All ❌✅ (primary) | -0.5% | [-1.0%, -0.2%] | 80    |


Inline a few functions. [#102387](https://github.com/rust-lang/rust/pull/102387) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b3aa4997d4817c5ea2b33ba20f6fe7c695e4f64c&end=4a0ee3cdc66573c8b46471462db7088a89d25183&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.4% | [-1.0%, -0.2%] | 60    |
| Improvements ✅ <br /> (secondary) | -0.8% | [-2.3%, -0.3%] | 42    |
| All ❌✅ (primary) | -0.4% | [-1.0%, -0.2%] | 60    |


#### Mixed

Rewrite and refactor format_args!() builtin macro. [#100996](https://github.com/rust-lang/rust/pull/100996) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=90c34fafcfa1d00ae25a165dc006e688761a5776&end=d6734be398fde0b078cde298e0d84eeccd71d08e&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | 1.5% | [1.1%, 2.0%] | 6     |
| Improvements ✅ <br /> (primary) | -0.3% | [-0.7%, -0.2%] | 7     |
| Improvements ✅ <br /> (secondary) | -1.2% | [-1.5%, -0.6%] | 7     |
| All ❌✅ (primary) | -0.3% | [-0.7%, -0.2%] | 7     |

* [already triaged](https://github.com/rust-lang/rust/pull/100996#issuecomment-1260438437)

rustdoc: Remove `clean::TraitWithExtraInfo` and queryify `is_notable_trait` [#102384](https://github.com/rust-lang/rust/pull/102384) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ce7f0f1aa0f02c45cad0749e63f3086234b1f422&end=b30c88623cf1f8f3e67b189fb2c5df5a0d89aaed&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.3% | [0.3%, 0.3%] | 1     |
| Regressions ❌ <br /> (secondary) | 2.7% | [2.7%, 2.7%] | 1     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -1.4% | [-1.7%, -1.2%] | 12    |
| All ❌✅ (primary) | 0.3% | [0.3%, 0.3%] | 1     |

* [already triaged](https://github.com/rust-lang/rust/pull/102384#issuecomment-1261912595)

Fix perf regression from TypeVisitor changes [#101893](https://github.com/rust-lang/rust/pull/101893) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=65445a571c11f07f4ca1ed0f63bad247ae295bd0&end=9f1a21ae2bd41b3dd335c44f38f29a1fb8712ddc&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | 1.4% | [1.2%, 1.6%] | 6     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -1.3% | [-2.9%, -0.5%] | 9     |
| All ❌✅ (primary) | -    | -     | 0     |

* [already triaged](https://github.com/rust-lang/rust/pull/101893#issuecomment-1262863099)

Shrink `hir::def::Res` [#101887](https://github.com/rust-lang/rust/pull/101887) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9c56d9d6fec6262bbb1549cfe466a812ae2c6523&end=1bb8d276c94c77a5fada815c5fad3b8d324adac4&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | 1.2% | [0.6%, 1.6%] | 7     |
| Improvements ✅ <br /> (primary) | -0.2% | [-0.3%, -0.2%] | 5     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.3%] | 2     |
| All ❌✅ (primary) | -0.2% | [-0.3%, -0.2%] | 5     |

* [already triaged](https://github.com/rust-lang/rust/pull/101887#issuecomment-1263228790)

Move lint level source explanation to the bottom [#101986](https://github.com/rust-lang/rust/pull/101986) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=277bb6653b55475b5fbce6309e9852fa2100dabe&end=744e397d8855f7da87d70aa8d0bd9e0f5f0b51a1&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | 1.0% | [0.9%, 1.0%] | 2     |
| Improvements ✅ <br /> (primary) | -0.3% | [-0.3%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.9% | [-1.4%, -0.3%] | 8     |
| All ❌✅ (primary) | -0.3% | [-0.3%, -0.2%] | 3     |

* [already triaged](https://github.com/rust-lang/rust/pull/101986#issuecomment-1264764911)

Compute lint levels by definition [#102236](https://github.com/rust-lang/rust/pull/102236) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=56a35bc906be1250a76fdb9a4b70e9261e10aec5&end=57f097ea25f2c05f424fc9b9dc50dbd6d399845c&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.6% | [0.3%, 0.9%] | 14    |
| Regressions ❌ <br /> (secondary) | 1.0% | [0.2%, 2.0%] | 20    |
| Improvements ✅ <br /> (primary) | -3.2% | [-30.2%, -0.2%] | 84    |
| Improvements ✅ <br /> (secondary) | -1.1% | [-2.8%, -0.3%] | 52    |
| All ❌✅ (primary) | -2.7% | [-30.2%, 0.9%] | 98    |


* based on reading of [#101620](https://github.com/rust-lang/rust/issues/101620), this was an important step for making incremental compilation apply to a much broader set of input code.
* the performance gains reported by perf seem well worth the cost that it registered.
* marked as triaged.

Mark Cell::replace() as #[inline] [#102548](https://github.com/rust-lang/rust/pull/102548) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c2590e6e892cce1105cc57b480aa07a51ae95fe5&end=756e7be5eb923ec955dfd8dec2a0d3ac81cfdf55&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.9% | [0.4%, 1.8%] | 3     |
| Regressions ❌ <br /> (secondary) | 0.9% | [0.2%, 1.3%] | 10    |
| Improvements ✅ <br /> (primary) | -0.3% | [-1.2%, -0.2%] | 14    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-1.9%, -0.2%] | 12    |
| All ❌✅ (primary) | -0.1% | [-1.2%, 1.8%] | 17    |

* PR had intermediate perf run reported stats that are somewhat better than what we actually ended up with in the end.
* did not mark as triaged; pinged a reviewer to confirm that this still meets acceptable criteria from their POV.


#### Untriaged Pull Requests

- [#102548 Mark Cell::replace() as #[inline]](https://github.com/rust-lang/rust/pull/102548)
- [#102236 Compute lint levels by definition](https://github.com/rust-lang/rust/pull/102236)
- [#101858 derive various impls instead of hand-rolling them](https://github.com/rust-lang/rust/pull/101858)
- [#101857 change `FnMutDelegate` to trait objects](https://github.com/rust-lang/rust/pull/101857)
- [#101620 Compute lint levels by definition](https://github.com/rust-lang/rust/pull/101620)
- [#101433 Emit a note that static bounds from HRTBs are a bug](https://github.com/rust-lang/rust/pull/101433)
- [#100982 Require `#[const_trait]` on `Trait` for `impl const Trait`](https://github.com/rust-lang/rust/pull/100982)
- [#100963 Rollup of 15 pull requests](https://github.com/rust-lang/rust/pull/100963)
- [#100869 Replace `rustc_data_structures::thin_vec::ThinVec` with `thin_vec::ThinVec`](https://github.com/rust-lang/rust/pull/100869)
- [#100841 update Miri](https://github.com/rust-lang/rust/pull/100841)
- [#100759 Make `const_eval_select` a real intrinsic](https://github.com/rust-lang/rust/pull/100759)
- [#100748 add `depth_limit` in `QueryVTable` to avoid entering a new tcx in `layout_of`](https://github.com/rust-lang/rust/pull/100748)
- [#100676 implied bounds: explicitly state which types are assumed to be wf](https://github.com/rust-lang/rust/pull/100676)
- [#100652 Remove deferred sized checks (make them eager)](https://github.com/rust-lang/rust/pull/100652)
- [#100497 Avoid cloning a collection only to iterate over it](https://github.com/rust-lang/rust/pull/100497)
- [#100429 rustdoc: Merge source code pages HTML elements together](https://github.com/rust-lang/rust/pull/100429)
- [#100293 Add inline-llvm option for disabling/enabling LLVM inlining](https://github.com/rust-lang/rust/pull/100293)
- [#100096 a fn pointer doesn't implement `Fn`/`FnMut`/`FnOnce` if its return type isn't sized](https://github.com/rust-lang/rust/pull/100096)
- [#99792 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/99792)
- [#99520 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/99520)
- [#99251 Upgrade indexmap and thorin-dwp to use hashbrown 0.12](https://github.com/rust-lang/rust/pull/99251)
- [#99231 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/99231)
- [#99210 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/99210)
- [#99126 remove allow(rustc::potential_query_instability) in rustc_span](https://github.com/rust-lang/rust/pull/99126)
- [#99123 proc_macro: use crossbeam channels for the proc_macro cross-thread bridge](https://github.com/rust-lang/rust/pull/99123)
- [#99102 Rework definition of MIR phases to more closely reflect semantic concerns](https://github.com/rust-lang/rust/pull/99102)
- [#99047 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/99047)
- [#99014 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/99014)
- [#98987 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/98987)
- [#98957  don't allow ZST in ScalarInt ](https://github.com/rust-lang/rust/pull/98957)
