% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{deleteDataColumn}
\alias{deleteDataColumn}
\title{Deletes a whole column from a workbook}
\usage{
deleteDataColumn(wb, sheet, col)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{col}{A column to delete}
}
\description{
Deletes the whole column from a workbook, shifting the remaining columns to the left
}
\examples{
## write some data
wb <- createWorkbook()
addWorksheet(wb, "tester")

for (i in seq(5)) {
  mat <- data.frame(x = rep(paste0(int2col(i), i), 10))
  writeData(wb, sheet = 1, startRow = 1, startCol = i, mat)
  writeFormula(wb, sheet = 1, startRow = 12, startCol = i,
               x = sprintf("=COUNTA(\%s2:\%s11)", int2col(i), int2col(i)))
}
deleteDataColumn(wb, 1, col = 3)
\dontrun{
saveWorkbook(wb, "deleteDataColumnExample.xlsx", overwrite = TRUE)
}
}
\author{
David Zimmermann
}
