
CREATE SCHEMA IF NOT EXISTS idro;

DROP TABLE IF EXISTS idro.cosmo_i5_snow CASCADE;

--
-- Name: cosmo_i5_snow; Type: TABLE; Schema: idro; Owner: -
--

CREATE TABLE idro.cosmo_i5_snow (
    rid integer NOT NULL,
    rast public.raster,
    filename text NOT NULL,
    data date,
    CONSTRAINT enforce_height_rast CHECK ((public.st_height(rast) = 54)),
    CONSTRAINT enforce_nodata_values_rast CHECK (((public._raster_constraint_nodata_values(rast))::numeric(16,10)[] = '{-9999.900390625}'::numeric(16,10)[])),
    CONSTRAINT enforce_num_bands_rast CHECK ((public.st_numbands(rast) = 1)),
    CONSTRAINT enforce_out_db_rast CHECK ((public._raster_constraint_out_db(rast) = '{f}'::boolean[])),
    CONSTRAINT enforce_pixel_types_rast CHECK ((public._raster_constraint_pixel_types(rast) = '{32BF}'::text[])),
    CONSTRAINT enforce_srid_rast CHECK ((public.st_srid(rast) = 32632)),
    CONSTRAINT enforce_width_rast CHECK ((public.st_width(rast) = 58))
);


--
-- Name: TABLE cosmo_i5_snow; Type: COMMENT; Schema: idro; Owner: -
--

COMMENT ON TABLE idro.cosmo_i5_snow IS 'raster di cosmo I5 orari con neve prevista - dati da Xmeteo4-Zenith';


--
-- Name: cosmo_i5_snow_rid_seq; Type: SEQUENCE; Schema: idro; Owner: -
--

CREATE SEQUENCE idro.cosmo_i5_snow_rid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cosmo_i5_snow_rid_seq; Type: SEQUENCE OWNED BY; Schema: idro; Owner: -
--

ALTER SEQUENCE idro.cosmo_i5_snow_rid_seq OWNED BY idro.cosmo_i5_snow.rid;


--
-- Name: cosmo_i5_snow rid; Type: DEFAULT; Schema: idro; Owner: -
--

ALTER TABLE ONLY idro.cosmo_i5_snow ALTER COLUMN rid SET DEFAULT nextval('idro.cosmo_i5_snow_rid_seq'::regclass);


--
-- Data for Name: cosmo_i5_snow; Type: TABLE DATA; Schema: idro; Owner: -
--

INSERT INTO idro.cosmo_i5_snow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h_048.tif', '2020-02-29');


--
-- Name: cosmo_i5_snow_rid_seq; Type: SEQUENCE SET; Schema: idro; Owner: -
--

SELECT pg_catalog.setval('idro.cosmo_i5_snow_rid_seq', 105, true);


--
-- Name: cosmo_i5_snow cosmo_i5_snow_pkey; Type: CONSTRAINT; Schema: idro; Owner: -
--

ALTER TABLE ONLY idro.cosmo_i5_snow
    ADD CONSTRAINT cosmo_i5_snow_pkey PRIMARY KEY (filename);


--
-- Name: cosmo_i5_snow_data_idx; Type: INDEX; Schema: idro; Owner: -
--

CREATE INDEX cosmo_i5_snow_data_idx ON idro.cosmo_i5_snow USING btree (data);


--
-- Name: cosmo_i5_snow_rast_gist; Type: INDEX; Schema: idro; Owner: -
--

CREATE INDEX cosmo_i5_snow_rast_gist ON idro.cosmo_i5_snow USING gist (public.st_convexhull(rast));
