/* Xtensa configuration-specific ISA information.

   Copyright (c) 2003-2015 Tensilica Inc.

   Permission is hereby granted, free of charge, to any person obtaining
   a copy of this software and associated documentation files (the
   "Software"), to deal in the Software without restriction, including
   without limitation the rights to use, copy, modify, merge, publish,
   distribute, sublicense, and/or sell copies of the Software, and to
   permit persons to whom the Software is furnished to do so, subject to
   the following conditions:

   The above copyright notice and this permission notice shall be included
   in all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
   CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
   TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
   SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.  */

#include "xtensa-isa.h"
#include "xtensa-isa-internal.h"


/* Sysregs.  */

static xtensa_sysreg_internal sysregs[] = {
  { "LBEG", 0, 0 },
  { "LEND", 1, 0 },
  { "LCOUNT", 2, 0 },
  { "BR", 4, 0 },
  { "ACCLO", 16, 0 },
  { "ACCHI", 17, 0 },
  { "M0", 32, 0 },
  { "M1", 33, 0 },
  { "M2", 34, 0 },
  { "M3", 35, 0 },
  { "PTEVADDR", 83, 0 },
  { "MMID", 89, 0 },
  { "DDR", 104, 0 },
  { "CONFIGID0", 176, 0 },
  { "CONFIGID1", 208, 0 },
  { "INTERRUPT", 226, 0 },
  { "INTCLEAR", 227, 0 },
  { "CCOUNT", 234, 0 },
  { "PRID", 235, 0 },
  { "ICOUNT", 236, 0 },
  { "CCOMPARE0", 240, 0 },
  { "CCOMPARE1", 241, 0 },
  { "CCOMPARE2", 242, 0 },
  { "VECBASE", 231, 0 },
  { "EPC1", 177, 0 },
  { "EPC2", 178, 0 },
  { "EPC3", 179, 0 },
  { "EPC4", 180, 0 },
  { "EPC5", 181, 0 },
  { "EPC6", 182, 0 },
  { "EPC7", 183, 0 },
  { "EXCSAVE1", 209, 0 },
  { "EXCSAVE2", 210, 0 },
  { "EXCSAVE3", 211, 0 },
  { "EXCSAVE4", 212, 0 },
  { "EXCSAVE5", 213, 0 },
  { "EXCSAVE6", 214, 0 },
  { "EXCSAVE7", 215, 0 },
  { "EPS2", 194, 0 },
  { "EPS3", 195, 0 },
  { "EPS4", 196, 0 },
  { "EPS5", 197, 0 },
  { "EPS6", 198, 0 },
  { "EPS7", 199, 0 },
  { "EXCCAUSE", 232, 0 },
  { "DEPC", 192, 0 },
  { "EXCVADDR", 238, 0 },
  { "WINDOWBASE", 72, 0 },
  { "WINDOWSTART", 73, 0 },
  { "SAR", 3, 0 },
  { "PS", 230, 0 },
  { "MISC0", 244, 0 },
  { "MISC1", 245, 0 },
  { "INTENABLE", 228, 0 },
  { "DBREAKA0", 144, 0 },
  { "DBREAKC0", 160, 0 },
  { "DBREAKA1", 145, 0 },
  { "DBREAKC1", 161, 0 },
  { "IBREAKA0", 128, 0 },
  { "IBREAKA1", 129, 0 },
  { "IBREAKENABLE", 96, 0 },
  { "ICOUNTLEVEL", 237, 0 },
  { "DEBUGCAUSE", 233, 0 },
  { "PREFCTL", 40, 0 },
  { "RASID", 90, 0 },
  { "ITLBCFG", 91, 0 },
  { "DTLBCFG", 92, 0 },
  { "CPENABLE", 224, 0 },
  { "SCOMPARE1", 12, 0 },
  { "ATOMCTL", 99, 0 },
  { "THREADPTR", 231, 1 },
  { "AE_OVF_SAR", 240, 1 },
  { "AE_BITHEAD", 241, 1 },
  { "AE_TS_FTS_BU_BP", 242, 1 },
  { "AE_SD_NO", 243, 1 },
  { "AE_CBEGIN0", 246, 1 },
  { "AE_CEND0", 247, 1 },
  { "EXPSTATE", 230, 1 }
};

#define NUM_SYSREGS 78
#define MAX_SPECIAL_REG 245
#define MAX_USER_REG 247


/* Processor states.  */

static xtensa_state_internal states[] = {
  { "LCOUNT", 32, 0 },
  { "PC", 32, 0 },
  { "ICOUNT", 32, 0 },
  { "DDR", 32, 0 },
  { "INTERRUPT", 22, 0 },
  { "CCOUNT", 32, 0 },
  { "XTSYNC", 1, 0 },
  { "VECBASE", 22, 0 },
  { "EPC1", 32, 0 },
  { "EPC2", 32, 0 },
  { "EPC3", 32, 0 },
  { "EPC4", 32, 0 },
  { "EPC5", 32, 0 },
  { "EPC6", 32, 0 },
  { "EPC7", 32, 0 },
  { "EXCSAVE1", 32, 0 },
  { "EXCSAVE2", 32, 0 },
  { "EXCSAVE3", 32, 0 },
  { "EXCSAVE4", 32, 0 },
  { "EXCSAVE5", 32, 0 },
  { "EXCSAVE6", 32, 0 },
  { "EXCSAVE7", 32, 0 },
  { "EPS2", 15, 0 },
  { "EPS3", 15, 0 },
  { "EPS4", 15, 0 },
  { "EPS5", 15, 0 },
  { "EPS6", 15, 0 },
  { "EPS7", 15, 0 },
  { "EXCCAUSE", 6, 0 },
  { "PSINTLEVEL", 4, 0 },
  { "PSUM", 1, 0 },
  { "PSWOE", 1, 0 },
  { "PSRING", 2, 0 },
  { "PSEXCM", 1, 0 },
  { "DEPC", 32, 0 },
  { "EXCVADDR", 32, 0 },
  { "WindowBase", 3, 0 },
  { "WindowStart", 8, 0 },
  { "PSCALLINC", 2, 0 },
  { "PSOWB", 4, 0 },
  { "LBEG", 32, 0 },
  { "LEND", 32, 0 },
  { "SAR", 6, 0 },
  { "THREADPTR", 32, 0 },
  { "MISC0", 32, 0 },
  { "MISC1", 32, 0 },
  { "ACC", 40, 0 },
  { "InOCDMode", 1, 0 },
  { "INTENABLE", 22, 0 },
  { "DBREAKA0", 32, 0 },
  { "DBREAKC0", 8, 0 },
  { "DBREAKA1", 32, 0 },
  { "DBREAKC1", 8, 0 },
  { "IBREAKA0", 32, 0 },
  { "IBREAKA1", 32, 0 },
  { "IBREAKENABLE", 2, 0 },
  { "ICOUNTLEVEL", 4, 0 },
  { "DEBUGCAUSE", 6, 0 },
  { "DBNUM", 4, 0 },
  { "CCOMPARE0", 32, 0 },
  { "CCOMPARE1", 32, 0 },
  { "CCOMPARE2", 32, 0 },
  { "PREFCTL", 9, 0 },
  { "ASID3", 8, 0 },
  { "ASID2", 8, 0 },
  { "ASID1", 8, 0 },
  { "INSTPGSZID6", 1, 0 },
  { "INSTPGSZID5", 1, 0 },
  { "INSTPGSZID4", 2, 0 },
  { "DATAPGSZID6", 1, 0 },
  { "DATAPGSZID5", 1, 0 },
  { "DATAPGSZID4", 2, 0 },
  { "PTBASE", 10, 0 },
  { "CPENABLE", 8, 0 },
  { "SCOMPARE1", 32, 0 },
  { "ATOMCTL", 6, 0 },
  { "ERI_RAW_INTERLOCK", 1, 0 },
  { "AE_OVERFLOW", 1, XTENSA_STATE_IS_SHARED_OR },
  { "AE_SAR", 6, 0 },
  { "AE_BITHEAD", 32, 0 },
  { "AE_BITPTR", 4, 0 },
  { "AE_BITSUSED", 4, 0 },
  { "AE_TABLESIZE", 4, 0 },
  { "AE_FIRST_TS", 4, 0 },
  { "AE_NEXTOFFSET", 27, 0 },
  { "AE_SEARCHDONE", 1, 0 },
  { "AE_CBEGIN0", 32, 0 },
  { "AE_CEND0", 32, 0 },
  { "EXPSTATE", 32, XTENSA_STATE_IS_EXPORTED }
};

#define NUM_STATES 89

enum xtensa_state_id {
  STATE_LCOUNT,
  STATE_PC,
  STATE_ICOUNT,
  STATE_DDR,
  STATE_INTERRUPT,
  STATE_CCOUNT,
  STATE_XTSYNC,
  STATE_VECBASE,
  STATE_EPC1,
  STATE_EPC2,
  STATE_EPC3,
  STATE_EPC4,
  STATE_EPC5,
  STATE_EPC6,
  STATE_EPC7,
  STATE_EXCSAVE1,
  STATE_EXCSAVE2,
  STATE_EXCSAVE3,
  STATE_EXCSAVE4,
  STATE_EXCSAVE5,
  STATE_EXCSAVE6,
  STATE_EXCSAVE7,
  STATE_EPS2,
  STATE_EPS3,
  STATE_EPS4,
  STATE_EPS5,
  STATE_EPS6,
  STATE_EPS7,
  STATE_EXCCAUSE,
  STATE_PSINTLEVEL,
  STATE_PSUM,
  STATE_PSWOE,
  STATE_PSRING,
  STATE_PSEXCM,
  STATE_DEPC,
  STATE_EXCVADDR,
  STATE_WindowBase,
  STATE_WindowStart,
  STATE_PSCALLINC,
  STATE_PSOWB,
  STATE_LBEG,
  STATE_LEND,
  STATE_SAR,
  STATE_THREADPTR,
  STATE_MISC0,
  STATE_MISC1,
  STATE_ACC,
  STATE_InOCDMode,
  STATE_INTENABLE,
  STATE_DBREAKA0,
  STATE_DBREAKC0,
  STATE_DBREAKA1,
  STATE_DBREAKC1,
  STATE_IBREAKA0,
  STATE_IBREAKA1,
  STATE_IBREAKENABLE,
  STATE_ICOUNTLEVEL,
  STATE_DEBUGCAUSE,
  STATE_DBNUM,
  STATE_CCOMPARE0,
  STATE_CCOMPARE1,
  STATE_CCOMPARE2,
  STATE_PREFCTL,
  STATE_ASID3,
  STATE_ASID2,
  STATE_ASID1,
  STATE_INSTPGSZID6,
  STATE_INSTPGSZID5,
  STATE_INSTPGSZID4,
  STATE_DATAPGSZID6,
  STATE_DATAPGSZID5,
  STATE_DATAPGSZID4,
  STATE_PTBASE,
  STATE_CPENABLE,
  STATE_SCOMPARE1,
  STATE_ATOMCTL,
  STATE_ERI_RAW_INTERLOCK,
  STATE_AE_OVERFLOW,
  STATE_AE_SAR,
  STATE_AE_BITHEAD,
  STATE_AE_BITPTR,
  STATE_AE_BITSUSED,
  STATE_AE_TABLESIZE,
  STATE_AE_FIRST_TS,
  STATE_AE_NEXTOFFSET,
  STATE_AE_SEARCHDONE,
  STATE_AE_CBEGIN0,
  STATE_AE_CEND0,
  STATE_EXPSTATE
};


/* Field definitions.  */

static unsigned
Field_t_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_s_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_r_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_op2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_op1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_op1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_op0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_n_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  return tie_t;
}

static void
Field_n_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_m_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  return tie_t;
}

static void
Field_m_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
}

static unsigned
Field_sr_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sr_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_st_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_st_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_thi3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  return tie_t;
}

static void
Field_thi3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_t3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_t3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_tlo_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  return tie_t;
}

static void
Field_tlo_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
}

static unsigned
Field_w_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_w_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_r3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_r3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_rhi_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_rhi_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_ae_r3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_ae_r3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_ae_r10_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_ae_r10_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_ae_r32_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_ae_r32_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_ae_s3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_ae_s3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_ae_s_non_samt_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_ae_s_non_samt_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_s3to1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_s3to1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_op0_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_t_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_op0_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_z_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_z_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_i_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_i_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_s_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ftsf42ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 12) >> 24);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf42ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 22) >> 24;
  insn[0] = (insn[0] & ~0xff000) | (tie_t << 12);
}

static unsigned
Field_op0_s3_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 25) >> 25);
  return tie_t;
}

static void
Field_op0_s3_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f) | (tie_t << 0);
}

static unsigned
Field_ftsf333ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 9) >> 29);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf333ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 26) >> 29;
  insn[0] = (insn[0] & ~0x700000) | (tie_t << 20);
}

static unsigned
Field_ftsf43ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf43ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 24) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_ftsf359ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf359ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
}

static unsigned
Field_ftsf45ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 9) | ((insn[0] << 16) >> 23);
  return tie_t;
}

static void
Field_ftsf45ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0xff80) | (tie_t << 7);
  tie_t = (val << 22) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf32ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf32ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf33ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf33ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf31ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf31ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf30ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf30ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf60ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 9) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf60ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x400000) | (tie_t << 22);
}

static unsigned
Field_ftsf355ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  return tie_t;
}

static void
Field_ftsf355ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_ftsf58ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 9) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf58ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x600000) | (tie_t << 21);
}

static unsigned
Field_ftsf354ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  return tie_t;
}

static void
Field_ftsf354ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_ftsf37ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf37ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ftsf22ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf22ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ftsf126ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 13) >> 30);
  return tie_t;
}

static void
Field_ftsf126ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60000) | (tie_t << 17);
}

static unsigned
Field_ftsf357ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 5) | ((insn[0] << 18) >> 27);
  return tie_t;
}

static void
Field_ftsf357ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e00) | (tie_t << 9);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf53ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 9) | ((insn[0] << 16) >> 23);
  return tie_t;
}

static void
Field_ftsf53ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0xff80) | (tie_t << 7);
  tie_t = (val << 22) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf66ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf66ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
}

static unsigned
Field_ftsf347ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 21) >> 30);
  return tie_t;
}

static void
Field_ftsf347ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x600) | (tie_t << 9);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_ftsf64ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf64ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_ftsf345ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_ftsf345ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_ftsf63ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 18) >> 25);
  return tie_t;
}

static void
Field_ftsf63ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x3f80) | (tie_t << 7);
}

static unsigned
Field_ftsf344ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_ftsf344ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_ftsf48ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 9) | ((insn[0] << 16) >> 23);
  return tie_t;
}

static void
Field_ftsf48ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0xff80) | (tie_t << 7);
  tie_t = (val << 22) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf47ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 9) | ((insn[0] << 16) >> 23);
  return tie_t;
}

static void
Field_ftsf47ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0xff80) | (tie_t << 7);
  tie_t = (val << 22) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf92ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf92ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 22) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf358ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  return tie_t;
}

static void
Field_ftsf358ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_ftsf94ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 9) >> 25);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf94ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 20) >> 25;
  insn[0] = (insn[0] & ~0x7f0000) | (tie_t << 16);
}

static unsigned
Field_ftsf93ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf93ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ae_r10_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_ae_r10_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_ftsf90ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf90ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 22) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf55_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_ftsf55_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_ftsf121ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 9) >> 24);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf121ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 21) >> 24;
  insn[0] = (insn[0] & ~0x7f8000) | (tie_t << 15);
}

static unsigned
Field_ftsf91_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_ftsf91_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_ftsf99ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 9) >> 27);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf99ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 22) >> 27;
  insn[0] = (insn[0] & ~0x7c0000) | (tie_t << 18);
}

static unsigned
Field_ftsf351_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  return tie_t;
}

static void
Field_ftsf351_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
}

static unsigned
Field_ftsf97ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 9) >> 26);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf97ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 21) >> 26;
  insn[0] = (insn[0] & ~0x7e0000) | (tie_t << 17);
}

static unsigned
Field_ftsf348ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_ftsf348ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_ftsf96ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 9) >> 25);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf96ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 20) >> 25;
  insn[0] = (insn[0] & ~0x7f0000) | (tie_t << 16);
}

static unsigned
Field_ftsf23ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf23ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf34ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf34ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf40ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 12) >> 24);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf40ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 22) >> 24;
  insn[0] = (insn[0] & ~0xff000) | (tie_t << 12);
}

static unsigned
Field_ftsf38ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 12) >> 24);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf38ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 22) >> 24;
  insn[0] = (insn[0] & ~0xff000) | (tie_t << 12);
}

static unsigned
Field_ftsf24ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf24ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf26ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf26ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf20ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf20ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_ftsf21ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf21ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_ftsf25ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf25ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf35ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf35ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf41ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 12) >> 24);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf41ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 22) >> 24;
  insn[0] = (insn[0] & ~0xff000) | (tie_t << 12);
}

static unsigned
Field_ftsf54ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf54ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_ftsf356ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_ftsf356ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_ftsf29ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf29ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf27ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf27ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf28ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf28ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf36ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf36ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf57ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 9) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf57ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x700000) | (tie_t << 20);
}

static unsigned
Field_ftsf62ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf62ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_ae_s20_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 9) >> 29);
  return tie_t;
}

static void
Field_ae_s20_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700000) | (tie_t << 20);
}

static unsigned
Field_ftsf56ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 9) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf56ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x700000) | (tie_t << 20);
}

static unsigned
Field_ftsf127ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  return tie_t;
}

static void
Field_ftsf127ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_ftsf350ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf350ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf114ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 9) >> 25);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf114ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 22) >> 25;
  insn[0] = (insn[0] & ~0x7f0000) | (tie_t << 16);
}

static unsigned
Field_ftsf124ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 9) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf124ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 26) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
  tie_t = (val << 24) >> 30;
  insn[0] = (insn[0] & ~0x600000) | (tie_t << 21);
}

static unsigned
Field_ftsf352ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 11) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_ftsf352ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x180000) | (tie_t << 19);
}

static unsigned
Field_ftsf118ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 9) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf118ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x7fc000) | (tie_t << 14);
}

static unsigned
Field_ftsf111ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 9) >> 25);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf111ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 22) >> 25;
  insn[0] = (insn[0] & ~0x7f0000) | (tie_t << 16);
}

static unsigned
Field_ftsf113ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 9) >> 25);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf113ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 22) >> 25;
  insn[0] = (insn[0] & ~0x7f0000) | (tie_t << 16);
}

static unsigned
Field_ftsf106ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf106ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 26) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_ftsf107ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf107ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 26) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_ftsf109ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 9) >> 25);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf109ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 22) >> 25;
  insn[0] = (insn[0] & ~0x7f0000) | (tie_t << 16);
}

static unsigned
Field_ftsf115ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 9) >> 25);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf115ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 22) >> 25;
  insn[0] = (insn[0] & ~0x7f0000) | (tie_t << 16);
}

static unsigned
Field_ftsf120ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 9) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf120ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x7fc000) | (tie_t << 14);
}

static unsigned
Field_ftsf123ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 9) >> 29);
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf123ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 26) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
  tie_t = (val << 23) >> 29;
  insn[0] = (insn[0] & ~0x700000) | (tie_t << 20);
}

static unsigned
Field_ftsf349ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_ftsf349ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf110ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 9) >> 25);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf110ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 22) >> 25;
  insn[0] = (insn[0] & ~0x7f0000) | (tie_t << 16);
}

static unsigned
Field_ftsf117ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 9) >> 25);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf117ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 22) >> 25;
  insn[0] = (insn[0] & ~0x7f0000) | (tie_t << 16);
}

static unsigned
Field_ftsf112ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 9) >> 25);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf112ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 22) >> 25;
  insn[0] = (insn[0] & ~0x7f0000) | (tie_t << 16);
}

static unsigned
Field_ftsf116ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 9) >> 25);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf116ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 22) >> 25;
  insn[0] = (insn[0] & ~0x7f0000) | (tie_t << 16);
}

static unsigned
Field_ftsf68ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf68ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
}

static unsigned
Field_ftsf50ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 9) | ((insn[0] << 16) >> 23);
  return tie_t;
}

static void
Field_ftsf50ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0xff80) | (tie_t << 7);
  tie_t = (val << 22) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf52ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 9) | ((insn[0] << 16) >> 23);
  return tie_t;
}

static void
Field_ftsf52ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0xff80) | (tie_t << 7);
  tie_t = (val << 22) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf51ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 9) | ((insn[0] << 16) >> 23);
  return tie_t;
}

static void
Field_ftsf51ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0xff80) | (tie_t << 7);
  tie_t = (val << 22) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf49ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 9) | ((insn[0] << 16) >> 23);
  return tie_t;
}

static void
Field_ftsf49ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0xff80) | (tie_t << 7);
  tie_t = (val << 22) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ae_r20_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  return tie_t;
}

static void
Field_ae_r20_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_ftsf343ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 18) >> 27);
  return tie_t;
}

static void
Field_ftsf343ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e00) | (tie_t << 9);
}

static unsigned
Field_ftsf125ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_ftsf125ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_ftsf342ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 21) >> 30);
  return tie_t;
}

static void
Field_ftsf342ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x600) | (tie_t << 9);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_ftsf108ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf108ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 26) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_ae_r32_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_ae_r32_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_ae_mul32x24fld_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ae_mul32x24fld_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf161ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf161ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf155ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf155ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf176ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf176ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf159ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf159ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf156ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf156ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf168ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf168ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf158ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf158ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf154ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf154ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf164ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf164ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf157ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf157ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf153ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf153ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf162ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf162ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf134ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf134ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf192ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf192ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf143ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf143ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf133ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf133ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf160ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf160ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf142ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf142ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf131ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf131ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf144ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf144ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf141ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf141ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf61_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 9) >> 31);
  return tie_t;
}

static void
Field_ftsf61_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400000) | (tie_t << 22);
}

static unsigned
Field_ftsf334ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 10) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf334ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x380000) | (tie_t << 19);
}

static unsigned
Field_ftsf136ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf136ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf139ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf139ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf177ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf177ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf171ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf171ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf185ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf185ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf175ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf175ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf172ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf172ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf183ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf183ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf174ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf174ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf170ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf170ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf182ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf182ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf173ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf173ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf169ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf169ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf181ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf181ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf140ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf140ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf152ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf152ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf138ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf138ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf148ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf148ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf137ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf137ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf146ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf146ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf135ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf135ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf145ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf145ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf179ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf179ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf189ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf189ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf184ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf184ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf187ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf187ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf180ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf180ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf188ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf188ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf178ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf178ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf186ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf186ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf76ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf76ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf75ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf75ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf79ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf79ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf78ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf78ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf80ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf80ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf81ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf81ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf83ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf83ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf82ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf82ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf69ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf69ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf103ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_ftsf103ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_ftsf337ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 21) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_ftsf337ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x600) | (tie_t << 9);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf71ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf71ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf70ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf70ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf77ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf77ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf73ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf73ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf74ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf74ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf72ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf72ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf85ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf85ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf84ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf84ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf86ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf86ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf102ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ftsf102ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ftsf336ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_ftsf336ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf89ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf89ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf87ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf87ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf88ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf88ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf101ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 9) >> 31);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_ftsf101ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x400000) | (tie_t << 22);
}

static unsigned
Field_ftsf335_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 10) >> 29);
  return tie_t;
}

static void
Field_ftsf335_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380000) | (tie_t << 19);
}

static unsigned
Field_t_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf196ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf196ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf208ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_ftsf208ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf341ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_ftsf341ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_ftsf200ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf200ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf340ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf340ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf195ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf195ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf198ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf198ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf197ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf197ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf199ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf199ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf201ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf201ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf204ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf204ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf202ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf202ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf203ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf203ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf205ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf205ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf207ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf207ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf206ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf206ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf210ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_ftsf210ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf339ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_ftsf339ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_ftsf128ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf128ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf130ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf130ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf129ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf129ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf132ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf132ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf147ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf147ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf150ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf150ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf149ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf149ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf151ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf151ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf163ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf163ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf166ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf166ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf165ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf165ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf167ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf167ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf190ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf190ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf193ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf193ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf191ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf191ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_ftsf194ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf194ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_combined2c0b5f72_fld132ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld132ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_combined2c0b5f72_fld69_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld69_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_combined2c0b5f72_fld68_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld68_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_combined2c0b5f72_fld19_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld19_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_combined2c0b5f72_fld22_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld22_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_op0_s3_s3_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 25) >> 25);
  return tie_t;
}

static void
Field_op0_s3_s3_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f) | (tie_t << 0);
}

static unsigned
Field_combined2c0b5f72_fld131ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld131ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_combined2c0b5f72_fld74_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 10) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld74_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200000) | (tie_t << 21);
}

static unsigned
Field_combined2c0b5f72_fld66_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld66_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_combined2c0b5f72_fld91_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 14) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld91_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20000) | (tie_t << 17);
}

static unsigned
Field_combined2c0b5f72_fld90_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld90_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_combined2c0b5f72_fld88_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld88_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_combined2c0b5f72_fld65_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld65_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_combined2c0b5f72_fld24_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld24_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_combined2c0b5f72_fld147ae_slot1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 9) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld147ae_slot1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400000) | (tie_t << 22);
}

static unsigned
Field_combined2c0b5f72_fld79_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 9) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld79_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400000) | (tie_t << 22);
}

static unsigned
Field_r_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 9) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x780000) | (tie_t << 19);
}

static unsigned
Field_op0_s4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 25) >> 25);
  return tie_t;
}

static void
Field_op0_s4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f) | (tie_t << 0);
}

static unsigned
Field_imm8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
}

static unsigned
Field_t_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 5) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x7800000) | (tie_t << 23);
}

static unsigned
Field_ftsf280_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 10) >> 29);
  return tie_t;
}

static void
Field_ftsf280_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380000) | (tie_t << 19);
}

static unsigned
Field_ftsf288_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 5) >> 31);
  return tie_t;
}

static void
Field_ftsf288_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000000) | (tie_t << 26);
}

static unsigned
Field_ftsf360ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 6) >> 29);
  return tie_t;
}

static void
Field_ftsf360ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x3800000) | (tie_t << 23);
}

static unsigned
Field_ftsf213ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 21) >> 28);
  return tie_t;
}

static void
Field_ftsf213ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x780) | (tie_t << 7);
}

static unsigned
Field_ftsf212ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_ftsf212ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
}

static unsigned
Field_ftsf211ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf211ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
}

static unsigned
Field_ftsf279ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 5) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 10) >> 29);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf279ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 21) >> 29;
  insn[0] = (insn[0] & ~0x380000) | (tie_t << 19);
  tie_t = (val << 17) >> 28;
  insn[0] = (insn[0] & ~0x7800000) | (tie_t << 23);
}

static unsigned
Field_s8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 9) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400000) | (tie_t << 22);
}

static unsigned
Field_ftsf313ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 13) >> 20);
  return tie_t;
}

static void
Field_ftsf313ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x7ff80) | (tie_t << 7);
}

static unsigned
Field_ftsf282ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 5) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 10) >> 29);
  tie_t = (tie_t << 7) | ((insn[0] << 17) >> 25);
  return tie_t;
}

static void
Field_ftsf282ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f00) | (tie_t << 8);
  tie_t = (val << 22) >> 29;
  insn[0] = (insn[0] & ~0x380000) | (tie_t << 19);
  tie_t = (val << 18) >> 28;
  insn[0] = (insn[0] & ~0x7800000) | (tie_t << 23);
}

static unsigned
Field_ftsf361ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 9) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_ftsf361ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x400000) | (tie_t << 22);
}

static unsigned
Field_ftsf281ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 5) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 10) >> 29);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf281ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 21) >> 29;
  insn[0] = (insn[0] & ~0x380000) | (tie_t << 19);
  tie_t = (val << 17) >> 28;
  insn[0] = (insn[0] & ~0x7800000) | (tie_t << 23);
}

static unsigned
Field_ftsf287ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 5) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 11) >> 30);
  tie_t = (tie_t << 7) | ((insn[0] << 17) >> 25);
  return tie_t;
}

static void
Field_ftsf287ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f00) | (tie_t << 8);
  tie_t = (val << 23) >> 30;
  insn[0] = (insn[0] & ~0x180000) | (tie_t << 19);
  tie_t = (val << 22) >> 31;
  insn[0] = (insn[0] & ~0x4000000) | (tie_t << 26);
}

static unsigned
Field_ftsf368ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 6) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_ftsf368ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0x3e00000) | (tie_t << 21);
}

static unsigned
Field_ftsf285ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 5) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 11) >> 30);
  tie_t = (tie_t << 7) | ((insn[0] << 17) >> 25);
  return tie_t;
}

static void
Field_ftsf285ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f00) | (tie_t << 8);
  tie_t = (val << 23) >> 30;
  insn[0] = (insn[0] & ~0x180000) | (tie_t << 19);
  tie_t = (val << 21) >> 30;
  insn[0] = (insn[0] & ~0x6000000) | (tie_t << 25);
}

static unsigned
Field_ftsf366ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 7) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_ftsf366ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x1e00000) | (tie_t << 21);
}

static unsigned
Field_ftsf284ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 5) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 11) >> 30);
  tie_t = (tie_t << 7) | ((insn[0] << 17) >> 25);
  return tie_t;
}

static void
Field_ftsf284ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f00) | (tie_t << 8);
  tie_t = (val << 23) >> 30;
  insn[0] = (insn[0] & ~0x180000) | (tie_t << 19);
  tie_t = (val << 20) >> 29;
  insn[0] = (insn[0] & ~0x7000000) | (tie_t << 24);
}

static unsigned
Field_ftsf364ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_ftsf364ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_ftsf297ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 11) >> 18);
  return tie_t;
}

static void
Field_ftsf297ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0x1fff80) | (tie_t << 7);
}

static unsigned
Field_ftsf309_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 10) >> 31);
  return tie_t;
}

static void
Field_ftsf309_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200000) | (tie_t << 21);
}

static unsigned
Field_ftsf327ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 5) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf327ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
  tie_t = (val << 21) >> 30;
  insn[0] = (insn[0] & ~0x6000000) | (tie_t << 25);
}

static unsigned
Field_ftsf363ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 7) >> 31);
  return tie_t;
}

static void
Field_ftsf363ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000000) | (tie_t << 24);
}

static unsigned
Field_ftsf214ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 18) >> 25);
  return tie_t;
}

static void
Field_ftsf214ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x3f80) | (tie_t << 7);
}

static unsigned
Field_ftsf298ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf298ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_ftsf373ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_ftsf373ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_ftsf302ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf302ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_ftsf376ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  return tie_t;
}

static void
Field_ftsf376ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_ftsf300ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf300ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 21) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_ftsf370ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_ftsf370ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_ae_s20_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 5) >> 29);
  return tie_t;
}

static void
Field_ae_s20_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000000) | (tie_t << 24);
}

static unsigned
Field_ftsf378ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 8) >> 27);
  return tie_t;
}

static void
Field_ftsf378ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80000) | (tie_t << 19);
}

static unsigned
Field_ftsf217ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf217ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf219ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf219ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf220ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf220ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf221ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf221ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf227ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf227ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf228ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf228ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf229ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf229ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf231ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf231ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf232ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf232ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf234ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf234ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf238ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf238ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf233ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf233ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf223ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf223ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf224ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf224ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf226ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf226ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf225ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf225ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf240ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf240ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf242ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf242ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf241ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf241ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf243ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf243ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf235ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf235ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf236ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf236ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf237ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf237ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf239ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf239ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf260ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf260ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf295ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf295ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf247ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf247ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf249ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf249ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf268ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf268ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf263ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf263ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf265ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf265ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf266ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf266ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf259ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf259ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf261ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf261ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf262ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf262ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf264ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf264ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf245ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf245ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf246ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf246ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf248ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf248ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf252ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf252ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf256ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf256ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf255ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf255ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf257ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf257ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf258ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf258ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf250ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf250ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf251ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf251ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf253ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf253ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf254ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf254ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf305ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 9) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf305ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0x600000) | (tie_t << 21);
}

static unsigned
Field_ftsf306ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 9) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf306ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0x600000) | (tie_t << 21);
}

static unsigned
Field_ftsf307ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 9) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf307ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0x600000) | (tie_t << 21);
}

static unsigned
Field_ftsf310ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 10) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf310ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x200000) | (tie_t << 21);
}

static unsigned
Field_ftsf304ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 9) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf304ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0x600000) | (tie_t << 21);
}

static unsigned
Field_ftsf308ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 10) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf308ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x200000) | (tie_t << 21);
}

static unsigned
Field_ae_r10_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 9) >> 30);
  return tie_t;
}

static void
Field_ae_r10_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x600000) | (tie_t << 21);
}

static unsigned
Field_ftsf329ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_ftsf329ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_ftsf379ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 9) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_ftsf379ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x600000) | (tie_t << 21);
}

static unsigned
Field_ftsf272ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 11) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf272ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0x180000) | (tie_t << 19);
}

static unsigned
Field_ftsf273ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 11) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf273ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0x180000) | (tie_t << 19);
}

static unsigned
Field_ftsf274ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 11) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf274ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0x180000) | (tie_t << 19);
}

static unsigned
Field_ftsf276ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 11) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf276ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0x180000) | (tie_t << 19);
}

static unsigned
Field_ftsf269ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 11) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf269ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0x180000) | (tie_t << 19);
}

static unsigned
Field_ftsf271ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 11) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf271ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0x180000) | (tie_t << 19);
}

static unsigned
Field_ftsf275ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 11) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf275ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0x180000) | (tie_t << 19);
}

static unsigned
Field_ftsf270ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 11) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf270ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0x180000) | (tie_t << 19);
}

static unsigned
Field_ftsf296ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 12) >> 19);
  return tie_t;
}

static void
Field_ftsf296ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0xfff80) | (tie_t << 7);
}

static unsigned
Field_ftsf315_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  return tie_t;
}

static void
Field_ftsf315_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
}

static unsigned
Field_combined2c0b5f72_fld52_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 14) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld52_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20000) | (tie_t << 17);
}

static unsigned
Field_combined1e9fefee_fld96_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_combined1e9fefee_fld96_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_combined1e9fefee_fld98_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_combined1e9fefee_fld98_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_combined2c0b5f72_fld49_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld49_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_combined2c0b5f72_fld39_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld39_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_combined2c0b5f72_fld50_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld50_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_combined2c0b5f72_fld40_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld40_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_ftsf362_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_ftsf362_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_op0_s4_s4_s4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 25) >> 25);
  return tie_t;
}

static void
Field_op0_s4_s4_s4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f) | (tie_t << 0);
}

static unsigned
Field_combined1e9fefee_fld109ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_combined1e9fefee_fld109ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_combined1e9fefee_fld108ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  return tie_t;
}

static void
Field_combined1e9fefee_fld108ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
}

static unsigned
Field_combined2c0b5f72_fld47_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld47_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_combined1e9fefee_fld107ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  return tie_t;
}

static void
Field_combined1e9fefee_fld107ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_combined1e9fefee_fld106ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  return tie_t;
}

static void
Field_combined1e9fefee_fld106ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_ftsf244ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf244ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf267ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf267ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf290ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 5) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf290ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
  tie_t = (val << 19) >> 28;
  insn[0] = (insn[0] & ~0x7800000) | (tie_t << 23);
}

static unsigned
Field_ftsf289ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 5) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf289ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
  tie_t = (val << 19) >> 28;
  insn[0] = (insn[0] & ~0x7800000) | (tie_t << 23);
}

static unsigned
Field_ftsf230ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf230ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf222ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf222ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf218ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf218ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf215ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf215ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ftsf314ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  tie_t = (tie_t << 12) | ((insn[0] << 13) >> 20);
  return tie_t;
}

static void
Field_ftsf314ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x7ff80) | (tie_t << 7);
  tie_t = (val << 19) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
}

static unsigned
Field_ftsf323ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 5) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf323ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0x7800000) | (tie_t << 23);
}

static unsigned
Field_ftsf322ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 5) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf322ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0x7800000) | (tie_t << 23);
}

static unsigned
Field_ftsf311ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 10) >> 31);
  tie_t = (tie_t << 7) | ((insn[0] << 17) >> 25);
  return tie_t;
}

static void
Field_ftsf311ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f00) | (tie_t << 8);
  tie_t = (val << 24) >> 31;
  insn[0] = (insn[0] & ~0x200000) | (tie_t << 21);
}

static unsigned
Field_ftsf386ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 5) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_ftsf386ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0x7c00000) | (tie_t << 22);
}

static unsigned
Field_ftsf278ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 5) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 11) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf278ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0x180000) | (tie_t << 19);
  tie_t = (val << 18) >> 28;
  insn[0] = (insn[0] & ~0x7800000) | (tie_t << 23);
}

static unsigned
Field_ftsf292ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 5) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 7) | ((insn[0] << 17) >> 25);
  return tie_t;
}

static void
Field_ftsf292ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f00) | (tie_t << 8);
  tie_t = (val << 24) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
  tie_t = (val << 21) >> 29;
  insn[0] = (insn[0] & ~0x7000000) | (tie_t << 24);
}

static unsigned
Field_ftsf382ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_ftsf382ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
}

static unsigned
Field_ftsf291ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 5) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 7) | ((insn[0] << 17) >> 25);
  return tie_t;
}

static void
Field_ftsf291ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f00) | (tie_t << 8);
  tie_t = (val << 24) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0x7800000) | (tie_t << 23);
}

static unsigned
Field_ftsf294ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 5) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 7) | ((insn[0] << 17) >> 25);
  return tie_t;
}

static void
Field_ftsf294ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f00) | (tie_t << 8);
  tie_t = (val << 24) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x4000000) | (tie_t << 26);
}

static unsigned
Field_ftsf383ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 6) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_ftsf383ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x3800000) | (tie_t << 23);
}

static unsigned
Field_ftsf293ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 5) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 7) | ((insn[0] << 17) >> 25);
  return tie_t;
}

static void
Field_ftsf293ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f00) | (tie_t << 8);
  tie_t = (val << 24) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0x6000000) | (tie_t << 25);
}

static unsigned
Field_ftsf384ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 7) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_ftsf384ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x1800000) | (tie_t << 23);
}

static unsigned
Field_ftsf312ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 15) >> 22);
  return tie_t;
}

static void
Field_ftsf312ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x1ff80) | (tie_t << 7);
}

static unsigned
Field_ftsf320ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf320ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_ftsf387ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 5) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 13) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_ftsf387ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x60000) | (tie_t << 17);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x7800000) | (tie_t << 23);
}

static unsigned
Field_ftsf319ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  tie_t = (tie_t << 10) | ((insn[0] << 15) >> 22);
  return tie_t;
}

static void
Field_ftsf319ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x1ff80) | (tie_t << 7);
  tie_t = (val << 21) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
}

static unsigned
Field_ftsf388ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 5) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 13) >> 30);
  return tie_t;
}

static void
Field_ftsf388ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60000) | (tie_t << 17);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0x7000000) | (tie_t << 24);
}

static unsigned
Field_ftsf317ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 10) | ((insn[0] << 15) >> 22);
  return tie_t;
}

static void
Field_ftsf317ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x1ff80) | (tie_t << 7);
  tie_t = (val << 21) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
  tie_t = (val << 20) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
}

static unsigned
Field_ftsf389ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 5) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 14) >> 31);
  return tie_t;
}

static void
Field_ftsf389ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20000) | (tie_t << 17);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x7000000) | (tie_t << 24);
}

static unsigned
Field_ftsf324ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 5) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf324ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0x7800000) | (tie_t << 23);
}

static unsigned
Field_ftsf325ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 5) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf325ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0x7800000) | (tie_t << 23);
}

static unsigned
Field_ftsf328ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 5) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf328ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x4000000) | (tie_t << 26);
}

static unsigned
Field_ftsf316ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  tie_t = (tie_t << 12) | ((insn[0] << 13) >> 20);
  return tie_t;
}

static void
Field_ftsf316ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x7ff80) | (tie_t << 7);
  tie_t = (val << 19) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
}

static unsigned
Field_ftsf326ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 5) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf326ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
  tie_t = (val << 21) >> 30;
  insn[0] = (insn[0] & ~0x6000000) | (tie_t << 25);
}

static unsigned
Field_ftsf277ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 5) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 11) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_ftsf277ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0x180000) | (tie_t << 19);
  tie_t = (val << 18) >> 28;
  insn[0] = (insn[0] & ~0x7800000) | (tie_t << 23);
}

static unsigned
Field_combined2c0b5f72_fld123_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 6) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld123_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000000) | (tie_t << 25);
}

static unsigned
Field_combined2c0b5f72_fld121_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 5) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld121_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000000) | (tie_t << 26);
}

static unsigned
Field_combined2c0b5f72_fld28_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld28_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_combined2c0b5f72_fld127_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld127_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_op0_s4_s4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 25) >> 25);
  return tie_t;
}

static void
Field_op0_s4_s4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f) | (tie_t << 0);
}

static unsigned
Field_combined2c0b5f72_fld149ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 17) >> 24);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld149ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f80) | (tie_t << 7);
}

static unsigned
Field_combined2c0b5f72_fld137ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld137ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_combined2c0b5f72_fld144ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld144ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_combined2c0b5f72_fld138ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld138ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_combined2c0b5f72_fld143ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld143ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_combined2c0b5f72_fld134ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld134ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_combined2c0b5f72_fld140ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld140ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_combined2c0b5f72_fld135ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld135ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_combined2c0b5f72_fld142ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld142ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_combined2c0b5f72_fld136ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld136ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_combined2c0b5f72_fld141ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld141ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_combined2c0b5f72_fld133ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld133ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_combined2c0b5f72_fld139ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld139ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_combined2c0b5f72_fld146ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld146ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_combined2c0b5f72_fld46_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld46_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_combined2c0b5f72_fld145ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld145ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_t_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_bbi4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_bbi4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_bbi_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_bbi_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_bbi_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 5) >> 27);
  return tie_t;
}

static void
Field_bbi_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00000) | (tie_t << 22);
}

static unsigned
Field_imm12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 20) >> 20);
  return tie_t;
}

static void
Field_imm12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff) | (tie_t << 0);
}

static unsigned
Field_imm12_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 5) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 17) >> 28);
  return tie_t;
}

static void
Field_imm12_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x7800) | (tie_t << 11);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0x7f80000) | (tie_t << 19);
}

static unsigned
Field_imm8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 24) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff) | (tie_t << 0);
}

static unsigned
Field_s_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_imm12b_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 24) >> 24);
  return tie_t;
}

static void
Field_imm12b_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff) | (tie_t << 0);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm12b_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 9) >> 20);
  return tie_t;
}

static void
Field_imm12b_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x7ff800) | (tie_t << 11);
}

static unsigned
Field_imm16_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 16) >> 16);
  return tie_t;
}

static void
Field_imm16_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff) | (tie_t << 0);
}

static unsigned
Field_imm16_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 9) >> 16);
  return tie_t;
}

static void
Field_imm16_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0x7fff80) | (tie_t << 7);
}

static unsigned
Field_offset_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 14) >> 14);
  return tie_t;
}

static void
Field_offset_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0x3ffff) | (tie_t << 0);
}

static unsigned
Field_offset_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 5) >> 14);
  return tie_t;
}

static void
Field_offset_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0x7fffe00) | (tie_t << 9);
}

static unsigned
Field_op2_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_r_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_sa4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_sa4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_sae4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_sae4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_sae_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_sae_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_sae_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_sal_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_sal_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 5) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_sal_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x7800000) | (tie_t << 23);
}

static unsigned
Field_sargt_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_sargt_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  return tie_t;
}

static void
Field_sargt_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_sas4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_sas4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_sas_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_sas_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_sas_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 5) >> 27);
  return tie_t;
}

static void
Field_sas_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00000) | (tie_t << 22);
}

static unsigned
Field_sr_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sr_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_sr_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sr_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_st_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_st_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_st_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_st_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_imm4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_imm4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_imm4_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm4_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_imm4_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm4_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_mn_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  return tie_t;
}

static void
Field_mn_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_i_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_i_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_imm6lo_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm6lo_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_imm6lo_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm6lo_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_imm6hi_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_imm6hi_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_imm6hi_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_imm6hi_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_imm7lo_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm7lo_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_imm7lo_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm7lo_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_imm7hi_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 21) >> 29);
  return tie_t;
}

static void
Field_imm7hi_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700) | (tie_t << 8);
}

static unsigned
Field_imm7hi_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 21) >> 29);
  return tie_t;
}

static void
Field_imm7hi_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700) | (tie_t << 8);
}

static unsigned
Field_z_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_z_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_imm6_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm6_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_imm6_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm6_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_imm7_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 21) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm7_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x700) | (tie_t << 8);
}

static unsigned
Field_imm7_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 21) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm7_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x700) | (tie_t << 8);
}

static unsigned
Field_rbit2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_rbit2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_tbit2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  return tie_t;
}

static void
Field_tbit2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_y_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  return tie_t;
}

static void
Field_y_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_x_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_x_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_t2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_t2_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_t2_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_t2_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_t2_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_s2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_s2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_s2_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_s2_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_s2_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_s2_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_r2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_r2_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_r2_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_t4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_t4_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_t4_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_s4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_s4_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_s4_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_s4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 9) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x600000) | (tie_t << 21);
}

static unsigned
Field_r4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_r4_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_r4_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_t8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_t8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_t8_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_t8_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_t8_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_t8_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_s8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_s8_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_s8_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_r8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_r8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_r8_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_r8_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
}

static unsigned
Field_r8_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_r8_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
}

static unsigned
Field_xt_wbr15_imm_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 8) >> 17);
  return tie_t;
}

static void
Field_xt_wbr15_imm_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0xfffe00) | (tie_t << 9);
}

static unsigned
Field_xt_wbr18_imm_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 8) >> 14);
  return tie_t;
}

static void
Field_xt_wbr18_imm_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffffc0) | (tie_t << 6);
}

static unsigned
Field_ae_r32_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 11) >> 30);
  return tie_t;
}

static void
Field_ae_r32_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180000) | (tie_t << 19);
}

static unsigned
Field_ae_samt_s_t_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  return tie_t;
}

static void
Field_ae_samt_s_t_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_ae_samt_s_t_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 5) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 13) >> 30);
  return tie_t;
}

static void
Field_ae_samt_s_t_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60000) | (tie_t << 17);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0x7800000) | (tie_t << 23);
}

static unsigned
Field_ae_r20_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 21) >> 29);
  return tie_t;
}

static void
Field_ae_r20_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700) | (tie_t << 8);
}

static unsigned
Field_ae_r20_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 9) >> 29);
  return tie_t;
}

static void
Field_ae_r20_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700000) | (tie_t << 20);
}

static unsigned
Field_ae_s20_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_ae_s20_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_ohba_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ohba_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ohba2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ohba2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ftsf11_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  return tie_t;
}

static void
Field_ftsf11_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_ftsf11_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_ftsf11_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_ftsf11_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  return tie_t;
}

static void
Field_ftsf11_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
}

static unsigned
Field_ftsf12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  return tie_t;
}

static void
Field_ftsf12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_ftsf12_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_ftsf12_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
}

static unsigned
Field_ftsf13_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ftsf13_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_combined2c0b5f72_fld37_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld37_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_combined2c0b5f72_fld148ae_slot0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 14) >> 21);
  return tie_t;
}

static void
Field_combined2c0b5f72_fld148ae_slot0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x3ff80) | (tie_t << 7);
}

static unsigned
Field_bitindex_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_bitindex_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_bitindex_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_bitindex_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_bitindex_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_bitindex_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_bitindex_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 5) >> 28);
  return tie_t;
}

static void
Field_bitindex_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x7800000) | (tie_t << 23);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_s3to1_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_s3to1_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_s3to1_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_s3to1_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_s3to1_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  return tie_t;
}

static void
Field_s3to1_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static void
Implicit_Field_set (xtensa_insnbuf insn ATTRIBUTE_UNUSED,
		    uint32 val ATTRIBUTE_UNUSED)
{
  /* Do nothing.  */
}

static unsigned
Implicit_Field_ar0_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_ar4_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 4;
}

static unsigned
Implicit_Field_ar8_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 8;
}

static unsigned
Implicit_Field_ar12_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 12;
}

static unsigned
Implicit_Field_mr0_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_mr1_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 1;
}

static unsigned
Implicit_Field_mr2_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 2;
}

static unsigned
Implicit_Field_mr3_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 3;
}

static unsigned
Implicit_Field_bt16_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_bs16_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_br16_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_brall_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

enum xtensa_field_id {
  FIELD_t,
  FIELD_bbi4,
  FIELD_bbi,
  FIELD_imm12,
  FIELD_imm8,
  FIELD_s,
  FIELD_imm12b,
  FIELD_imm16,
  FIELD_m,
  FIELD_n,
  FIELD_offset,
  FIELD_op0,
  FIELD_op1,
  FIELD_op2,
  FIELD_r,
  FIELD_sa4,
  FIELD_sae4,
  FIELD_sae,
  FIELD_sal,
  FIELD_sargt,
  FIELD_sas4,
  FIELD_sas,
  FIELD_sr,
  FIELD_st,
  FIELD_thi3,
  FIELD_imm4,
  FIELD_mn,
  FIELD_i,
  FIELD_imm6lo,
  FIELD_imm6hi,
  FIELD_imm7lo,
  FIELD_imm7hi,
  FIELD_z,
  FIELD_imm6,
  FIELD_imm7,
  FIELD_r3,
  FIELD_rbit2,
  FIELD_rhi,
  FIELD_t3,
  FIELD_tbit2,
  FIELD_tlo,
  FIELD_w,
  FIELD_y,
  FIELD_x,
  FIELD_t2,
  FIELD_s2,
  FIELD_r2,
  FIELD_t4,
  FIELD_s4,
  FIELD_r4,
  FIELD_t8,
  FIELD_s8,
  FIELD_r8,
  FIELD_xt_wbr15_imm,
  FIELD_xt_wbr18_imm,
  FIELD_ae_r3,
  FIELD_ae_s_non_samt,
  FIELD_ae_s3,
  FIELD_ae_r32,
  FIELD_ae_samt_s_t,
  FIELD_ae_r20,
  FIELD_ae_r10,
  FIELD_ae_s20,
  FIELD_ae_fld_ohba,
  FIELD_ae_fld_ohba2,
  FIELD_op0_s3,
  FIELD_ftsf11,
  FIELD_ftsf12,
  FIELD_ftsf13,
  FIELD_ftsf20ae_slot1,
  FIELD_ftsf21ae_slot1,
  FIELD_ftsf22ae_slot1,
  FIELD_ftsf23ae_slot1,
  FIELD_ftsf24ae_slot1,
  FIELD_ftsf25ae_slot1,
  FIELD_ftsf26ae_slot1,
  FIELD_ftsf27ae_slot1,
  FIELD_ftsf28ae_slot1,
  FIELD_ftsf29ae_slot1,
  FIELD_ftsf30ae_slot1,
  FIELD_ftsf31ae_slot1,
  FIELD_ftsf32ae_slot1,
  FIELD_ftsf33ae_slot1,
  FIELD_ftsf34ae_slot1,
  FIELD_ftsf35ae_slot1,
  FIELD_ftsf36ae_slot1,
  FIELD_ftsf37ae_slot1,
  FIELD_ftsf38ae_slot1,
  FIELD_ftsf40ae_slot1,
  FIELD_ftsf41ae_slot1,
  FIELD_ftsf42ae_slot1,
  FIELD_ftsf43ae_slot1,
  FIELD_ftsf45ae_slot1,
  FIELD_ftsf47ae_slot1,
  FIELD_ftsf48ae_slot1,
  FIELD_ftsf49ae_slot1,
  FIELD_ftsf50ae_slot1,
  FIELD_ftsf51ae_slot1,
  FIELD_ftsf52ae_slot1,
  FIELD_ftsf53ae_slot1,
  FIELD_ftsf54ae_slot1,
  FIELD_ftsf55,
  FIELD_ftsf56ae_slot1,
  FIELD_ftsf57ae_slot1,
  FIELD_ftsf58ae_slot1,
  FIELD_ftsf60ae_slot1,
  FIELD_ftsf61,
  FIELD_ftsf62ae_slot1,
  FIELD_ftsf63ae_slot1,
  FIELD_ftsf64ae_slot1,
  FIELD_ftsf66ae_slot1,
  FIELD_ftsf68ae_slot1,
  FIELD_ftsf69ae_slot1,
  FIELD_ftsf70ae_slot1,
  FIELD_ftsf71ae_slot1,
  FIELD_ftsf72ae_slot1,
  FIELD_ftsf73ae_slot1,
  FIELD_ftsf74ae_slot1,
  FIELD_ftsf75ae_slot1,
  FIELD_ftsf76ae_slot1,
  FIELD_ftsf77ae_slot1,
  FIELD_ftsf78ae_slot1,
  FIELD_ftsf79ae_slot1,
  FIELD_ftsf80ae_slot1,
  FIELD_ftsf81ae_slot1,
  FIELD_ftsf82ae_slot1,
  FIELD_ftsf83ae_slot1,
  FIELD_ftsf84ae_slot1,
  FIELD_ftsf85ae_slot1,
  FIELD_ftsf86ae_slot1,
  FIELD_ftsf87ae_slot1,
  FIELD_ftsf88ae_slot1,
  FIELD_ftsf89ae_slot1,
  FIELD_ftsf90ae_slot1,
  FIELD_ftsf91,
  FIELD_ftsf92ae_slot1,
  FIELD_ftsf93ae_slot1,
  FIELD_ftsf94ae_slot1,
  FIELD_ftsf96ae_slot1,
  FIELD_ftsf97ae_slot1,
  FIELD_ftsf99ae_slot1,
  FIELD_ftsf101ae_slot1,
  FIELD_ftsf102ae_slot1,
  FIELD_ftsf103ae_slot1,
  FIELD_ftsf106ae_slot1,
  FIELD_ftsf107ae_slot1,
  FIELD_ftsf108ae_slot1,
  FIELD_ftsf109ae_slot1,
  FIELD_ftsf110ae_slot1,
  FIELD_ftsf111ae_slot1,
  FIELD_ftsf112ae_slot1,
  FIELD_ftsf113ae_slot1,
  FIELD_ftsf114ae_slot1,
  FIELD_ftsf115ae_slot1,
  FIELD_ftsf116ae_slot1,
  FIELD_ftsf117ae_slot1,
  FIELD_ftsf118ae_slot1,
  FIELD_ftsf120ae_slot1,
  FIELD_ftsf121ae_slot1,
  FIELD_ftsf123ae_slot1,
  FIELD_ftsf124ae_slot1,
  FIELD_ftsf125ae_slot1,
  FIELD_ftsf126ae_slot1,
  FIELD_ftsf127ae_slot1,
  FIELD_ftsf128ae_slot1,
  FIELD_ftsf129ae_slot1,
  FIELD_ftsf130ae_slot1,
  FIELD_ftsf131ae_slot1,
  FIELD_ftsf132ae_slot1,
  FIELD_ftsf133ae_slot1,
  FIELD_ftsf134ae_slot1,
  FIELD_ftsf135ae_slot1,
  FIELD_ftsf136ae_slot1,
  FIELD_ftsf137ae_slot1,
  FIELD_ftsf138ae_slot1,
  FIELD_ftsf139ae_slot1,
  FIELD_ftsf140ae_slot1,
  FIELD_ftsf141ae_slot1,
  FIELD_ftsf142ae_slot1,
  FIELD_ftsf143ae_slot1,
  FIELD_ftsf144ae_slot1,
  FIELD_ftsf145ae_slot1,
  FIELD_ftsf146ae_slot1,
  FIELD_ftsf147ae_slot1,
  FIELD_ftsf148ae_slot1,
  FIELD_ftsf149ae_slot1,
  FIELD_ftsf150ae_slot1,
  FIELD_ftsf151ae_slot1,
  FIELD_ftsf152ae_slot1,
  FIELD_ftsf153ae_slot1,
  FIELD_ftsf154ae_slot1,
  FIELD_ftsf155ae_slot1,
  FIELD_ftsf156ae_slot1,
  FIELD_ftsf157ae_slot1,
  FIELD_ftsf158ae_slot1,
  FIELD_ftsf159ae_slot1,
  FIELD_ftsf160ae_slot1,
  FIELD_ftsf161ae_slot1,
  FIELD_ftsf162ae_slot1,
  FIELD_ftsf163ae_slot1,
  FIELD_ftsf164ae_slot1,
  FIELD_ftsf165ae_slot1,
  FIELD_ftsf166ae_slot1,
  FIELD_ftsf167ae_slot1,
  FIELD_ftsf168ae_slot1,
  FIELD_ftsf169ae_slot1,
  FIELD_ftsf170ae_slot1,
  FIELD_ftsf171ae_slot1,
  FIELD_ftsf172ae_slot1,
  FIELD_ftsf173ae_slot1,
  FIELD_ftsf174ae_slot1,
  FIELD_ftsf175ae_slot1,
  FIELD_ftsf176ae_slot1,
  FIELD_ftsf177ae_slot1,
  FIELD_ftsf178ae_slot1,
  FIELD_ftsf179ae_slot1,
  FIELD_ftsf180ae_slot1,
  FIELD_ftsf181ae_slot1,
  FIELD_ftsf182ae_slot1,
  FIELD_ftsf183ae_slot1,
  FIELD_ftsf184ae_slot1,
  FIELD_ftsf185ae_slot1,
  FIELD_ftsf186ae_slot1,
  FIELD_ftsf187ae_slot1,
  FIELD_ftsf188ae_slot1,
  FIELD_ftsf189ae_slot1,
  FIELD_ftsf190ae_slot1,
  FIELD_ftsf191ae_slot1,
  FIELD_ftsf192ae_slot1,
  FIELD_ftsf193ae_slot1,
  FIELD_ftsf194ae_slot1,
  FIELD_ftsf195ae_slot1,
  FIELD_ftsf196ae_slot1,
  FIELD_ftsf197ae_slot1,
  FIELD_ftsf198ae_slot1,
  FIELD_ftsf199ae_slot1,
  FIELD_ftsf200ae_slot1,
  FIELD_ftsf201ae_slot1,
  FIELD_ftsf202ae_slot1,
  FIELD_ftsf203ae_slot1,
  FIELD_ftsf204ae_slot1,
  FIELD_ftsf205ae_slot1,
  FIELD_ftsf206ae_slot1,
  FIELD_ftsf207ae_slot1,
  FIELD_ftsf208ae_slot1,
  FIELD_ftsf210ae_slot1,
  FIELD_ftsf333ae_slot1,
  FIELD_ftsf334ae_slot1,
  FIELD_ftsf335,
  FIELD_ftsf336ae_slot1,
  FIELD_ftsf337ae_slot1,
  FIELD_ftsf339ae_slot1,
  FIELD_ftsf340ae_slot1,
  FIELD_ftsf341ae_slot1,
  FIELD_ftsf342ae_slot1,
  FIELD_ftsf343ae_slot1,
  FIELD_ftsf344ae_slot1,
  FIELD_ftsf345ae_slot1,
  FIELD_ftsf347ae_slot1,
  FIELD_ftsf348ae_slot1,
  FIELD_ftsf349ae_slot1,
  FIELD_ftsf350ae_slot1,
  FIELD_ftsf351,
  FIELD_ftsf352ae_slot1,
  FIELD_ftsf354ae_slot1,
  FIELD_ftsf355ae_slot1,
  FIELD_ftsf356ae_slot1,
  FIELD_ftsf357ae_slot1,
  FIELD_ftsf358ae_slot1,
  FIELD_ftsf359ae_slot1,
  FIELD_op0_s4,
  FIELD_ftsf211ae_slot0,
  FIELD_ftsf212ae_slot0,
  FIELD_ftsf213ae_slot0,
  FIELD_ftsf214ae_slot0,
  FIELD_ftsf215ae_slot0,
  FIELD_ftsf217ae_slot0,
  FIELD_ftsf218ae_slot0,
  FIELD_ftsf219ae_slot0,
  FIELD_ftsf220ae_slot0,
  FIELD_ftsf221ae_slot0,
  FIELD_ftsf222ae_slot0,
  FIELD_ftsf223ae_slot0,
  FIELD_ftsf224ae_slot0,
  FIELD_ftsf225ae_slot0,
  FIELD_ftsf226ae_slot0,
  FIELD_ftsf227ae_slot0,
  FIELD_ftsf228ae_slot0,
  FIELD_ftsf229ae_slot0,
  FIELD_ftsf230ae_slot0,
  FIELD_ftsf231ae_slot0,
  FIELD_ftsf232ae_slot0,
  FIELD_ftsf233ae_slot0,
  FIELD_ftsf234ae_slot0,
  FIELD_ftsf235ae_slot0,
  FIELD_ftsf236ae_slot0,
  FIELD_ftsf237ae_slot0,
  FIELD_ftsf238ae_slot0,
  FIELD_ftsf239ae_slot0,
  FIELD_ftsf240ae_slot0,
  FIELD_ftsf241ae_slot0,
  FIELD_ftsf242ae_slot0,
  FIELD_ftsf243ae_slot0,
  FIELD_ftsf244ae_slot0,
  FIELD_ftsf245ae_slot0,
  FIELD_ftsf246ae_slot0,
  FIELD_ftsf247ae_slot0,
  FIELD_ftsf248ae_slot0,
  FIELD_ftsf249ae_slot0,
  FIELD_ftsf250ae_slot0,
  FIELD_ftsf251ae_slot0,
  FIELD_ftsf252ae_slot0,
  FIELD_ftsf253ae_slot0,
  FIELD_ftsf254ae_slot0,
  FIELD_ftsf255ae_slot0,
  FIELD_ftsf256ae_slot0,
  FIELD_ftsf257ae_slot0,
  FIELD_ftsf258ae_slot0,
  FIELD_ftsf259ae_slot0,
  FIELD_ftsf260ae_slot0,
  FIELD_ftsf261ae_slot0,
  FIELD_ftsf262ae_slot0,
  FIELD_ftsf263ae_slot0,
  FIELD_ftsf264ae_slot0,
  FIELD_ftsf265ae_slot0,
  FIELD_ftsf266ae_slot0,
  FIELD_ftsf267ae_slot0,
  FIELD_ftsf268ae_slot0,
  FIELD_ftsf269ae_slot0,
  FIELD_ftsf270ae_slot0,
  FIELD_ftsf271ae_slot0,
  FIELD_ftsf272ae_slot0,
  FIELD_ftsf273ae_slot0,
  FIELD_ftsf274ae_slot0,
  FIELD_ftsf275ae_slot0,
  FIELD_ftsf276ae_slot0,
  FIELD_ftsf277ae_slot0,
  FIELD_ftsf278ae_slot0,
  FIELD_ftsf279ae_slot0,
  FIELD_ftsf280,
  FIELD_ftsf281ae_slot0,
  FIELD_ftsf282ae_slot0,
  FIELD_ftsf284ae_slot0,
  FIELD_ftsf285ae_slot0,
  FIELD_ftsf287ae_slot0,
  FIELD_ftsf288,
  FIELD_ftsf289ae_slot0,
  FIELD_ftsf290ae_slot0,
  FIELD_ftsf291ae_slot0,
  FIELD_ftsf292ae_slot0,
  FIELD_ftsf293ae_slot0,
  FIELD_ftsf294ae_slot0,
  FIELD_ftsf295ae_slot0,
  FIELD_ftsf296ae_slot0,
  FIELD_ftsf297ae_slot0,
  FIELD_ftsf298ae_slot0,
  FIELD_ftsf300ae_slot0,
  FIELD_ftsf302ae_slot0,
  FIELD_ftsf304ae_slot0,
  FIELD_ftsf305ae_slot0,
  FIELD_ftsf306ae_slot0,
  FIELD_ftsf307ae_slot0,
  FIELD_ftsf308ae_slot0,
  FIELD_ftsf309,
  FIELD_ftsf310ae_slot0,
  FIELD_ftsf311ae_slot0,
  FIELD_ftsf312ae_slot0,
  FIELD_ftsf313ae_slot0,
  FIELD_ftsf314ae_slot0,
  FIELD_ftsf315,
  FIELD_ftsf316ae_slot0,
  FIELD_ftsf317ae_slot0,
  FIELD_ftsf319ae_slot0,
  FIELD_ftsf320ae_slot0,
  FIELD_ftsf322ae_slot0,
  FIELD_ftsf323ae_slot0,
  FIELD_ftsf324ae_slot0,
  FIELD_ftsf325ae_slot0,
  FIELD_ftsf326ae_slot0,
  FIELD_ftsf327ae_slot0,
  FIELD_ftsf328ae_slot0,
  FIELD_ftsf329ae_slot0,
  FIELD_ftsf360ae_slot0,
  FIELD_ftsf361ae_slot0,
  FIELD_ftsf362,
  FIELD_ftsf363ae_slot0,
  FIELD_ftsf364ae_slot0,
  FIELD_ftsf366ae_slot0,
  FIELD_ftsf368ae_slot0,
  FIELD_ftsf370ae_slot0,
  FIELD_ftsf373ae_slot0,
  FIELD_ftsf376ae_slot0,
  FIELD_ftsf378ae_slot0,
  FIELD_ftsf379ae_slot0,
  FIELD_ftsf382ae_slot0,
  FIELD_ftsf383ae_slot0,
  FIELD_ftsf384ae_slot0,
  FIELD_ftsf386ae_slot0,
  FIELD_ftsf387ae_slot0,
  FIELD_ftsf388ae_slot0,
  FIELD_ftsf389ae_slot0,
  FIELD_ae_mul32x24fld,
  FIELD_op0_s4_s4,
  FIELD_combined2c0b5f72_fld28,
  FIELD_combined2c0b5f72_fld37,
  FIELD_combined2c0b5f72_fld39,
  FIELD_combined2c0b5f72_fld40,
  FIELD_combined2c0b5f72_fld46,
  FIELD_combined2c0b5f72_fld47,
  FIELD_combined2c0b5f72_fld49,
  FIELD_combined2c0b5f72_fld50,
  FIELD_combined2c0b5f72_fld52,
  FIELD_combined2c0b5f72_fld121,
  FIELD_combined2c0b5f72_fld123,
  FIELD_combined2c0b5f72_fld127,
  FIELD_combined2c0b5f72_fld133ae_slot0,
  FIELD_combined2c0b5f72_fld134ae_slot0,
  FIELD_combined2c0b5f72_fld135ae_slot0,
  FIELD_combined2c0b5f72_fld136ae_slot0,
  FIELD_combined2c0b5f72_fld137ae_slot0,
  FIELD_combined2c0b5f72_fld138ae_slot0,
  FIELD_combined2c0b5f72_fld139ae_slot0,
  FIELD_combined2c0b5f72_fld140ae_slot0,
  FIELD_combined2c0b5f72_fld141ae_slot0,
  FIELD_combined2c0b5f72_fld142ae_slot0,
  FIELD_combined2c0b5f72_fld143ae_slot0,
  FIELD_combined2c0b5f72_fld144ae_slot0,
  FIELD_combined2c0b5f72_fld145ae_slot0,
  FIELD_combined2c0b5f72_fld146ae_slot0,
  FIELD_combined2c0b5f72_fld148ae_slot0,
  FIELD_combined2c0b5f72_fld149ae_slot0,
  FIELD_op0_s4_s4_s4,
  FIELD_combined1e9fefee_fld96,
  FIELD_combined1e9fefee_fld98,
  FIELD_combined1e9fefee_fld106ae_slot0,
  FIELD_combined1e9fefee_fld107ae_slot0,
  FIELD_combined1e9fefee_fld108ae_slot0,
  FIELD_combined1e9fefee_fld109ae_slot0,
  FIELD_op0_s3_s3,
  FIELD_combined2c0b5f72_fld19,
  FIELD_combined2c0b5f72_fld22,
  FIELD_combined2c0b5f72_fld24,
  FIELD_combined2c0b5f72_fld65,
  FIELD_combined2c0b5f72_fld66,
  FIELD_combined2c0b5f72_fld68,
  FIELD_combined2c0b5f72_fld69,
  FIELD_combined2c0b5f72_fld74,
  FIELD_combined2c0b5f72_fld79,
  FIELD_combined2c0b5f72_fld88,
  FIELD_combined2c0b5f72_fld90,
  FIELD_combined2c0b5f72_fld91,
  FIELD_combined2c0b5f72_fld131ae_slot1,
  FIELD_combined2c0b5f72_fld132ae_slot1,
  FIELD_combined2c0b5f72_fld147ae_slot1,
  FIELD_bitindex,
  FIELD_s3to1,
  FIELD__ar0,
  FIELD__ar4,
  FIELD__ar8,
  FIELD__ar12,
  FIELD__mr0,
  FIELD__mr1,
  FIELD__mr2,
  FIELD__mr3,
  FIELD__bt16,
  FIELD__bs16,
  FIELD__br16,
  FIELD__brall
};


/* Functional units.  */

static xtensa_funcUnit_internal funcUnits[] = {
  { "ae_add32", 1 },
  { "ae_shift32x4", 1 },
  { "ae_shift32x5", 1 },
  { "ae_subshift", 1 }
};

enum xtensa_funcUnit_id {
  FUNCUNIT_ae_add32,
  FUNCUNIT_ae_shift32x4,
  FUNCUNIT_ae_shift32x5,
  FUNCUNIT_ae_subshift
};


/* Register files.  */

enum xtensa_regfile_id {
  REGFILE_AR,
  REGFILE_MR,
  REGFILE_BR,
  REGFILE_AE_PR,
  REGFILE_AE_QR,
  REGFILE_BR2,
  REGFILE_BR4,
  REGFILE_BR8,
  REGFILE_BR16
};

static xtensa_regfile_internal regfiles[] = {
  { "AR", "a", REGFILE_AR, 32, 32 },
  { "MR", "m", REGFILE_MR, 32, 4 },
  { "BR", "b", REGFILE_BR, 1, 16 },
  { "AE_PR", "aep", REGFILE_AE_PR, 48, 8 },
  { "AE_QR", "aeq", REGFILE_AE_QR, 56, 4 },
  { "BR2", "b", REGFILE_BR, 2, 8 },
  { "BR4", "b", REGFILE_BR, 4, 4 },
  { "BR8", "b", REGFILE_BR, 8, 2 },
  { "BR16", "b", REGFILE_BR, 16, 1 }
};


/* Interfaces.  */

static xtensa_interface_internal interfaces[] = {
  { "ERI_RD_Out", 14, 0, 0, 'o' },
  { "ERI_RD_In", 32, 0, 1, 'i' },
  { "ERI_RD_Rdy", 1, 0, 0, 'i' },
  { "ERI_WR_Out", 46, 0, 2, 'o' },
  { "ERI_WR_In", 1, 0, 3, 'i' },
  { "IMPWIRE", 32, 0, 4, 'i' }
};

enum xtensa_interface_id {
  INTERFACE_ERI_RD_Out,
  INTERFACE_ERI_RD_In,
  INTERFACE_ERI_RD_Rdy,
  INTERFACE_ERI_WR_Out,
  INTERFACE_ERI_WR_In,
  INTERFACE_IMPWIRE
};


/* Constant tables.  */

/* constant table ai4c */
static const unsigned CONST_TBL_ai4c_0[] = {
  0xffffffff,
  0x1,
  0x2,
  0x3,
  0x4,
  0x5,
  0x6,
  0x7,
  0x8,
  0x9,
  0xa,
  0xb,
  0xc,
  0xd,
  0xe,
  0xf,
  0
};

/* constant table b4c */
static const unsigned CONST_TBL_b4c_0[] = {
  0xffffffff,
  0x1,
  0x2,
  0x3,
  0x4,
  0x5,
  0x6,
  0x7,
  0x8,
  0xa,
  0xc,
  0x10,
  0x20,
  0x40,
  0x80,
  0x100,
  0
};

/* constant table b4cu */
static const unsigned CONST_TBL_b4cu_0[] = {
  0x8000,
  0x10000,
  0x2,
  0x3,
  0x4,
  0x5,
  0x6,
  0x7,
  0x8,
  0xa,
  0xc,
  0x10,
  0x20,
  0x40,
  0x80,
  0x100,
  0
};


/* Instruction operands.  */

static int
OperandSem_opnd_sem_MR_0_decode (uint32 *valp)
{
  *valp += 2;
  return 0;
}

static int
OperandSem_opnd_sem_MR_0_encode (uint32 *valp)
{
  int error;
  error = ((*valp & ~0x3) != 0) || ((*valp & 0x2) == 0);
  *valp = *valp & 1;
  return error;
}

static int
OperandSem_opnd_sem_soffsetx4_decode (uint32 *valp)
{
  unsigned soffsetx4_out_0;
  unsigned soffsetx4_in_0;
  soffsetx4_in_0 = *valp & 0x3ffff;
  soffsetx4_out_0 = 0x4 + ((((int) soffsetx4_in_0 << 14) >> 14) << 2);
  *valp = soffsetx4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_soffsetx4_encode (uint32 *valp)
{
  unsigned soffsetx4_in_0;
  unsigned soffsetx4_out_0;
  soffsetx4_out_0 = *valp;
  soffsetx4_in_0 = ((soffsetx4_out_0 - 0x4) >> 2) & 0x3ffff;
  *valp = soffsetx4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm12x8_decode (uint32 *valp)
{
  unsigned uimm12x8_out_0;
  unsigned uimm12x8_in_0;
  uimm12x8_in_0 = *valp & 0xfff;
  uimm12x8_out_0 = uimm12x8_in_0 << 3;
  *valp = uimm12x8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm12x8_encode (uint32 *valp)
{
  unsigned uimm12x8_in_0;
  unsigned uimm12x8_out_0;
  uimm12x8_out_0 = *valp;
  uimm12x8_in_0 = ((uimm12x8_out_0 >> 3) & 0xfff);
  *valp = uimm12x8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm4_decode (uint32 *valp)
{
  unsigned simm4_out_0;
  unsigned simm4_in_0;
  simm4_in_0 = *valp & 0xf;
  simm4_out_0 = ((int) simm4_in_0 << 28) >> 28;
  *valp = simm4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm4_encode (uint32 *valp)
{
  unsigned simm4_in_0;
  unsigned simm4_out_0;
  simm4_out_0 = *valp;
  simm4_in_0 = (simm4_out_0 & 0xf);
  *valp = simm4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_AR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_AR_0_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_0_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_AR_1_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_1_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_AR_2_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_2_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_AR_3_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_3_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_AR_4_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_4_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_immrx4_decode (uint32 *valp)
{
  unsigned immrx4_out_0;
  unsigned immrx4_in_0;
  immrx4_in_0 = *valp & 0xf;
  immrx4_out_0 = (((0xfffffff) << 4) | immrx4_in_0) << 2;
  *valp = immrx4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_immrx4_encode (uint32 *valp)
{
  unsigned immrx4_in_0;
  unsigned immrx4_out_0;
  immrx4_out_0 = *valp;
  immrx4_in_0 = ((immrx4_out_0 >> 2) & 0xf);
  *valp = immrx4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_lsi4x4_decode (uint32 *valp)
{
  unsigned lsi4x4_out_0;
  unsigned lsi4x4_in_0;
  lsi4x4_in_0 = *valp & 0xf;
  lsi4x4_out_0 = lsi4x4_in_0 << 2;
  *valp = lsi4x4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_lsi4x4_encode (uint32 *valp)
{
  unsigned lsi4x4_in_0;
  unsigned lsi4x4_out_0;
  lsi4x4_out_0 = *valp;
  lsi4x4_in_0 = ((lsi4x4_out_0 >> 2) & 0xf);
  *valp = lsi4x4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm7_decode (uint32 *valp)
{
  unsigned simm7_out_0;
  unsigned simm7_in_0;
  simm7_in_0 = *valp & 0x7f;
  simm7_out_0 = ((((-((((simm7_in_0 >> 6) & 1)) & (((simm7_in_0 >> 5) & 1)))) & 0x1ffffff)) << 7) | simm7_in_0;
  *valp = simm7_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm7_encode (uint32 *valp)
{
  unsigned simm7_in_0;
  unsigned simm7_out_0;
  simm7_out_0 = *valp;
  simm7_in_0 = (simm7_out_0 & 0x7f);
  *valp = simm7_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm6_decode (uint32 *valp)
{
  unsigned uimm6_out_0;
  unsigned uimm6_in_0;
  uimm6_in_0 = *valp & 0x3f;
  uimm6_out_0 = 0x4 + (((0) << 6) | uimm6_in_0);
  *valp = uimm6_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm6_encode (uint32 *valp)
{
  unsigned uimm6_in_0;
  unsigned uimm6_out_0;
  uimm6_out_0 = *valp;
  uimm6_in_0 = (uimm6_out_0 - 0x4) & 0x3f;
  *valp = uimm6_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ai4const_decode (uint32 *valp)
{
  unsigned ai4const_out_0;
  unsigned ai4const_in_0;
  ai4const_in_0 = *valp & 0xf;
  ai4const_out_0 = CONST_TBL_ai4c_0[ai4const_in_0 & 0xf];
  *valp = ai4const_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ai4const_encode (uint32 *valp)
{
  unsigned ai4const_in_0;
  unsigned ai4const_out_0;
  ai4const_out_0 = *valp;
  switch (ai4const_out_0)
    {
    case 0xffffffff: ai4const_in_0 = 0; break;
    case 0x1: ai4const_in_0 = 0x1; break;
    case 0x2: ai4const_in_0 = 0x2; break;
    case 0x3: ai4const_in_0 = 0x3; break;
    case 0x4: ai4const_in_0 = 0x4; break;
    case 0x5: ai4const_in_0 = 0x5; break;
    case 0x6: ai4const_in_0 = 0x6; break;
    case 0x7: ai4const_in_0 = 0x7; break;
    case 0x8: ai4const_in_0 = 0x8; break;
    case 0x9: ai4const_in_0 = 0x9; break;
    case 0xa: ai4const_in_0 = 0xa; break;
    case 0xb: ai4const_in_0 = 0xb; break;
    case 0xc: ai4const_in_0 = 0xc; break;
    case 0xd: ai4const_in_0 = 0xd; break;
    case 0xe: ai4const_in_0 = 0xe; break;
    default: ai4const_in_0 = 0xf; break;
    }
  *valp = ai4const_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4const_decode (uint32 *valp)
{
  unsigned b4const_out_0;
  unsigned b4const_in_0;
  b4const_in_0 = *valp & 0xf;
  b4const_out_0 = CONST_TBL_b4c_0[b4const_in_0 & 0xf];
  *valp = b4const_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4const_encode (uint32 *valp)
{
  unsigned b4const_in_0;
  unsigned b4const_out_0;
  b4const_out_0 = *valp;
  switch (b4const_out_0)
    {
    case 0xffffffff: b4const_in_0 = 0; break;
    case 0x1: b4const_in_0 = 0x1; break;
    case 0x2: b4const_in_0 = 0x2; break;
    case 0x3: b4const_in_0 = 0x3; break;
    case 0x4: b4const_in_0 = 0x4; break;
    case 0x5: b4const_in_0 = 0x5; break;
    case 0x6: b4const_in_0 = 0x6; break;
    case 0x7: b4const_in_0 = 0x7; break;
    case 0x8: b4const_in_0 = 0x8; break;
    case 0xa: b4const_in_0 = 0x9; break;
    case 0xc: b4const_in_0 = 0xa; break;
    case 0x10: b4const_in_0 = 0xb; break;
    case 0x20: b4const_in_0 = 0xc; break;
    case 0x40: b4const_in_0 = 0xd; break;
    case 0x80: b4const_in_0 = 0xe; break;
    default: b4const_in_0 = 0xf; break;
    }
  *valp = b4const_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4constu_decode (uint32 *valp)
{
  unsigned b4constu_out_0;
  unsigned b4constu_in_0;
  b4constu_in_0 = *valp & 0xf;
  b4constu_out_0 = CONST_TBL_b4cu_0[b4constu_in_0 & 0xf];
  *valp = b4constu_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4constu_encode (uint32 *valp)
{
  unsigned b4constu_in_0;
  unsigned b4constu_out_0;
  b4constu_out_0 = *valp;
  switch (b4constu_out_0)
    {
    case 0x8000: b4constu_in_0 = 0; break;
    case 0x10000: b4constu_in_0 = 0x1; break;
    case 0x2: b4constu_in_0 = 0x2; break;
    case 0x3: b4constu_in_0 = 0x3; break;
    case 0x4: b4constu_in_0 = 0x4; break;
    case 0x5: b4constu_in_0 = 0x5; break;
    case 0x6: b4constu_in_0 = 0x6; break;
    case 0x7: b4constu_in_0 = 0x7; break;
    case 0x8: b4constu_in_0 = 0x8; break;
    case 0xa: b4constu_in_0 = 0x9; break;
    case 0xc: b4constu_in_0 = 0xa; break;
    case 0x10: b4constu_in_0 = 0xb; break;
    case 0x20: b4constu_in_0 = 0xc; break;
    case 0x40: b4constu_in_0 = 0xd; break;
    case 0x80: b4constu_in_0 = 0xe; break;
    default: b4constu_in_0 = 0xf; break;
    }
  *valp = b4constu_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8_decode (uint32 *valp)
{
  unsigned uimm8_out_0;
  unsigned uimm8_in_0;
  uimm8_in_0 = *valp & 0xff;
  uimm8_out_0 = uimm8_in_0;
  *valp = uimm8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8_encode (uint32 *valp)
{
  unsigned uimm8_in_0;
  unsigned uimm8_out_0;
  uimm8_out_0 = *valp;
  uimm8_in_0 = (uimm8_out_0 & 0xff);
  *valp = uimm8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x2_decode (uint32 *valp)
{
  unsigned uimm8x2_out_0;
  unsigned uimm8x2_in_0;
  uimm8x2_in_0 = *valp & 0xff;
  uimm8x2_out_0 = uimm8x2_in_0 << 1;
  *valp = uimm8x2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x2_encode (uint32 *valp)
{
  unsigned uimm8x2_in_0;
  unsigned uimm8x2_out_0;
  uimm8x2_out_0 = *valp;
  uimm8x2_in_0 = ((uimm8x2_out_0 >> 1) & 0xff);
  *valp = uimm8x2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x4_decode (uint32 *valp)
{
  unsigned uimm8x4_out_0;
  unsigned uimm8x4_in_0;
  uimm8x4_in_0 = *valp & 0xff;
  uimm8x4_out_0 = uimm8x4_in_0 << 2;
  *valp = uimm8x4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x4_encode (uint32 *valp)
{
  unsigned uimm8x4_in_0;
  unsigned uimm8x4_out_0;
  uimm8x4_out_0 = *valp;
  uimm8x4_in_0 = ((uimm8x4_out_0 >> 2) & 0xff);
  *valp = uimm8x4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm4x16_decode (uint32 *valp)
{
  unsigned uimm4x16_out_0;
  unsigned uimm4x16_in_0;
  uimm4x16_in_0 = *valp & 0xf;
  uimm4x16_out_0 = uimm4x16_in_0 << 4;
  *valp = uimm4x16_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm4x16_encode (uint32 *valp)
{
  unsigned uimm4x16_in_0;
  unsigned uimm4x16_out_0;
  uimm4x16_out_0 = *valp;
  uimm4x16_in_0 = ((uimm4x16_out_0 >> 4) & 0xf);
  *valp = uimm4x16_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8_decode (uint32 *valp)
{
  unsigned simm8_out_0;
  unsigned simm8_in_0;
  simm8_in_0 = *valp & 0xff;
  simm8_out_0 = ((int) simm8_in_0 << 24) >> 24;
  *valp = simm8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8_encode (uint32 *valp)
{
  unsigned simm8_in_0;
  unsigned simm8_out_0;
  simm8_out_0 = *valp;
  simm8_in_0 = (simm8_out_0 & 0xff);
  *valp = simm8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8x256_decode (uint32 *valp)
{
  unsigned simm8x256_out_0;
  unsigned simm8x256_in_0;
  simm8x256_in_0 = *valp & 0xff;
  simm8x256_out_0 = (((int) simm8x256_in_0 << 24) >> 24) << 8;
  *valp = simm8x256_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8x256_encode (uint32 *valp)
{
  unsigned simm8x256_in_0;
  unsigned simm8x256_out_0;
  simm8x256_out_0 = *valp;
  simm8x256_in_0 = ((simm8x256_out_0 >> 8) & 0xff);
  *valp = simm8x256_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm12b_decode (uint32 *valp)
{
  unsigned simm12b_out_0;
  unsigned simm12b_in_0;
  simm12b_in_0 = *valp & 0xfff;
  simm12b_out_0 = ((int) simm12b_in_0 << 20) >> 20;
  *valp = simm12b_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm12b_encode (uint32 *valp)
{
  unsigned simm12b_in_0;
  unsigned simm12b_out_0;
  simm12b_out_0 = *valp;
  simm12b_in_0 = (simm12b_out_0 & 0xfff);
  *valp = simm12b_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_msalp32_decode (uint32 *valp)
{
  unsigned msalp32_out_0;
  unsigned msalp32_in_0;
  msalp32_in_0 = *valp & 0x1f;
  msalp32_out_0 = 0x20 - msalp32_in_0;
  *valp = msalp32_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_msalp32_encode (uint32 *valp)
{
  unsigned msalp32_in_0;
  unsigned msalp32_out_0;
  msalp32_out_0 = *valp;
  msalp32_in_0 = (0x20 - msalp32_out_0) & 0x1f;
  *valp = msalp32_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_op2p1_decode (uint32 *valp)
{
  unsigned op2p1_out_0;
  unsigned op2p1_in_0;
  op2p1_in_0 = *valp & 0xf;
  op2p1_out_0 = op2p1_in_0 + 0x1;
  *valp = op2p1_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_op2p1_encode (uint32 *valp)
{
  unsigned op2p1_in_0;
  unsigned op2p1_out_0;
  op2p1_out_0 = *valp;
  op2p1_in_0 = (op2p1_out_0 - 0x1) & 0xf;
  *valp = op2p1_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_label8_decode (uint32 *valp)
{
  unsigned label8_out_0;
  unsigned label8_in_0;
  label8_in_0 = *valp & 0xff;
  label8_out_0 = 0x4 + (((int) label8_in_0 << 24) >> 24);
  *valp = label8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_label8_encode (uint32 *valp)
{
  unsigned label8_in_0;
  unsigned label8_out_0;
  label8_out_0 = *valp;
  label8_in_0 = (label8_out_0 - 0x4) & 0xff;
  *valp = label8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ulabel8_decode (uint32 *valp)
{
  unsigned ulabel8_out_0;
  unsigned ulabel8_in_0;
  ulabel8_in_0 = *valp & 0xff;
  ulabel8_out_0 = 0x4 + (((0) << 8) | ulabel8_in_0);
  *valp = ulabel8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ulabel8_encode (uint32 *valp)
{
  unsigned ulabel8_in_0;
  unsigned ulabel8_out_0;
  ulabel8_out_0 = *valp;
  ulabel8_in_0 = (ulabel8_out_0 - 0x4) & 0xff;
  *valp = ulabel8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_label12_decode (uint32 *valp)
{
  unsigned label12_out_0;
  unsigned label12_in_0;
  label12_in_0 = *valp & 0xfff;
  label12_out_0 = 0x4 + (((int) label12_in_0 << 20) >> 20);
  *valp = label12_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_label12_encode (uint32 *valp)
{
  unsigned label12_in_0;
  unsigned label12_out_0;
  label12_out_0 = *valp;
  label12_in_0 = (label12_out_0 - 0x4) & 0xfff;
  *valp = label12_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_soffset_decode (uint32 *valp)
{
  unsigned soffset_out_0;
  unsigned soffset_in_0;
  soffset_in_0 = *valp & 0x3ffff;
  soffset_out_0 = 0x4 + (((int) soffset_in_0 << 14) >> 14);
  *valp = soffset_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_soffset_encode (uint32 *valp)
{
  unsigned soffset_in_0;
  unsigned soffset_out_0;
  soffset_out_0 = *valp;
  soffset_in_0 = (soffset_out_0 - 0x4) & 0x3ffff;
  *valp = soffset_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm16x4_decode (uint32 *valp)
{
  unsigned uimm16x4_out_0;
  unsigned uimm16x4_in_0;
  uimm16x4_in_0 = *valp & 0xffff;
  uimm16x4_out_0 = (((0xffff) << 16) | uimm16x4_in_0) << 2;
  *valp = uimm16x4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm16x4_encode (uint32 *valp)
{
  unsigned uimm16x4_in_0;
  unsigned uimm16x4_out_0;
  uimm16x4_out_0 = *valp;
  uimm16x4_in_0 = (uimm16x4_out_0 >> 2) & 0xffff;
  *valp = uimm16x4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_bbi_decode (uint32 *valp)
{
  unsigned bbi_out_0;
  unsigned bbi_in_0;
  bbi_in_0 = *valp & 0x1f;
  bbi_out_0 = (0 << 5) | bbi_in_0;
  *valp = bbi_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_bbi_encode (uint32 *valp)
{
  unsigned bbi_in_0;
  unsigned bbi_out_0;
  bbi_out_0 = *valp;
  bbi_in_0 = (bbi_out_0 & 0x1f);
  *valp = bbi_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_s_decode (uint32 *valp)
{
  unsigned s_out_0;
  unsigned s_in_0;
  s_in_0 = *valp & 0xf;
  s_out_0 = (0 << 4) | s_in_0;
  *valp = s_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_s_encode (uint32 *valp)
{
  unsigned s_in_0;
  unsigned s_out_0;
  s_out_0 = *valp;
  s_in_0 = (s_out_0 & 0xf);
  *valp = s_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_MR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_MR_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_MR_1_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_MR_1_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_MR_2_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_MR_2_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_MR_3_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_MR_3_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_MR_4_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_MR_4_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_MR_5_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_MR_5_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_immt_decode (uint32 *valp)
{
  unsigned immt_out_0;
  unsigned immt_in_0;
  immt_in_0 = *valp & 0xf;
  immt_out_0 = immt_in_0;
  *valp = immt_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_immt_encode (uint32 *valp)
{
  unsigned immt_in_0;
  unsigned immt_out_0;
  immt_out_0 = *valp;
  immt_in_0 = immt_out_0 & 0xf;
  *valp = immt_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_BR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_BR_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16);
  return error;
}

static int
OperandSem_opnd_sem_BR2_decode (uint32 *valp)
{
  *valp = *valp << 1;
  return 0;
}

static int
OperandSem_opnd_sem_BR2_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16) || ((*valp & 1) != 0);
  *valp = *valp >> 1;
  return error;
}

static int
OperandSem_opnd_sem_BR4_decode (uint32 *valp)
{
  *valp = *valp << 2;
  return 0;
}

static int
OperandSem_opnd_sem_BR4_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16) || ((*valp & 3) != 0);
  *valp = *valp >> 2;
  return error;
}

static int
OperandSem_opnd_sem_BR8_decode (uint32 *valp)
{
  *valp = *valp << 3;
  return 0;
}

static int
OperandSem_opnd_sem_BR8_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16) || ((*valp & 7) != 0);
  *valp = *valp >> 3;
  return error;
}

static int
OperandSem_opnd_sem_BR16_decode (uint32 *valp)
{
  *valp = *valp << 4;
  return 0;
}

static int
OperandSem_opnd_sem_BR16_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16) || ((*valp & 15) != 0);
  *valp = *valp >> 4;
  return error;
}

static int
OperandSem_opnd_sem_tp7_decode (uint32 *valp)
{
  unsigned tp7_out_0;
  unsigned tp7_in_0;
  tp7_in_0 = *valp & 0xf;
  tp7_out_0 = tp7_in_0 + 0x7;
  *valp = tp7_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_tp7_encode (uint32 *valp)
{
  unsigned tp7_in_0;
  unsigned tp7_out_0;
  tp7_out_0 = *valp;
  tp7_in_0 = (tp7_out_0 - 0x7) & 0xf;
  *valp = tp7_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_xt_wbr15_label_decode (uint32 *valp)
{
  unsigned xt_wbr15_label_out_0;
  unsigned xt_wbr15_label_in_0;
  xt_wbr15_label_in_0 = *valp & 0x7fff;
  xt_wbr15_label_out_0 = 0x4 + (((int) xt_wbr15_label_in_0 << 17) >> 17);
  *valp = xt_wbr15_label_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_xt_wbr15_label_encode (uint32 *valp)
{
  unsigned xt_wbr15_label_in_0;
  unsigned xt_wbr15_label_out_0;
  xt_wbr15_label_out_0 = *valp;
  xt_wbr15_label_in_0 = (xt_wbr15_label_out_0 - 0x4) & 0x7fff;
  *valp = xt_wbr15_label_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_samt32_decode (uint32 *valp)
{
  unsigned ae_samt32_out_0;
  unsigned ae_samt32_in_0;
  ae_samt32_in_0 = *valp & 0x1f;
  ae_samt32_out_0 = (0 << 5) | ae_samt32_in_0;
  *valp = ae_samt32_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_samt32_encode (uint32 *valp)
{
  unsigned ae_samt32_in_0;
  unsigned ae_samt32_out_0;
  ae_samt32_out_0 = *valp;
  ae_samt32_in_0 = (ae_samt32_out_0 & 0x1f);
  *valp = ae_samt32_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_AE_PR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AE_PR_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 8);
  return error;
}

static int
OperandSem_opnd_sem_AE_QR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AE_QR_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_ae_lsimm16_decode (uint32 *valp)
{
  unsigned ae_lsimm16_out_0;
  unsigned ae_lsimm16_in_0;
  ae_lsimm16_in_0 = *valp & 0xf;
  ae_lsimm16_out_0 = (((int) ae_lsimm16_in_0 << 28) >> 28) << 1;
  *valp = ae_lsimm16_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_lsimm16_encode (uint32 *valp)
{
  unsigned ae_lsimm16_in_0;
  unsigned ae_lsimm16_out_0;
  ae_lsimm16_out_0 = *valp;
  ae_lsimm16_in_0 = ((ae_lsimm16_out_0 >> 1) & 0xf);
  *valp = ae_lsimm16_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_lsimm32_decode (uint32 *valp)
{
  unsigned ae_lsimm32_out_0;
  unsigned ae_lsimm32_in_0;
  ae_lsimm32_in_0 = *valp & 0xf;
  ae_lsimm32_out_0 = (((int) ae_lsimm32_in_0 << 28) >> 28) << 2;
  *valp = ae_lsimm32_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_lsimm32_encode (uint32 *valp)
{
  unsigned ae_lsimm32_in_0;
  unsigned ae_lsimm32_out_0;
  ae_lsimm32_out_0 = *valp;
  ae_lsimm32_in_0 = ((ae_lsimm32_out_0 >> 2) & 0xf);
  *valp = ae_lsimm32_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_lsimm64_decode (uint32 *valp)
{
  unsigned ae_lsimm64_out_0;
  unsigned ae_lsimm64_in_0;
  ae_lsimm64_in_0 = *valp & 0xf;
  ae_lsimm64_out_0 = (((int) ae_lsimm64_in_0 << 28) >> 28) << 3;
  *valp = ae_lsimm64_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_lsimm64_encode (uint32 *valp)
{
  unsigned ae_lsimm64_in_0;
  unsigned ae_lsimm64_out_0;
  ae_lsimm64_out_0 = *valp;
  ae_lsimm64_in_0 = ((ae_lsimm64_out_0 >> 3) & 0xf);
  *valp = ae_lsimm64_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_samt64_decode (uint32 *valp)
{
  unsigned ae_samt64_out_0;
  unsigned ae_samt64_in_0;
  ae_samt64_in_0 = *valp & 0x3f;
  ae_samt64_out_0 = (0 << 6) | ae_samt64_in_0;
  *valp = ae_samt64_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_samt64_encode (uint32 *valp)
{
  unsigned ae_samt64_in_0;
  unsigned ae_samt64_out_0;
  ae_samt64_out_0 = *valp;
  ae_samt64_in_0 = (ae_samt64_out_0 & 0x3f);
  *valp = ae_samt64_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_ohba_decode (uint32 *valp)
{
  unsigned ae_ohba_out_0;
  unsigned ae_ohba_in_0;
  ae_ohba_in_0 = *valp & 0xf;
  ae_ohba_out_0 = (0 << 5) | (((((ae_ohba_in_0 & 0xf))) == 0) << 4) | ((ae_ohba_in_0 & 0xf));
  *valp = ae_ohba_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_ohba_encode (uint32 *valp)
{
  unsigned ae_ohba_in_0;
  unsigned ae_ohba_out_0;
  ae_ohba_out_0 = *valp;
  ae_ohba_in_0 = (ae_ohba_out_0 & 0xf);
  *valp = ae_ohba_in_0;
  return 0;
}

static int
Operand_soffsetx4_ator (uint32 *valp, uint32 pc)
{
  *valp -= (pc & ~0x3);
  return 0;
}

static int
Operand_soffsetx4_rtoa (uint32 *valp, uint32 pc)
{
  *valp += (pc & ~0x3);
  return 0;
}

static int
Operand_uimm6_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_uimm6_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_label8_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_label8_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_ulabel8_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_ulabel8_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_label12_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_label12_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_soffset_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_soffset_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_uimm16x4_ator (uint32 *valp, uint32 pc)
{
  *valp -= ((pc + 3) & ~0x3);
  return 0;
}

static int
Operand_uimm16x4_rtoa (uint32 *valp, uint32 pc)
{
  *valp += ((pc + 3) & ~0x3);
  return 0;
}

static int
Operand_xt_wbr15_label_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_xt_wbr15_label_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_xt_wbr18_label_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_xt_wbr18_label_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static xtensa_operand_internal operands[] = {
  { "soffsetx4", FIELD_offset, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_soffsetx4_encode, OperandSem_opnd_sem_soffsetx4_decode,
    Operand_soffsetx4_ator, Operand_soffsetx4_rtoa },
  { "uimm12x8", FIELD_imm12, -1, 0,
    0,
    OperandSem_opnd_sem_uimm12x8_encode, OperandSem_opnd_sem_uimm12x8_decode,
    0, 0 },
  { "simm4", FIELD_mn, -1, 0,
    0,
    OperandSem_opnd_sem_simm4_encode, OperandSem_opnd_sem_simm4_decode,
    0, 0 },
  { "arr", FIELD_r, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "ars", FIELD_s, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "*ars_invisible", FIELD_s, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "art", FIELD_t, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "ar0", FIELD__ar0, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_0_encode, OperandSem_opnd_sem_AR_0_decode,
    0, 0 },
  { "ar4", FIELD__ar4, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_1_encode, OperandSem_opnd_sem_AR_1_decode,
    0, 0 },
  { "ar8", FIELD__ar8, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_2_encode, OperandSem_opnd_sem_AR_2_decode,
    0, 0 },
  { "ar12", FIELD__ar12, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_3_encode, OperandSem_opnd_sem_AR_3_decode,
    0, 0 },
  { "ars_entry", FIELD_s, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_4_encode, OperandSem_opnd_sem_AR_4_decode,
    0, 0 },
  { "immrx4", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_immrx4_encode, OperandSem_opnd_sem_immrx4_decode,
    0, 0 },
  { "lsi4x4", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_lsi4x4_encode, OperandSem_opnd_sem_lsi4x4_decode,
    0, 0 },
  { "simm7", FIELD_imm7, -1, 0,
    0,
    OperandSem_opnd_sem_simm7_encode, OperandSem_opnd_sem_simm7_decode,
    0, 0 },
  { "uimm6", FIELD_imm6, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_uimm6_encode, OperandSem_opnd_sem_uimm6_decode,
    Operand_uimm6_ator, Operand_uimm6_rtoa },
  { "ai4const", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_ai4const_encode, OperandSem_opnd_sem_ai4const_decode,
    0, 0 },
  { "b4const", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_b4const_encode, OperandSem_opnd_sem_b4const_decode,
    0, 0 },
  { "b4constu", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_b4constu_encode, OperandSem_opnd_sem_b4constu_decode,
    0, 0 },
  { "uimm8", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_uimm8_encode, OperandSem_opnd_sem_uimm8_decode,
    0, 0 },
  { "uimm8x2", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_uimm8x2_encode, OperandSem_opnd_sem_uimm8x2_decode,
    0, 0 },
  { "uimm8x4", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_uimm8x4_encode, OperandSem_opnd_sem_uimm8x4_decode,
    0, 0 },
  { "uimm4x16", FIELD_op2, -1, 0,
    0,
    OperandSem_opnd_sem_uimm4x16_encode, OperandSem_opnd_sem_uimm4x16_decode,
    0, 0 },
  { "uimmrx4", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_lsi4x4_encode, OperandSem_opnd_sem_lsi4x4_decode,
    0, 0 },
  { "simm8", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_simm8_encode, OperandSem_opnd_sem_simm8_decode,
    0, 0 },
  { "simm8x256", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_simm8x256_encode, OperandSem_opnd_sem_simm8x256_decode,
    0, 0 },
  { "simm12b", FIELD_imm12b, -1, 0,
    0,
    OperandSem_opnd_sem_simm12b_encode, OperandSem_opnd_sem_simm12b_decode,
    0, 0 },
  { "msalp32", FIELD_sal, -1, 0,
    0,
    OperandSem_opnd_sem_msalp32_encode, OperandSem_opnd_sem_msalp32_decode,
    0, 0 },
  { "op2p1", FIELD_op2, -1, 0,
    0,
    OperandSem_opnd_sem_op2p1_encode, OperandSem_opnd_sem_op2p1_decode,
    0, 0 },
  { "label8", FIELD_imm8, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_label8_encode, OperandSem_opnd_sem_label8_decode,
    Operand_label8_ator, Operand_label8_rtoa },
  { "ulabel8", FIELD_imm8, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_ulabel8_encode, OperandSem_opnd_sem_ulabel8_decode,
    Operand_ulabel8_ator, Operand_ulabel8_rtoa },
  { "label12", FIELD_imm12, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_label12_encode, OperandSem_opnd_sem_label12_decode,
    Operand_label12_ator, Operand_label12_rtoa },
  { "soffset", FIELD_offset, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_soffset_encode, OperandSem_opnd_sem_soffset_decode,
    Operand_soffset_ator, Operand_soffset_rtoa },
  { "uimm16x4", FIELD_imm16, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_uimm16x4_encode, OperandSem_opnd_sem_uimm16x4_decode,
    Operand_uimm16x4_ator, Operand_uimm16x4_rtoa },
  { "bbi", FIELD_bbi, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0 },
  { "sae", FIELD_sae, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0 },
  { "sas", FIELD_sas, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0 },
  { "sargt", FIELD_sargt, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0 },
  { "s", FIELD_s, -1, 0,
    0,
    OperandSem_opnd_sem_s_encode, OperandSem_opnd_sem_s_decode,
    0, 0 },
  { "mx", FIELD_x, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_UNKNOWN,
    OperandSem_opnd_sem_MR_encode, OperandSem_opnd_sem_MR_decode,
    0, 0 },
  { "my", FIELD_y, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_UNKNOWN,
    OperandSem_opnd_sem_MR_0_encode, OperandSem_opnd_sem_MR_0_decode,
    0, 0 },
  { "mw", FIELD_w, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_MR_1_encode, OperandSem_opnd_sem_MR_1_decode,
    0, 0 },
  { "mr0", FIELD__mr0, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_MR_2_encode, OperandSem_opnd_sem_MR_2_decode,
    0, 0 },
  { "mr1", FIELD__mr1, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_MR_3_encode, OperandSem_opnd_sem_MR_3_decode,
    0, 0 },
  { "mr2", FIELD__mr2, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_MR_4_encode, OperandSem_opnd_sem_MR_4_decode,
    0, 0 },
  { "mr3", FIELD__mr3, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_MR_5_encode, OperandSem_opnd_sem_MR_5_decode,
    0, 0 },
  { "immt", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_immt_encode, OperandSem_opnd_sem_immt_decode,
    0, 0 },
  { "imms", FIELD_s, -1, 0,
    0,
    OperandSem_opnd_sem_immt_encode, OperandSem_opnd_sem_immt_decode,
    0, 0 },
  { "bt", FIELD_t, REGFILE_BR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR_encode, OperandSem_opnd_sem_BR_decode,
    0, 0 },
  { "bs", FIELD_s, REGFILE_BR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR_encode, OperandSem_opnd_sem_BR_decode,
    0, 0 },
  { "br", FIELD_r, REGFILE_BR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR_encode, OperandSem_opnd_sem_BR_decode,
    0, 0 },
  { "bt2", FIELD_t2, REGFILE_BR, 2,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR2_encode, OperandSem_opnd_sem_BR2_decode,
    0, 0 },
  { "bs2", FIELD_s2, REGFILE_BR, 2,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR2_encode, OperandSem_opnd_sem_BR2_decode,
    0, 0 },
  { "br2", FIELD_r2, REGFILE_BR, 2,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR2_encode, OperandSem_opnd_sem_BR2_decode,
    0, 0 },
  { "bt4", FIELD_t4, REGFILE_BR, 4,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR4_encode, OperandSem_opnd_sem_BR4_decode,
    0, 0 },
  { "bs4", FIELD_s4, REGFILE_BR, 4,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR4_encode, OperandSem_opnd_sem_BR4_decode,
    0, 0 },
  { "br4", FIELD_r4, REGFILE_BR, 4,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR4_encode, OperandSem_opnd_sem_BR4_decode,
    0, 0 },
  { "bt8", FIELD_t8, REGFILE_BR, 8,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR8_encode, OperandSem_opnd_sem_BR8_decode,
    0, 0 },
  { "bs8", FIELD_s8, REGFILE_BR, 8,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR8_encode, OperandSem_opnd_sem_BR8_decode,
    0, 0 },
  { "br8", FIELD_r8, REGFILE_BR, 8,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR8_encode, OperandSem_opnd_sem_BR8_decode,
    0, 0 },
  { "bt16", FIELD__bt16, REGFILE_BR, 16,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR16_encode, OperandSem_opnd_sem_BR16_decode,
    0, 0 },
  { "bs16", FIELD__bs16, REGFILE_BR, 16,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR16_encode, OperandSem_opnd_sem_BR16_decode,
    0, 0 },
  { "br16", FIELD__br16, REGFILE_BR, 16,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR16_encode, OperandSem_opnd_sem_BR16_decode,
    0, 0 },
  { "brall", FIELD__brall, REGFILE_BR, 16,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_BR16_encode, OperandSem_opnd_sem_BR16_decode,
    0, 0 },
  { "tp7", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_tp7_encode, OperandSem_opnd_sem_tp7_decode,
    0, 0 },
  { "xt_wbr15_label", FIELD_xt_wbr15_imm, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_xt_wbr15_label_encode, OperandSem_opnd_sem_xt_wbr15_label_decode,
    Operand_xt_wbr15_label_ator, Operand_xt_wbr15_label_rtoa },
  { "xt_wbr18_label", FIELD_xt_wbr18_imm, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_soffset_encode, OperandSem_opnd_sem_soffset_decode,
    Operand_xt_wbr18_label_ator, Operand_xt_wbr18_label_rtoa },
  { "ae_samt32", FIELD_ftsf13, -1, 0,
    0,
    OperandSem_opnd_sem_ae_samt32_encode, OperandSem_opnd_sem_ae_samt32_decode,
    0, 0 },
  { "pr0", FIELD_ftsf11, REGFILE_AE_PR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_PR_encode, OperandSem_opnd_sem_AE_PR_decode,
    0, 0 },
  { "qr0", FIELD_ftsf12, REGFILE_AE_QR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_QR_encode, OperandSem_opnd_sem_AE_QR_decode,
    0, 0 },
  { "mac_qr0", FIELD_ftsf12, REGFILE_AE_QR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_QR_encode, OperandSem_opnd_sem_AE_QR_decode,
    0, 0 },
  { "ae_lsimm16", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_ae_lsimm16_encode, OperandSem_opnd_sem_ae_lsimm16_decode,
    0, 0 },
  { "ae_lsimm32", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_ae_lsimm32_encode, OperandSem_opnd_sem_ae_lsimm32_decode,
    0, 0 },
  { "ae_lsimm64", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_ae_lsimm64_encode, OperandSem_opnd_sem_ae_lsimm64_decode,
    0, 0 },
  { "ae_samt64", FIELD_ae_samt_s_t, -1, 0,
    0,
    OperandSem_opnd_sem_ae_samt64_encode, OperandSem_opnd_sem_ae_samt64_decode,
    0, 0 },
  { "ae_ohba", FIELD_ae_fld_ohba, -1, 0,
    0,
    OperandSem_opnd_sem_ae_ohba_encode, OperandSem_opnd_sem_ae_ohba_decode,
    0, 0 },
  { "ae_ohba2", FIELD_ae_fld_ohba2, -1, 0,
    0,
    OperandSem_opnd_sem_ae_ohba_encode, OperandSem_opnd_sem_ae_ohba_decode,
    0, 0 },
  { "pr", FIELD_ae_r20, REGFILE_AE_PR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_PR_encode, OperandSem_opnd_sem_AE_PR_decode,
    0, 0 },
  { "cvt_pr", FIELD_ae_r20, REGFILE_AE_PR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_PR_encode, OperandSem_opnd_sem_AE_PR_decode,
    0, 0 },
  { "qr0_rw", FIELD_ae_r10, REGFILE_AE_QR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_QR_encode, OperandSem_opnd_sem_AE_QR_decode,
    0, 0 },
  { "mac_qr0_rw", FIELD_ae_r10, REGFILE_AE_QR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_QR_encode, OperandSem_opnd_sem_AE_QR_decode,
    0, 0 },
  { "qr1_w", FIELD_ae_r32, REGFILE_AE_QR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_QR_encode, OperandSem_opnd_sem_AE_QR_decode,
    0, 0 },
  { "mac_qr1_w", FIELD_ae_r32, REGFILE_AE_QR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_QR_encode, OperandSem_opnd_sem_AE_QR_decode,
    0, 0 },
  { "ps", FIELD_ae_s20, REGFILE_AE_PR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_PR_encode, OperandSem_opnd_sem_AE_PR_decode,
    0, 0 },
  { "alupppb_ps", FIELD_ae_s20, REGFILE_AE_PR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_PR_encode, OperandSem_opnd_sem_AE_PR_decode,
    0, 0 },
  { "bitindex", FIELD_bitindex, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0 },
  { "t", FIELD_t, -1, 0, 0, 0, 0, 0, 0 },
  { "bbi4", FIELD_bbi4, -1, 0, 0, 0, 0, 0, 0 },
  { "imm12", FIELD_imm12, -1, 0, 0, 0, 0, 0, 0 },
  { "imm8", FIELD_imm8, -1, 0, 0, 0, 0, 0, 0 },
  { "imm12b", FIELD_imm12b, -1, 0, 0, 0, 0, 0, 0 },
  { "imm16", FIELD_imm16, -1, 0, 0, 0, 0, 0, 0 },
  { "m", FIELD_m, -1, 0, 0, 0, 0, 0, 0 },
  { "n", FIELD_n, -1, 0, 0, 0, 0, 0, 0 },
  { "offset", FIELD_offset, -1, 0, 0, 0, 0, 0, 0 },
  { "op0", FIELD_op0, -1, 0, 0, 0, 0, 0, 0 },
  { "op1", FIELD_op1, -1, 0, 0, 0, 0, 0, 0 },
  { "op2", FIELD_op2, -1, 0, 0, 0, 0, 0, 0 },
  { "r", FIELD_r, -1, 0, 0, 0, 0, 0, 0 },
  { "sa4", FIELD_sa4, -1, 0, 0, 0, 0, 0, 0 },
  { "sae4", FIELD_sae4, -1, 0, 0, 0, 0, 0, 0 },
  { "sal", FIELD_sal, -1, 0, 0, 0, 0, 0, 0 },
  { "sas4", FIELD_sas4, -1, 0, 0, 0, 0, 0, 0 },
  { "sr", FIELD_sr, -1, 0, 0, 0, 0, 0, 0 },
  { "st", FIELD_st, -1, 0, 0, 0, 0, 0, 0 },
  { "thi3", FIELD_thi3, -1, 0, 0, 0, 0, 0, 0 },
  { "imm4", FIELD_imm4, -1, 0, 0, 0, 0, 0, 0 },
  { "mn", FIELD_mn, -1, 0, 0, 0, 0, 0, 0 },
  { "i", FIELD_i, -1, 0, 0, 0, 0, 0, 0 },
  { "imm6lo", FIELD_imm6lo, -1, 0, 0, 0, 0, 0, 0 },
  { "imm6hi", FIELD_imm6hi, -1, 0, 0, 0, 0, 0, 0 },
  { "imm7lo", FIELD_imm7lo, -1, 0, 0, 0, 0, 0, 0 },
  { "imm7hi", FIELD_imm7hi, -1, 0, 0, 0, 0, 0, 0 },
  { "z", FIELD_z, -1, 0, 0, 0, 0, 0, 0 },
  { "imm6", FIELD_imm6, -1, 0, 0, 0, 0, 0, 0 },
  { "imm7", FIELD_imm7, -1, 0, 0, 0, 0, 0, 0 },
  { "r3", FIELD_r3, -1, 0, 0, 0, 0, 0, 0 },
  { "rbit2", FIELD_rbit2, -1, 0, 0, 0, 0, 0, 0 },
  { "rhi", FIELD_rhi, -1, 0, 0, 0, 0, 0, 0 },
  { "t3", FIELD_t3, -1, 0, 0, 0, 0, 0, 0 },
  { "tbit2", FIELD_tbit2, -1, 0, 0, 0, 0, 0, 0 },
  { "tlo", FIELD_tlo, -1, 0, 0, 0, 0, 0, 0 },
  { "w", FIELD_w, -1, 0, 0, 0, 0, 0, 0 },
  { "y", FIELD_y, -1, 0, 0, 0, 0, 0, 0 },
  { "x", FIELD_x, -1, 0, 0, 0, 0, 0, 0 },
  { "t2", FIELD_t2, -1, 0, 0, 0, 0, 0, 0 },
  { "s2", FIELD_s2, -1, 0, 0, 0, 0, 0, 0 },
  { "r2", FIELD_r2, -1, 0, 0, 0, 0, 0, 0 },
  { "t4", FIELD_t4, -1, 0, 0, 0, 0, 0, 0 },
  { "s4", FIELD_s4, -1, 0, 0, 0, 0, 0, 0 },
  { "r4", FIELD_r4, -1, 0, 0, 0, 0, 0, 0 },
  { "t8", FIELD_t8, -1, 0, 0, 0, 0, 0, 0 },
  { "s8", FIELD_s8, -1, 0, 0, 0, 0, 0, 0 },
  { "r8", FIELD_r8, -1, 0, 0, 0, 0, 0, 0 },
  { "xt_wbr15_imm", FIELD_xt_wbr15_imm, -1, 0, 0, 0, 0, 0, 0 },
  { "xt_wbr18_imm", FIELD_xt_wbr18_imm, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_r3", FIELD_ae_r3, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_s_non_samt", FIELD_ae_s_non_samt, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_s3", FIELD_ae_s3, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_r32", FIELD_ae_r32, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_samt_s_t", FIELD_ae_samt_s_t, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_r20", FIELD_ae_r20, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_r10", FIELD_ae_r10, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_s20", FIELD_ae_s20, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ohba", FIELD_ae_fld_ohba, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ohba2", FIELD_ae_fld_ohba2, -1, 0, 0, 0, 0, 0, 0 },
  { "op0_s3", FIELD_op0_s3, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf11", FIELD_ftsf11, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf12", FIELD_ftsf12, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf13", FIELD_ftsf13, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf20ae_slot1", FIELD_ftsf20ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf21ae_slot1", FIELD_ftsf21ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf22ae_slot1", FIELD_ftsf22ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf23ae_slot1", FIELD_ftsf23ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf24ae_slot1", FIELD_ftsf24ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf25ae_slot1", FIELD_ftsf25ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf26ae_slot1", FIELD_ftsf26ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf27ae_slot1", FIELD_ftsf27ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf28ae_slot1", FIELD_ftsf28ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf29ae_slot1", FIELD_ftsf29ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf30ae_slot1", FIELD_ftsf30ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf31ae_slot1", FIELD_ftsf31ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf32ae_slot1", FIELD_ftsf32ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf33ae_slot1", FIELD_ftsf33ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf34ae_slot1", FIELD_ftsf34ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf35ae_slot1", FIELD_ftsf35ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf36ae_slot1", FIELD_ftsf36ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf37ae_slot1", FIELD_ftsf37ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf38ae_slot1", FIELD_ftsf38ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf40ae_slot1", FIELD_ftsf40ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf41ae_slot1", FIELD_ftsf41ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf42ae_slot1", FIELD_ftsf42ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf43ae_slot1", FIELD_ftsf43ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf45ae_slot1", FIELD_ftsf45ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf47ae_slot1", FIELD_ftsf47ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf48ae_slot1", FIELD_ftsf48ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf49ae_slot1", FIELD_ftsf49ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf50ae_slot1", FIELD_ftsf50ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf51ae_slot1", FIELD_ftsf51ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf52ae_slot1", FIELD_ftsf52ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf53ae_slot1", FIELD_ftsf53ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf54ae_slot1", FIELD_ftsf54ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf55", FIELD_ftsf55, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf56ae_slot1", FIELD_ftsf56ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf57ae_slot1", FIELD_ftsf57ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf58ae_slot1", FIELD_ftsf58ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf60ae_slot1", FIELD_ftsf60ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf61", FIELD_ftsf61, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf62ae_slot1", FIELD_ftsf62ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf63ae_slot1", FIELD_ftsf63ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf64ae_slot1", FIELD_ftsf64ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf66ae_slot1", FIELD_ftsf66ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf68ae_slot1", FIELD_ftsf68ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf69ae_slot1", FIELD_ftsf69ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf70ae_slot1", FIELD_ftsf70ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf71ae_slot1", FIELD_ftsf71ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf72ae_slot1", FIELD_ftsf72ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf73ae_slot1", FIELD_ftsf73ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf74ae_slot1", FIELD_ftsf74ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf75ae_slot1", FIELD_ftsf75ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf76ae_slot1", FIELD_ftsf76ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf77ae_slot1", FIELD_ftsf77ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf78ae_slot1", FIELD_ftsf78ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf79ae_slot1", FIELD_ftsf79ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf80ae_slot1", FIELD_ftsf80ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf81ae_slot1", FIELD_ftsf81ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf82ae_slot1", FIELD_ftsf82ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf83ae_slot1", FIELD_ftsf83ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf84ae_slot1", FIELD_ftsf84ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf85ae_slot1", FIELD_ftsf85ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf86ae_slot1", FIELD_ftsf86ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf87ae_slot1", FIELD_ftsf87ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf88ae_slot1", FIELD_ftsf88ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf89ae_slot1", FIELD_ftsf89ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf90ae_slot1", FIELD_ftsf90ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf91", FIELD_ftsf91, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf92ae_slot1", FIELD_ftsf92ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf93ae_slot1", FIELD_ftsf93ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf94ae_slot1", FIELD_ftsf94ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf96ae_slot1", FIELD_ftsf96ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf97ae_slot1", FIELD_ftsf97ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf99ae_slot1", FIELD_ftsf99ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf101ae_slot1", FIELD_ftsf101ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf102ae_slot1", FIELD_ftsf102ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf103ae_slot1", FIELD_ftsf103ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf106ae_slot1", FIELD_ftsf106ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf107ae_slot1", FIELD_ftsf107ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf108ae_slot1", FIELD_ftsf108ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf109ae_slot1", FIELD_ftsf109ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf110ae_slot1", FIELD_ftsf110ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf111ae_slot1", FIELD_ftsf111ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf112ae_slot1", FIELD_ftsf112ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf113ae_slot1", FIELD_ftsf113ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf114ae_slot1", FIELD_ftsf114ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf115ae_slot1", FIELD_ftsf115ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf116ae_slot1", FIELD_ftsf116ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf117ae_slot1", FIELD_ftsf117ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf118ae_slot1", FIELD_ftsf118ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf120ae_slot1", FIELD_ftsf120ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf121ae_slot1", FIELD_ftsf121ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf123ae_slot1", FIELD_ftsf123ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf124ae_slot1", FIELD_ftsf124ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf125ae_slot1", FIELD_ftsf125ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf126ae_slot1", FIELD_ftsf126ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf127ae_slot1", FIELD_ftsf127ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf128ae_slot1", FIELD_ftsf128ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf129ae_slot1", FIELD_ftsf129ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf130ae_slot1", FIELD_ftsf130ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf131ae_slot1", FIELD_ftsf131ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf132ae_slot1", FIELD_ftsf132ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf133ae_slot1", FIELD_ftsf133ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf134ae_slot1", FIELD_ftsf134ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf135ae_slot1", FIELD_ftsf135ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf136ae_slot1", FIELD_ftsf136ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf137ae_slot1", FIELD_ftsf137ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf138ae_slot1", FIELD_ftsf138ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf139ae_slot1", FIELD_ftsf139ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf140ae_slot1", FIELD_ftsf140ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf141ae_slot1", FIELD_ftsf141ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf142ae_slot1", FIELD_ftsf142ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf143ae_slot1", FIELD_ftsf143ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf144ae_slot1", FIELD_ftsf144ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf145ae_slot1", FIELD_ftsf145ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf146ae_slot1", FIELD_ftsf146ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf147ae_slot1", FIELD_ftsf147ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf148ae_slot1", FIELD_ftsf148ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf149ae_slot1", FIELD_ftsf149ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf150ae_slot1", FIELD_ftsf150ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf151ae_slot1", FIELD_ftsf151ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf152ae_slot1", FIELD_ftsf152ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf153ae_slot1", FIELD_ftsf153ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf154ae_slot1", FIELD_ftsf154ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf155ae_slot1", FIELD_ftsf155ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf156ae_slot1", FIELD_ftsf156ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf157ae_slot1", FIELD_ftsf157ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf158ae_slot1", FIELD_ftsf158ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf159ae_slot1", FIELD_ftsf159ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf160ae_slot1", FIELD_ftsf160ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf161ae_slot1", FIELD_ftsf161ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf162ae_slot1", FIELD_ftsf162ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf163ae_slot1", FIELD_ftsf163ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf164ae_slot1", FIELD_ftsf164ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf165ae_slot1", FIELD_ftsf165ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf166ae_slot1", FIELD_ftsf166ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf167ae_slot1", FIELD_ftsf167ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf168ae_slot1", FIELD_ftsf168ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf169ae_slot1", FIELD_ftsf169ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf170ae_slot1", FIELD_ftsf170ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf171ae_slot1", FIELD_ftsf171ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf172ae_slot1", FIELD_ftsf172ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf173ae_slot1", FIELD_ftsf173ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf174ae_slot1", FIELD_ftsf174ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf175ae_slot1", FIELD_ftsf175ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf176ae_slot1", FIELD_ftsf176ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf177ae_slot1", FIELD_ftsf177ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf178ae_slot1", FIELD_ftsf178ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf179ae_slot1", FIELD_ftsf179ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf180ae_slot1", FIELD_ftsf180ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf181ae_slot1", FIELD_ftsf181ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf182ae_slot1", FIELD_ftsf182ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf183ae_slot1", FIELD_ftsf183ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf184ae_slot1", FIELD_ftsf184ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf185ae_slot1", FIELD_ftsf185ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf186ae_slot1", FIELD_ftsf186ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf187ae_slot1", FIELD_ftsf187ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf188ae_slot1", FIELD_ftsf188ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf189ae_slot1", FIELD_ftsf189ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf190ae_slot1", FIELD_ftsf190ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf191ae_slot1", FIELD_ftsf191ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf192ae_slot1", FIELD_ftsf192ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf193ae_slot1", FIELD_ftsf193ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf194ae_slot1", FIELD_ftsf194ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf195ae_slot1", FIELD_ftsf195ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf196ae_slot1", FIELD_ftsf196ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf197ae_slot1", FIELD_ftsf197ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf198ae_slot1", FIELD_ftsf198ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf199ae_slot1", FIELD_ftsf199ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf200ae_slot1", FIELD_ftsf200ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf201ae_slot1", FIELD_ftsf201ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf202ae_slot1", FIELD_ftsf202ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf203ae_slot1", FIELD_ftsf203ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf204ae_slot1", FIELD_ftsf204ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf205ae_slot1", FIELD_ftsf205ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf206ae_slot1", FIELD_ftsf206ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf207ae_slot1", FIELD_ftsf207ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf208ae_slot1", FIELD_ftsf208ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf210ae_slot1", FIELD_ftsf210ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf333ae_slot1", FIELD_ftsf333ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf334ae_slot1", FIELD_ftsf334ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf335", FIELD_ftsf335, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf336ae_slot1", FIELD_ftsf336ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf337ae_slot1", FIELD_ftsf337ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf339ae_slot1", FIELD_ftsf339ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf340ae_slot1", FIELD_ftsf340ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf341ae_slot1", FIELD_ftsf341ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf342ae_slot1", FIELD_ftsf342ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf343ae_slot1", FIELD_ftsf343ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf344ae_slot1", FIELD_ftsf344ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf345ae_slot1", FIELD_ftsf345ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf347ae_slot1", FIELD_ftsf347ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf348ae_slot1", FIELD_ftsf348ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf349ae_slot1", FIELD_ftsf349ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf350ae_slot1", FIELD_ftsf350ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf351", FIELD_ftsf351, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf352ae_slot1", FIELD_ftsf352ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf354ae_slot1", FIELD_ftsf354ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf355ae_slot1", FIELD_ftsf355ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf356ae_slot1", FIELD_ftsf356ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf357ae_slot1", FIELD_ftsf357ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf358ae_slot1", FIELD_ftsf358ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf359ae_slot1", FIELD_ftsf359ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "op0_s4", FIELD_op0_s4, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf211ae_slot0", FIELD_ftsf211ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf212ae_slot0", FIELD_ftsf212ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf213ae_slot0", FIELD_ftsf213ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf214ae_slot0", FIELD_ftsf214ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf215ae_slot0", FIELD_ftsf215ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf217ae_slot0", FIELD_ftsf217ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf218ae_slot0", FIELD_ftsf218ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf219ae_slot0", FIELD_ftsf219ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf220ae_slot0", FIELD_ftsf220ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf221ae_slot0", FIELD_ftsf221ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf222ae_slot0", FIELD_ftsf222ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf223ae_slot0", FIELD_ftsf223ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf224ae_slot0", FIELD_ftsf224ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf225ae_slot0", FIELD_ftsf225ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf226ae_slot0", FIELD_ftsf226ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf227ae_slot0", FIELD_ftsf227ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf228ae_slot0", FIELD_ftsf228ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf229ae_slot0", FIELD_ftsf229ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf230ae_slot0", FIELD_ftsf230ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf231ae_slot0", FIELD_ftsf231ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf232ae_slot0", FIELD_ftsf232ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf233ae_slot0", FIELD_ftsf233ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf234ae_slot0", FIELD_ftsf234ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf235ae_slot0", FIELD_ftsf235ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf236ae_slot0", FIELD_ftsf236ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf237ae_slot0", FIELD_ftsf237ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf238ae_slot0", FIELD_ftsf238ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf239ae_slot0", FIELD_ftsf239ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf240ae_slot0", FIELD_ftsf240ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf241ae_slot0", FIELD_ftsf241ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf242ae_slot0", FIELD_ftsf242ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf243ae_slot0", FIELD_ftsf243ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf244ae_slot0", FIELD_ftsf244ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf245ae_slot0", FIELD_ftsf245ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf246ae_slot0", FIELD_ftsf246ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf247ae_slot0", FIELD_ftsf247ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf248ae_slot0", FIELD_ftsf248ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf249ae_slot0", FIELD_ftsf249ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf250ae_slot0", FIELD_ftsf250ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf251ae_slot0", FIELD_ftsf251ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf252ae_slot0", FIELD_ftsf252ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf253ae_slot0", FIELD_ftsf253ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf254ae_slot0", FIELD_ftsf254ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf255ae_slot0", FIELD_ftsf255ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf256ae_slot0", FIELD_ftsf256ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf257ae_slot0", FIELD_ftsf257ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf258ae_slot0", FIELD_ftsf258ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf259ae_slot0", FIELD_ftsf259ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf260ae_slot0", FIELD_ftsf260ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf261ae_slot0", FIELD_ftsf261ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf262ae_slot0", FIELD_ftsf262ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf263ae_slot0", FIELD_ftsf263ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf264ae_slot0", FIELD_ftsf264ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf265ae_slot0", FIELD_ftsf265ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf266ae_slot0", FIELD_ftsf266ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf267ae_slot0", FIELD_ftsf267ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf268ae_slot0", FIELD_ftsf268ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf269ae_slot0", FIELD_ftsf269ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf270ae_slot0", FIELD_ftsf270ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf271ae_slot0", FIELD_ftsf271ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf272ae_slot0", FIELD_ftsf272ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf273ae_slot0", FIELD_ftsf273ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf274ae_slot0", FIELD_ftsf274ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf275ae_slot0", FIELD_ftsf275ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf276ae_slot0", FIELD_ftsf276ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf277ae_slot0", FIELD_ftsf277ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf278ae_slot0", FIELD_ftsf278ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf279ae_slot0", FIELD_ftsf279ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf280", FIELD_ftsf280, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf281ae_slot0", FIELD_ftsf281ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf282ae_slot0", FIELD_ftsf282ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf284ae_slot0", FIELD_ftsf284ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf285ae_slot0", FIELD_ftsf285ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf287ae_slot0", FIELD_ftsf287ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf288", FIELD_ftsf288, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf289ae_slot0", FIELD_ftsf289ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf290ae_slot0", FIELD_ftsf290ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf291ae_slot0", FIELD_ftsf291ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf292ae_slot0", FIELD_ftsf292ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf293ae_slot0", FIELD_ftsf293ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf294ae_slot0", FIELD_ftsf294ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf295ae_slot0", FIELD_ftsf295ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf296ae_slot0", FIELD_ftsf296ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf297ae_slot0", FIELD_ftsf297ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf298ae_slot0", FIELD_ftsf298ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf300ae_slot0", FIELD_ftsf300ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf302ae_slot0", FIELD_ftsf302ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf304ae_slot0", FIELD_ftsf304ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf305ae_slot0", FIELD_ftsf305ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf306ae_slot0", FIELD_ftsf306ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf307ae_slot0", FIELD_ftsf307ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf308ae_slot0", FIELD_ftsf308ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf309", FIELD_ftsf309, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf310ae_slot0", FIELD_ftsf310ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf311ae_slot0", FIELD_ftsf311ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf312ae_slot0", FIELD_ftsf312ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf313ae_slot0", FIELD_ftsf313ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf314ae_slot0", FIELD_ftsf314ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf315", FIELD_ftsf315, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf316ae_slot0", FIELD_ftsf316ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf317ae_slot0", FIELD_ftsf317ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf319ae_slot0", FIELD_ftsf319ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf320ae_slot0", FIELD_ftsf320ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf322ae_slot0", FIELD_ftsf322ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf323ae_slot0", FIELD_ftsf323ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf324ae_slot0", FIELD_ftsf324ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf325ae_slot0", FIELD_ftsf325ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf326ae_slot0", FIELD_ftsf326ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf327ae_slot0", FIELD_ftsf327ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf328ae_slot0", FIELD_ftsf328ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf329ae_slot0", FIELD_ftsf329ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf360ae_slot0", FIELD_ftsf360ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf361ae_slot0", FIELD_ftsf361ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf362", FIELD_ftsf362, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf363ae_slot0", FIELD_ftsf363ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf364ae_slot0", FIELD_ftsf364ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf366ae_slot0", FIELD_ftsf366ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf368ae_slot0", FIELD_ftsf368ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf370ae_slot0", FIELD_ftsf370ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf373ae_slot0", FIELD_ftsf373ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf376ae_slot0", FIELD_ftsf376ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf378ae_slot0", FIELD_ftsf378ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf379ae_slot0", FIELD_ftsf379ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf382ae_slot0", FIELD_ftsf382ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf383ae_slot0", FIELD_ftsf383ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf384ae_slot0", FIELD_ftsf384ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf386ae_slot0", FIELD_ftsf386ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf387ae_slot0", FIELD_ftsf387ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf388ae_slot0", FIELD_ftsf388ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ftsf389ae_slot0", FIELD_ftsf389ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_mul32x24fld", FIELD_ae_mul32x24fld, -1, 0, 0, 0, 0, 0, 0 },
  { "op0_s4_s4", FIELD_op0_s4_s4, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld28", FIELD_combined2c0b5f72_fld28, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld37", FIELD_combined2c0b5f72_fld37, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld39", FIELD_combined2c0b5f72_fld39, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld40", FIELD_combined2c0b5f72_fld40, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld46", FIELD_combined2c0b5f72_fld46, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld47", FIELD_combined2c0b5f72_fld47, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld49", FIELD_combined2c0b5f72_fld49, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld50", FIELD_combined2c0b5f72_fld50, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld52", FIELD_combined2c0b5f72_fld52, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld121", FIELD_combined2c0b5f72_fld121, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld123", FIELD_combined2c0b5f72_fld123, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld127", FIELD_combined2c0b5f72_fld127, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld133ae_slot0", FIELD_combined2c0b5f72_fld133ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld134ae_slot0", FIELD_combined2c0b5f72_fld134ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld135ae_slot0", FIELD_combined2c0b5f72_fld135ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld136ae_slot0", FIELD_combined2c0b5f72_fld136ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld137ae_slot0", FIELD_combined2c0b5f72_fld137ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld138ae_slot0", FIELD_combined2c0b5f72_fld138ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld139ae_slot0", FIELD_combined2c0b5f72_fld139ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld140ae_slot0", FIELD_combined2c0b5f72_fld140ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld141ae_slot0", FIELD_combined2c0b5f72_fld141ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld142ae_slot0", FIELD_combined2c0b5f72_fld142ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld143ae_slot0", FIELD_combined2c0b5f72_fld143ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld144ae_slot0", FIELD_combined2c0b5f72_fld144ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld145ae_slot0", FIELD_combined2c0b5f72_fld145ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld146ae_slot0", FIELD_combined2c0b5f72_fld146ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld148ae_slot0", FIELD_combined2c0b5f72_fld148ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld149ae_slot0", FIELD_combined2c0b5f72_fld149ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "op0_s4_s4_s4", FIELD_op0_s4_s4_s4, -1, 0, 0, 0, 0, 0, 0 },
  { "combined1e9fefee_fld96", FIELD_combined1e9fefee_fld96, -1, 0, 0, 0, 0, 0, 0 },
  { "combined1e9fefee_fld98", FIELD_combined1e9fefee_fld98, -1, 0, 0, 0, 0, 0, 0 },
  { "combined1e9fefee_fld106ae_slot0", FIELD_combined1e9fefee_fld106ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "combined1e9fefee_fld107ae_slot0", FIELD_combined1e9fefee_fld107ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "combined1e9fefee_fld108ae_slot0", FIELD_combined1e9fefee_fld108ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "combined1e9fefee_fld109ae_slot0", FIELD_combined1e9fefee_fld109ae_slot0, -1, 0, 0, 0, 0, 0, 0 },
  { "op0_s3_s3", FIELD_op0_s3_s3, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld19", FIELD_combined2c0b5f72_fld19, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld22", FIELD_combined2c0b5f72_fld22, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld24", FIELD_combined2c0b5f72_fld24, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld65", FIELD_combined2c0b5f72_fld65, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld66", FIELD_combined2c0b5f72_fld66, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld68", FIELD_combined2c0b5f72_fld68, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld69", FIELD_combined2c0b5f72_fld69, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld74", FIELD_combined2c0b5f72_fld74, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld79", FIELD_combined2c0b5f72_fld79, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld88", FIELD_combined2c0b5f72_fld88, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld90", FIELD_combined2c0b5f72_fld90, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld91", FIELD_combined2c0b5f72_fld91, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld131ae_slot1", FIELD_combined2c0b5f72_fld131ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld132ae_slot1", FIELD_combined2c0b5f72_fld132ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "combined2c0b5f72_fld147ae_slot1", FIELD_combined2c0b5f72_fld147ae_slot1, -1, 0, 0, 0, 0, 0, 0 },
  { "s3to1", FIELD_s3to1, -1, 0, 0, 0, 0, 0, 0 }
};

enum xtensa_operand_id {
  OPERAND_soffsetx4,
  OPERAND_uimm12x8,
  OPERAND_simm4,
  OPERAND_arr,
  OPERAND_ars,
  OPERAND__ars_invisible,
  OPERAND_art,
  OPERAND_ar0,
  OPERAND_ar4,
  OPERAND_ar8,
  OPERAND_ar12,
  OPERAND_ars_entry,
  OPERAND_immrx4,
  OPERAND_lsi4x4,
  OPERAND_simm7,
  OPERAND_uimm6,
  OPERAND_ai4const,
  OPERAND_b4const,
  OPERAND_b4constu,
  OPERAND_uimm8,
  OPERAND_uimm8x2,
  OPERAND_uimm8x4,
  OPERAND_uimm4x16,
  OPERAND_uimmrx4,
  OPERAND_simm8,
  OPERAND_simm8x256,
  OPERAND_simm12b,
  OPERAND_msalp32,
  OPERAND_op2p1,
  OPERAND_label8,
  OPERAND_ulabel8,
  OPERAND_label12,
  OPERAND_soffset,
  OPERAND_uimm16x4,
  OPERAND_bbi,
  OPERAND_sae,
  OPERAND_sas,
  OPERAND_sargt,
  OPERAND_s,
  OPERAND_mx,
  OPERAND_my,
  OPERAND_mw,
  OPERAND_mr0,
  OPERAND_mr1,
  OPERAND_mr2,
  OPERAND_mr3,
  OPERAND_immt,
  OPERAND_imms,
  OPERAND_bt,
  OPERAND_bs,
  OPERAND_br,
  OPERAND_bt2,
  OPERAND_bs2,
  OPERAND_br2,
  OPERAND_bt4,
  OPERAND_bs4,
  OPERAND_br4,
  OPERAND_bt8,
  OPERAND_bs8,
  OPERAND_br8,
  OPERAND_bt16,
  OPERAND_bs16,
  OPERAND_br16,
  OPERAND_brall,
  OPERAND_tp7,
  OPERAND_xt_wbr15_label,
  OPERAND_xt_wbr18_label,
  OPERAND_ae_samt32,
  OPERAND_pr0,
  OPERAND_qr0,
  OPERAND_mac_qr0,
  OPERAND_ae_lsimm16,
  OPERAND_ae_lsimm32,
  OPERAND_ae_lsimm64,
  OPERAND_ae_samt64,
  OPERAND_ae_ohba,
  OPERAND_ae_ohba2,
  OPERAND_pr,
  OPERAND_cvt_pr,
  OPERAND_qr0_rw,
  OPERAND_mac_qr0_rw,
  OPERAND_qr1_w,
  OPERAND_mac_qr1_w,
  OPERAND_ps,
  OPERAND_alupppb_ps,
  OPERAND_bitindex,
  OPERAND_t,
  OPERAND_bbi4,
  OPERAND_imm12,
  OPERAND_imm8,
  OPERAND_imm12b,
  OPERAND_imm16,
  OPERAND_m,
  OPERAND_n,
  OPERAND_offset,
  OPERAND_op0,
  OPERAND_op1,
  OPERAND_op2,
  OPERAND_r,
  OPERAND_sa4,
  OPERAND_sae4,
  OPERAND_sal,
  OPERAND_sas4,
  OPERAND_sr,
  OPERAND_st,
  OPERAND_thi3,
  OPERAND_imm4,
  OPERAND_mn,
  OPERAND_i,
  OPERAND_imm6lo,
  OPERAND_imm6hi,
  OPERAND_imm7lo,
  OPERAND_imm7hi,
  OPERAND_z,
  OPERAND_imm6,
  OPERAND_imm7,
  OPERAND_r3,
  OPERAND_rbit2,
  OPERAND_rhi,
  OPERAND_t3,
  OPERAND_tbit2,
  OPERAND_tlo,
  OPERAND_w,
  OPERAND_y,
  OPERAND_x,
  OPERAND_t2,
  OPERAND_s2,
  OPERAND_r2,
  OPERAND_t4,
  OPERAND_s4,
  OPERAND_r4,
  OPERAND_t8,
  OPERAND_s8,
  OPERAND_r8,
  OPERAND_xt_wbr15_imm,
  OPERAND_xt_wbr18_imm,
  OPERAND_ae_r3,
  OPERAND_ae_s_non_samt,
  OPERAND_ae_s3,
  OPERAND_ae_r32,
  OPERAND_ae_samt_s_t,
  OPERAND_ae_r20,
  OPERAND_ae_r10,
  OPERAND_ae_s20,
  OPERAND_ae_fld_ohba,
  OPERAND_ae_fld_ohba2,
  OPERAND_op0_s3,
  OPERAND_ftsf11,
  OPERAND_ftsf12,
  OPERAND_ftsf13,
  OPERAND_ftsf20ae_slot1,
  OPERAND_ftsf21ae_slot1,
  OPERAND_ftsf22ae_slot1,
  OPERAND_ftsf23ae_slot1,
  OPERAND_ftsf24ae_slot1,
  OPERAND_ftsf25ae_slot1,
  OPERAND_ftsf26ae_slot1,
  OPERAND_ftsf27ae_slot1,
  OPERAND_ftsf28ae_slot1,
  OPERAND_ftsf29ae_slot1,
  OPERAND_ftsf30ae_slot1,
  OPERAND_ftsf31ae_slot1,
  OPERAND_ftsf32ae_slot1,
  OPERAND_ftsf33ae_slot1,
  OPERAND_ftsf34ae_slot1,
  OPERAND_ftsf35ae_slot1,
  OPERAND_ftsf36ae_slot1,
  OPERAND_ftsf37ae_slot1,
  OPERAND_ftsf38ae_slot1,
  OPERAND_ftsf40ae_slot1,
  OPERAND_ftsf41ae_slot1,
  OPERAND_ftsf42ae_slot1,
  OPERAND_ftsf43ae_slot1,
  OPERAND_ftsf45ae_slot1,
  OPERAND_ftsf47ae_slot1,
  OPERAND_ftsf48ae_slot1,
  OPERAND_ftsf49ae_slot1,
  OPERAND_ftsf50ae_slot1,
  OPERAND_ftsf51ae_slot1,
  OPERAND_ftsf52ae_slot1,
  OPERAND_ftsf53ae_slot1,
  OPERAND_ftsf54ae_slot1,
  OPERAND_ftsf55,
  OPERAND_ftsf56ae_slot1,
  OPERAND_ftsf57ae_slot1,
  OPERAND_ftsf58ae_slot1,
  OPERAND_ftsf60ae_slot1,
  OPERAND_ftsf61,
  OPERAND_ftsf62ae_slot1,
  OPERAND_ftsf63ae_slot1,
  OPERAND_ftsf64ae_slot1,
  OPERAND_ftsf66ae_slot1,
  OPERAND_ftsf68ae_slot1,
  OPERAND_ftsf69ae_slot1,
  OPERAND_ftsf70ae_slot1,
  OPERAND_ftsf71ae_slot1,
  OPERAND_ftsf72ae_slot1,
  OPERAND_ftsf73ae_slot1,
  OPERAND_ftsf74ae_slot1,
  OPERAND_ftsf75ae_slot1,
  OPERAND_ftsf76ae_slot1,
  OPERAND_ftsf77ae_slot1,
  OPERAND_ftsf78ae_slot1,
  OPERAND_ftsf79ae_slot1,
  OPERAND_ftsf80ae_slot1,
  OPERAND_ftsf81ae_slot1,
  OPERAND_ftsf82ae_slot1,
  OPERAND_ftsf83ae_slot1,
  OPERAND_ftsf84ae_slot1,
  OPERAND_ftsf85ae_slot1,
  OPERAND_ftsf86ae_slot1,
  OPERAND_ftsf87ae_slot1,
  OPERAND_ftsf88ae_slot1,
  OPERAND_ftsf89ae_slot1,
  OPERAND_ftsf90ae_slot1,
  OPERAND_ftsf91,
  OPERAND_ftsf92ae_slot1,
  OPERAND_ftsf93ae_slot1,
  OPERAND_ftsf94ae_slot1,
  OPERAND_ftsf96ae_slot1,
  OPERAND_ftsf97ae_slot1,
  OPERAND_ftsf99ae_slot1,
  OPERAND_ftsf101ae_slot1,
  OPERAND_ftsf102ae_slot1,
  OPERAND_ftsf103ae_slot1,
  OPERAND_ftsf106ae_slot1,
  OPERAND_ftsf107ae_slot1,
  OPERAND_ftsf108ae_slot1,
  OPERAND_ftsf109ae_slot1,
  OPERAND_ftsf110ae_slot1,
  OPERAND_ftsf111ae_slot1,
  OPERAND_ftsf112ae_slot1,
  OPERAND_ftsf113ae_slot1,
  OPERAND_ftsf114ae_slot1,
  OPERAND_ftsf115ae_slot1,
  OPERAND_ftsf116ae_slot1,
  OPERAND_ftsf117ae_slot1,
  OPERAND_ftsf118ae_slot1,
  OPERAND_ftsf120ae_slot1,
  OPERAND_ftsf121ae_slot1,
  OPERAND_ftsf123ae_slot1,
  OPERAND_ftsf124ae_slot1,
  OPERAND_ftsf125ae_slot1,
  OPERAND_ftsf126ae_slot1,
  OPERAND_ftsf127ae_slot1,
  OPERAND_ftsf128ae_slot1,
  OPERAND_ftsf129ae_slot1,
  OPERAND_ftsf130ae_slot1,
  OPERAND_ftsf131ae_slot1,
  OPERAND_ftsf132ae_slot1,
  OPERAND_ftsf133ae_slot1,
  OPERAND_ftsf134ae_slot1,
  OPERAND_ftsf135ae_slot1,
  OPERAND_ftsf136ae_slot1,
  OPERAND_ftsf137ae_slot1,
  OPERAND_ftsf138ae_slot1,
  OPERAND_ftsf139ae_slot1,
  OPERAND_ftsf140ae_slot1,
  OPERAND_ftsf141ae_slot1,
  OPERAND_ftsf142ae_slot1,
  OPERAND_ftsf143ae_slot1,
  OPERAND_ftsf144ae_slot1,
  OPERAND_ftsf145ae_slot1,
  OPERAND_ftsf146ae_slot1,
  OPERAND_ftsf147ae_slot1,
  OPERAND_ftsf148ae_slot1,
  OPERAND_ftsf149ae_slot1,
  OPERAND_ftsf150ae_slot1,
  OPERAND_ftsf151ae_slot1,
  OPERAND_ftsf152ae_slot1,
  OPERAND_ftsf153ae_slot1,
  OPERAND_ftsf154ae_slot1,
  OPERAND_ftsf155ae_slot1,
  OPERAND_ftsf156ae_slot1,
  OPERAND_ftsf157ae_slot1,
  OPERAND_ftsf158ae_slot1,
  OPERAND_ftsf159ae_slot1,
  OPERAND_ftsf160ae_slot1,
  OPERAND_ftsf161ae_slot1,
  OPERAND_ftsf162ae_slot1,
  OPERAND_ftsf163ae_slot1,
  OPERAND_ftsf164ae_slot1,
  OPERAND_ftsf165ae_slot1,
  OPERAND_ftsf166ae_slot1,
  OPERAND_ftsf167ae_slot1,
  OPERAND_ftsf168ae_slot1,
  OPERAND_ftsf169ae_slot1,
  OPERAND_ftsf170ae_slot1,
  OPERAND_ftsf171ae_slot1,
  OPERAND_ftsf172ae_slot1,
  OPERAND_ftsf173ae_slot1,
  OPERAND_ftsf174ae_slot1,
  OPERAND_ftsf175ae_slot1,
  OPERAND_ftsf176ae_slot1,
  OPERAND_ftsf177ae_slot1,
  OPERAND_ftsf178ae_slot1,
  OPERAND_ftsf179ae_slot1,
  OPERAND_ftsf180ae_slot1,
  OPERAND_ftsf181ae_slot1,
  OPERAND_ftsf182ae_slot1,
  OPERAND_ftsf183ae_slot1,
  OPERAND_ftsf184ae_slot1,
  OPERAND_ftsf185ae_slot1,
  OPERAND_ftsf186ae_slot1,
  OPERAND_ftsf187ae_slot1,
  OPERAND_ftsf188ae_slot1,
  OPERAND_ftsf189ae_slot1,
  OPERAND_ftsf190ae_slot1,
  OPERAND_ftsf191ae_slot1,
  OPERAND_ftsf192ae_slot1,
  OPERAND_ftsf193ae_slot1,
  OPERAND_ftsf194ae_slot1,
  OPERAND_ftsf195ae_slot1,
  OPERAND_ftsf196ae_slot1,
  OPERAND_ftsf197ae_slot1,
  OPERAND_ftsf198ae_slot1,
  OPERAND_ftsf199ae_slot1,
  OPERAND_ftsf200ae_slot1,
  OPERAND_ftsf201ae_slot1,
  OPERAND_ftsf202ae_slot1,
  OPERAND_ftsf203ae_slot1,
  OPERAND_ftsf204ae_slot1,
  OPERAND_ftsf205ae_slot1,
  OPERAND_ftsf206ae_slot1,
  OPERAND_ftsf207ae_slot1,
  OPERAND_ftsf208ae_slot1,
  OPERAND_ftsf210ae_slot1,
  OPERAND_ftsf333ae_slot1,
  OPERAND_ftsf334ae_slot1,
  OPERAND_ftsf335,
  OPERAND_ftsf336ae_slot1,
  OPERAND_ftsf337ae_slot1,
  OPERAND_ftsf339ae_slot1,
  OPERAND_ftsf340ae_slot1,
  OPERAND_ftsf341ae_slot1,
  OPERAND_ftsf342ae_slot1,
  OPERAND_ftsf343ae_slot1,
  OPERAND_ftsf344ae_slot1,
  OPERAND_ftsf345ae_slot1,
  OPERAND_ftsf347ae_slot1,
  OPERAND_ftsf348ae_slot1,
  OPERAND_ftsf349ae_slot1,
  OPERAND_ftsf350ae_slot1,
  OPERAND_ftsf351,
  OPERAND_ftsf352ae_slot1,
  OPERAND_ftsf354ae_slot1,
  OPERAND_ftsf355ae_slot1,
  OPERAND_ftsf356ae_slot1,
  OPERAND_ftsf357ae_slot1,
  OPERAND_ftsf358ae_slot1,
  OPERAND_ftsf359ae_slot1,
  OPERAND_op0_s4,
  OPERAND_ftsf211ae_slot0,
  OPERAND_ftsf212ae_slot0,
  OPERAND_ftsf213ae_slot0,
  OPERAND_ftsf214ae_slot0,
  OPERAND_ftsf215ae_slot0,
  OPERAND_ftsf217ae_slot0,
  OPERAND_ftsf218ae_slot0,
  OPERAND_ftsf219ae_slot0,
  OPERAND_ftsf220ae_slot0,
  OPERAND_ftsf221ae_slot0,
  OPERAND_ftsf222ae_slot0,
  OPERAND_ftsf223ae_slot0,
  OPERAND_ftsf224ae_slot0,
  OPERAND_ftsf225ae_slot0,
  OPERAND_ftsf226ae_slot0,
  OPERAND_ftsf227ae_slot0,
  OPERAND_ftsf228ae_slot0,
  OPERAND_ftsf229ae_slot0,
  OPERAND_ftsf230ae_slot0,
  OPERAND_ftsf231ae_slot0,
  OPERAND_ftsf232ae_slot0,
  OPERAND_ftsf233ae_slot0,
  OPERAND_ftsf234ae_slot0,
  OPERAND_ftsf235ae_slot0,
  OPERAND_ftsf236ae_slot0,
  OPERAND_ftsf237ae_slot0,
  OPERAND_ftsf238ae_slot0,
  OPERAND_ftsf239ae_slot0,
  OPERAND_ftsf240ae_slot0,
  OPERAND_ftsf241ae_slot0,
  OPERAND_ftsf242ae_slot0,
  OPERAND_ftsf243ae_slot0,
  OPERAND_ftsf244ae_slot0,
  OPERAND_ftsf245ae_slot0,
  OPERAND_ftsf246ae_slot0,
  OPERAND_ftsf247ae_slot0,
  OPERAND_ftsf248ae_slot0,
  OPERAND_ftsf249ae_slot0,
  OPERAND_ftsf250ae_slot0,
  OPERAND_ftsf251ae_slot0,
  OPERAND_ftsf252ae_slot0,
  OPERAND_ftsf253ae_slot0,
  OPERAND_ftsf254ae_slot0,
  OPERAND_ftsf255ae_slot0,
  OPERAND_ftsf256ae_slot0,
  OPERAND_ftsf257ae_slot0,
  OPERAND_ftsf258ae_slot0,
  OPERAND_ftsf259ae_slot0,
  OPERAND_ftsf260ae_slot0,
  OPERAND_ftsf261ae_slot0,
  OPERAND_ftsf262ae_slot0,
  OPERAND_ftsf263ae_slot0,
  OPERAND_ftsf264ae_slot0,
  OPERAND_ftsf265ae_slot0,
  OPERAND_ftsf266ae_slot0,
  OPERAND_ftsf267ae_slot0,
  OPERAND_ftsf268ae_slot0,
  OPERAND_ftsf269ae_slot0,
  OPERAND_ftsf270ae_slot0,
  OPERAND_ftsf271ae_slot0,
  OPERAND_ftsf272ae_slot0,
  OPERAND_ftsf273ae_slot0,
  OPERAND_ftsf274ae_slot0,
  OPERAND_ftsf275ae_slot0,
  OPERAND_ftsf276ae_slot0,
  OPERAND_ftsf277ae_slot0,
  OPERAND_ftsf278ae_slot0,
  OPERAND_ftsf279ae_slot0,
  OPERAND_ftsf280,
  OPERAND_ftsf281ae_slot0,
  OPERAND_ftsf282ae_slot0,
  OPERAND_ftsf284ae_slot0,
  OPERAND_ftsf285ae_slot0,
  OPERAND_ftsf287ae_slot0,
  OPERAND_ftsf288,
  OPERAND_ftsf289ae_slot0,
  OPERAND_ftsf290ae_slot0,
  OPERAND_ftsf291ae_slot0,
  OPERAND_ftsf292ae_slot0,
  OPERAND_ftsf293ae_slot0,
  OPERAND_ftsf294ae_slot0,
  OPERAND_ftsf295ae_slot0,
  OPERAND_ftsf296ae_slot0,
  OPERAND_ftsf297ae_slot0,
  OPERAND_ftsf298ae_slot0,
  OPERAND_ftsf300ae_slot0,
  OPERAND_ftsf302ae_slot0,
  OPERAND_ftsf304ae_slot0,
  OPERAND_ftsf305ae_slot0,
  OPERAND_ftsf306ae_slot0,
  OPERAND_ftsf307ae_slot0,
  OPERAND_ftsf308ae_slot0,
  OPERAND_ftsf309,
  OPERAND_ftsf310ae_slot0,
  OPERAND_ftsf311ae_slot0,
  OPERAND_ftsf312ae_slot0,
  OPERAND_ftsf313ae_slot0,
  OPERAND_ftsf314ae_slot0,
  OPERAND_ftsf315,
  OPERAND_ftsf316ae_slot0,
  OPERAND_ftsf317ae_slot0,
  OPERAND_ftsf319ae_slot0,
  OPERAND_ftsf320ae_slot0,
  OPERAND_ftsf322ae_slot0,
  OPERAND_ftsf323ae_slot0,
  OPERAND_ftsf324ae_slot0,
  OPERAND_ftsf325ae_slot0,
  OPERAND_ftsf326ae_slot0,
  OPERAND_ftsf327ae_slot0,
  OPERAND_ftsf328ae_slot0,
  OPERAND_ftsf329ae_slot0,
  OPERAND_ftsf360ae_slot0,
  OPERAND_ftsf361ae_slot0,
  OPERAND_ftsf362,
  OPERAND_ftsf363ae_slot0,
  OPERAND_ftsf364ae_slot0,
  OPERAND_ftsf366ae_slot0,
  OPERAND_ftsf368ae_slot0,
  OPERAND_ftsf370ae_slot0,
  OPERAND_ftsf373ae_slot0,
  OPERAND_ftsf376ae_slot0,
  OPERAND_ftsf378ae_slot0,
  OPERAND_ftsf379ae_slot0,
  OPERAND_ftsf382ae_slot0,
  OPERAND_ftsf383ae_slot0,
  OPERAND_ftsf384ae_slot0,
  OPERAND_ftsf386ae_slot0,
  OPERAND_ftsf387ae_slot0,
  OPERAND_ftsf388ae_slot0,
  OPERAND_ftsf389ae_slot0,
  OPERAND_ae_mul32x24fld,
  OPERAND_op0_s4_s4,
  OPERAND_combined2c0b5f72_fld28,
  OPERAND_combined2c0b5f72_fld37,
  OPERAND_combined2c0b5f72_fld39,
  OPERAND_combined2c0b5f72_fld40,
  OPERAND_combined2c0b5f72_fld46,
  OPERAND_combined2c0b5f72_fld47,
  OPERAND_combined2c0b5f72_fld49,
  OPERAND_combined2c0b5f72_fld50,
  OPERAND_combined2c0b5f72_fld52,
  OPERAND_combined2c0b5f72_fld121,
  OPERAND_combined2c0b5f72_fld123,
  OPERAND_combined2c0b5f72_fld127,
  OPERAND_combined2c0b5f72_fld133ae_slot0,
  OPERAND_combined2c0b5f72_fld134ae_slot0,
  OPERAND_combined2c0b5f72_fld135ae_slot0,
  OPERAND_combined2c0b5f72_fld136ae_slot0,
  OPERAND_combined2c0b5f72_fld137ae_slot0,
  OPERAND_combined2c0b5f72_fld138ae_slot0,
  OPERAND_combined2c0b5f72_fld139ae_slot0,
  OPERAND_combined2c0b5f72_fld140ae_slot0,
  OPERAND_combined2c0b5f72_fld141ae_slot0,
  OPERAND_combined2c0b5f72_fld142ae_slot0,
  OPERAND_combined2c0b5f72_fld143ae_slot0,
  OPERAND_combined2c0b5f72_fld144ae_slot0,
  OPERAND_combined2c0b5f72_fld145ae_slot0,
  OPERAND_combined2c0b5f72_fld146ae_slot0,
  OPERAND_combined2c0b5f72_fld148ae_slot0,
  OPERAND_combined2c0b5f72_fld149ae_slot0,
  OPERAND_op0_s4_s4_s4,
  OPERAND_combined1e9fefee_fld96,
  OPERAND_combined1e9fefee_fld98,
  OPERAND_combined1e9fefee_fld106ae_slot0,
  OPERAND_combined1e9fefee_fld107ae_slot0,
  OPERAND_combined1e9fefee_fld108ae_slot0,
  OPERAND_combined1e9fefee_fld109ae_slot0,
  OPERAND_op0_s3_s3,
  OPERAND_combined2c0b5f72_fld19,
  OPERAND_combined2c0b5f72_fld22,
  OPERAND_combined2c0b5f72_fld24,
  OPERAND_combined2c0b5f72_fld65,
  OPERAND_combined2c0b5f72_fld66,
  OPERAND_combined2c0b5f72_fld68,
  OPERAND_combined2c0b5f72_fld69,
  OPERAND_combined2c0b5f72_fld74,
  OPERAND_combined2c0b5f72_fld79,
  OPERAND_combined2c0b5f72_fld88,
  OPERAND_combined2c0b5f72_fld90,
  OPERAND_combined2c0b5f72_fld91,
  OPERAND_combined2c0b5f72_fld131ae_slot1,
  OPERAND_combined2c0b5f72_fld132ae_slot1,
  OPERAND_combined2c0b5f72_fld147ae_slot1,
  OPERAND_s3to1
};


/* Iclass table.  */

static xtensa_arg_internal Iclass_xt_iclass_rfe_stateArgs[] = {
  { { STATE_PSRING }, 'i' },
  { { STATE_PSEXCM }, 'm' },
  { { STATE_EPC1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfde_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DEPC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_call12_args[] = {
  { { OPERAND_soffsetx4 }, 'i' },
  { { OPERAND_ar12 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call12_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call8_args[] = {
  { { OPERAND_soffsetx4 }, 'i' },
  { { OPERAND_ar8 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call8_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call4_args[] = {
  { { OPERAND_soffsetx4 }, 'i' },
  { { OPERAND_ar4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call4_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx12_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ar12 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx12_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx8_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ar8 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx8_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx4_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ar4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx4_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_entry_args[] = {
  { { OPERAND_ars_entry }, 's' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm12x8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_entry_stateArgs[] = {
  { { STATE_PSCALLINC }, 'i' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSWOE }, 'i' },
  { { STATE_WindowBase }, 'm' },
  { { STATE_WindowStart }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_movsp_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_movsp_stateArgs[] = {
  { { STATE_WindowBase }, 'i' },
  { { STATE_WindowStart }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rotw_args[] = {
  { { OPERAND_simm4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rotw_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_WindowBase }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_retw_args[] = {
  { { OPERAND__ars_invisible }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_retw_stateArgs[] = {
  { { STATE_WindowBase }, 'm' },
  { { STATE_WindowStart }, 'm' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSWOE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfwou_stateArgs[] = {
  { { STATE_EPC1 }, 'i' },
  { { STATE_PSEXCM }, 'm' },
  { { STATE_PSRING }, 'i' },
  { { STATE_WindowBase }, 'm' },
  { { STATE_WindowStart }, 'm' },
  { { STATE_PSOWB }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32e_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_immrx4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32e_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32e_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_immrx4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32e_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_windowbase_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_windowbase_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_WindowBase }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_windowbase_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_windowbase_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_WindowBase }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_windowbase_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_windowbase_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_WindowBase }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_windowstart_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_windowstart_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_WindowStart }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_windowstart_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_windowstart_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_WindowStart }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_windowstart_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_windowstart_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_WindowStart }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_add_n_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_addi_n_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ai4const }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bz6_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm6 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_loadi4_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_lsi4x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mov_n_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_movi_n_args[] = {
  { { OPERAND_ars }, 'o' },
  { { OPERAND_simm7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_retn_args[] = {
  { { OPERAND__ars_invisible }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_storei4_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_lsi4x4 }, 'i' }
};

static xtensa_arg_internal Iclass_rur_threadptr_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_threadptr_stateArgs[] = {
  { { STATE_THREADPTR }, 'i' }
};

static xtensa_arg_internal Iclass_wur_threadptr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_threadptr_stateArgs[] = {
  { { STATE_THREADPTR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_addi_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_simm8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_addmi_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_simm8x256 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_addsub_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bit_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bsi8_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_b4const }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bsi8b_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_bbi }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bsi8u_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_b4constu }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bst8_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bsz12_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_label12 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_call0_args[] = {
  { { OPERAND_soffsetx4 }, 'i' },
  { { OPERAND_ar0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx0_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ar0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_exti_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_sae }, 'i' },
  { { OPERAND_op2p1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_jump_args[] = {
  { { OPERAND_soffset }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_jumpx_args[] = {
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l16ui_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l16si_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32i_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32r_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_uimm16x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l8i_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_loop_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ulabel8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_loop_stateArgs[] = {
  { { STATE_LBEG }, 'o' },
  { { STATE_LEND }, 'o' },
  { { STATE_LCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_loopz_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ulabel8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_loopz_stateArgs[] = {
  { { STATE_LBEG }, 'o' },
  { { STATE_LEND }, 'o' },
  { { STATE_LCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_movi_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_simm12b }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_movz_args[] = {
  { { OPERAND_arr }, 'm' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_neg_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_return_args[] = {
  { { OPERAND__ars_invisible }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s16i_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32i_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32nb_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimmrx4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s8i_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sar_args[] = {
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sar_stateArgs[] = {
  { { STATE_SAR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_sari_args[] = {
  { { OPERAND_sas }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sari_stateArgs[] = {
  { { STATE_SAR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_shifts_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shifts_stateArgs[] = {
  { { STATE_SAR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shiftst_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shiftst_stateArgs[] = {
  { { STATE_SAR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shiftt_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shiftt_stateArgs[] = {
  { { STATE_SAR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_slli_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_msalp32 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_srai_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_sargt }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_srli_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_s }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sync_stateArgs[] = {
  { { STATE_XTSYNC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsil_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_s }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsil_stateArgs[] = {
  { { STATE_PSWOE }, 'i' },
  { { STATE_PSCALLINC }, 'i' },
  { { STATE_PSOWB }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_PSUM }, 'i' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSINTLEVEL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lend_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lend_stateArgs[] = {
  { { STATE_LEND }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lend_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lend_stateArgs[] = {
  { { STATE_LEND }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lend_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lend_stateArgs[] = {
  { { STATE_LEND }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lcount_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lcount_stateArgs[] = {
  { { STATE_LCOUNT }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lcount_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lcount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_LCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lcount_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lcount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_LCOUNT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lbeg_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lbeg_stateArgs[] = {
  { { STATE_LBEG }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lbeg_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lbeg_stateArgs[] = {
  { { STATE_LBEG }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lbeg_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lbeg_stateArgs[] = {
  { { STATE_LBEG }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_sar_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_sar_stateArgs[] = {
  { { STATE_SAR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_sar_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_sar_stateArgs[] = {
  { { STATE_SAR }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_sar_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_sar_stateArgs[] = {
  { { STATE_SAR }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_memctl_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_memctl_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_memctl_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_litbase_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_litbase_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_litbase_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_configid0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_configid0_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_configid0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_configid0_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_configid1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_configid1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_243_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_243_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ps_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ps_stateArgs[] = {
  { { STATE_PSWOE }, 'i' },
  { { STATE_PSCALLINC }, 'i' },
  { { STATE_PSOWB }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_PSUM }, 'i' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSINTLEVEL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ps_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ps_stateArgs[] = {
  { { STATE_PSWOE }, 'o' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSOWB }, 'o' },
  { { STATE_PSRING }, 'm' },
  { { STATE_PSUM }, 'o' },
  { { STATE_PSEXCM }, 'm' },
  { { STATE_PSINTLEVEL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ps_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ps_stateArgs[] = {
  { { STATE_PSWOE }, 'm' },
  { { STATE_PSCALLINC }, 'm' },
  { { STATE_PSOWB }, 'm' },
  { { STATE_PSRING }, 'm' },
  { { STATE_PSUM }, 'm' },
  { { STATE_PSEXCM }, 'm' },
  { { STATE_PSINTLEVEL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc2_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc2_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc2_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc2_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC2 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc2_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc2_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC2 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave2_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave2_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave2_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave2_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE2 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave2_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave2_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE2 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc3_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc3_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC3 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc3_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc3_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC3 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc3_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc3_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC3 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave3_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave3_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE3 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave3_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave3_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE3 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave3_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave3_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE3 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc4_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc4_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc4_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc4_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc4_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc4_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC4 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave4_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave4_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave4_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave4_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave4_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave4_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE4 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc5_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc5_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC5 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc5_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc5_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC5 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc5_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc5_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC5 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave5_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave5_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE5 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave5_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave5_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE5 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave5_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave5_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE5 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc6_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc6_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC6 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc6_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc6_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC6 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc6_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc6_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC6 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave6_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave6_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE6 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave6_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave6_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE6 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave6_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave6_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE6 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc7_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc7_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc7_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc7_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC7 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc7_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc7_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPC7 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave7_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave7_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave7_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave7_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE7 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave7_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave7_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCSAVE7 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps2_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps2_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPS2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps2_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps2_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPS2 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps2_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps2_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPS2 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps3_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps3_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPS3 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps3_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps3_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPS3 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps3_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps3_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPS3 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps4_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps4_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPS4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps4_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps4_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPS4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps4_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps4_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPS4 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps5_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps5_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPS5 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps5_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps5_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPS5 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps5_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps5_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPS5 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps6_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps6_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPS6 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps6_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps6_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPS6 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps6_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps6_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPS6 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps7_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps7_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPS7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps7_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps7_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPS7 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps7_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps7_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EPS7 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excvaddr_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excvaddr_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCVADDR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excvaddr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excvaddr_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCVADDR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excvaddr_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excvaddr_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCVADDR }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_depc_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_depc_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DEPC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_depc_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_depc_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DEPC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_depc_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_depc_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DEPC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_exccause_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_exccause_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCCAUSE }, 'i' },
  { { STATE_XTSYNC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_exccause_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_exccause_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCCAUSE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_exccause_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_exccause_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_EXCCAUSE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_misc0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_misc0_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_MISC0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_misc0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_misc0_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_MISC0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_misc0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_misc0_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_MISC0 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_misc1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_misc1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_MISC1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_misc1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_misc1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_MISC1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_misc1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_misc1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_MISC1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_prid_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_prid_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_vecbase_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_vecbase_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_VECBASE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_vecbase_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_vecbase_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_VECBASE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_vecbase_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_vecbase_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_VECBASE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_mul16_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_mul32_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_mul32h_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_aa_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_aa_stateArgs[] = {
  { { STATE_ACC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_ad_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_my }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_ad_stateArgs[] = {
  { { STATE_ACC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_da_args[] = {
  { { OPERAND_mx }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_da_stateArgs[] = {
  { { STATE_ACC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_dd_args[] = {
  { { OPERAND_mx }, 'i' },
  { { OPERAND_my }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_dd_stateArgs[] = {
  { { STATE_ACC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_aa_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_aa_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_ad_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_my }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_ad_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_da_args[] = {
  { { OPERAND_mx }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_da_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_dd_args[] = {
  { { OPERAND_mx }, 'i' },
  { { OPERAND_my }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_dd_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16al_da_args[] = {
  { { OPERAND_mw }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_mx }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16al_da_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16al_dd_args[] = {
  { { OPERAND_mw }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_mx }, 'i' },
  { { OPERAND_my }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16al_dd_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_l_args[] = {
  { { OPERAND_mw }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_m0_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_mr0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_m0_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_mr0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_m0_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_mr0 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_m1_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_mr1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_m1_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_mr1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_m1_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_mr1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_m2_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_mr2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_m2_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_mr2 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_m2_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_mr2 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_m3_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_mr3 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_m3_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_mr3 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_m3_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_mr3 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_acclo_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_acclo_stateArgs[] = {
  { { STATE_ACC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_acclo_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_acclo_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_acclo_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_acclo_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_acchi_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_acchi_stateArgs[] = {
  { { STATE_ACC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_acchi_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_acchi_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_acchi_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_acchi_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfi_args[] = {
  { { OPERAND_s }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfi_stateArgs[] = {
  { { STATE_PSWOE }, 'o' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSOWB }, 'o' },
  { { STATE_PSRING }, 'm' },
  { { STATE_PSUM }, 'o' },
  { { STATE_PSEXCM }, 'm' },
  { { STATE_PSINTLEVEL }, 'o' },
  { { STATE_EPC1 }, 'i' },
  { { STATE_EPC2 }, 'i' },
  { { STATE_EPC3 }, 'i' },
  { { STATE_EPC4 }, 'i' },
  { { STATE_EPC5 }, 'i' },
  { { STATE_EPC6 }, 'i' },
  { { STATE_EPC7 }, 'i' },
  { { STATE_EPS2 }, 'i' },
  { { STATE_EPS3 }, 'i' },
  { { STATE_EPS4 }, 'i' },
  { { STATE_EPS5 }, 'i' },
  { { STATE_EPS6 }, 'i' },
  { { STATE_EPS7 }, 'i' },
  { { STATE_InOCDMode }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_wait_args[] = {
  { { OPERAND_s }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wait_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_PSINTLEVEL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_interrupt_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_interrupt_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_INTERRUPT }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intset_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intset_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_XTSYNC }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intclear_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intclear_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_XTSYNC }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_intenable_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_intenable_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_INTENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intenable_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intenable_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_INTENABLE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_intenable_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_intenable_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_INTENABLE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_break_args[] = {
  { { OPERAND_imms }, 'i' },
  { { OPERAND_immt }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_break_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSINTLEVEL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_break_n_args[] = {
  { { OPERAND_imms }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_break_n_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSINTLEVEL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreaka0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreaka0_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DBREAKA0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreaka0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreaka0_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DBREAKA0 }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreaka0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreaka0_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DBREAKA0 }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreakc0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreakc0_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DBREAKC0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreakc0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreakc0_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DBREAKC0 }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreakc0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreakc0_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DBREAKC0 }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreaka1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreaka1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DBREAKA1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreaka1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreaka1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DBREAKA1 }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreaka1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreaka1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DBREAKA1 }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreakc1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreakc1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DBREAKC1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreakc1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreakc1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DBREAKC1 }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreakc1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreakc1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DBREAKC1 }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreaka0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreaka0_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_IBREAKA0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreaka0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreaka0_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_IBREAKA0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreaka0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreaka0_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_IBREAKA0 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreaka1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreaka1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_IBREAKA1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreaka1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreaka1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_IBREAKA1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreaka1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreaka1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_IBREAKA1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreakenable_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreakenable_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_IBREAKENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreakenable_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreakenable_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_IBREAKENABLE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreakenable_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreakenable_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_IBREAKENABLE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_debugcause_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_debugcause_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DEBUGCAUSE }, 'i' },
  { { STATE_DBNUM }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_debugcause_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_debugcause_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DEBUGCAUSE }, 'o' },
  { { STATE_DBNUM }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_debugcause_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_debugcause_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DEBUGCAUSE }, 'm' },
  { { STATE_DBNUM }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_icount_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_icount_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_ICOUNT }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_icount_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_icount_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_XTSYNC }, 'o' },
  { { STATE_ICOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_icount_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_icount_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_XTSYNC }, 'o' },
  { { STATE_ICOUNT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_icountlevel_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_icountlevel_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_ICOUNTLEVEL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_icountlevel_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_icountlevel_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_ICOUNTLEVEL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_icountlevel_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_icountlevel_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_ICOUNTLEVEL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ddr_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ddr_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DDR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ddr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ddr_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_XTSYNC }, 'o' },
  { { STATE_DDR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ddr_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ddr_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_XTSYNC }, 'o' },
  { { STATE_DDR }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_lddr32_p_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_lddr32_p_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_XTSYNC }, 'o' },
  { { STATE_InOCDMode }, 'i' },
  { { STATE_DDR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_sddr32_p_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_sddr32_p_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_InOCDMode }, 'i' },
  { { STATE_DDR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfdo_args[] = {
  { { OPERAND_imms }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfdo_stateArgs[] = {
  { { STATE_InOCDMode }, 'm' },
  { { STATE_EPC6 }, 'i' },
  { { STATE_PSWOE }, 'o' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSOWB }, 'o' },
  { { STATE_PSRING }, 'o' },
  { { STATE_PSUM }, 'o' },
  { { STATE_PSEXCM }, 'o' },
  { { STATE_PSINTLEVEL }, 'o' },
  { { STATE_EPS6 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfdd_stateArgs[] = {
  { { STATE_InOCDMode }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_mmid_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_mmid_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_bbool1_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_bs }, 'i' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bbool4_args[] = {
  { { OPERAND_bt }, 'o' },
  { { OPERAND_bs4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bbool8_args[] = {
  { { OPERAND_bt }, 'o' },
  { { OPERAND_bs8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bbranch_args[] = {
  { { OPERAND_bs }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bmove_args[] = {
  { { OPERAND_arr }, 'm' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_RSR_BR_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_brall }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_WSR_BR_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_brall }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_XSR_BR_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_brall }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccount_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccount_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_CCOUNT }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccount_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccount_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_XTSYNC }, 'o' },
  { { STATE_CCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccount_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccount_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_XTSYNC }, 'o' },
  { { STATE_CCOUNT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare0_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_CCOMPARE0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare0_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_CCOMPARE0 }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare0_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_CCOMPARE0 }, 'm' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_CCOMPARE1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_CCOMPARE1 }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare1_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_CCOMPARE1 }, 'm' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare2_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare2_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_CCOMPARE2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare2_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare2_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_CCOMPARE2 }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare2_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare2_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_CCOMPARE2 }, 'm' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_icache_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_icache_lock_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm4x16 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_icache_lock_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_icache_inv_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_icache_inv_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_licx_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_licx_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sicx_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sicx_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dcache_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dcache_dyn_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_dcache_dyn_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dcache_ind_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm4x16 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dcache_ind_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dcache_inv_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dcache_inv_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dpf_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dcache_lock_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm4x16 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dcache_lock_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sdct_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sdct_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_ldct_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_ldct_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_prefctl_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_prefctl_stateArgs[] = {
  { { STATE_PREFCTL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_prefctl_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_prefctl_stateArgs[] = {
  { { STATE_PREFCTL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_prefctl_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_prefctl_stateArgs[] = {
  { { STATE_PREFCTL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ptevaddr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ptevaddr_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_PTBASE }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ptevaddr_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ptevaddr_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_PTBASE }, 'i' },
  { { STATE_EXCVADDR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ptevaddr_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ptevaddr_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_PTBASE }, 'm' },
  { { STATE_EXCVADDR }, 'i' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_rasid_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_rasid_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_ASID3 }, 'i' },
  { { STATE_ASID2 }, 'i' },
  { { STATE_ASID1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_rasid_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_rasid_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_ASID3 }, 'o' },
  { { STATE_ASID2 }, 'o' },
  { { STATE_ASID1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_rasid_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_rasid_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_ASID3 }, 'm' },
  { { STATE_ASID2 }, 'm' },
  { { STATE_ASID1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_itlbcfg_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_itlbcfg_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_INSTPGSZID6 }, 'i' },
  { { STATE_INSTPGSZID5 }, 'i' },
  { { STATE_INSTPGSZID4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_itlbcfg_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_itlbcfg_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_INSTPGSZID6 }, 'o' },
  { { STATE_INSTPGSZID5 }, 'o' },
  { { STATE_INSTPGSZID4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_itlbcfg_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_itlbcfg_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_INSTPGSZID6 }, 'm' },
  { { STATE_INSTPGSZID5 }, 'm' },
  { { STATE_INSTPGSZID4 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dtlbcfg_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dtlbcfg_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DATAPGSZID6 }, 'i' },
  { { STATE_DATAPGSZID5 }, 'i' },
  { { STATE_DATAPGSZID4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dtlbcfg_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dtlbcfg_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DATAPGSZID6 }, 'o' },
  { { STATE_DATAPGSZID5 }, 'o' },
  { { STATE_DATAPGSZID4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dtlbcfg_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dtlbcfg_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_DATAPGSZID6 }, 'm' },
  { { STATE_DATAPGSZID5 }, 'm' },
  { { STATE_DATAPGSZID4 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_idtlb_args[] = {
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_idtlb_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rdtlb_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rdtlb_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wdtlb_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wdtlb_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_iitlb_args[] = {
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_iitlb_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_ritlb_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_ritlb_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_witlb_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_witlb_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_ldpte_stateArgs[] = {
  { { STATE_PTBASE }, 'i' },
  { { STATE_EXCVADDR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_hwwitlba_stateArgs[] = {
  { { STATE_EXCVADDR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_hwwdtlba_stateArgs[] = {
  { { STATE_EXCVADDR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_cpenable_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_cpenable_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_cpenable_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_cpenable_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_CPENABLE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_cpenable_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_cpenable_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_CPENABLE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_clamp_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_tp7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_minmax_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_nsa_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sx_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_tp7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32ai_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32ri_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32c1i_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32c1i_stateArgs[] = {
  { { STATE_SCOMPARE1 }, 'i' },
  { { STATE_XTSYNC }, 'i' },
  { { STATE_SCOMPARE1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_scompare1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_scompare1_stateArgs[] = {
  { { STATE_SCOMPARE1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_scompare1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_scompare1_stateArgs[] = {
  { { STATE_SCOMPARE1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_scompare1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_scompare1_stateArgs[] = {
  { { STATE_SCOMPARE1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_atomctl_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_atomctl_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_ATOMCTL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_atomctl_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_atomctl_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_ATOMCTL }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_atomctl_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_atomctl_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSRING }, 'i' },
  { { STATE_ATOMCTL }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_div_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rer_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rer_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_ERI_RAW_INTERLOCK }, 'i' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_interface Iclass_xt_iclass_rer_intfArgs[] = {
  INTERFACE_ERI_RD_In,
  INTERFACE_ERI_RD_Out
};

static xtensa_arg_internal Iclass_xt_iclass_wer_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wer_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_ERI_RAW_INTERLOCK }, 'o' },
  { { STATE_PSRING }, 'i' }
};

static xtensa_interface Iclass_xt_iclass_wer_intfArgs[] = {
  INTERFACE_ERI_WR_In,
  INTERFACE_ERI_WR_Out
};

static xtensa_arg_internal Iclass_rur_ae_ovf_sar_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_ovf_sar_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'i' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_ovf_sar_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_ovf_sar_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'o' },
  { { STATE_AE_SAR }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_bithead_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_bithead_stateArgs[] = {
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_bithead_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_bithead_stateArgs[] = {
  { { STATE_AE_BITHEAD }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_ts_fts_bu_bp_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_ts_fts_bu_bp_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_TABLESIZE }, 'i' },
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_ts_fts_bu_bp_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_ts_fts_bu_bp_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'o' },
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_TABLESIZE }, 'o' },
  { { STATE_AE_FIRST_TS }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_sd_no_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_sd_no_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_sd_no_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_sd_no_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_AE_SEARCHDONE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_rur_ae_overflow_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_ae_iclass_rur_ae_overflow_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_wur_ae_overflow_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_wur_ae_overflow_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_rur_ae_sar_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_ae_iclass_rur_ae_sar_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_wur_ae_sar_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_wur_ae_sar_stateArgs[] = {
  { { STATE_AE_SAR }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_rur_ae_bitptr_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_ae_iclass_rur_ae_bitptr_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_wur_ae_bitptr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_wur_ae_bitptr_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_rur_ae_bitsused_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_ae_iclass_rur_ae_bitsused_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_wur_ae_bitsused_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_wur_ae_bitsused_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_rur_ae_tablesize_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_ae_iclass_rur_ae_tablesize_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_wur_ae_tablesize_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_wur_ae_tablesize_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_rur_ae_first_ts_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_ae_iclass_rur_ae_first_ts_stateArgs[] = {
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_wur_ae_first_ts_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_wur_ae_first_ts_stateArgs[] = {
  { { STATE_AE_FIRST_TS }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_rur_ae_nextoffset_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_ae_iclass_rur_ae_nextoffset_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_wur_ae_nextoffset_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_wur_ae_nextoffset_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_rur_ae_searchdone_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_ae_iclass_rur_ae_searchdone_stateArgs[] = {
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_wur_ae_searchdone_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_wur_ae_searchdone_stateArgs[] = {
  { { STATE_AE_SEARCHDONE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp16f_i_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_lsimm16 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp16f_i_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp16f_iu_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_lsimm16 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp16f_iu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp16f_x_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp16f_x_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp16f_xu_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp16f_xu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24_i_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_lsimm32 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24_i_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24_iu_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_lsimm32 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24_iu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24_x_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24_x_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24_xu_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24_xu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24f_i_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_lsimm32 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24f_i_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24f_iu_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_lsimm32 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24f_iu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24f_x_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24f_x_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24f_xu_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24f_xu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp16x2f_i_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_lsimm32 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp16x2f_i_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp16x2f_iu_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_lsimm32 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp16x2f_iu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp16x2f_x_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp16x2f_x_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp16x2f_xu_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp16x2f_xu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24x2f_i_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_lsimm64 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24x2f_i_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24x2f_iu_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_lsimm64 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24x2f_iu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24x2f_x_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24x2f_x_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24x2f_xu_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24x2f_xu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24x2_i_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_lsimm64 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24x2_i_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24x2_iu_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_lsimm64 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24x2_iu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24x2_x_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24x2_x_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24x2_xu_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lp24x2_xu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp16x2f_i_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_lsimm32 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp16x2f_i_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp16x2f_iu_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_lsimm32 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp16x2f_iu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp16x2f_x_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp16x2f_x_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp16x2f_xu_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp16x2f_xu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24x2s_i_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_lsimm64 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24x2s_i_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24x2s_iu_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_lsimm64 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24x2s_iu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24x2s_x_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24x2s_x_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24x2s_xu_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24x2s_xu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24x2f_i_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_lsimm64 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24x2f_i_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24x2f_iu_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_lsimm64 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24x2f_iu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24x2f_x_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24x2f_x_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24x2f_xu_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24x2f_xu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp16f_l_i_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_lsimm16 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp16f_l_i_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp16f_l_iu_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_lsimm16 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp16f_l_iu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp16f_l_x_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp16f_l_x_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp16f_l_xu_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp16f_l_xu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24s_l_i_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_lsimm32 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24s_l_i_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24s_l_iu_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_lsimm32 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24s_l_iu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24s_l_x_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24s_l_x_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24s_l_xu_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24s_l_xu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24f_l_i_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_lsimm32 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24f_l_i_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24f_l_iu_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_lsimm32 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24f_l_iu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24f_l_x_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24f_l_x_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24f_l_xu_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sp24f_l_xu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lq56_i_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_lsimm64 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lq56_i_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lq56_iu_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_lsimm64 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lq56_iu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lq56_x_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lq56_x_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lq56_xu_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lq56_xu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lq32f_i_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_lsimm32 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lq32f_i_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lq32f_iu_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_lsimm32 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lq32f_iu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lq32f_x_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lq32f_x_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lq32f_xu_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lq32f_xu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sq56s_i_args[] = {
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_lsimm64 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sq56s_i_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sq56s_iu_args[] = {
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_lsimm64 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sq56s_iu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sq56s_x_args[] = {
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sq56s_x_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sq56s_xu_args[] = {
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sq56s_xu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sq32f_i_args[] = {
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_lsimm32 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sq32f_i_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sq32f_iu_args[] = {
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_lsimm32 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sq32f_iu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sq32f_x_args[] = {
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sq32f_x_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sq32f_xu_args[] = {
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sq32f_xu_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_zerop48_args[] = {
  { { OPERAND_ps }, 'o' }
};

static xtensa_arg_internal Iclass_ae_iclass_zerop48_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movp48_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movp48_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_selp24_ll_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_selp24_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_selp24_lh_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_selp24_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_selp24_hl_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_selp24_hl_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_selp24_hh_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_selp24_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movtp24x2_args[] = {
  { { OPERAND_pr }, 'm' },
  { { OPERAND_pr0 }, 'i' },
  { { OPERAND_bt2 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movtp24x2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movfp24x2_args[] = {
  { { OPERAND_pr }, 'm' },
  { { OPERAND_pr0 }, 'i' },
  { { OPERAND_bt2 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movfp24x2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movtp48_args[] = {
  { { OPERAND_pr }, 'm' },
  { { OPERAND_pr0 }, 'i' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movtp48_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movfp48_args[] = {
  { { OPERAND_pr }, 'm' },
  { { OPERAND_pr0 }, 'i' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movfp48_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movpa24x2_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movpa24x2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_truncp24a32x2_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_truncp24a32x2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_cvta32p24_l_args[] = {
  { { OPERAND_ars }, 'o' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_cvta32p24_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_cvta32p24_h_args[] = {
  { { OPERAND_ars }, 'o' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_cvta32p24_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_cvtp24a16x2_ll_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_cvtp24a16x2_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_cvtp24a16x2_lh_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_cvtp24a16x2_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_cvtp24a16x2_hl_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_cvtp24a16x2_hl_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_cvtp24a16x2_hh_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_cvtp24a16x2_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_truncp24q48x2_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_qr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_truncp24q48x2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_truncp16_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_truncp16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_roundsp24q48sym_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_roundsp24q48sym_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_roundsp24q48asym_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_roundsp24q48asym_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_roundsp16q48sym_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_roundsp16q48sym_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_roundsp16q48asym_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_roundsp16q48asym_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_roundsp16sym_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_roundsp16sym_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_roundsp16asym_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_roundsp16asym_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_zeroq56_args[] = {
  { { OPERAND_qr1_w }, 'o' }
};

static xtensa_arg_internal Iclass_ae_iclass_zeroq56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movq56_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movq56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movtq56_args[] = {
  { { OPERAND_qr1_w }, 'm' },
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_bs }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movtq56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movfq56_args[] = {
  { { OPERAND_qr1_w }, 'm' },
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_bs }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movfq56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_cvtq48a32s_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_cvtq48a32s_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_cvtq48p24s_l_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_cvt_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_cvtq48p24s_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_cvtq48p24s_h_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_cvt_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_cvtq48p24s_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_satq48s_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_satq48s_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_truncq32_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_truncq32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_roundsq32sym_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_roundsq32sym_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_roundsq32asym_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_roundsq32asym_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_trunca32q48_args[] = {
  { { OPERAND_ars }, 'o' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_trunca32q48_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movap24s_l_args[] = {
  { { OPERAND_ars }, 'o' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movap24s_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movap24s_h_args[] = {
  { { OPERAND_ars }, 'o' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_movap24s_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_trunca16p24s_l_args[] = {
  { { OPERAND_ars }, 'o' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_trunca16p24s_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_trunca16p24s_h_args[] = {
  { { OPERAND_ars }, 'o' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_trunca16p24s_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_addp24_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_addp24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_subp24_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_subp24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_negp24_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_negp24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_absp24_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_absp24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_maxp24s_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_maxp24s_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_minp24s_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_minp24s_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_maxbp24s_args[] = {
  { { OPERAND_alupppb_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' },
  { { OPERAND_bt2 }, 'o' }
};

static xtensa_arg_internal Iclass_ae_iclass_maxbp24s_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_minbp24s_args[] = {
  { { OPERAND_alupppb_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' },
  { { OPERAND_bt2 }, 'o' }
};

static xtensa_arg_internal Iclass_ae_iclass_minbp24s_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_addsp24s_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_addsp24s_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_subsp24s_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_subsp24s_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_negsp24s_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_negsp24s_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_abssp24s_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_abssp24s_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_andp48_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_andp48_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_nandp48_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_nandp48_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_orp48_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_orp48_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_xorp48_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_xorp48_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_ltp24s_args[] = {
  { { OPERAND_bt2 }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_ltp24s_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lep24s_args[] = {
  { { OPERAND_bt2 }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lep24s_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_eqp24_args[] = {
  { { OPERAND_bt2 }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_eqp24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_addq56_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_qr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_addq56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_subq56_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_qr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_subq56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_negq56_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_negq56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_absq56_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_absq56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_maxq56s_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0 }, 'i' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_maxq56s_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_minq56s_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0 }, 'i' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_minq56s_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_maxbq56s_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0 }, 'i' },
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_bt }, 'o' }
};

static xtensa_arg_internal Iclass_ae_iclass_maxbq56s_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_minbq56s_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0 }, 'i' },
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_bt }, 'o' }
};

static xtensa_arg_internal Iclass_ae_iclass_minbq56s_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_addsq56s_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_qr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_addsq56s_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_subsq56s_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_qr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_subsq56s_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_negsq56s_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_negsq56s_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_abssq56s_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_abssq56s_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_andq56_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0 }, 'i' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_andq56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_nandq56_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0 }, 'i' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_nandq56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_orq56_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0 }, 'i' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_orq56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_xorq56_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0 }, 'i' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_xorq56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sllip24_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ae_samt32 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sllip24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_srlip24_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ae_samt32 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_srlip24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sraip24_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ae_samt32 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sraip24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sllsp24_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sllsp24_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_srlsp24_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_srlsp24_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_srasp24_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_srasp24_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sllisp24s_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ae_samt32 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sllisp24s_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sllssp24s_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sllssp24s_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_slliq56_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_ae_samt64 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_slliq56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_srliq56_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_ae_samt64 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_srliq56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sraiq56_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_ae_samt64 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sraiq56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sllsq56_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sllsq56_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_srlsq56_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_srlsq56_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_srasq56_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_srasq56_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sllaq56_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sllaq56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_srlaq56_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_srlaq56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sraaq56_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sraaq56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sllisq56s_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_ae_samt64 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sllisq56s_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sllssq56s_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sllssq56s_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sllasq56s_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sllasq56s_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_ltq56s_args[] = {
  { { OPERAND_bt }, 'o' },
  { { OPERAND_qr0 }, 'i' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_ltq56s_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_leq56s_args[] = {
  { { OPERAND_bt }, 'o' },
  { { OPERAND_qr0 }, 'i' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_leq56s_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_eqq56_args[] = {
  { { OPERAND_bt }, 'o' },
  { { OPERAND_qr0 }, 'i' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_eqq56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_nsaq56s_args[] = {
  { { OPERAND_ars }, 'o' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_nsaq56s_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsrfq32sp24s_h_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsrfq32sp24s_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsrfq32sp24s_l_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsrfq32sp24s_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mularfq32sp24s_h_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mularfq32sp24s_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mularfq32sp24s_l_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mularfq32sp24s_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulrfq32sp24s_h_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulrfq32sp24s_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulrfq32sp24s_l_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulrfq32sp24s_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfq32sp24s_h_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfq32sp24s_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfq32sp24s_l_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfq32sp24s_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafq32sp24s_h_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafq32sp24s_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafq32sp24s_l_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafq32sp24s_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfq32sp24s_h_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfq32sp24s_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfq32sp24s_l_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfq32sp24s_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfs32p16s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfs32p16s_ll_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfp24s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfp24s_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulp24s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulp24s_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfs32p16s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfs32p16s_lh_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfp24s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfp24s_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulp24s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulp24s_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfs32p16s_hl_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfs32p16s_hl_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfp24s_hl_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfp24s_hl_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulp24s_hl_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulp24s_hl_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfs32p16s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfs32p16s_hh_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfp24s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfp24s_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulp24s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulp24s_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafs32p16s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafs32p16s_ll_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafp24s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafp24s_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulap24s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulap24s_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafs32p16s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafs32p16s_lh_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafp24s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafp24s_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulap24s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulap24s_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafs32p16s_hl_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafs32p16s_hl_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafp24s_hl_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafp24s_hl_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulap24s_hl_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulap24s_hl_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafs32p16s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafs32p16s_hh_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafp24s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafp24s_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulap24s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulap24s_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfs32p16s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfs32p16s_ll_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfp24s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfp24s_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsp24s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsp24s_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfs32p16s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfs32p16s_lh_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfp24s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfp24s_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsp24s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsp24s_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfs32p16s_hl_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfs32p16s_hl_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfp24s_hl_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfp24s_hl_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsp24s_hl_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsp24s_hl_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfs32p16s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfs32p16s_hh_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfp24s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfp24s_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsp24s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsp24s_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafs56p24s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafs56p24s_ll_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulas56p24s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulas56p24s_ll_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafs56p24s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafs56p24s_lh_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulas56p24s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulas56p24s_lh_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafs56p24s_hl_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafs56p24s_hl_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulas56p24s_hl_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulas56p24s_hl_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafs56p24s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafs56p24s_hh_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulas56p24s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulas56p24s_hh_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfs56p24s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfs56p24s_ll_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulss56p24s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulss56p24s_ll_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfs56p24s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfs56p24s_lh_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulss56p24s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulss56p24s_lh_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfs56p24s_hl_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfs56p24s_hl_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulss56p24s_hl_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulss56p24s_hl_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfs56p24s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfs56p24s_hh_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulss56p24s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulss56p24s_hh_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfq32sp16s_l_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfq32sp16s_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfq32sp16s_h_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfq32sp16s_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfq32sp16u_l_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfq32sp16u_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfq32sp16u_h_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulfq32sp16u_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulq32sp16s_l_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulq32sp16s_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulq32sp16s_h_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulq32sp16s_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulq32sp16u_l_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulq32sp16u_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulq32sp16u_h_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulq32sp16u_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafq32sp16s_l_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafq32sp16s_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafq32sp16s_h_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafq32sp16s_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafq32sp16u_l_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafq32sp16u_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafq32sp16u_h_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulafq32sp16u_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulaq32sp16s_l_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulaq32sp16s_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulaq32sp16s_h_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulaq32sp16s_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulaq32sp16u_l_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulaq32sp16u_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulaq32sp16u_h_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulaq32sp16u_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfq32sp16s_l_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfq32sp16s_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfq32sp16s_h_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfq32sp16s_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfq32sp16u_l_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfq32sp16u_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfq32sp16u_h_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsfq32sp16u_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsq32sp16s_l_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsq32sp16s_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsq32sp16s_h_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsq32sp16s_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsq32sp16u_l_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsq32sp16u_l_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsq32sp16u_h_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsq32sp16u_h_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaaq32sp16s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaaq32sp16s_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaafq32sp16s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaafq32sp16s_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaaq32sp16u_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaaq32sp16u_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaafq32sp16u_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaafq32sp16u_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaaq32sp16s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaaq32sp16s_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaafq32sp16s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaafq32sp16s_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaaq32sp16u_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaaq32sp16u_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaafq32sp16u_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaafq32sp16u_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaaq32sp16s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaaq32sp16s_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaafq32sp16s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaafq32sp16s_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaaq32sp16u_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaaq32sp16u_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaafq32sp16u_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaafq32sp16u_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasq32sp16s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasq32sp16s_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasfq32sp16s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasfq32sp16s_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasq32sp16u_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasq32sp16u_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasfq32sp16u_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasfq32sp16u_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasq32sp16s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasq32sp16s_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasfq32sp16s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasfq32sp16s_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasq32sp16u_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasq32sp16u_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasfq32sp16u_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasfq32sp16u_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasq32sp16s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasq32sp16s_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasfq32sp16s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasfq32sp16s_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasq32sp16u_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasq32sp16u_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasfq32sp16u_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasfq32sp16u_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsaq32sp16s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsaq32sp16s_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsafq32sp16s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsafq32sp16s_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsaq32sp16u_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsaq32sp16u_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsafq32sp16u_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsafq32sp16u_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsaq32sp16s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsaq32sp16s_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsafq32sp16s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsafq32sp16s_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsaq32sp16u_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsaq32sp16u_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsafq32sp16u_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsafq32sp16u_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsaq32sp16s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsaq32sp16s_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsafq32sp16s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsafq32sp16s_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsaq32sp16u_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsaq32sp16u_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsafq32sp16u_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsafq32sp16u_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssq32sp16s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssq32sp16s_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssfq32sp16s_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssfq32sp16s_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssq32sp16u_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssq32sp16u_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssfq32sp16u_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssfq32sp16u_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssq32sp16s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssq32sp16s_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssfq32sp16s_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssfq32sp16s_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssq32sp16u_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssq32sp16u_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssfq32sp16u_hh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssfq32sp16u_hh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssq32sp16s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssq32sp16s_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssfq32sp16s_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssfq32sp16s_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssq32sp16u_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssq32sp16u_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssfq32sp16u_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_mac_qr0_rw }, 'i' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_mac_qr0 }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssfq32sp16u_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaafp24s_hh_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaafp24s_hh_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaap24s_hh_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaap24s_hh_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaafp24s_hl_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaafp24s_hl_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaap24s_hl_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzaap24s_hl_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasfp24s_hh_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasfp24s_hh_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasp24s_hh_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasp24s_hh_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasfp24s_hl_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasfp24s_hl_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasp24s_hl_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzasp24s_hl_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsafp24s_hh_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsafp24s_hh_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsap24s_hh_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsap24s_hh_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsafp24s_hl_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsafp24s_hl_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsap24s_hl_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzsap24s_hl_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssfp24s_hh_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssfp24s_hh_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssp24s_hh_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssp24s_hh_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssfp24s_hl_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssfp24s_hl_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssp24s_hl_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulzssp24s_hl_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulaafp24s_hh_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulaafp24s_hh_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulaap24s_hh_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulaap24s_hh_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulaafp24s_hl_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulaafp24s_hl_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulaap24s_hl_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulaap24s_hl_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulasfp24s_hh_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulasfp24s_hh_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulasp24s_hh_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulasp24s_hh_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulasfp24s_hl_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulasfp24s_hl_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulasp24s_hl_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulasp24s_hl_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsafp24s_hh_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsafp24s_hh_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsap24s_hh_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsap24s_hh_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsafp24s_hl_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsafp24s_hl_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsap24s_hl_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulsap24s_hl_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulssfp24s_hh_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulssfp24s_hh_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulssp24s_hh_ll_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulssp24s_hh_ll_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulssfp24s_hl_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulssfp24s_hl_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulssp24s_hl_lh_args[] = {
  { { OPERAND_mac_qr1_w }, 'm' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_mulssp24s_hl_lh_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sha32_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_vldl32t_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_vldl32t_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_SEARCHDONE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_vldl16t_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_vldl16t_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_SEARCHDONE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_vldl16c_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_ae_iclass_vldl16c_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_vldsht_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_vldsht_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_AE_FIRST_TS }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_AE_TABLESIZE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lb_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lb_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lbi_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_ohba2 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lbi_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lbk_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lbk_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lbki_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_ohba2 }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_lbki_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_db_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_db_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_dbi_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_dbi_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_vlel32t_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_art }, 'm' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_vlel32t_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_vlel16t_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_art }, 'm' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_vlel16t_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sb_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sb_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sbi_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sbi_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_vles16c_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_ae_iclass_vles16c_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ae_iclass_sbf_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_ae_iclass_sbf_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_SLAASQ56S_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_SLAASQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_ADDBRBA32_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_MINABSSP24S_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_MINABSSP24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_MAXABSSP24S_args[] = {
  { { OPERAND_ps }, 'o' },
  { { OPERAND_pr }, 'i' },
  { { OPERAND_pr0 }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_MAXABSSP24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_MINABSSQ56S_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0 }, 'i' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_MINABSSQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_MAXABSSQ56S_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_qr0 }, 'i' },
  { { OPERAND_qr0_rw }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_MAXABSSQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_cbegin0_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_cbegin0_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cbegin0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cbegin0_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_cend0_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_cend0_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cend0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cend0_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_LP24X2_C_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_LP24X2_C_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_SP24X2S_C_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_SP24X2S_C_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_LP24X2F_C_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_LP24X2F_C_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_SP24X2F_C_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_SP24X2F_C_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_LP16X2F_C_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_LP16X2F_C_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_SP16X2F_C_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_SP16X2F_C_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_LP24_C_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_LP24_C_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_SP24S_L_C_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_SP24S_L_C_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_LP24F_C_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_LP24F_C_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_SP24F_L_C_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_SP24F_L_C_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_LP16F_C_args[] = {
  { { OPERAND_pr }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_LP16F_C_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_SP16F_L_C_args[] = {
  { { OPERAND_pr }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_SP16F_L_C_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_LQ56_C_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_LQ56_C_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_SQ56S_C_args[] = {
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_SQ56S_C_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_LQ32F_C_args[] = {
  { { OPERAND_qr1_w }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_LQ32F_C_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_SQ32F_C_args[] = {
  { { OPERAND_qr0_rw }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_icls_AE_SQ32F_C_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_expstate_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_expstate_stateArgs[] = {
  { { STATE_EXPSTATE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_expstate_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_expstate_stateArgs[] = {
  { { STATE_EXPSTATE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_READ_IMPWIRE_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_iclass_READ_IMPWIRE_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_interface Iclass_iclass_READ_IMPWIRE_intfArgs[] = {
  INTERFACE_IMPWIRE
};

static xtensa_arg_internal Iclass_iclass_SETB_EXPSTATE_args[] = {
  { { OPERAND_bitindex }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_SETB_EXPSTATE_stateArgs[] = {
  { { STATE_EXPSTATE }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_CLRB_EXPSTATE_args[] = {
  { { OPERAND_bitindex }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_CLRB_EXPSTATE_stateArgs[] = {
  { { STATE_EXPSTATE }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_WRMSK_EXPSTATE_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_WRMSK_EXPSTATE_stateArgs[] = {
  { { STATE_EXPSTATE }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_iclass_internal iclasses[] = {
  { 0, 0 /* xt_iclass_excw */,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_rfe */,
    3, Iclass_xt_iclass_rfe_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_rfde */,
    3, Iclass_xt_iclass_rfde_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_syscall */,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_call12_args,
    1, Iclass_xt_iclass_call12_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_call8_args,
    1, Iclass_xt_iclass_call8_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_call4_args,
    1, Iclass_xt_iclass_call4_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_callx12_args,
    1, Iclass_xt_iclass_callx12_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_callx8_args,
    1, Iclass_xt_iclass_callx8_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_callx4_args,
    1, Iclass_xt_iclass_callx4_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_entry_args,
    5, Iclass_xt_iclass_entry_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_movsp_args,
    2, Iclass_xt_iclass_movsp_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rotw_args,
    3, Iclass_xt_iclass_rotw_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_retw_args,
    5, Iclass_xt_iclass_retw_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_rfwou */,
    6, Iclass_xt_iclass_rfwou_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_l32e_args,
    2, Iclass_xt_iclass_l32e_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_s32e_args,
    2, Iclass_xt_iclass_s32e_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_windowbase_args,
    3, Iclass_xt_iclass_rsr_windowbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_windowbase_args,
    3, Iclass_xt_iclass_wsr_windowbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_windowbase_args,
    3, Iclass_xt_iclass_xsr_windowbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_windowstart_args,
    3, Iclass_xt_iclass_rsr_windowstart_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_windowstart_args,
    3, Iclass_xt_iclass_wsr_windowstart_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_windowstart_args,
    3, Iclass_xt_iclass_xsr_windowstart_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_add_n_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_addi_n_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bz6_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_ill_n */,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_loadi4_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_mov_n_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_movi_n_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_nopn */,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_retn_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_storei4_args,
    0, 0, 0, 0 },
  { 1, Iclass_rur_threadptr_args,
    1, Iclass_rur_threadptr_stateArgs, 0, 0 },
  { 1, Iclass_wur_threadptr_args,
    1, Iclass_wur_threadptr_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_addi_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_addmi_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_addsub_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bit_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bsi8_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bsi8b_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bsi8u_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bst8_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bsz12_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_call0_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_callx0_args,
    0, 0, 0, 0 },
  { 4, Iclass_xt_iclass_exti_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_ill */,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_jump_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_jumpx_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l16ui_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l16si_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l32i_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_l32r_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l8i_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_loop_args,
    3, Iclass_xt_iclass_loop_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_loopz_args,
    3, Iclass_xt_iclass_loopz_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_movi_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_movz_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_neg_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_nop */,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_return_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_simcall */,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s16i_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32i_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32nb_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s8i_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_sar_args,
    1, Iclass_xt_iclass_sar_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_sari_args,
    1, Iclass_xt_iclass_sari_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_shifts_args,
    1, Iclass_xt_iclass_shifts_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_shiftst_args,
    1, Iclass_xt_iclass_shiftst_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_shiftt_args,
    1, Iclass_xt_iclass_shiftt_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_slli_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_srai_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_srli_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_memw */,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_extw */,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_isync */,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_sync */,
    1, Iclass_xt_iclass_sync_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_rsil_args,
    7, Iclass_xt_iclass_rsil_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_lend_args,
    1, Iclass_xt_iclass_rsr_lend_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_lend_args,
    1, Iclass_xt_iclass_wsr_lend_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_lend_args,
    1, Iclass_xt_iclass_xsr_lend_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_lcount_args,
    1, Iclass_xt_iclass_rsr_lcount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_lcount_args,
    2, Iclass_xt_iclass_wsr_lcount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_lcount_args,
    2, Iclass_xt_iclass_xsr_lcount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_lbeg_args,
    1, Iclass_xt_iclass_rsr_lbeg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_lbeg_args,
    1, Iclass_xt_iclass_wsr_lbeg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_lbeg_args,
    1, Iclass_xt_iclass_xsr_lbeg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_sar_args,
    1, Iclass_xt_iclass_rsr_sar_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_sar_args,
    2, Iclass_xt_iclass_wsr_sar_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_sar_args,
    1, Iclass_xt_iclass_xsr_sar_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_memctl_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_memctl_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_memctl_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_litbase_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_litbase_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_litbase_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_configid0_args,
    2, Iclass_xt_iclass_rsr_configid0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_configid0_args,
    2, Iclass_xt_iclass_wsr_configid0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_configid1_args,
    2, Iclass_xt_iclass_rsr_configid1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_243_args,
    2, Iclass_xt_iclass_rsr_243_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ps_args,
    7, Iclass_xt_iclass_rsr_ps_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ps_args,
    7, Iclass_xt_iclass_wsr_ps_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ps_args,
    7, Iclass_xt_iclass_xsr_ps_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc1_args,
    3, Iclass_xt_iclass_rsr_epc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc1_args,
    3, Iclass_xt_iclass_wsr_epc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc1_args,
    3, Iclass_xt_iclass_xsr_epc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave1_args,
    3, Iclass_xt_iclass_rsr_excsave1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave1_args,
    3, Iclass_xt_iclass_wsr_excsave1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave1_args,
    3, Iclass_xt_iclass_xsr_excsave1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc2_args,
    3, Iclass_xt_iclass_rsr_epc2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc2_args,
    3, Iclass_xt_iclass_wsr_epc2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc2_args,
    3, Iclass_xt_iclass_xsr_epc2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave2_args,
    3, Iclass_xt_iclass_rsr_excsave2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave2_args,
    3, Iclass_xt_iclass_wsr_excsave2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave2_args,
    3, Iclass_xt_iclass_xsr_excsave2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc3_args,
    3, Iclass_xt_iclass_rsr_epc3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc3_args,
    3, Iclass_xt_iclass_wsr_epc3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc3_args,
    3, Iclass_xt_iclass_xsr_epc3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave3_args,
    3, Iclass_xt_iclass_rsr_excsave3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave3_args,
    3, Iclass_xt_iclass_wsr_excsave3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave3_args,
    3, Iclass_xt_iclass_xsr_excsave3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc4_args,
    3, Iclass_xt_iclass_rsr_epc4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc4_args,
    3, Iclass_xt_iclass_wsr_epc4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc4_args,
    3, Iclass_xt_iclass_xsr_epc4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave4_args,
    3, Iclass_xt_iclass_rsr_excsave4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave4_args,
    3, Iclass_xt_iclass_wsr_excsave4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave4_args,
    3, Iclass_xt_iclass_xsr_excsave4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc5_args,
    3, Iclass_xt_iclass_rsr_epc5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc5_args,
    3, Iclass_xt_iclass_wsr_epc5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc5_args,
    3, Iclass_xt_iclass_xsr_epc5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave5_args,
    3, Iclass_xt_iclass_rsr_excsave5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave5_args,
    3, Iclass_xt_iclass_wsr_excsave5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave5_args,
    3, Iclass_xt_iclass_xsr_excsave5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc6_args,
    3, Iclass_xt_iclass_rsr_epc6_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc6_args,
    3, Iclass_xt_iclass_wsr_epc6_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc6_args,
    3, Iclass_xt_iclass_xsr_epc6_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave6_args,
    3, Iclass_xt_iclass_rsr_excsave6_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave6_args,
    3, Iclass_xt_iclass_wsr_excsave6_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave6_args,
    3, Iclass_xt_iclass_xsr_excsave6_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc7_args,
    3, Iclass_xt_iclass_rsr_epc7_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc7_args,
    3, Iclass_xt_iclass_wsr_epc7_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc7_args,
    3, Iclass_xt_iclass_xsr_epc7_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave7_args,
    3, Iclass_xt_iclass_rsr_excsave7_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave7_args,
    3, Iclass_xt_iclass_wsr_excsave7_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave7_args,
    3, Iclass_xt_iclass_xsr_excsave7_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps2_args,
    3, Iclass_xt_iclass_rsr_eps2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps2_args,
    3, Iclass_xt_iclass_wsr_eps2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps2_args,
    3, Iclass_xt_iclass_xsr_eps2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps3_args,
    3, Iclass_xt_iclass_rsr_eps3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps3_args,
    3, Iclass_xt_iclass_wsr_eps3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps3_args,
    3, Iclass_xt_iclass_xsr_eps3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps4_args,
    3, Iclass_xt_iclass_rsr_eps4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps4_args,
    3, Iclass_xt_iclass_wsr_eps4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps4_args,
    3, Iclass_xt_iclass_xsr_eps4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps5_args,
    3, Iclass_xt_iclass_rsr_eps5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps5_args,
    3, Iclass_xt_iclass_wsr_eps5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps5_args,
    3, Iclass_xt_iclass_xsr_eps5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps6_args,
    3, Iclass_xt_iclass_rsr_eps6_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps6_args,
    3, Iclass_xt_iclass_wsr_eps6_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps6_args,
    3, Iclass_xt_iclass_xsr_eps6_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps7_args,
    3, Iclass_xt_iclass_rsr_eps7_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps7_args,
    3, Iclass_xt_iclass_wsr_eps7_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps7_args,
    3, Iclass_xt_iclass_xsr_eps7_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excvaddr_args,
    3, Iclass_xt_iclass_rsr_excvaddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excvaddr_args,
    3, Iclass_xt_iclass_wsr_excvaddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excvaddr_args,
    3, Iclass_xt_iclass_xsr_excvaddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_depc_args,
    3, Iclass_xt_iclass_rsr_depc_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_depc_args,
    3, Iclass_xt_iclass_wsr_depc_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_depc_args,
    3, Iclass_xt_iclass_xsr_depc_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_exccause_args,
    4, Iclass_xt_iclass_rsr_exccause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_exccause_args,
    3, Iclass_xt_iclass_wsr_exccause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_exccause_args,
    3, Iclass_xt_iclass_xsr_exccause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_misc0_args,
    3, Iclass_xt_iclass_rsr_misc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_misc0_args,
    3, Iclass_xt_iclass_wsr_misc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_misc0_args,
    3, Iclass_xt_iclass_xsr_misc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_misc1_args,
    3, Iclass_xt_iclass_rsr_misc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_misc1_args,
    3, Iclass_xt_iclass_wsr_misc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_misc1_args,
    3, Iclass_xt_iclass_xsr_misc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_prid_args,
    2, Iclass_xt_iclass_rsr_prid_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_vecbase_args,
    3, Iclass_xt_iclass_rsr_vecbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_vecbase_args,
    3, Iclass_xt_iclass_wsr_vecbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_vecbase_args,
    3, Iclass_xt_iclass_xsr_vecbase_stateArgs, 0, 0 },
  { 3, Iclass_xt_mul16_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_mul32_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_mul32h_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_mac16_aa_args,
    1, Iclass_xt_iclass_mac16_aa_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16_ad_args,
    1, Iclass_xt_iclass_mac16_ad_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16_da_args,
    1, Iclass_xt_iclass_mac16_da_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16_dd_args,
    1, Iclass_xt_iclass_mac16_dd_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16a_aa_args,
    1, Iclass_xt_iclass_mac16a_aa_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16a_ad_args,
    1, Iclass_xt_iclass_mac16a_ad_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16a_da_args,
    1, Iclass_xt_iclass_mac16a_da_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16a_dd_args,
    1, Iclass_xt_iclass_mac16a_dd_stateArgs, 0, 0 },
  { 4, Iclass_xt_iclass_mac16al_da_args,
    1, Iclass_xt_iclass_mac16al_da_stateArgs, 0, 0 },
  { 4, Iclass_xt_iclass_mac16al_dd_args,
    1, Iclass_xt_iclass_mac16al_dd_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16_l_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_rsr_m0_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_wsr_m0_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_xsr_m0_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_rsr_m1_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_wsr_m1_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_xsr_m1_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_rsr_m2_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_wsr_m2_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_xsr_m2_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_rsr_m3_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_wsr_m3_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_xsr_m3_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_acclo_args,
    1, Iclass_xt_iclass_rsr_acclo_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_acclo_args,
    1, Iclass_xt_iclass_wsr_acclo_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_acclo_args,
    1, Iclass_xt_iclass_xsr_acclo_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_acchi_args,
    1, Iclass_xt_iclass_rsr_acchi_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_acchi_args,
    1, Iclass_xt_iclass_wsr_acchi_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_acchi_args,
    1, Iclass_xt_iclass_xsr_acchi_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rfi_args,
    21, Iclass_xt_iclass_rfi_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wait_args,
    3, Iclass_xt_iclass_wait_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_interrupt_args,
    3, Iclass_xt_iclass_rsr_interrupt_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_intset_args,
    4, Iclass_xt_iclass_wsr_intset_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_intclear_args,
    4, Iclass_xt_iclass_wsr_intclear_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_intenable_args,
    3, Iclass_xt_iclass_rsr_intenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_intenable_args,
    3, Iclass_xt_iclass_wsr_intenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_intenable_args,
    3, Iclass_xt_iclass_xsr_intenable_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_break_args,
    2, Iclass_xt_iclass_break_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_break_n_args,
    2, Iclass_xt_iclass_break_n_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dbreaka0_args,
    3, Iclass_xt_iclass_rsr_dbreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dbreaka0_args,
    4, Iclass_xt_iclass_wsr_dbreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dbreaka0_args,
    4, Iclass_xt_iclass_xsr_dbreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dbreakc0_args,
    3, Iclass_xt_iclass_rsr_dbreakc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dbreakc0_args,
    4, Iclass_xt_iclass_wsr_dbreakc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dbreakc0_args,
    4, Iclass_xt_iclass_xsr_dbreakc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dbreaka1_args,
    3, Iclass_xt_iclass_rsr_dbreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dbreaka1_args,
    4, Iclass_xt_iclass_wsr_dbreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dbreaka1_args,
    4, Iclass_xt_iclass_xsr_dbreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dbreakc1_args,
    3, Iclass_xt_iclass_rsr_dbreakc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dbreakc1_args,
    4, Iclass_xt_iclass_wsr_dbreakc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dbreakc1_args,
    4, Iclass_xt_iclass_xsr_dbreakc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ibreaka0_args,
    3, Iclass_xt_iclass_rsr_ibreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ibreaka0_args,
    3, Iclass_xt_iclass_wsr_ibreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ibreaka0_args,
    3, Iclass_xt_iclass_xsr_ibreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ibreaka1_args,
    3, Iclass_xt_iclass_rsr_ibreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ibreaka1_args,
    3, Iclass_xt_iclass_wsr_ibreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ibreaka1_args,
    3, Iclass_xt_iclass_xsr_ibreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ibreakenable_args,
    3, Iclass_xt_iclass_rsr_ibreakenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ibreakenable_args,
    3, Iclass_xt_iclass_wsr_ibreakenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ibreakenable_args,
    3, Iclass_xt_iclass_xsr_ibreakenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_debugcause_args,
    4, Iclass_xt_iclass_rsr_debugcause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_debugcause_args,
    4, Iclass_xt_iclass_wsr_debugcause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_debugcause_args,
    4, Iclass_xt_iclass_xsr_debugcause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_icount_args,
    3, Iclass_xt_iclass_rsr_icount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_icount_args,
    4, Iclass_xt_iclass_wsr_icount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_icount_args,
    4, Iclass_xt_iclass_xsr_icount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_icountlevel_args,
    3, Iclass_xt_iclass_rsr_icountlevel_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_icountlevel_args,
    3, Iclass_xt_iclass_wsr_icountlevel_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_icountlevel_args,
    3, Iclass_xt_iclass_xsr_icountlevel_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ddr_args,
    3, Iclass_xt_iclass_rsr_ddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ddr_args,
    4, Iclass_xt_iclass_wsr_ddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ddr_args,
    4, Iclass_xt_iclass_xsr_ddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_lddr32_p_args,
    5, Iclass_xt_iclass_lddr32_p_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_sddr32_p_args,
    4, Iclass_xt_iclass_sddr32_p_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rfdo_args,
    10, Iclass_xt_iclass_rfdo_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_rfdd */,
    1, Iclass_xt_iclass_rfdd_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_mmid_args,
    3, Iclass_xt_iclass_wsr_mmid_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_bbool1_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bbool4_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bbool8_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bbranch_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bmove_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_RSR_BR_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_WSR_BR_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_XSR_BR_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ccount_args,
    3, Iclass_xt_iclass_rsr_ccount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ccount_args,
    4, Iclass_xt_iclass_wsr_ccount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ccount_args,
    4, Iclass_xt_iclass_xsr_ccount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ccompare0_args,
    3, Iclass_xt_iclass_rsr_ccompare0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ccompare0_args,
    4, Iclass_xt_iclass_wsr_ccompare0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ccompare0_args,
    4, Iclass_xt_iclass_xsr_ccompare0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ccompare1_args,
    3, Iclass_xt_iclass_rsr_ccompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ccompare1_args,
    4, Iclass_xt_iclass_wsr_ccompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ccompare1_args,
    4, Iclass_xt_iclass_xsr_ccompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ccompare2_args,
    3, Iclass_xt_iclass_rsr_ccompare2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ccompare2_args,
    4, Iclass_xt_iclass_wsr_ccompare2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ccompare2_args,
    4, Iclass_xt_iclass_xsr_ccompare2_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_icache_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_icache_lock_args,
    2, Iclass_xt_iclass_icache_lock_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_icache_inv_args,
    2, Iclass_xt_iclass_icache_inv_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_licx_args,
    2, Iclass_xt_iclass_licx_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_sicx_args,
    2, Iclass_xt_iclass_sicx_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_dcache_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_dcache_dyn_args,
    2, Iclass_xt_iclass_dcache_dyn_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_dcache_ind_args,
    2, Iclass_xt_iclass_dcache_ind_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_dcache_inv_args,
    2, Iclass_xt_iclass_dcache_inv_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_dpf_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_dcache_lock_args,
    2, Iclass_xt_iclass_dcache_lock_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_sdct_args,
    2, Iclass_xt_iclass_sdct_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_ldct_args,
    2, Iclass_xt_iclass_ldct_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_prefctl_args,
    1, Iclass_xt_iclass_rsr_prefctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_prefctl_args,
    1, Iclass_xt_iclass_wsr_prefctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_prefctl_args,
    1, Iclass_xt_iclass_xsr_prefctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ptevaddr_args,
    4, Iclass_xt_iclass_wsr_ptevaddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ptevaddr_args,
    4, Iclass_xt_iclass_rsr_ptevaddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ptevaddr_args,
    5, Iclass_xt_iclass_xsr_ptevaddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_rasid_args,
    5, Iclass_xt_iclass_rsr_rasid_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_rasid_args,
    6, Iclass_xt_iclass_wsr_rasid_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_rasid_args,
    6, Iclass_xt_iclass_xsr_rasid_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_itlbcfg_args,
    5, Iclass_xt_iclass_rsr_itlbcfg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_itlbcfg_args,
    6, Iclass_xt_iclass_wsr_itlbcfg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_itlbcfg_args,
    6, Iclass_xt_iclass_xsr_itlbcfg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dtlbcfg_args,
    5, Iclass_xt_iclass_rsr_dtlbcfg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dtlbcfg_args,
    6, Iclass_xt_iclass_wsr_dtlbcfg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dtlbcfg_args,
    6, Iclass_xt_iclass_xsr_dtlbcfg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_idtlb_args,
    3, Iclass_xt_iclass_idtlb_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_rdtlb_args,
    2, Iclass_xt_iclass_rdtlb_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_wdtlb_args,
    3, Iclass_xt_iclass_wdtlb_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_iitlb_args,
    2, Iclass_xt_iclass_iitlb_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_ritlb_args,
    2, Iclass_xt_iclass_ritlb_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_witlb_args,
    2, Iclass_xt_iclass_witlb_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_ldpte */,
    2, Iclass_xt_iclass_ldpte_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_hwwitlba */,
    1, Iclass_xt_iclass_hwwitlba_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_hwwdtlba */,
    1, Iclass_xt_iclass_hwwdtlba_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_cpenable_args,
    3, Iclass_xt_iclass_rsr_cpenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_cpenable_args,
    3, Iclass_xt_iclass_wsr_cpenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_cpenable_args,
    3, Iclass_xt_iclass_xsr_cpenable_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_clamp_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_minmax_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_nsa_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_sx_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l32ai_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32ri_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32c1i_args,
    3, Iclass_xt_iclass_s32c1i_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_scompare1_args,
    1, Iclass_xt_iclass_rsr_scompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_scompare1_args,
    1, Iclass_xt_iclass_wsr_scompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_scompare1_args,
    1, Iclass_xt_iclass_xsr_scompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_atomctl_args,
    3, Iclass_xt_iclass_rsr_atomctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_atomctl_args,
    4, Iclass_xt_iclass_wsr_atomctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_atomctl_args,
    4, Iclass_xt_iclass_xsr_atomctl_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_div_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_rer_args,
    3, Iclass_xt_iclass_rer_stateArgs, 2, Iclass_xt_iclass_rer_intfArgs },
  { 2, Iclass_xt_iclass_wer_args,
    3, Iclass_xt_iclass_wer_stateArgs, 2, Iclass_xt_iclass_wer_intfArgs },
  { 1, Iclass_rur_ae_ovf_sar_args,
    3, Iclass_rur_ae_ovf_sar_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_ovf_sar_args,
    3, Iclass_wur_ae_ovf_sar_stateArgs, 0, 0 },
  { 1, Iclass_rur_ae_bithead_args,
    2, Iclass_rur_ae_bithead_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_bithead_args,
    2, Iclass_wur_ae_bithead_stateArgs, 0, 0 },
  { 1, Iclass_rur_ae_ts_fts_bu_bp_args,
    5, Iclass_rur_ae_ts_fts_bu_bp_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_ts_fts_bu_bp_args,
    5, Iclass_wur_ae_ts_fts_bu_bp_stateArgs, 0, 0 },
  { 1, Iclass_rur_ae_sd_no_args,
    3, Iclass_rur_ae_sd_no_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_sd_no_args,
    3, Iclass_wur_ae_sd_no_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_rur_ae_overflow_args,
    2, Iclass_ae_iclass_rur_ae_overflow_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_wur_ae_overflow_args,
    2, Iclass_ae_iclass_wur_ae_overflow_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_rur_ae_sar_args,
    2, Iclass_ae_iclass_rur_ae_sar_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_wur_ae_sar_args,
    2, Iclass_ae_iclass_wur_ae_sar_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_rur_ae_bitptr_args,
    2, Iclass_ae_iclass_rur_ae_bitptr_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_wur_ae_bitptr_args,
    2, Iclass_ae_iclass_wur_ae_bitptr_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_rur_ae_bitsused_args,
    2, Iclass_ae_iclass_rur_ae_bitsused_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_wur_ae_bitsused_args,
    2, Iclass_ae_iclass_wur_ae_bitsused_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_rur_ae_tablesize_args,
    2, Iclass_ae_iclass_rur_ae_tablesize_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_wur_ae_tablesize_args,
    2, Iclass_ae_iclass_wur_ae_tablesize_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_rur_ae_first_ts_args,
    2, Iclass_ae_iclass_rur_ae_first_ts_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_wur_ae_first_ts_args,
    2, Iclass_ae_iclass_wur_ae_first_ts_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_rur_ae_nextoffset_args,
    2, Iclass_ae_iclass_rur_ae_nextoffset_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_wur_ae_nextoffset_args,
    2, Iclass_ae_iclass_wur_ae_nextoffset_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_rur_ae_searchdone_args,
    2, Iclass_ae_iclass_rur_ae_searchdone_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_wur_ae_searchdone_args,
    2, Iclass_ae_iclass_wur_ae_searchdone_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp16f_i_args,
    1, Iclass_ae_iclass_lp16f_i_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp16f_iu_args,
    1, Iclass_ae_iclass_lp16f_iu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp16f_x_args,
    1, Iclass_ae_iclass_lp16f_x_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp16f_xu_args,
    1, Iclass_ae_iclass_lp16f_xu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp24_i_args,
    1, Iclass_ae_iclass_lp24_i_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp24_iu_args,
    1, Iclass_ae_iclass_lp24_iu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp24_x_args,
    1, Iclass_ae_iclass_lp24_x_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp24_xu_args,
    1, Iclass_ae_iclass_lp24_xu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp24f_i_args,
    1, Iclass_ae_iclass_lp24f_i_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp24f_iu_args,
    1, Iclass_ae_iclass_lp24f_iu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp24f_x_args,
    1, Iclass_ae_iclass_lp24f_x_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp24f_xu_args,
    1, Iclass_ae_iclass_lp24f_xu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp16x2f_i_args,
    1, Iclass_ae_iclass_lp16x2f_i_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp16x2f_iu_args,
    1, Iclass_ae_iclass_lp16x2f_iu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp16x2f_x_args,
    1, Iclass_ae_iclass_lp16x2f_x_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp16x2f_xu_args,
    1, Iclass_ae_iclass_lp16x2f_xu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp24x2f_i_args,
    1, Iclass_ae_iclass_lp24x2f_i_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp24x2f_iu_args,
    1, Iclass_ae_iclass_lp24x2f_iu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp24x2f_x_args,
    1, Iclass_ae_iclass_lp24x2f_x_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp24x2f_xu_args,
    1, Iclass_ae_iclass_lp24x2f_xu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp24x2_i_args,
    1, Iclass_ae_iclass_lp24x2_i_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp24x2_iu_args,
    1, Iclass_ae_iclass_lp24x2_iu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp24x2_x_args,
    1, Iclass_ae_iclass_lp24x2_x_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lp24x2_xu_args,
    1, Iclass_ae_iclass_lp24x2_xu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp16x2f_i_args,
    1, Iclass_ae_iclass_sp16x2f_i_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp16x2f_iu_args,
    1, Iclass_ae_iclass_sp16x2f_iu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp16x2f_x_args,
    1, Iclass_ae_iclass_sp16x2f_x_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp16x2f_xu_args,
    1, Iclass_ae_iclass_sp16x2f_xu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp24x2s_i_args,
    1, Iclass_ae_iclass_sp24x2s_i_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp24x2s_iu_args,
    1, Iclass_ae_iclass_sp24x2s_iu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp24x2s_x_args,
    1, Iclass_ae_iclass_sp24x2s_x_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp24x2s_xu_args,
    1, Iclass_ae_iclass_sp24x2s_xu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp24x2f_i_args,
    1, Iclass_ae_iclass_sp24x2f_i_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp24x2f_iu_args,
    1, Iclass_ae_iclass_sp24x2f_iu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp24x2f_x_args,
    1, Iclass_ae_iclass_sp24x2f_x_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp24x2f_xu_args,
    1, Iclass_ae_iclass_sp24x2f_xu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp16f_l_i_args,
    1, Iclass_ae_iclass_sp16f_l_i_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp16f_l_iu_args,
    1, Iclass_ae_iclass_sp16f_l_iu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp16f_l_x_args,
    1, Iclass_ae_iclass_sp16f_l_x_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp16f_l_xu_args,
    1, Iclass_ae_iclass_sp16f_l_xu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp24s_l_i_args,
    1, Iclass_ae_iclass_sp24s_l_i_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp24s_l_iu_args,
    1, Iclass_ae_iclass_sp24s_l_iu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp24s_l_x_args,
    1, Iclass_ae_iclass_sp24s_l_x_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp24s_l_xu_args,
    1, Iclass_ae_iclass_sp24s_l_xu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp24f_l_i_args,
    1, Iclass_ae_iclass_sp24f_l_i_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp24f_l_iu_args,
    1, Iclass_ae_iclass_sp24f_l_iu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp24f_l_x_args,
    1, Iclass_ae_iclass_sp24f_l_x_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sp24f_l_xu_args,
    1, Iclass_ae_iclass_sp24f_l_xu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lq56_i_args,
    1, Iclass_ae_iclass_lq56_i_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lq56_iu_args,
    1, Iclass_ae_iclass_lq56_iu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lq56_x_args,
    1, Iclass_ae_iclass_lq56_x_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lq56_xu_args,
    1, Iclass_ae_iclass_lq56_xu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lq32f_i_args,
    1, Iclass_ae_iclass_lq32f_i_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lq32f_iu_args,
    1, Iclass_ae_iclass_lq32f_iu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lq32f_x_args,
    1, Iclass_ae_iclass_lq32f_x_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lq32f_xu_args,
    1, Iclass_ae_iclass_lq32f_xu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sq56s_i_args,
    1, Iclass_ae_iclass_sq56s_i_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sq56s_iu_args,
    1, Iclass_ae_iclass_sq56s_iu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sq56s_x_args,
    1, Iclass_ae_iclass_sq56s_x_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sq56s_xu_args,
    1, Iclass_ae_iclass_sq56s_xu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sq32f_i_args,
    1, Iclass_ae_iclass_sq32f_i_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sq32f_iu_args,
    1, Iclass_ae_iclass_sq32f_iu_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sq32f_x_args,
    1, Iclass_ae_iclass_sq32f_x_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sq32f_xu_args,
    1, Iclass_ae_iclass_sq32f_xu_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_zerop48_args,
    1, Iclass_ae_iclass_zerop48_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_movp48_args,
    1, Iclass_ae_iclass_movp48_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_selp24_ll_args,
    1, Iclass_ae_iclass_selp24_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_selp24_lh_args,
    1, Iclass_ae_iclass_selp24_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_selp24_hl_args,
    1, Iclass_ae_iclass_selp24_hl_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_selp24_hh_args,
    1, Iclass_ae_iclass_selp24_hh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_movtp24x2_args,
    1, Iclass_ae_iclass_movtp24x2_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_movfp24x2_args,
    1, Iclass_ae_iclass_movfp24x2_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_movtp48_args,
    1, Iclass_ae_iclass_movtp48_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_movfp48_args,
    1, Iclass_ae_iclass_movfp48_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_movpa24x2_args,
    1, Iclass_ae_iclass_movpa24x2_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_truncp24a32x2_args,
    1, Iclass_ae_iclass_truncp24a32x2_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_cvta32p24_l_args,
    1, Iclass_ae_iclass_cvta32p24_l_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_cvta32p24_h_args,
    1, Iclass_ae_iclass_cvta32p24_h_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_cvtp24a16x2_ll_args,
    1, Iclass_ae_iclass_cvtp24a16x2_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_cvtp24a16x2_lh_args,
    1, Iclass_ae_iclass_cvtp24a16x2_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_cvtp24a16x2_hl_args,
    1, Iclass_ae_iclass_cvtp24a16x2_hl_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_cvtp24a16x2_hh_args,
    1, Iclass_ae_iclass_cvtp24a16x2_hh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_truncp24q48x2_args,
    1, Iclass_ae_iclass_truncp24q48x2_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_truncp16_args,
    1, Iclass_ae_iclass_truncp16_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_roundsp24q48sym_args,
    2, Iclass_ae_iclass_roundsp24q48sym_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_roundsp24q48asym_args,
    2, Iclass_ae_iclass_roundsp24q48asym_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_roundsp16q48sym_args,
    2, Iclass_ae_iclass_roundsp16q48sym_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_roundsp16q48asym_args,
    2, Iclass_ae_iclass_roundsp16q48asym_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_roundsp16sym_args,
    2, Iclass_ae_iclass_roundsp16sym_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_roundsp16asym_args,
    2, Iclass_ae_iclass_roundsp16asym_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_zeroq56_args,
    1, Iclass_ae_iclass_zeroq56_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_movq56_args,
    1, Iclass_ae_iclass_movq56_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_movtq56_args,
    1, Iclass_ae_iclass_movtq56_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_movfq56_args,
    1, Iclass_ae_iclass_movfq56_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_cvtq48a32s_args,
    1, Iclass_ae_iclass_cvtq48a32s_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_cvtq48p24s_l_args,
    1, Iclass_ae_iclass_cvtq48p24s_l_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_cvtq48p24s_h_args,
    1, Iclass_ae_iclass_cvtq48p24s_h_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_satq48s_args,
    2, Iclass_ae_iclass_satq48s_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_truncq32_args,
    1, Iclass_ae_iclass_truncq32_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_roundsq32sym_args,
    2, Iclass_ae_iclass_roundsq32sym_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_roundsq32asym_args,
    2, Iclass_ae_iclass_roundsq32asym_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_trunca32q48_args,
    1, Iclass_ae_iclass_trunca32q48_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_movap24s_l_args,
    1, Iclass_ae_iclass_movap24s_l_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_movap24s_h_args,
    1, Iclass_ae_iclass_movap24s_h_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_trunca16p24s_l_args,
    1, Iclass_ae_iclass_trunca16p24s_l_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_trunca16p24s_h_args,
    1, Iclass_ae_iclass_trunca16p24s_h_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_addp24_args,
    1, Iclass_ae_iclass_addp24_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_subp24_args,
    1, Iclass_ae_iclass_subp24_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_negp24_args,
    1, Iclass_ae_iclass_negp24_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_absp24_args,
    1, Iclass_ae_iclass_absp24_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_maxp24s_args,
    1, Iclass_ae_iclass_maxp24s_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_minp24s_args,
    1, Iclass_ae_iclass_minp24s_stateArgs, 0, 0 },
  { 4, Iclass_ae_iclass_maxbp24s_args,
    1, Iclass_ae_iclass_maxbp24s_stateArgs, 0, 0 },
  { 4, Iclass_ae_iclass_minbp24s_args,
    1, Iclass_ae_iclass_minbp24s_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_addsp24s_args,
    2, Iclass_ae_iclass_addsp24s_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_subsp24s_args,
    2, Iclass_ae_iclass_subsp24s_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_negsp24s_args,
    2, Iclass_ae_iclass_negsp24s_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_abssp24s_args,
    2, Iclass_ae_iclass_abssp24s_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_andp48_args,
    1, Iclass_ae_iclass_andp48_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_nandp48_args,
    1, Iclass_ae_iclass_nandp48_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_orp48_args,
    1, Iclass_ae_iclass_orp48_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_xorp48_args,
    1, Iclass_ae_iclass_xorp48_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_ltp24s_args,
    1, Iclass_ae_iclass_ltp24s_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lep24s_args,
    1, Iclass_ae_iclass_lep24s_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_eqp24_args,
    1, Iclass_ae_iclass_eqp24_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_addq56_args,
    1, Iclass_ae_iclass_addq56_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_subq56_args,
    1, Iclass_ae_iclass_subq56_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_negq56_args,
    1, Iclass_ae_iclass_negq56_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_absq56_args,
    1, Iclass_ae_iclass_absq56_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_maxq56s_args,
    1, Iclass_ae_iclass_maxq56s_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_minq56s_args,
    1, Iclass_ae_iclass_minq56s_stateArgs, 0, 0 },
  { 4, Iclass_ae_iclass_maxbq56s_args,
    1, Iclass_ae_iclass_maxbq56s_stateArgs, 0, 0 },
  { 4, Iclass_ae_iclass_minbq56s_args,
    1, Iclass_ae_iclass_minbq56s_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_addsq56s_args,
    2, Iclass_ae_iclass_addsq56s_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_subsq56s_args,
    2, Iclass_ae_iclass_subsq56s_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_negsq56s_args,
    2, Iclass_ae_iclass_negsq56s_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_abssq56s_args,
    2, Iclass_ae_iclass_abssq56s_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_andq56_args,
    1, Iclass_ae_iclass_andq56_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_nandq56_args,
    1, Iclass_ae_iclass_nandq56_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_orq56_args,
    1, Iclass_ae_iclass_orq56_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_xorq56_args,
    1, Iclass_ae_iclass_xorq56_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sllip24_args,
    1, Iclass_ae_iclass_sllip24_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_srlip24_args,
    1, Iclass_ae_iclass_srlip24_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sraip24_args,
    1, Iclass_ae_iclass_sraip24_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_sllsp24_args,
    2, Iclass_ae_iclass_sllsp24_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_srlsp24_args,
    2, Iclass_ae_iclass_srlsp24_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_srasp24_args,
    2, Iclass_ae_iclass_srasp24_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sllisp24s_args,
    2, Iclass_ae_iclass_sllisp24s_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_sllssp24s_args,
    3, Iclass_ae_iclass_sllssp24s_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_slliq56_args,
    1, Iclass_ae_iclass_slliq56_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_srliq56_args,
    1, Iclass_ae_iclass_srliq56_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sraiq56_args,
    1, Iclass_ae_iclass_sraiq56_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_sllsq56_args,
    2, Iclass_ae_iclass_sllsq56_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_srlsq56_args,
    2, Iclass_ae_iclass_srlsq56_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_srasq56_args,
    2, Iclass_ae_iclass_srasq56_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sllaq56_args,
    1, Iclass_ae_iclass_sllaq56_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_srlaq56_args,
    1, Iclass_ae_iclass_srlaq56_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sraaq56_args,
    1, Iclass_ae_iclass_sraaq56_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sllisq56s_args,
    2, Iclass_ae_iclass_sllisq56s_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_sllssq56s_args,
    3, Iclass_ae_iclass_sllssq56s_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sllasq56s_args,
    2, Iclass_ae_iclass_sllasq56s_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_ltq56s_args,
    1, Iclass_ae_iclass_ltq56s_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_leq56s_args,
    1, Iclass_ae_iclass_leq56s_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_eqq56_args,
    1, Iclass_ae_iclass_eqq56_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_nsaq56s_args,
    1, Iclass_ae_iclass_nsaq56s_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsrfq32sp24s_h_args,
    1, Iclass_ae_iclass_mulsrfq32sp24s_h_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsrfq32sp24s_l_args,
    1, Iclass_ae_iclass_mulsrfq32sp24s_l_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mularfq32sp24s_h_args,
    1, Iclass_ae_iclass_mularfq32sp24s_h_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mularfq32sp24s_l_args,
    1, Iclass_ae_iclass_mularfq32sp24s_l_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulrfq32sp24s_h_args,
    1, Iclass_ae_iclass_mulrfq32sp24s_h_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulrfq32sp24s_l_args,
    1, Iclass_ae_iclass_mulrfq32sp24s_l_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsfq32sp24s_h_args,
    1, Iclass_ae_iclass_mulsfq32sp24s_h_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsfq32sp24s_l_args,
    1, Iclass_ae_iclass_mulsfq32sp24s_l_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulafq32sp24s_h_args,
    1, Iclass_ae_iclass_mulafq32sp24s_h_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulafq32sp24s_l_args,
    1, Iclass_ae_iclass_mulafq32sp24s_l_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulfq32sp24s_h_args,
    1, Iclass_ae_iclass_mulfq32sp24s_h_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulfq32sp24s_l_args,
    1, Iclass_ae_iclass_mulfq32sp24s_l_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulfs32p16s_ll_args,
    2, Iclass_ae_iclass_mulfs32p16s_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulfp24s_ll_args,
    1, Iclass_ae_iclass_mulfp24s_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulp24s_ll_args,
    1, Iclass_ae_iclass_mulp24s_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulfs32p16s_lh_args,
    2, Iclass_ae_iclass_mulfs32p16s_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulfp24s_lh_args,
    1, Iclass_ae_iclass_mulfp24s_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulp24s_lh_args,
    1, Iclass_ae_iclass_mulp24s_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulfs32p16s_hl_args,
    2, Iclass_ae_iclass_mulfs32p16s_hl_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulfp24s_hl_args,
    1, Iclass_ae_iclass_mulfp24s_hl_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulp24s_hl_args,
    1, Iclass_ae_iclass_mulp24s_hl_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulfs32p16s_hh_args,
    2, Iclass_ae_iclass_mulfs32p16s_hh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulfp24s_hh_args,
    1, Iclass_ae_iclass_mulfp24s_hh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulp24s_hh_args,
    1, Iclass_ae_iclass_mulp24s_hh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulafs32p16s_ll_args,
    2, Iclass_ae_iclass_mulafs32p16s_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulafp24s_ll_args,
    1, Iclass_ae_iclass_mulafp24s_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulap24s_ll_args,
    1, Iclass_ae_iclass_mulap24s_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulafs32p16s_lh_args,
    2, Iclass_ae_iclass_mulafs32p16s_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulafp24s_lh_args,
    1, Iclass_ae_iclass_mulafp24s_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulap24s_lh_args,
    1, Iclass_ae_iclass_mulap24s_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulafs32p16s_hl_args,
    2, Iclass_ae_iclass_mulafs32p16s_hl_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulafp24s_hl_args,
    1, Iclass_ae_iclass_mulafp24s_hl_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulap24s_hl_args,
    1, Iclass_ae_iclass_mulap24s_hl_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulafs32p16s_hh_args,
    2, Iclass_ae_iclass_mulafs32p16s_hh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulafp24s_hh_args,
    1, Iclass_ae_iclass_mulafp24s_hh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulap24s_hh_args,
    1, Iclass_ae_iclass_mulap24s_hh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsfs32p16s_ll_args,
    2, Iclass_ae_iclass_mulsfs32p16s_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsfp24s_ll_args,
    1, Iclass_ae_iclass_mulsfp24s_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsp24s_ll_args,
    1, Iclass_ae_iclass_mulsp24s_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsfs32p16s_lh_args,
    2, Iclass_ae_iclass_mulsfs32p16s_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsfp24s_lh_args,
    1, Iclass_ae_iclass_mulsfp24s_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsp24s_lh_args,
    1, Iclass_ae_iclass_mulsp24s_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsfs32p16s_hl_args,
    2, Iclass_ae_iclass_mulsfs32p16s_hl_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsfp24s_hl_args,
    1, Iclass_ae_iclass_mulsfp24s_hl_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsp24s_hl_args,
    1, Iclass_ae_iclass_mulsp24s_hl_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsfs32p16s_hh_args,
    2, Iclass_ae_iclass_mulsfs32p16s_hh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsfp24s_hh_args,
    1, Iclass_ae_iclass_mulsfp24s_hh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsp24s_hh_args,
    1, Iclass_ae_iclass_mulsp24s_hh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulafs56p24s_ll_args,
    2, Iclass_ae_iclass_mulafs56p24s_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulas56p24s_ll_args,
    2, Iclass_ae_iclass_mulas56p24s_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulafs56p24s_lh_args,
    2, Iclass_ae_iclass_mulafs56p24s_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulas56p24s_lh_args,
    2, Iclass_ae_iclass_mulas56p24s_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulafs56p24s_hl_args,
    2, Iclass_ae_iclass_mulafs56p24s_hl_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulas56p24s_hl_args,
    2, Iclass_ae_iclass_mulas56p24s_hl_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulafs56p24s_hh_args,
    2, Iclass_ae_iclass_mulafs56p24s_hh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulas56p24s_hh_args,
    2, Iclass_ae_iclass_mulas56p24s_hh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsfs56p24s_ll_args,
    2, Iclass_ae_iclass_mulsfs56p24s_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulss56p24s_ll_args,
    2, Iclass_ae_iclass_mulss56p24s_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsfs56p24s_lh_args,
    2, Iclass_ae_iclass_mulsfs56p24s_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulss56p24s_lh_args,
    2, Iclass_ae_iclass_mulss56p24s_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsfs56p24s_hl_args,
    2, Iclass_ae_iclass_mulsfs56p24s_hl_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulss56p24s_hl_args,
    2, Iclass_ae_iclass_mulss56p24s_hl_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsfs56p24s_hh_args,
    2, Iclass_ae_iclass_mulsfs56p24s_hh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulss56p24s_hh_args,
    2, Iclass_ae_iclass_mulss56p24s_hh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulfq32sp16s_l_args,
    1, Iclass_ae_iclass_mulfq32sp16s_l_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulfq32sp16s_h_args,
    1, Iclass_ae_iclass_mulfq32sp16s_h_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulfq32sp16u_l_args,
    1, Iclass_ae_iclass_mulfq32sp16u_l_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulfq32sp16u_h_args,
    1, Iclass_ae_iclass_mulfq32sp16u_h_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulq32sp16s_l_args,
    1, Iclass_ae_iclass_mulq32sp16s_l_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulq32sp16s_h_args,
    1, Iclass_ae_iclass_mulq32sp16s_h_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulq32sp16u_l_args,
    1, Iclass_ae_iclass_mulq32sp16u_l_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulq32sp16u_h_args,
    1, Iclass_ae_iclass_mulq32sp16u_h_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulafq32sp16s_l_args,
    1, Iclass_ae_iclass_mulafq32sp16s_l_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulafq32sp16s_h_args,
    1, Iclass_ae_iclass_mulafq32sp16s_h_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulafq32sp16u_l_args,
    1, Iclass_ae_iclass_mulafq32sp16u_l_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulafq32sp16u_h_args,
    1, Iclass_ae_iclass_mulafq32sp16u_h_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulaq32sp16s_l_args,
    1, Iclass_ae_iclass_mulaq32sp16s_l_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulaq32sp16s_h_args,
    1, Iclass_ae_iclass_mulaq32sp16s_h_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulaq32sp16u_l_args,
    1, Iclass_ae_iclass_mulaq32sp16u_l_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulaq32sp16u_h_args,
    1, Iclass_ae_iclass_mulaq32sp16u_h_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsfq32sp16s_l_args,
    1, Iclass_ae_iclass_mulsfq32sp16s_l_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsfq32sp16s_h_args,
    1, Iclass_ae_iclass_mulsfq32sp16s_h_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsfq32sp16u_l_args,
    1, Iclass_ae_iclass_mulsfq32sp16u_l_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsfq32sp16u_h_args,
    1, Iclass_ae_iclass_mulsfq32sp16u_h_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsq32sp16s_l_args,
    1, Iclass_ae_iclass_mulsq32sp16s_l_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsq32sp16s_h_args,
    1, Iclass_ae_iclass_mulsq32sp16s_h_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsq32sp16u_l_args,
    1, Iclass_ae_iclass_mulsq32sp16u_l_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsq32sp16u_h_args,
    1, Iclass_ae_iclass_mulsq32sp16u_h_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzaaq32sp16s_ll_args,
    1, Iclass_ae_iclass_mulzaaq32sp16s_ll_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzaafq32sp16s_ll_args,
    1, Iclass_ae_iclass_mulzaafq32sp16s_ll_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzaaq32sp16u_ll_args,
    1, Iclass_ae_iclass_mulzaaq32sp16u_ll_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzaafq32sp16u_ll_args,
    1, Iclass_ae_iclass_mulzaafq32sp16u_ll_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzaaq32sp16s_hh_args,
    1, Iclass_ae_iclass_mulzaaq32sp16s_hh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzaafq32sp16s_hh_args,
    1, Iclass_ae_iclass_mulzaafq32sp16s_hh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzaaq32sp16u_hh_args,
    1, Iclass_ae_iclass_mulzaaq32sp16u_hh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzaafq32sp16u_hh_args,
    1, Iclass_ae_iclass_mulzaafq32sp16u_hh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzaaq32sp16s_lh_args,
    1, Iclass_ae_iclass_mulzaaq32sp16s_lh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzaafq32sp16s_lh_args,
    1, Iclass_ae_iclass_mulzaafq32sp16s_lh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzaaq32sp16u_lh_args,
    1, Iclass_ae_iclass_mulzaaq32sp16u_lh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzaafq32sp16u_lh_args,
    1, Iclass_ae_iclass_mulzaafq32sp16u_lh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzasq32sp16s_ll_args,
    1, Iclass_ae_iclass_mulzasq32sp16s_ll_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzasfq32sp16s_ll_args,
    1, Iclass_ae_iclass_mulzasfq32sp16s_ll_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzasq32sp16u_ll_args,
    1, Iclass_ae_iclass_mulzasq32sp16u_ll_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzasfq32sp16u_ll_args,
    1, Iclass_ae_iclass_mulzasfq32sp16u_ll_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzasq32sp16s_hh_args,
    1, Iclass_ae_iclass_mulzasq32sp16s_hh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzasfq32sp16s_hh_args,
    1, Iclass_ae_iclass_mulzasfq32sp16s_hh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzasq32sp16u_hh_args,
    1, Iclass_ae_iclass_mulzasq32sp16u_hh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzasfq32sp16u_hh_args,
    1, Iclass_ae_iclass_mulzasfq32sp16u_hh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzasq32sp16s_lh_args,
    1, Iclass_ae_iclass_mulzasq32sp16s_lh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzasfq32sp16s_lh_args,
    1, Iclass_ae_iclass_mulzasfq32sp16s_lh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzasq32sp16u_lh_args,
    1, Iclass_ae_iclass_mulzasq32sp16u_lh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzasfq32sp16u_lh_args,
    1, Iclass_ae_iclass_mulzasfq32sp16u_lh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzsaq32sp16s_ll_args,
    1, Iclass_ae_iclass_mulzsaq32sp16s_ll_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzsafq32sp16s_ll_args,
    1, Iclass_ae_iclass_mulzsafq32sp16s_ll_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzsaq32sp16u_ll_args,
    1, Iclass_ae_iclass_mulzsaq32sp16u_ll_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzsafq32sp16u_ll_args,
    1, Iclass_ae_iclass_mulzsafq32sp16u_ll_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzsaq32sp16s_hh_args,
    1, Iclass_ae_iclass_mulzsaq32sp16s_hh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzsafq32sp16s_hh_args,
    1, Iclass_ae_iclass_mulzsafq32sp16s_hh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzsaq32sp16u_hh_args,
    1, Iclass_ae_iclass_mulzsaq32sp16u_hh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzsafq32sp16u_hh_args,
    1, Iclass_ae_iclass_mulzsafq32sp16u_hh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzsaq32sp16s_lh_args,
    1, Iclass_ae_iclass_mulzsaq32sp16s_lh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzsafq32sp16s_lh_args,
    1, Iclass_ae_iclass_mulzsafq32sp16s_lh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzsaq32sp16u_lh_args,
    1, Iclass_ae_iclass_mulzsaq32sp16u_lh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzsafq32sp16u_lh_args,
    1, Iclass_ae_iclass_mulzsafq32sp16u_lh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzssq32sp16s_ll_args,
    1, Iclass_ae_iclass_mulzssq32sp16s_ll_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzssfq32sp16s_ll_args,
    1, Iclass_ae_iclass_mulzssfq32sp16s_ll_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzssq32sp16u_ll_args,
    1, Iclass_ae_iclass_mulzssq32sp16u_ll_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzssfq32sp16u_ll_args,
    1, Iclass_ae_iclass_mulzssfq32sp16u_ll_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzssq32sp16s_hh_args,
    1, Iclass_ae_iclass_mulzssq32sp16s_hh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzssfq32sp16s_hh_args,
    1, Iclass_ae_iclass_mulzssfq32sp16s_hh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzssq32sp16u_hh_args,
    1, Iclass_ae_iclass_mulzssq32sp16u_hh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzssfq32sp16u_hh_args,
    1, Iclass_ae_iclass_mulzssfq32sp16u_hh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzssq32sp16s_lh_args,
    1, Iclass_ae_iclass_mulzssq32sp16s_lh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzssfq32sp16s_lh_args,
    1, Iclass_ae_iclass_mulzssfq32sp16s_lh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzssq32sp16u_lh_args,
    1, Iclass_ae_iclass_mulzssq32sp16u_lh_stateArgs, 0, 0 },
  { 5, Iclass_ae_iclass_mulzssfq32sp16u_lh_args,
    1, Iclass_ae_iclass_mulzssfq32sp16u_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulzaafp24s_hh_ll_args,
    1, Iclass_ae_iclass_mulzaafp24s_hh_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulzaap24s_hh_ll_args,
    1, Iclass_ae_iclass_mulzaap24s_hh_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulzaafp24s_hl_lh_args,
    1, Iclass_ae_iclass_mulzaafp24s_hl_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulzaap24s_hl_lh_args,
    1, Iclass_ae_iclass_mulzaap24s_hl_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulzasfp24s_hh_ll_args,
    1, Iclass_ae_iclass_mulzasfp24s_hh_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulzasp24s_hh_ll_args,
    1, Iclass_ae_iclass_mulzasp24s_hh_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulzasfp24s_hl_lh_args,
    1, Iclass_ae_iclass_mulzasfp24s_hl_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulzasp24s_hl_lh_args,
    1, Iclass_ae_iclass_mulzasp24s_hl_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulzsafp24s_hh_ll_args,
    1, Iclass_ae_iclass_mulzsafp24s_hh_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulzsap24s_hh_ll_args,
    1, Iclass_ae_iclass_mulzsap24s_hh_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulzsafp24s_hl_lh_args,
    1, Iclass_ae_iclass_mulzsafp24s_hl_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulzsap24s_hl_lh_args,
    1, Iclass_ae_iclass_mulzsap24s_hl_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulzssfp24s_hh_ll_args,
    1, Iclass_ae_iclass_mulzssfp24s_hh_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulzssp24s_hh_ll_args,
    1, Iclass_ae_iclass_mulzssp24s_hh_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulzssfp24s_hl_lh_args,
    1, Iclass_ae_iclass_mulzssfp24s_hl_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulzssp24s_hl_lh_args,
    1, Iclass_ae_iclass_mulzssp24s_hl_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulaafp24s_hh_ll_args,
    1, Iclass_ae_iclass_mulaafp24s_hh_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulaap24s_hh_ll_args,
    1, Iclass_ae_iclass_mulaap24s_hh_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulaafp24s_hl_lh_args,
    1, Iclass_ae_iclass_mulaafp24s_hl_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulaap24s_hl_lh_args,
    1, Iclass_ae_iclass_mulaap24s_hl_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulasfp24s_hh_ll_args,
    1, Iclass_ae_iclass_mulasfp24s_hh_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulasp24s_hh_ll_args,
    1, Iclass_ae_iclass_mulasp24s_hh_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulasfp24s_hl_lh_args,
    1, Iclass_ae_iclass_mulasfp24s_hl_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulasp24s_hl_lh_args,
    1, Iclass_ae_iclass_mulasp24s_hl_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsafp24s_hh_ll_args,
    1, Iclass_ae_iclass_mulsafp24s_hh_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsap24s_hh_ll_args,
    1, Iclass_ae_iclass_mulsap24s_hh_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsafp24s_hl_lh_args,
    1, Iclass_ae_iclass_mulsafp24s_hl_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulsap24s_hl_lh_args,
    1, Iclass_ae_iclass_mulsap24s_hl_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulssfp24s_hh_ll_args,
    1, Iclass_ae_iclass_mulssfp24s_hh_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulssp24s_hh_ll_args,
    1, Iclass_ae_iclass_mulssp24s_hh_ll_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulssfp24s_hl_lh_args,
    1, Iclass_ae_iclass_mulssfp24s_hl_lh_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_mulssp24s_hl_lh_args,
    1, Iclass_ae_iclass_mulssp24s_hl_lh_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_sha32_args,
    0, 0, 0, 0 },
  { 3, Iclass_ae_iclass_vldl32t_args,
    5, Iclass_ae_iclass_vldl32t_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_vldl16t_args,
    5, Iclass_ae_iclass_vldl16t_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_vldl16c_args,
    8, Iclass_ae_iclass_vldl16c_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_vldsht_args,
    6, Iclass_ae_iclass_vldsht_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_lb_args,
    3, Iclass_ae_iclass_lb_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_lbi_args,
    3, Iclass_ae_iclass_lbi_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lbk_args,
    3, Iclass_ae_iclass_lbk_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_lbki_args,
    3, Iclass_ae_iclass_lbki_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_db_args,
    3, Iclass_ae_iclass_db_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_dbi_args,
    3, Iclass_ae_iclass_dbi_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_vlel32t_args,
    3, Iclass_ae_iclass_vlel32t_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_vlel16t_args,
    3, Iclass_ae_iclass_vlel16t_stateArgs, 0, 0 },
  { 2, Iclass_ae_iclass_sb_args,
    4, Iclass_ae_iclass_sb_stateArgs, 0, 0 },
  { 3, Iclass_ae_iclass_sbi_args,
    3, Iclass_ae_iclass_sbi_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_vles16c_args,
    5, Iclass_ae_iclass_vles16c_stateArgs, 0, 0 },
  { 1, Iclass_ae_iclass_sbf_args,
    3, Iclass_ae_iclass_sbf_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_SLAASQ56S_args,
    2, Iclass_icls_AE_SLAASQ56S_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_ADDBRBA32_args,
    0, 0, 0, 0 },
  { 3, Iclass_icls_AE_MINABSSP24S_args,
    2, Iclass_icls_AE_MINABSSP24S_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_MAXABSSP24S_args,
    2, Iclass_icls_AE_MAXABSSP24S_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_MINABSSQ56S_args,
    2, Iclass_icls_AE_MINABSSQ56S_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_MAXABSSQ56S_args,
    2, Iclass_icls_AE_MAXABSSQ56S_stateArgs, 0, 0 },
  { 1, Iclass_rur_ae_cbegin0_args,
    2, Iclass_rur_ae_cbegin0_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_cbegin0_args,
    2, Iclass_wur_ae_cbegin0_stateArgs, 0, 0 },
  { 1, Iclass_rur_ae_cend0_args,
    2, Iclass_rur_ae_cend0_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_cend0_args,
    2, Iclass_wur_ae_cend0_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_LP24X2_C_args,
    3, Iclass_icls_AE_LP24X2_C_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_SP24X2S_C_args,
    3, Iclass_icls_AE_SP24X2S_C_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_LP24X2F_C_args,
    3, Iclass_icls_AE_LP24X2F_C_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_SP24X2F_C_args,
    3, Iclass_icls_AE_SP24X2F_C_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_LP16X2F_C_args,
    3, Iclass_icls_AE_LP16X2F_C_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_SP16X2F_C_args,
    3, Iclass_icls_AE_SP16X2F_C_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_LP24_C_args,
    3, Iclass_icls_AE_LP24_C_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_SP24S_L_C_args,
    3, Iclass_icls_AE_SP24S_L_C_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_LP24F_C_args,
    3, Iclass_icls_AE_LP24F_C_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_SP24F_L_C_args,
    3, Iclass_icls_AE_SP24F_L_C_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_LP16F_C_args,
    3, Iclass_icls_AE_LP16F_C_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_SP16F_L_C_args,
    3, Iclass_icls_AE_SP16F_L_C_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_LQ56_C_args,
    3, Iclass_icls_AE_LQ56_C_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_SQ56S_C_args,
    3, Iclass_icls_AE_SQ56S_C_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_LQ32F_C_args,
    3, Iclass_icls_AE_LQ32F_C_stateArgs, 0, 0 },
  { 3, Iclass_icls_AE_SQ32F_C_args,
    3, Iclass_icls_AE_SQ32F_C_stateArgs, 0, 0 },
  { 1, Iclass_rur_expstate_args,
    2, Iclass_rur_expstate_stateArgs, 0, 0 },
  { 1, Iclass_wur_expstate_args,
    2, Iclass_wur_expstate_stateArgs, 0, 0 },
  { 1, Iclass_iclass_READ_IMPWIRE_args,
    1, Iclass_iclass_READ_IMPWIRE_stateArgs, 1, Iclass_iclass_READ_IMPWIRE_intfArgs },
  { 1, Iclass_iclass_SETB_EXPSTATE_args,
    2, Iclass_iclass_SETB_EXPSTATE_stateArgs, 0, 0 },
  { 1, Iclass_iclass_CLRB_EXPSTATE_args,
    2, Iclass_iclass_CLRB_EXPSTATE_stateArgs, 0, 0 },
  { 2, Iclass_iclass_WRMSK_EXPSTATE_args,
    2, Iclass_iclass_WRMSK_EXPSTATE_stateArgs, 0, 0 }
};

enum xtensa_iclass_id {
  ICLASS_xt_iclass_excw,
  ICLASS_xt_iclass_rfe,
  ICLASS_xt_iclass_rfde,
  ICLASS_xt_iclass_syscall,
  ICLASS_xt_iclass_call12,
  ICLASS_xt_iclass_call8,
  ICLASS_xt_iclass_call4,
  ICLASS_xt_iclass_callx12,
  ICLASS_xt_iclass_callx8,
  ICLASS_xt_iclass_callx4,
  ICLASS_xt_iclass_entry,
  ICLASS_xt_iclass_movsp,
  ICLASS_xt_iclass_rotw,
  ICLASS_xt_iclass_retw,
  ICLASS_xt_iclass_rfwou,
  ICLASS_xt_iclass_l32e,
  ICLASS_xt_iclass_s32e,
  ICLASS_xt_iclass_rsr_windowbase,
  ICLASS_xt_iclass_wsr_windowbase,
  ICLASS_xt_iclass_xsr_windowbase,
  ICLASS_xt_iclass_rsr_windowstart,
  ICLASS_xt_iclass_wsr_windowstart,
  ICLASS_xt_iclass_xsr_windowstart,
  ICLASS_xt_iclass_add_n,
  ICLASS_xt_iclass_addi_n,
  ICLASS_xt_iclass_bz6,
  ICLASS_xt_iclass_ill_n,
  ICLASS_xt_iclass_loadi4,
  ICLASS_xt_iclass_mov_n,
  ICLASS_xt_iclass_movi_n,
  ICLASS_xt_iclass_nopn,
  ICLASS_xt_iclass_retn,
  ICLASS_xt_iclass_storei4,
  ICLASS_rur_threadptr,
  ICLASS_wur_threadptr,
  ICLASS_xt_iclass_addi,
  ICLASS_xt_iclass_addmi,
  ICLASS_xt_iclass_addsub,
  ICLASS_xt_iclass_bit,
  ICLASS_xt_iclass_bsi8,
  ICLASS_xt_iclass_bsi8b,
  ICLASS_xt_iclass_bsi8u,
  ICLASS_xt_iclass_bst8,
  ICLASS_xt_iclass_bsz12,
  ICLASS_xt_iclass_call0,
  ICLASS_xt_iclass_callx0,
  ICLASS_xt_iclass_exti,
  ICLASS_xt_iclass_ill,
  ICLASS_xt_iclass_jump,
  ICLASS_xt_iclass_jumpx,
  ICLASS_xt_iclass_l16ui,
  ICLASS_xt_iclass_l16si,
  ICLASS_xt_iclass_l32i,
  ICLASS_xt_iclass_l32r,
  ICLASS_xt_iclass_l8i,
  ICLASS_xt_iclass_loop,
  ICLASS_xt_iclass_loopz,
  ICLASS_xt_iclass_movi,
  ICLASS_xt_iclass_movz,
  ICLASS_xt_iclass_neg,
  ICLASS_xt_iclass_nop,
  ICLASS_xt_iclass_return,
  ICLASS_xt_iclass_simcall,
  ICLASS_xt_iclass_s16i,
  ICLASS_xt_iclass_s32i,
  ICLASS_xt_iclass_s32nb,
  ICLASS_xt_iclass_s8i,
  ICLASS_xt_iclass_sar,
  ICLASS_xt_iclass_sari,
  ICLASS_xt_iclass_shifts,
  ICLASS_xt_iclass_shiftst,
  ICLASS_xt_iclass_shiftt,
  ICLASS_xt_iclass_slli,
  ICLASS_xt_iclass_srai,
  ICLASS_xt_iclass_srli,
  ICLASS_xt_iclass_memw,
  ICLASS_xt_iclass_extw,
  ICLASS_xt_iclass_isync,
  ICLASS_xt_iclass_sync,
  ICLASS_xt_iclass_rsil,
  ICLASS_xt_iclass_rsr_lend,
  ICLASS_xt_iclass_wsr_lend,
  ICLASS_xt_iclass_xsr_lend,
  ICLASS_xt_iclass_rsr_lcount,
  ICLASS_xt_iclass_wsr_lcount,
  ICLASS_xt_iclass_xsr_lcount,
  ICLASS_xt_iclass_rsr_lbeg,
  ICLASS_xt_iclass_wsr_lbeg,
  ICLASS_xt_iclass_xsr_lbeg,
  ICLASS_xt_iclass_rsr_sar,
  ICLASS_xt_iclass_wsr_sar,
  ICLASS_xt_iclass_xsr_sar,
  ICLASS_xt_iclass_rsr_memctl,
  ICLASS_xt_iclass_wsr_memctl,
  ICLASS_xt_iclass_xsr_memctl,
  ICLASS_xt_iclass_rsr_litbase,
  ICLASS_xt_iclass_wsr_litbase,
  ICLASS_xt_iclass_xsr_litbase,
  ICLASS_xt_iclass_rsr_configid0,
  ICLASS_xt_iclass_wsr_configid0,
  ICLASS_xt_iclass_rsr_configid1,
  ICLASS_xt_iclass_rsr_243,
  ICLASS_xt_iclass_rsr_ps,
  ICLASS_xt_iclass_wsr_ps,
  ICLASS_xt_iclass_xsr_ps,
  ICLASS_xt_iclass_rsr_epc1,
  ICLASS_xt_iclass_wsr_epc1,
  ICLASS_xt_iclass_xsr_epc1,
  ICLASS_xt_iclass_rsr_excsave1,
  ICLASS_xt_iclass_wsr_excsave1,
  ICLASS_xt_iclass_xsr_excsave1,
  ICLASS_xt_iclass_rsr_epc2,
  ICLASS_xt_iclass_wsr_epc2,
  ICLASS_xt_iclass_xsr_epc2,
  ICLASS_xt_iclass_rsr_excsave2,
  ICLASS_xt_iclass_wsr_excsave2,
  ICLASS_xt_iclass_xsr_excsave2,
  ICLASS_xt_iclass_rsr_epc3,
  ICLASS_xt_iclass_wsr_epc3,
  ICLASS_xt_iclass_xsr_epc3,
  ICLASS_xt_iclass_rsr_excsave3,
  ICLASS_xt_iclass_wsr_excsave3,
  ICLASS_xt_iclass_xsr_excsave3,
  ICLASS_xt_iclass_rsr_epc4,
  ICLASS_xt_iclass_wsr_epc4,
  ICLASS_xt_iclass_xsr_epc4,
  ICLASS_xt_iclass_rsr_excsave4,
  ICLASS_xt_iclass_wsr_excsave4,
  ICLASS_xt_iclass_xsr_excsave4,
  ICLASS_xt_iclass_rsr_epc5,
  ICLASS_xt_iclass_wsr_epc5,
  ICLASS_xt_iclass_xsr_epc5,
  ICLASS_xt_iclass_rsr_excsave5,
  ICLASS_xt_iclass_wsr_excsave5,
  ICLASS_xt_iclass_xsr_excsave5,
  ICLASS_xt_iclass_rsr_epc6,
  ICLASS_xt_iclass_wsr_epc6,
  ICLASS_xt_iclass_xsr_epc6,
  ICLASS_xt_iclass_rsr_excsave6,
  ICLASS_xt_iclass_wsr_excsave6,
  ICLASS_xt_iclass_xsr_excsave6,
  ICLASS_xt_iclass_rsr_epc7,
  ICLASS_xt_iclass_wsr_epc7,
  ICLASS_xt_iclass_xsr_epc7,
  ICLASS_xt_iclass_rsr_excsave7,
  ICLASS_xt_iclass_wsr_excsave7,
  ICLASS_xt_iclass_xsr_excsave7,
  ICLASS_xt_iclass_rsr_eps2,
  ICLASS_xt_iclass_wsr_eps2,
  ICLASS_xt_iclass_xsr_eps2,
  ICLASS_xt_iclass_rsr_eps3,
  ICLASS_xt_iclass_wsr_eps3,
  ICLASS_xt_iclass_xsr_eps3,
  ICLASS_xt_iclass_rsr_eps4,
  ICLASS_xt_iclass_wsr_eps4,
  ICLASS_xt_iclass_xsr_eps4,
  ICLASS_xt_iclass_rsr_eps5,
  ICLASS_xt_iclass_wsr_eps5,
  ICLASS_xt_iclass_xsr_eps5,
  ICLASS_xt_iclass_rsr_eps6,
  ICLASS_xt_iclass_wsr_eps6,
  ICLASS_xt_iclass_xsr_eps6,
  ICLASS_xt_iclass_rsr_eps7,
  ICLASS_xt_iclass_wsr_eps7,
  ICLASS_xt_iclass_xsr_eps7,
  ICLASS_xt_iclass_rsr_excvaddr,
  ICLASS_xt_iclass_wsr_excvaddr,
  ICLASS_xt_iclass_xsr_excvaddr,
  ICLASS_xt_iclass_rsr_depc,
  ICLASS_xt_iclass_wsr_depc,
  ICLASS_xt_iclass_xsr_depc,
  ICLASS_xt_iclass_rsr_exccause,
  ICLASS_xt_iclass_wsr_exccause,
  ICLASS_xt_iclass_xsr_exccause,
  ICLASS_xt_iclass_rsr_misc0,
  ICLASS_xt_iclass_wsr_misc0,
  ICLASS_xt_iclass_xsr_misc0,
  ICLASS_xt_iclass_rsr_misc1,
  ICLASS_xt_iclass_wsr_misc1,
  ICLASS_xt_iclass_xsr_misc1,
  ICLASS_xt_iclass_rsr_prid,
  ICLASS_xt_iclass_rsr_vecbase,
  ICLASS_xt_iclass_wsr_vecbase,
  ICLASS_xt_iclass_xsr_vecbase,
  ICLASS_xt_mul16,
  ICLASS_xt_mul32,
  ICLASS_xt_mul32h,
  ICLASS_xt_iclass_mac16_aa,
  ICLASS_xt_iclass_mac16_ad,
  ICLASS_xt_iclass_mac16_da,
  ICLASS_xt_iclass_mac16_dd,
  ICLASS_xt_iclass_mac16a_aa,
  ICLASS_xt_iclass_mac16a_ad,
  ICLASS_xt_iclass_mac16a_da,
  ICLASS_xt_iclass_mac16a_dd,
  ICLASS_xt_iclass_mac16al_da,
  ICLASS_xt_iclass_mac16al_dd,
  ICLASS_xt_iclass_mac16_l,
  ICLASS_xt_iclass_rsr_m0,
  ICLASS_xt_iclass_wsr_m0,
  ICLASS_xt_iclass_xsr_m0,
  ICLASS_xt_iclass_rsr_m1,
  ICLASS_xt_iclass_wsr_m1,
  ICLASS_xt_iclass_xsr_m1,
  ICLASS_xt_iclass_rsr_m2,
  ICLASS_xt_iclass_wsr_m2,
  ICLASS_xt_iclass_xsr_m2,
  ICLASS_xt_iclass_rsr_m3,
  ICLASS_xt_iclass_wsr_m3,
  ICLASS_xt_iclass_xsr_m3,
  ICLASS_xt_iclass_rsr_acclo,
  ICLASS_xt_iclass_wsr_acclo,
  ICLASS_xt_iclass_xsr_acclo,
  ICLASS_xt_iclass_rsr_acchi,
  ICLASS_xt_iclass_wsr_acchi,
  ICLASS_xt_iclass_xsr_acchi,
  ICLASS_xt_iclass_rfi,
  ICLASS_xt_iclass_wait,
  ICLASS_xt_iclass_rsr_interrupt,
  ICLASS_xt_iclass_wsr_intset,
  ICLASS_xt_iclass_wsr_intclear,
  ICLASS_xt_iclass_rsr_intenable,
  ICLASS_xt_iclass_wsr_intenable,
  ICLASS_xt_iclass_xsr_intenable,
  ICLASS_xt_iclass_break,
  ICLASS_xt_iclass_break_n,
  ICLASS_xt_iclass_rsr_dbreaka0,
  ICLASS_xt_iclass_wsr_dbreaka0,
  ICLASS_xt_iclass_xsr_dbreaka0,
  ICLASS_xt_iclass_rsr_dbreakc0,
  ICLASS_xt_iclass_wsr_dbreakc0,
  ICLASS_xt_iclass_xsr_dbreakc0,
  ICLASS_xt_iclass_rsr_dbreaka1,
  ICLASS_xt_iclass_wsr_dbreaka1,
  ICLASS_xt_iclass_xsr_dbreaka1,
  ICLASS_xt_iclass_rsr_dbreakc1,
  ICLASS_xt_iclass_wsr_dbreakc1,
  ICLASS_xt_iclass_xsr_dbreakc1,
  ICLASS_xt_iclass_rsr_ibreaka0,
  ICLASS_xt_iclass_wsr_ibreaka0,
  ICLASS_xt_iclass_xsr_ibreaka0,
  ICLASS_xt_iclass_rsr_ibreaka1,
  ICLASS_xt_iclass_wsr_ibreaka1,
  ICLASS_xt_iclass_xsr_ibreaka1,
  ICLASS_xt_iclass_rsr_ibreakenable,
  ICLASS_xt_iclass_wsr_ibreakenable,
  ICLASS_xt_iclass_xsr_ibreakenable,
  ICLASS_xt_iclass_rsr_debugcause,
  ICLASS_xt_iclass_wsr_debugcause,
  ICLASS_xt_iclass_xsr_debugcause,
  ICLASS_xt_iclass_rsr_icount,
  ICLASS_xt_iclass_wsr_icount,
  ICLASS_xt_iclass_xsr_icount,
  ICLASS_xt_iclass_rsr_icountlevel,
  ICLASS_xt_iclass_wsr_icountlevel,
  ICLASS_xt_iclass_xsr_icountlevel,
  ICLASS_xt_iclass_rsr_ddr,
  ICLASS_xt_iclass_wsr_ddr,
  ICLASS_xt_iclass_xsr_ddr,
  ICLASS_xt_iclass_lddr32_p,
  ICLASS_xt_iclass_sddr32_p,
  ICLASS_xt_iclass_rfdo,
  ICLASS_xt_iclass_rfdd,
  ICLASS_xt_iclass_wsr_mmid,
  ICLASS_xt_iclass_bbool1,
  ICLASS_xt_iclass_bbool4,
  ICLASS_xt_iclass_bbool8,
  ICLASS_xt_iclass_bbranch,
  ICLASS_xt_iclass_bmove,
  ICLASS_xt_iclass_RSR_BR,
  ICLASS_xt_iclass_WSR_BR,
  ICLASS_xt_iclass_XSR_BR,
  ICLASS_xt_iclass_rsr_ccount,
  ICLASS_xt_iclass_wsr_ccount,
  ICLASS_xt_iclass_xsr_ccount,
  ICLASS_xt_iclass_rsr_ccompare0,
  ICLASS_xt_iclass_wsr_ccompare0,
  ICLASS_xt_iclass_xsr_ccompare0,
  ICLASS_xt_iclass_rsr_ccompare1,
  ICLASS_xt_iclass_wsr_ccompare1,
  ICLASS_xt_iclass_xsr_ccompare1,
  ICLASS_xt_iclass_rsr_ccompare2,
  ICLASS_xt_iclass_wsr_ccompare2,
  ICLASS_xt_iclass_xsr_ccompare2,
  ICLASS_xt_iclass_icache,
  ICLASS_xt_iclass_icache_lock,
  ICLASS_xt_iclass_icache_inv,
  ICLASS_xt_iclass_licx,
  ICLASS_xt_iclass_sicx,
  ICLASS_xt_iclass_dcache,
  ICLASS_xt_iclass_dcache_dyn,
  ICLASS_xt_iclass_dcache_ind,
  ICLASS_xt_iclass_dcache_inv,
  ICLASS_xt_iclass_dpf,
  ICLASS_xt_iclass_dcache_lock,
  ICLASS_xt_iclass_sdct,
  ICLASS_xt_iclass_ldct,
  ICLASS_xt_iclass_rsr_prefctl,
  ICLASS_xt_iclass_wsr_prefctl,
  ICLASS_xt_iclass_xsr_prefctl,
  ICLASS_xt_iclass_wsr_ptevaddr,
  ICLASS_xt_iclass_rsr_ptevaddr,
  ICLASS_xt_iclass_xsr_ptevaddr,
  ICLASS_xt_iclass_rsr_rasid,
  ICLASS_xt_iclass_wsr_rasid,
  ICLASS_xt_iclass_xsr_rasid,
  ICLASS_xt_iclass_rsr_itlbcfg,
  ICLASS_xt_iclass_wsr_itlbcfg,
  ICLASS_xt_iclass_xsr_itlbcfg,
  ICLASS_xt_iclass_rsr_dtlbcfg,
  ICLASS_xt_iclass_wsr_dtlbcfg,
  ICLASS_xt_iclass_xsr_dtlbcfg,
  ICLASS_xt_iclass_idtlb,
  ICLASS_xt_iclass_rdtlb,
  ICLASS_xt_iclass_wdtlb,
  ICLASS_xt_iclass_iitlb,
  ICLASS_xt_iclass_ritlb,
  ICLASS_xt_iclass_witlb,
  ICLASS_xt_iclass_ldpte,
  ICLASS_xt_iclass_hwwitlba,
  ICLASS_xt_iclass_hwwdtlba,
  ICLASS_xt_iclass_rsr_cpenable,
  ICLASS_xt_iclass_wsr_cpenable,
  ICLASS_xt_iclass_xsr_cpenable,
  ICLASS_xt_iclass_clamp,
  ICLASS_xt_iclass_minmax,
  ICLASS_xt_iclass_nsa,
  ICLASS_xt_iclass_sx,
  ICLASS_xt_iclass_l32ai,
  ICLASS_xt_iclass_s32ri,
  ICLASS_xt_iclass_s32c1i,
  ICLASS_xt_iclass_rsr_scompare1,
  ICLASS_xt_iclass_wsr_scompare1,
  ICLASS_xt_iclass_xsr_scompare1,
  ICLASS_xt_iclass_rsr_atomctl,
  ICLASS_xt_iclass_wsr_atomctl,
  ICLASS_xt_iclass_xsr_atomctl,
  ICLASS_xt_iclass_div,
  ICLASS_xt_iclass_rer,
  ICLASS_xt_iclass_wer,
  ICLASS_rur_ae_ovf_sar,
  ICLASS_wur_ae_ovf_sar,
  ICLASS_rur_ae_bithead,
  ICLASS_wur_ae_bithead,
  ICLASS_rur_ae_ts_fts_bu_bp,
  ICLASS_wur_ae_ts_fts_bu_bp,
  ICLASS_rur_ae_sd_no,
  ICLASS_wur_ae_sd_no,
  ICLASS_ae_iclass_rur_ae_overflow,
  ICLASS_ae_iclass_wur_ae_overflow,
  ICLASS_ae_iclass_rur_ae_sar,
  ICLASS_ae_iclass_wur_ae_sar,
  ICLASS_ae_iclass_rur_ae_bitptr,
  ICLASS_ae_iclass_wur_ae_bitptr,
  ICLASS_ae_iclass_rur_ae_bitsused,
  ICLASS_ae_iclass_wur_ae_bitsused,
  ICLASS_ae_iclass_rur_ae_tablesize,
  ICLASS_ae_iclass_wur_ae_tablesize,
  ICLASS_ae_iclass_rur_ae_first_ts,
  ICLASS_ae_iclass_wur_ae_first_ts,
  ICLASS_ae_iclass_rur_ae_nextoffset,
  ICLASS_ae_iclass_wur_ae_nextoffset,
  ICLASS_ae_iclass_rur_ae_searchdone,
  ICLASS_ae_iclass_wur_ae_searchdone,
  ICLASS_ae_iclass_lp16f_i,
  ICLASS_ae_iclass_lp16f_iu,
  ICLASS_ae_iclass_lp16f_x,
  ICLASS_ae_iclass_lp16f_xu,
  ICLASS_ae_iclass_lp24_i,
  ICLASS_ae_iclass_lp24_iu,
  ICLASS_ae_iclass_lp24_x,
  ICLASS_ae_iclass_lp24_xu,
  ICLASS_ae_iclass_lp24f_i,
  ICLASS_ae_iclass_lp24f_iu,
  ICLASS_ae_iclass_lp24f_x,
  ICLASS_ae_iclass_lp24f_xu,
  ICLASS_ae_iclass_lp16x2f_i,
  ICLASS_ae_iclass_lp16x2f_iu,
  ICLASS_ae_iclass_lp16x2f_x,
  ICLASS_ae_iclass_lp16x2f_xu,
  ICLASS_ae_iclass_lp24x2f_i,
  ICLASS_ae_iclass_lp24x2f_iu,
  ICLASS_ae_iclass_lp24x2f_x,
  ICLASS_ae_iclass_lp24x2f_xu,
  ICLASS_ae_iclass_lp24x2_i,
  ICLASS_ae_iclass_lp24x2_iu,
  ICLASS_ae_iclass_lp24x2_x,
  ICLASS_ae_iclass_lp24x2_xu,
  ICLASS_ae_iclass_sp16x2f_i,
  ICLASS_ae_iclass_sp16x2f_iu,
  ICLASS_ae_iclass_sp16x2f_x,
  ICLASS_ae_iclass_sp16x2f_xu,
  ICLASS_ae_iclass_sp24x2s_i,
  ICLASS_ae_iclass_sp24x2s_iu,
  ICLASS_ae_iclass_sp24x2s_x,
  ICLASS_ae_iclass_sp24x2s_xu,
  ICLASS_ae_iclass_sp24x2f_i,
  ICLASS_ae_iclass_sp24x2f_iu,
  ICLASS_ae_iclass_sp24x2f_x,
  ICLASS_ae_iclass_sp24x2f_xu,
  ICLASS_ae_iclass_sp16f_l_i,
  ICLASS_ae_iclass_sp16f_l_iu,
  ICLASS_ae_iclass_sp16f_l_x,
  ICLASS_ae_iclass_sp16f_l_xu,
  ICLASS_ae_iclass_sp24s_l_i,
  ICLASS_ae_iclass_sp24s_l_iu,
  ICLASS_ae_iclass_sp24s_l_x,
  ICLASS_ae_iclass_sp24s_l_xu,
  ICLASS_ae_iclass_sp24f_l_i,
  ICLASS_ae_iclass_sp24f_l_iu,
  ICLASS_ae_iclass_sp24f_l_x,
  ICLASS_ae_iclass_sp24f_l_xu,
  ICLASS_ae_iclass_lq56_i,
  ICLASS_ae_iclass_lq56_iu,
  ICLASS_ae_iclass_lq56_x,
  ICLASS_ae_iclass_lq56_xu,
  ICLASS_ae_iclass_lq32f_i,
  ICLASS_ae_iclass_lq32f_iu,
  ICLASS_ae_iclass_lq32f_x,
  ICLASS_ae_iclass_lq32f_xu,
  ICLASS_ae_iclass_sq56s_i,
  ICLASS_ae_iclass_sq56s_iu,
  ICLASS_ae_iclass_sq56s_x,
  ICLASS_ae_iclass_sq56s_xu,
  ICLASS_ae_iclass_sq32f_i,
  ICLASS_ae_iclass_sq32f_iu,
  ICLASS_ae_iclass_sq32f_x,
  ICLASS_ae_iclass_sq32f_xu,
  ICLASS_ae_iclass_zerop48,
  ICLASS_ae_iclass_movp48,
  ICLASS_ae_iclass_selp24_ll,
  ICLASS_ae_iclass_selp24_lh,
  ICLASS_ae_iclass_selp24_hl,
  ICLASS_ae_iclass_selp24_hh,
  ICLASS_ae_iclass_movtp24x2,
  ICLASS_ae_iclass_movfp24x2,
  ICLASS_ae_iclass_movtp48,
  ICLASS_ae_iclass_movfp48,
  ICLASS_ae_iclass_movpa24x2,
  ICLASS_ae_iclass_truncp24a32x2,
  ICLASS_ae_iclass_cvta32p24_l,
  ICLASS_ae_iclass_cvta32p24_h,
  ICLASS_ae_iclass_cvtp24a16x2_ll,
  ICLASS_ae_iclass_cvtp24a16x2_lh,
  ICLASS_ae_iclass_cvtp24a16x2_hl,
  ICLASS_ae_iclass_cvtp24a16x2_hh,
  ICLASS_ae_iclass_truncp24q48x2,
  ICLASS_ae_iclass_truncp16,
  ICLASS_ae_iclass_roundsp24q48sym,
  ICLASS_ae_iclass_roundsp24q48asym,
  ICLASS_ae_iclass_roundsp16q48sym,
  ICLASS_ae_iclass_roundsp16q48asym,
  ICLASS_ae_iclass_roundsp16sym,
  ICLASS_ae_iclass_roundsp16asym,
  ICLASS_ae_iclass_zeroq56,
  ICLASS_ae_iclass_movq56,
  ICLASS_ae_iclass_movtq56,
  ICLASS_ae_iclass_movfq56,
  ICLASS_ae_iclass_cvtq48a32s,
  ICLASS_ae_iclass_cvtq48p24s_l,
  ICLASS_ae_iclass_cvtq48p24s_h,
  ICLASS_ae_iclass_satq48s,
  ICLASS_ae_iclass_truncq32,
  ICLASS_ae_iclass_roundsq32sym,
  ICLASS_ae_iclass_roundsq32asym,
  ICLASS_ae_iclass_trunca32q48,
  ICLASS_ae_iclass_movap24s_l,
  ICLASS_ae_iclass_movap24s_h,
  ICLASS_ae_iclass_trunca16p24s_l,
  ICLASS_ae_iclass_trunca16p24s_h,
  ICLASS_ae_iclass_addp24,
  ICLASS_ae_iclass_subp24,
  ICLASS_ae_iclass_negp24,
  ICLASS_ae_iclass_absp24,
  ICLASS_ae_iclass_maxp24s,
  ICLASS_ae_iclass_minp24s,
  ICLASS_ae_iclass_maxbp24s,
  ICLASS_ae_iclass_minbp24s,
  ICLASS_ae_iclass_addsp24s,
  ICLASS_ae_iclass_subsp24s,
  ICLASS_ae_iclass_negsp24s,
  ICLASS_ae_iclass_abssp24s,
  ICLASS_ae_iclass_andp48,
  ICLASS_ae_iclass_nandp48,
  ICLASS_ae_iclass_orp48,
  ICLASS_ae_iclass_xorp48,
  ICLASS_ae_iclass_ltp24s,
  ICLASS_ae_iclass_lep24s,
  ICLASS_ae_iclass_eqp24,
  ICLASS_ae_iclass_addq56,
  ICLASS_ae_iclass_subq56,
  ICLASS_ae_iclass_negq56,
  ICLASS_ae_iclass_absq56,
  ICLASS_ae_iclass_maxq56s,
  ICLASS_ae_iclass_minq56s,
  ICLASS_ae_iclass_maxbq56s,
  ICLASS_ae_iclass_minbq56s,
  ICLASS_ae_iclass_addsq56s,
  ICLASS_ae_iclass_subsq56s,
  ICLASS_ae_iclass_negsq56s,
  ICLASS_ae_iclass_abssq56s,
  ICLASS_ae_iclass_andq56,
  ICLASS_ae_iclass_nandq56,
  ICLASS_ae_iclass_orq56,
  ICLASS_ae_iclass_xorq56,
  ICLASS_ae_iclass_sllip24,
  ICLASS_ae_iclass_srlip24,
  ICLASS_ae_iclass_sraip24,
  ICLASS_ae_iclass_sllsp24,
  ICLASS_ae_iclass_srlsp24,
  ICLASS_ae_iclass_srasp24,
  ICLASS_ae_iclass_sllisp24s,
  ICLASS_ae_iclass_sllssp24s,
  ICLASS_ae_iclass_slliq56,
  ICLASS_ae_iclass_srliq56,
  ICLASS_ae_iclass_sraiq56,
  ICLASS_ae_iclass_sllsq56,
  ICLASS_ae_iclass_srlsq56,
  ICLASS_ae_iclass_srasq56,
  ICLASS_ae_iclass_sllaq56,
  ICLASS_ae_iclass_srlaq56,
  ICLASS_ae_iclass_sraaq56,
  ICLASS_ae_iclass_sllisq56s,
  ICLASS_ae_iclass_sllssq56s,
  ICLASS_ae_iclass_sllasq56s,
  ICLASS_ae_iclass_ltq56s,
  ICLASS_ae_iclass_leq56s,
  ICLASS_ae_iclass_eqq56,
  ICLASS_ae_iclass_nsaq56s,
  ICLASS_ae_iclass_mulsrfq32sp24s_h,
  ICLASS_ae_iclass_mulsrfq32sp24s_l,
  ICLASS_ae_iclass_mularfq32sp24s_h,
  ICLASS_ae_iclass_mularfq32sp24s_l,
  ICLASS_ae_iclass_mulrfq32sp24s_h,
  ICLASS_ae_iclass_mulrfq32sp24s_l,
  ICLASS_ae_iclass_mulsfq32sp24s_h,
  ICLASS_ae_iclass_mulsfq32sp24s_l,
  ICLASS_ae_iclass_mulafq32sp24s_h,
  ICLASS_ae_iclass_mulafq32sp24s_l,
  ICLASS_ae_iclass_mulfq32sp24s_h,
  ICLASS_ae_iclass_mulfq32sp24s_l,
  ICLASS_ae_iclass_mulfs32p16s_ll,
  ICLASS_ae_iclass_mulfp24s_ll,
  ICLASS_ae_iclass_mulp24s_ll,
  ICLASS_ae_iclass_mulfs32p16s_lh,
  ICLASS_ae_iclass_mulfp24s_lh,
  ICLASS_ae_iclass_mulp24s_lh,
  ICLASS_ae_iclass_mulfs32p16s_hl,
  ICLASS_ae_iclass_mulfp24s_hl,
  ICLASS_ae_iclass_mulp24s_hl,
  ICLASS_ae_iclass_mulfs32p16s_hh,
  ICLASS_ae_iclass_mulfp24s_hh,
  ICLASS_ae_iclass_mulp24s_hh,
  ICLASS_ae_iclass_mulafs32p16s_ll,
  ICLASS_ae_iclass_mulafp24s_ll,
  ICLASS_ae_iclass_mulap24s_ll,
  ICLASS_ae_iclass_mulafs32p16s_lh,
  ICLASS_ae_iclass_mulafp24s_lh,
  ICLASS_ae_iclass_mulap24s_lh,
  ICLASS_ae_iclass_mulafs32p16s_hl,
  ICLASS_ae_iclass_mulafp24s_hl,
  ICLASS_ae_iclass_mulap24s_hl,
  ICLASS_ae_iclass_mulafs32p16s_hh,
  ICLASS_ae_iclass_mulafp24s_hh,
  ICLASS_ae_iclass_mulap24s_hh,
  ICLASS_ae_iclass_mulsfs32p16s_ll,
  ICLASS_ae_iclass_mulsfp24s_ll,
  ICLASS_ae_iclass_mulsp24s_ll,
  ICLASS_ae_iclass_mulsfs32p16s_lh,
  ICLASS_ae_iclass_mulsfp24s_lh,
  ICLASS_ae_iclass_mulsp24s_lh,
  ICLASS_ae_iclass_mulsfs32p16s_hl,
  ICLASS_ae_iclass_mulsfp24s_hl,
  ICLASS_ae_iclass_mulsp24s_hl,
  ICLASS_ae_iclass_mulsfs32p16s_hh,
  ICLASS_ae_iclass_mulsfp24s_hh,
  ICLASS_ae_iclass_mulsp24s_hh,
  ICLASS_ae_iclass_mulafs56p24s_ll,
  ICLASS_ae_iclass_mulas56p24s_ll,
  ICLASS_ae_iclass_mulafs56p24s_lh,
  ICLASS_ae_iclass_mulas56p24s_lh,
  ICLASS_ae_iclass_mulafs56p24s_hl,
  ICLASS_ae_iclass_mulas56p24s_hl,
  ICLASS_ae_iclass_mulafs56p24s_hh,
  ICLASS_ae_iclass_mulas56p24s_hh,
  ICLASS_ae_iclass_mulsfs56p24s_ll,
  ICLASS_ae_iclass_mulss56p24s_ll,
  ICLASS_ae_iclass_mulsfs56p24s_lh,
  ICLASS_ae_iclass_mulss56p24s_lh,
  ICLASS_ae_iclass_mulsfs56p24s_hl,
  ICLASS_ae_iclass_mulss56p24s_hl,
  ICLASS_ae_iclass_mulsfs56p24s_hh,
  ICLASS_ae_iclass_mulss56p24s_hh,
  ICLASS_ae_iclass_mulfq32sp16s_l,
  ICLASS_ae_iclass_mulfq32sp16s_h,
  ICLASS_ae_iclass_mulfq32sp16u_l,
  ICLASS_ae_iclass_mulfq32sp16u_h,
  ICLASS_ae_iclass_mulq32sp16s_l,
  ICLASS_ae_iclass_mulq32sp16s_h,
  ICLASS_ae_iclass_mulq32sp16u_l,
  ICLASS_ae_iclass_mulq32sp16u_h,
  ICLASS_ae_iclass_mulafq32sp16s_l,
  ICLASS_ae_iclass_mulafq32sp16s_h,
  ICLASS_ae_iclass_mulafq32sp16u_l,
  ICLASS_ae_iclass_mulafq32sp16u_h,
  ICLASS_ae_iclass_mulaq32sp16s_l,
  ICLASS_ae_iclass_mulaq32sp16s_h,
  ICLASS_ae_iclass_mulaq32sp16u_l,
  ICLASS_ae_iclass_mulaq32sp16u_h,
  ICLASS_ae_iclass_mulsfq32sp16s_l,
  ICLASS_ae_iclass_mulsfq32sp16s_h,
  ICLASS_ae_iclass_mulsfq32sp16u_l,
  ICLASS_ae_iclass_mulsfq32sp16u_h,
  ICLASS_ae_iclass_mulsq32sp16s_l,
  ICLASS_ae_iclass_mulsq32sp16s_h,
  ICLASS_ae_iclass_mulsq32sp16u_l,
  ICLASS_ae_iclass_mulsq32sp16u_h,
  ICLASS_ae_iclass_mulzaaq32sp16s_ll,
  ICLASS_ae_iclass_mulzaafq32sp16s_ll,
  ICLASS_ae_iclass_mulzaaq32sp16u_ll,
  ICLASS_ae_iclass_mulzaafq32sp16u_ll,
  ICLASS_ae_iclass_mulzaaq32sp16s_hh,
  ICLASS_ae_iclass_mulzaafq32sp16s_hh,
  ICLASS_ae_iclass_mulzaaq32sp16u_hh,
  ICLASS_ae_iclass_mulzaafq32sp16u_hh,
  ICLASS_ae_iclass_mulzaaq32sp16s_lh,
  ICLASS_ae_iclass_mulzaafq32sp16s_lh,
  ICLASS_ae_iclass_mulzaaq32sp16u_lh,
  ICLASS_ae_iclass_mulzaafq32sp16u_lh,
  ICLASS_ae_iclass_mulzasq32sp16s_ll,
  ICLASS_ae_iclass_mulzasfq32sp16s_ll,
  ICLASS_ae_iclass_mulzasq32sp16u_ll,
  ICLASS_ae_iclass_mulzasfq32sp16u_ll,
  ICLASS_ae_iclass_mulzasq32sp16s_hh,
  ICLASS_ae_iclass_mulzasfq32sp16s_hh,
  ICLASS_ae_iclass_mulzasq32sp16u_hh,
  ICLASS_ae_iclass_mulzasfq32sp16u_hh,
  ICLASS_ae_iclass_mulzasq32sp16s_lh,
  ICLASS_ae_iclass_mulzasfq32sp16s_lh,
  ICLASS_ae_iclass_mulzasq32sp16u_lh,
  ICLASS_ae_iclass_mulzasfq32sp16u_lh,
  ICLASS_ae_iclass_mulzsaq32sp16s_ll,
  ICLASS_ae_iclass_mulzsafq32sp16s_ll,
  ICLASS_ae_iclass_mulzsaq32sp16u_ll,
  ICLASS_ae_iclass_mulzsafq32sp16u_ll,
  ICLASS_ae_iclass_mulzsaq32sp16s_hh,
  ICLASS_ae_iclass_mulzsafq32sp16s_hh,
  ICLASS_ae_iclass_mulzsaq32sp16u_hh,
  ICLASS_ae_iclass_mulzsafq32sp16u_hh,
  ICLASS_ae_iclass_mulzsaq32sp16s_lh,
  ICLASS_ae_iclass_mulzsafq32sp16s_lh,
  ICLASS_ae_iclass_mulzsaq32sp16u_lh,
  ICLASS_ae_iclass_mulzsafq32sp16u_lh,
  ICLASS_ae_iclass_mulzssq32sp16s_ll,
  ICLASS_ae_iclass_mulzssfq32sp16s_ll,
  ICLASS_ae_iclass_mulzssq32sp16u_ll,
  ICLASS_ae_iclass_mulzssfq32sp16u_ll,
  ICLASS_ae_iclass_mulzssq32sp16s_hh,
  ICLASS_ae_iclass_mulzssfq32sp16s_hh,
  ICLASS_ae_iclass_mulzssq32sp16u_hh,
  ICLASS_ae_iclass_mulzssfq32sp16u_hh,
  ICLASS_ae_iclass_mulzssq32sp16s_lh,
  ICLASS_ae_iclass_mulzssfq32sp16s_lh,
  ICLASS_ae_iclass_mulzssq32sp16u_lh,
  ICLASS_ae_iclass_mulzssfq32sp16u_lh,
  ICLASS_ae_iclass_mulzaafp24s_hh_ll,
  ICLASS_ae_iclass_mulzaap24s_hh_ll,
  ICLASS_ae_iclass_mulzaafp24s_hl_lh,
  ICLASS_ae_iclass_mulzaap24s_hl_lh,
  ICLASS_ae_iclass_mulzasfp24s_hh_ll,
  ICLASS_ae_iclass_mulzasp24s_hh_ll,
  ICLASS_ae_iclass_mulzasfp24s_hl_lh,
  ICLASS_ae_iclass_mulzasp24s_hl_lh,
  ICLASS_ae_iclass_mulzsafp24s_hh_ll,
  ICLASS_ae_iclass_mulzsap24s_hh_ll,
  ICLASS_ae_iclass_mulzsafp24s_hl_lh,
  ICLASS_ae_iclass_mulzsap24s_hl_lh,
  ICLASS_ae_iclass_mulzssfp24s_hh_ll,
  ICLASS_ae_iclass_mulzssp24s_hh_ll,
  ICLASS_ae_iclass_mulzssfp24s_hl_lh,
  ICLASS_ae_iclass_mulzssp24s_hl_lh,
  ICLASS_ae_iclass_mulaafp24s_hh_ll,
  ICLASS_ae_iclass_mulaap24s_hh_ll,
  ICLASS_ae_iclass_mulaafp24s_hl_lh,
  ICLASS_ae_iclass_mulaap24s_hl_lh,
  ICLASS_ae_iclass_mulasfp24s_hh_ll,
  ICLASS_ae_iclass_mulasp24s_hh_ll,
  ICLASS_ae_iclass_mulasfp24s_hl_lh,
  ICLASS_ae_iclass_mulasp24s_hl_lh,
  ICLASS_ae_iclass_mulsafp24s_hh_ll,
  ICLASS_ae_iclass_mulsap24s_hh_ll,
  ICLASS_ae_iclass_mulsafp24s_hl_lh,
  ICLASS_ae_iclass_mulsap24s_hl_lh,
  ICLASS_ae_iclass_mulssfp24s_hh_ll,
  ICLASS_ae_iclass_mulssp24s_hh_ll,
  ICLASS_ae_iclass_mulssfp24s_hl_lh,
  ICLASS_ae_iclass_mulssp24s_hl_lh,
  ICLASS_ae_iclass_sha32,
  ICLASS_ae_iclass_vldl32t,
  ICLASS_ae_iclass_vldl16t,
  ICLASS_ae_iclass_vldl16c,
  ICLASS_ae_iclass_vldsht,
  ICLASS_ae_iclass_lb,
  ICLASS_ae_iclass_lbi,
  ICLASS_ae_iclass_lbk,
  ICLASS_ae_iclass_lbki,
  ICLASS_ae_iclass_db,
  ICLASS_ae_iclass_dbi,
  ICLASS_ae_iclass_vlel32t,
  ICLASS_ae_iclass_vlel16t,
  ICLASS_ae_iclass_sb,
  ICLASS_ae_iclass_sbi,
  ICLASS_ae_iclass_vles16c,
  ICLASS_ae_iclass_sbf,
  ICLASS_icls_AE_SLAASQ56S,
  ICLASS_icls_AE_ADDBRBA32,
  ICLASS_icls_AE_MINABSSP24S,
  ICLASS_icls_AE_MAXABSSP24S,
  ICLASS_icls_AE_MINABSSQ56S,
  ICLASS_icls_AE_MAXABSSQ56S,
  ICLASS_rur_ae_cbegin0,
  ICLASS_wur_ae_cbegin0,
  ICLASS_rur_ae_cend0,
  ICLASS_wur_ae_cend0,
  ICLASS_icls_AE_LP24X2_C,
  ICLASS_icls_AE_SP24X2S_C,
  ICLASS_icls_AE_LP24X2F_C,
  ICLASS_icls_AE_SP24X2F_C,
  ICLASS_icls_AE_LP16X2F_C,
  ICLASS_icls_AE_SP16X2F_C,
  ICLASS_icls_AE_LP24_C,
  ICLASS_icls_AE_SP24S_L_C,
  ICLASS_icls_AE_LP24F_C,
  ICLASS_icls_AE_SP24F_L_C,
  ICLASS_icls_AE_LP16F_C,
  ICLASS_icls_AE_SP16F_L_C,
  ICLASS_icls_AE_LQ56_C,
  ICLASS_icls_AE_SQ56S_C,
  ICLASS_icls_AE_LQ32F_C,
  ICLASS_icls_AE_SQ32F_C,
  ICLASS_rur_expstate,
  ICLASS_wur_expstate,
  ICLASS_iclass_READ_IMPWIRE,
  ICLASS_iclass_SETB_EXPSTATE,
  ICLASS_iclass_CLRB_EXPSTATE,
  ICLASS_iclass_WRMSK_EXPSTATE
};


/*  Opcode encodings.  */

static void
Opcode_excw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80200;
}

static void
Opcode_rfe_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300;
}

static void
Opcode_rfde_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2300;
}

static void
Opcode_syscall_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x500;
}

static void
Opcode_call12_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5c0000;
}

static void
Opcode_call8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x580000;
}

static void
Opcode_call4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x540000;
}

static void
Opcode_callx12_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0000;
}

static void
Opcode_callx8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb0000;
}

static void
Opcode_callx4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70000;
}

static void
Opcode_entry_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6c0000;
}

static void
Opcode_movsp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100;
}

static void
Opcode_rotw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x804;
}

static void
Opcode_retw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x60000;
}

static void
Opcode_retw_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd10f;
}

static void
Opcode_rfwo_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4300;
}

static void
Opcode_rfwu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5300;
}

static void
Opcode_l32e_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90;
}

static void
Opcode_s32e_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x94;
}

static void
Opcode_rsr_windowbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4830;
}

static void
Opcode_wsr_windowbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4831;
}

static void
Opcode_xsr_windowbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4816;
}

static void
Opcode_rsr_windowstart_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4930;
}

static void
Opcode_wsr_windowstart_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4931;
}

static void
Opcode_xsr_windowstart_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4916;
}

static void
Opcode_add_n_Slot_inst16a_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa000;
}

static void
Opcode_addi_n_Slot_inst16a_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb000;
}

static void
Opcode_beqz_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc800;
}

static void
Opcode_bnez_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc00;
}

static void
Opcode_ill_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd60f;
}

static void
Opcode_l32i_n_Slot_inst16a_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8000;
}

static void
Opcode_mov_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd000;
}

static void
Opcode_movi_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc000;
}

static void
Opcode_nop_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd30f;
}

static void
Opcode_ret_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00f;
}

static void
Opcode_s32i_n_Slot_inst16a_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9000;
}

static void
Opcode_rur_threadptr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7e03e;
}

static void
Opcode_wur_threadptr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe73f;
}

static void
Opcode_addi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200c00;
}

static void
Opcode_addi_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100002;
}

static void
Opcode_addmi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200d00;
}

static void
Opcode_addmi_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200002;
}

static void
Opcode_add_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8;
}

static void
Opcode_add_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb81;
}

static void
Opcode_sub_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc;
}

static void
Opcode_sub_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf01;
}

static void
Opcode_addx2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9;
}

static void
Opcode_addx2_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1381;
}

static void
Opcode_addx4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa;
}

static void
Opcode_addx4_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2381;
}

static void
Opcode_addx8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb;
}

static void
Opcode_addx8_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4b81;
}

static void
Opcode_subx2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd;
}

static void
Opcode_subx2_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4d01;
}

static void
Opcode_subx4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe;
}

static void
Opcode_subx4_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf81;
}

static void
Opcode_subx8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf;
}

static void
Opcode_subx8_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4d81;
}

static void
Opcode_and_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1;
}

static void
Opcode_and_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b81;
}

static void
Opcode_or_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2;
}

static void
Opcode_or_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2501;
}

static void
Opcode_xor_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3;
}

static void
Opcode_xor_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4f01;
}

static void
Opcode_beqi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x680000;
}

static void
Opcode_beqi_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3;
}

static void
Opcode_bnei_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x690000;
}

static void
Opcode_bnei_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1800003;
}

static void
Opcode_bgei_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6b0000;
}

static void
Opcode_bgei_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800003;
}

static void
Opcode_blti_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a0000;
}

static void
Opcode_blti_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2000003;
}

static void
Opcode_bbci_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700600;
}

static void
Opcode_bbci_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2;
}

static void
Opcode_bbsi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700e00;
}

static void
Opcode_bbsi_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80002;
}

static void
Opcode_bgeui_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6f0000;
}

static void
Opcode_bgeui_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1000003;
}

static void
Opcode_bltui_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6e0000;
}

static void
Opcode_bltui_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000003;
}

static void
Opcode_beq_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700100;
}

static void
Opcode_beq_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300002;
}

static void
Opcode_bne_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700900;
}

static void
Opcode_bne_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4;
}

static void
Opcode_bge_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700a00;
}

static void
Opcode_bge_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600002;
}

static void
Opcode_blt_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700200;
}

static void
Opcode_blt_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x680002;
}

static void
Opcode_bgeu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700b00;
}

static void
Opcode_bgeu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x380002;
}

static void
Opcode_bltu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700300;
}

static void
Opcode_bltu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700002;
}

static void
Opcode_bany_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700800;
}

static void
Opcode_bany_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x500002;
}

static void
Opcode_bnone_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700000;
}

static void
Opcode_bnone_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80004;
}

static void
Opcode_ball_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700400;
}

static void
Opcode_ball_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180002;
}

static void
Opcode_bnall_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700c00;
}

static void
Opcode_bnall_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x780002;
}

static void
Opcode_bbc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700500;
}

static void
Opcode_bbc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x580002;
}

static void
Opcode_bbs_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700d00;
}

static void
Opcode_bbs_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280002;
}

static void
Opcode_beqz_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x640000;
}

static void
Opcode_beqz_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x101;
}

static void
Opcode_bnez_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x650000;
}

static void
Opcode_bnez_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x181;
}

static void
Opcode_bgez_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x670000;
}

static void
Opcode_bgez_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x281;
}

static void
Opcode_bltz_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x660000;
}

static void
Opcode_bltz_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x681;
}

static void
Opcode_call0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x500000;
}

static void
Opcode_callx0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30000;
}

static void
Opcode_extui_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40;
}

static void
Opcode_extui_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x81;
}

static void
Opcode_ill_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_j_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600000;
}

static void
Opcode_j_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1;
}

static void
Opcode_jx_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0000;
}

static void
Opcode_jx_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x983d01;
}

static void
Opcode_l16ui_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200100;
}

static void
Opcode_l16ui_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200004;
}

static void
Opcode_l16si_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200900;
}

static void
Opcode_l16si_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100004;
}

static void
Opcode_l32i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200200;
}

static void
Opcode_l32i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400004;
}

static void
Opcode_l32r_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100000;
}

static void
Opcode_l32r_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5;
}

static void
Opcode_l8ui_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200000;
}

static void
Opcode_l8ui_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180004;
}

static void
Opcode_loop_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d0800;
}

static void
Opcode_loopnez_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d0900;
}

static void
Opcode_loopgtz_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d0a00;
}

static void
Opcode_movi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200a00;
}

static void
Opcode_movi_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x301;
}

static void
Opcode_moveqz_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x38;
}

static void
Opcode_moveqz_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7381;
}

static void
Opcode_movnez_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x39;
}

static void
Opcode_movnez_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd01;
}

static void
Opcode_movltz_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a;
}

static void
Opcode_movltz_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x701;
}

static void
Opcode_movgez_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b;
}

static void
Opcode_movgez_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x581;
}

static void
Opcode_neg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6;
}

static void
Opcode_neg_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3ed81;
}

static void
Opcode_abs_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1006;
}

static void
Opcode_abs_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ed81;
}

static void
Opcode_nop_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0200;
}

static void
Opcode_nop_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36001;
}

static void
Opcode_nop_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb83d01;
}

static void
Opcode_ret_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20000;
}

static void
Opcode_simcall_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1500;
}

static void
Opcode_s16i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200500;
}

static void
Opcode_s16i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280004;
}

static void
Opcode_s32i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200600;
}

static void
Opcode_s32i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300004;
}

static void
Opcode_s32nb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x95;
}

static void
Opcode_s8i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200400;
}

static void
Opcode_s8i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x380004;
}

static void
Opcode_ssr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4;
}

static void
Opcode_ssr_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x983d81;
}

static void
Opcode_ssl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x104;
}

static void
Opcode_ssl_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4183d01;
}

static void
Opcode_ssa8l_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x204;
}

static void
Opcode_ssa8l_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2183d01;
}

static void
Opcode_ssa8b_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x304;
}

static void
Opcode_ssa8b_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1183d01;
}

static void
Opcode_ssai_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x404;
}

static void
Opcode_ssai_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x18e501;
}

static void
Opcode_sll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a;
}

static void
Opcode_sll_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2806f81;
}

static void
Opcode_src_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x18;
}

static void
Opcode_src_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4781;
}

static void
Opcode_srl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x19;
}

static void
Opcode_srl_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7ed81;
}

static void
Opcode_sra_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b;
}

static void
Opcode_sra_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5ed81;
}

static void
Opcode_slli_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10;
}

static void
Opcode_slli_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x501;
}

static void
Opcode_srai_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x12;
}

static void
Opcode_srai_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x381;
}

static void
Opcode_srli_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14;
}

static void
Opcode_srli_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd81;
}

static void
Opcode_memw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0200;
}

static void
Opcode_extw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0200;
}

static void
Opcode_isync_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200;
}

static void
Opcode_rsync_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10200;
}

static void
Opcode_esync_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20200;
}

static void
Opcode_dsync_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30200;
}

static void
Opcode_rsil_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600;
}

static void
Opcode_rsr_lend_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130;
}

static void
Opcode_wsr_lend_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x131;
}

static void
Opcode_xsr_lend_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x116;
}

static void
Opcode_rsr_lcount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x230;
}

static void
Opcode_wsr_lcount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x231;
}

static void
Opcode_xsr_lcount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x216;
}

static void
Opcode_rsr_lbeg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30;
}

static void
Opcode_wsr_lbeg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x31;
}

static void
Opcode_xsr_lbeg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16;
}

static void
Opcode_rsr_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x330;
}

static void
Opcode_wsr_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x331;
}

static void
Opcode_xsr_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x316;
}

static void
Opcode_rsr_memctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6130;
}

static void
Opcode_wsr_memctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6131;
}

static void
Opcode_xsr_memctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6116;
}

static void
Opcode_rsr_litbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x530;
}

static void
Opcode_wsr_litbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x531;
}

static void
Opcode_xsr_litbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x516;
}

static void
Opcode_rsr_configid0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb030;
}

static void
Opcode_wsr_configid0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb031;
}

static void
Opcode_rsr_configid1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd030;
}

static void
Opcode_rsr_243_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf330;
}

static void
Opcode_rsr_ps_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe630;
}

static void
Opcode_wsr_ps_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe631;
}

static void
Opcode_xsr_ps_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe616;
}

static void
Opcode_rsr_epc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb130;
}

static void
Opcode_wsr_epc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb131;
}

static void
Opcode_xsr_epc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb116;
}

static void
Opcode_rsr_excsave1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd130;
}

static void
Opcode_wsr_excsave1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd131;
}

static void
Opcode_xsr_excsave1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd116;
}

static void
Opcode_rsr_epc2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb230;
}

static void
Opcode_wsr_epc2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb231;
}

static void
Opcode_xsr_epc2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb216;
}

static void
Opcode_rsr_excsave2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd230;
}

static void
Opcode_wsr_excsave2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd231;
}

static void
Opcode_xsr_excsave2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd216;
}

static void
Opcode_rsr_epc3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb330;
}

static void
Opcode_wsr_epc3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb331;
}

static void
Opcode_xsr_epc3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb316;
}

static void
Opcode_rsr_excsave3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd330;
}

static void
Opcode_wsr_excsave3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd331;
}

static void
Opcode_xsr_excsave3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd316;
}

static void
Opcode_rsr_epc4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb430;
}

static void
Opcode_wsr_epc4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb431;
}

static void
Opcode_xsr_epc4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb416;
}

static void
Opcode_rsr_excsave4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd430;
}

static void
Opcode_wsr_excsave4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd431;
}

static void
Opcode_xsr_excsave4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd416;
}

static void
Opcode_rsr_epc5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb530;
}

static void
Opcode_wsr_epc5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb531;
}

static void
Opcode_xsr_epc5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb516;
}

static void
Opcode_rsr_excsave5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd530;
}

static void
Opcode_wsr_excsave5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd531;
}

static void
Opcode_xsr_excsave5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd516;
}

static void
Opcode_rsr_epc6_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb630;
}

static void
Opcode_wsr_epc6_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb631;
}

static void
Opcode_xsr_epc6_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb616;
}

static void
Opcode_rsr_excsave6_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd630;
}

static void
Opcode_wsr_excsave6_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd631;
}

static void
Opcode_xsr_excsave6_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd616;
}

static void
Opcode_rsr_epc7_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb730;
}

static void
Opcode_wsr_epc7_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb731;
}

static void
Opcode_xsr_epc7_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb716;
}

static void
Opcode_rsr_excsave7_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd730;
}

static void
Opcode_wsr_excsave7_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd731;
}

static void
Opcode_xsr_excsave7_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd716;
}

static void
Opcode_rsr_eps2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc230;
}

static void
Opcode_wsr_eps2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc231;
}

static void
Opcode_xsr_eps2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc216;
}

static void
Opcode_rsr_eps3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc330;
}

static void
Opcode_wsr_eps3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc331;
}

static void
Opcode_xsr_eps3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc316;
}

static void
Opcode_rsr_eps4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc430;
}

static void
Opcode_wsr_eps4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc431;
}

static void
Opcode_xsr_eps4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc416;
}

static void
Opcode_rsr_eps5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc530;
}

static void
Opcode_wsr_eps5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc531;
}

static void
Opcode_xsr_eps5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc516;
}

static void
Opcode_rsr_eps6_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc630;
}

static void
Opcode_wsr_eps6_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc631;
}

static void
Opcode_xsr_eps6_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc616;
}

static void
Opcode_rsr_eps7_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc730;
}

static void
Opcode_wsr_eps7_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc731;
}

static void
Opcode_xsr_eps7_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc716;
}

static void
Opcode_rsr_excvaddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xee30;
}

static void
Opcode_wsr_excvaddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xee31;
}

static void
Opcode_xsr_excvaddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xee16;
}

static void
Opcode_rsr_depc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc030;
}

static void
Opcode_wsr_depc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc031;
}

static void
Opcode_xsr_depc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc016;
}

static void
Opcode_rsr_exccause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe830;
}

static void
Opcode_wsr_exccause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe831;
}

static void
Opcode_xsr_exccause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe816;
}

static void
Opcode_rsr_misc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf430;
}

static void
Opcode_wsr_misc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf431;
}

static void
Opcode_xsr_misc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf416;
}

static void
Opcode_rsr_misc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf530;
}

static void
Opcode_wsr_misc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf531;
}

static void
Opcode_xsr_misc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf516;
}

static void
Opcode_rsr_prid_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xeb30;
}

static void
Opcode_rsr_vecbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe730;
}

static void
Opcode_wsr_vecbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe731;
}

static void
Opcode_xsr_vecbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe716;
}

static void
Opcode_mul16u_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c;
}

static void
Opcode_mul16s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d;
}

static void
Opcode_mull_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x28;
}

static void
Opcode_muluh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2a;
}

static void
Opcode_mulsh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b;
}

static void
Opcode_mul_aa_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400047;
}

static void
Opcode_mul_aa_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400057;
}

static void
Opcode_mul_aa_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400067;
}

static void
Opcode_mul_aa_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400077;
}

static void
Opcode_umul_aa_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400007;
}

static void
Opcode_umul_aa_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400017;
}

static void
Opcode_umul_aa_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400027;
}

static void
Opcode_umul_aa_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400037;
}

static void
Opcode_mul_ad_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400043;
}

static void
Opcode_mul_ad_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400053;
}

static void
Opcode_mul_ad_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400063;
}

static void
Opcode_mul_ad_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400073;
}

static void
Opcode_mul_da_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400046;
}

static void
Opcode_mul_da_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400056;
}

static void
Opcode_mul_da_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400066;
}

static void
Opcode_mul_da_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400076;
}

static void
Opcode_mul_dd_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400042;
}

static void
Opcode_mul_dd_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400052;
}

static void
Opcode_mul_dd_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400062;
}

static void
Opcode_mul_dd_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400072;
}

static void
Opcode_mula_aa_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400087;
}

static void
Opcode_mula_aa_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400097;
}

static void
Opcode_mula_aa_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000a7;
}

static void
Opcode_mula_aa_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000b7;
}

static void
Opcode_muls_aa_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000c7;
}

static void
Opcode_muls_aa_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000d7;
}

static void
Opcode_muls_aa_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000e7;
}

static void
Opcode_muls_aa_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000f7;
}

static void
Opcode_mula_ad_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400083;
}

static void
Opcode_mula_ad_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400093;
}

static void
Opcode_mula_ad_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000a3;
}

static void
Opcode_mula_ad_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000b3;
}

static void
Opcode_muls_ad_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000c3;
}

static void
Opcode_muls_ad_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000d3;
}

static void
Opcode_muls_ad_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000e3;
}

static void
Opcode_muls_ad_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000f3;
}

static void
Opcode_mula_da_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400086;
}

static void
Opcode_mula_da_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400096;
}

static void
Opcode_mula_da_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000a6;
}

static void
Opcode_mula_da_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000b6;
}

static void
Opcode_muls_da_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000c6;
}

static void
Opcode_muls_da_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000d6;
}

static void
Opcode_muls_da_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000e6;
}

static void
Opcode_muls_da_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000f6;
}

static void
Opcode_mula_dd_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400082;
}

static void
Opcode_mula_dd_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400092;
}

static void
Opcode_mula_dd_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000a2;
}

static void
Opcode_mula_dd_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000b2;
}

static void
Opcode_muls_dd_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000c2;
}

static void
Opcode_muls_dd_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000d2;
}

static void
Opcode_muls_dd_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000e2;
}

static void
Opcode_muls_dd_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000f2;
}

static void
Opcode_mula_da_ll_lddec_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400085;
}

static void
Opcode_mula_da_ll_ldinc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400084;
}

static void
Opcode_mula_da_hl_lddec_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400095;
}

static void
Opcode_mula_da_hl_ldinc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400094;
}

static void
Opcode_mula_da_lh_lddec_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000a5;
}

static void
Opcode_mula_da_lh_ldinc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000a4;
}

static void
Opcode_mula_da_hh_lddec_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000b5;
}

static void
Opcode_mula_da_hh_ldinc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000b4;
}

static void
Opcode_mula_dd_ll_lddec_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400081;
}

static void
Opcode_mula_dd_ll_ldinc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400080;
}

static void
Opcode_mula_dd_hl_lddec_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400091;
}

static void
Opcode_mula_dd_hl_ldinc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400090;
}

static void
Opcode_mula_dd_lh_lddec_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000a1;
}

static void
Opcode_mula_dd_lh_ldinc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000a0;
}

static void
Opcode_mula_dd_hh_lddec_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000b1;
}

static void
Opcode_mula_dd_hh_ldinc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000b0;
}

static void
Opcode_lddec_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400009;
}

static void
Opcode_ldinc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400008;
}

static void
Opcode_rsr_m0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2030;
}

static void
Opcode_wsr_m0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2031;
}

static void
Opcode_xsr_m0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2016;
}

static void
Opcode_rsr_m1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2130;
}

static void
Opcode_wsr_m1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2131;
}

static void
Opcode_xsr_m1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2116;
}

static void
Opcode_rsr_m2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2230;
}

static void
Opcode_wsr_m2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2231;
}

static void
Opcode_xsr_m2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2216;
}

static void
Opcode_rsr_m3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2330;
}

static void
Opcode_wsr_m3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2331;
}

static void
Opcode_xsr_m3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2316;
}

static void
Opcode_rsr_acclo_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1030;
}

static void
Opcode_wsr_acclo_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1031;
}

static void
Opcode_xsr_acclo_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1016;
}

static void
Opcode_rsr_acchi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1130;
}

static void
Opcode_wsr_acchi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1131;
}

static void
Opcode_xsr_acchi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1116;
}

static void
Opcode_rfi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10300;
}

static void
Opcode_waiti_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700;
}

static void
Opcode_rsr_interrupt_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe230;
}

static void
Opcode_wsr_intset_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe231;
}

static void
Opcode_wsr_intclear_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe331;
}

static void
Opcode_rsr_intenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe430;
}

static void
Opcode_wsr_intenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe431;
}

static void
Opcode_xsr_intenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe416;
}

static void
Opcode_break_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400;
}

static void
Opcode_break_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd20f;
}

static void
Opcode_rsr_dbreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9030;
}

static void
Opcode_wsr_dbreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9031;
}

static void
Opcode_xsr_dbreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9016;
}

static void
Opcode_rsr_dbreakc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa030;
}

static void
Opcode_wsr_dbreakc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa031;
}

static void
Opcode_xsr_dbreakc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa016;
}

static void
Opcode_rsr_dbreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9130;
}

static void
Opcode_wsr_dbreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9131;
}

static void
Opcode_xsr_dbreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9116;
}

static void
Opcode_rsr_dbreakc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa130;
}

static void
Opcode_wsr_dbreakc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa131;
}

static void
Opcode_xsr_dbreakc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa116;
}

static void
Opcode_rsr_ibreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8030;
}

static void
Opcode_wsr_ibreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8031;
}

static void
Opcode_xsr_ibreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8016;
}

static void
Opcode_rsr_ibreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8130;
}

static void
Opcode_wsr_ibreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8131;
}

static void
Opcode_xsr_ibreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8116;
}

static void
Opcode_rsr_ibreakenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6030;
}

static void
Opcode_wsr_ibreakenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6031;
}

static void
Opcode_xsr_ibreakenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6016;
}

static void
Opcode_rsr_debugcause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe930;
}

static void
Opcode_wsr_debugcause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe931;
}

static void
Opcode_xsr_debugcause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe916;
}

static void
Opcode_rsr_icount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xec30;
}

static void
Opcode_wsr_icount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xec31;
}

static void
Opcode_xsr_icount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xec16;
}

static void
Opcode_rsr_icountlevel_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xed30;
}

static void
Opcode_wsr_icountlevel_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xed31;
}

static void
Opcode_xsr_icountlevel_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xed16;
}

static void
Opcode_rsr_ddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6830;
}

static void
Opcode_wsr_ddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6831;
}

static void
Opcode_xsr_ddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6816;
}

static void
Opcode_lddr32_p_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0700;
}

static void
Opcode_sddr32_p_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0700;
}

static void
Opcode_rfdo_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe1f;
}

static void
Opcode_rfdd_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10e1f;
}

static void
Opcode_wsr_mmid_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5931;
}

static void
Opcode_andb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20;
}

static void
Opcode_andb_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5381;
}

static void
Opcode_andbc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x21;
}

static void
Opcode_andbc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5b81;
}

static void
Opcode_orb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x22;
}

static void
Opcode_orb_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4581;
}

static void
Opcode_orbc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x23;
}

static void
Opcode_orbc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x781;
}

static void
Opcode_xorb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x24;
}

static void
Opcode_xorb_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4f81;
}

static void
Opcode_any4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800;
}

static void
Opcode_any4_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x96501;
}

static void
Opcode_all4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x900;
}

static void
Opcode_all4_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8e501;
}

static void
Opcode_any8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa00;
}

static void
Opcode_any8_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc6501;
}

static void
Opcode_all8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb00;
}

static void
Opcode_all8_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa6501;
}

static void
Opcode_bf_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d0000;
}

static void
Opcode_bf_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2800003;
}

static void
Opcode_bt_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d0100;
}

static void
Opcode_bt_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3000003;
}

static void
Opcode_movf_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c;
}

static void
Opcode_movf_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7b81;
}

static void
Opcode_movt_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d;
}

static void
Opcode_movt_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1501;
}

static void
Opcode_rsr_br_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x430;
}

static void
Opcode_wsr_br_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x431;
}

static void
Opcode_xsr_br_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x416;
}

static void
Opcode_rsr_ccount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea30;
}

static void
Opcode_wsr_ccount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea31;
}

static void
Opcode_xsr_ccount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea16;
}

static void
Opcode_rsr_ccompare0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf030;
}

static void
Opcode_wsr_ccompare0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf031;
}

static void
Opcode_xsr_ccompare0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf016;
}

static void
Opcode_rsr_ccompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf130;
}

static void
Opcode_wsr_ccompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf131;
}

static void
Opcode_xsr_ccompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf116;
}

static void
Opcode_rsr_ccompare2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf230;
}

static void
Opcode_wsr_ccompare2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf231;
}

static void
Opcode_xsr_ccompare2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf216;
}

static void
Opcode_ipf_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2c0700;
}

static void
Opcode_ihi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e0700;
}

static void
Opcode_ipfl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d0700;
}

static void
Opcode_ihu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d0720;
}

static void
Opcode_iiu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d0730;
}

static void
Opcode_iii_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2f0700;
}

static void
Opcode_lict_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f;
}

static void
Opcode_licw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x21f;
}

static void
Opcode_sict_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x11f;
}

static void
Opcode_sicw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x31f;
}

static void
Opcode_dhwb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240700;
}

static void
Opcode_dhwbi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x250700;
}

static void
Opcode_diwbui_p_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2807f0;
}

static void
Opcode_diwb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280740;
}

static void
Opcode_diwbi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280750;
}

static void
Opcode_dhi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x260700;
}

static void
Opcode_dii_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x270700;
}

static void
Opcode_dpfr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200700;
}

static void
Opcode_dpfw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x210700;
}

static void
Opcode_dpfro_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x220700;
}

static void
Opcode_dpfwo_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x230700;
}

static void
Opcode_dpfl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280700;
}

static void
Opcode_dhu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280720;
}

static void
Opcode_diu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280730;
}

static void
Opcode_sdct_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x91f;
}

static void
Opcode_ldct_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x81f;
}

static void
Opcode_rsr_prefctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2830;
}

static void
Opcode_wsr_prefctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2831;
}

static void
Opcode_xsr_prefctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2816;
}

static void
Opcode_wsr_ptevaddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5331;
}

static void
Opcode_rsr_ptevaddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5330;
}

static void
Opcode_xsr_ptevaddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5316;
}

static void
Opcode_rsr_rasid_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a30;
}

static void
Opcode_wsr_rasid_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a31;
}

static void
Opcode_xsr_rasid_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a16;
}

static void
Opcode_rsr_itlbcfg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5b30;
}

static void
Opcode_wsr_itlbcfg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5b31;
}

static void
Opcode_xsr_itlbcfg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5b16;
}

static void
Opcode_rsr_dtlbcfg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5c30;
}

static void
Opcode_wsr_dtlbcfg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5c31;
}

static void
Opcode_xsr_dtlbcfg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5c16;
}

static void
Opcode_idtlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc05;
}

static void
Opcode_pdtlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd05;
}

static void
Opcode_rdtlb0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb05;
}

static void
Opcode_rdtlb1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf05;
}

static void
Opcode_wdtlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe05;
}

static void
Opcode_iitlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x405;
}

static void
Opcode_pitlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x505;
}

static void
Opcode_ritlb0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x305;
}

static void
Opcode_ritlb1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x705;
}

static void
Opcode_witlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x605;
}

static void
Opcode_ldpte_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf1f;
}

static void
Opcode_hwwitlba_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x105;
}

static void
Opcode_hwwdtlba_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x905;
}

static void
Opcode_rsr_cpenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe030;
}

static void
Opcode_wsr_cpenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe031;
}

static void
Opcode_xsr_cpenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe016;
}

static void
Opcode_clamps_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x33;
}

static void
Opcode_clamps_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b81;
}

static void
Opcode_min_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x34;
}

static void
Opcode_min_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b81;
}

static void
Opcode_max_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x35;
}

static void
Opcode_max_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3381;
}

static void
Opcode_minu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36;
}

static void
Opcode_minu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6b81;
}

static void
Opcode_maxu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x37;
}

static void
Opcode_maxu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6381;
}

static void
Opcode_nsa_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe04;
}

static void
Opcode_nsau_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf04;
}

static void
Opcode_sext_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x32;
}

static void
Opcode_sext_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4701;
}

static void
Opcode_l32ai_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200b00;
}

static void
Opcode_s32ri_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200f00;
}

static void
Opcode_s32c1i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200e00;
}

static void
Opcode_rsr_scompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc30;
}

static void
Opcode_wsr_scompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc31;
}

static void
Opcode_xsr_scompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc16;
}

static void
Opcode_rsr_atomctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6330;
}

static void
Opcode_wsr_atomctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6331;
}

static void
Opcode_xsr_atomctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6316;
}

static void
Opcode_quou_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2c;
}

static void
Opcode_quos_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d;
}

static void
Opcode_remu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e;
}

static void
Opcode_rems_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2f;
}

static void
Opcode_rer_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x604;
}

static void
Opcode_wer_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x704;
}

static void
Opcode_rur_ae_ovf_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf03e;
}

static void
Opcode_wur_ae_ovf_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf03f;
}

static void
Opcode_rur_ae_bithead_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f03e;
}

static void
Opcode_wur_ae_bithead_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf13f;
}

static void
Opcode_rur_ae_ts_fts_bu_bp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2f03e;
}

static void
Opcode_wur_ae_ts_fts_bu_bp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf23f;
}

static void
Opcode_rur_ae_sd_no_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f03e;
}

static void
Opcode_wur_ae_sd_no_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf33f;
}

static void
Opcode_rur_ae_overflow_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40809c;
}

static void
Opcode_wur_ae_overflow_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000ac;
}

static void
Opcode_rur_ae_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40909c;
}

static void
Opcode_wur_ae_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4001ac;
}

static void
Opcode_rur_ae_bitptr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40a09c;
}

static void
Opcode_wur_ae_bitptr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4002ac;
}

static void
Opcode_rur_ae_bitsused_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40b09c;
}

static void
Opcode_wur_ae_bitsused_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4003ac;
}

static void
Opcode_rur_ae_tablesize_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40c09c;
}

static void
Opcode_wur_ae_tablesize_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4004ac;
}

static void
Opcode_rur_ae_first_ts_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40d09c;
}

static void
Opcode_wur_ae_first_ts_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4005ac;
}

static void
Opcode_rur_ae_nextoffset_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40e09c;
}

static void
Opcode_wur_ae_nextoffset_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4006ac;
}

static void
Opcode_rur_ae_searchdone_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40f09c;
}

static void
Opcode_wur_ae_searchdone_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4007ac;
}

static void
Opcode_ae_lp16f_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x81581;
}

static void
Opcode_ae_lp16f_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40005a;
}

static void
Opcode_ae_lp16f_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1781;
}

static void
Opcode_ae_lp16f_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40009a;
}

static void
Opcode_ae_lp16f_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x81701;
}

static void
Opcode_ae_lp16f_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000ca;
}

static void
Opcode_ae_lp16f_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x81781;
}

static void
Opcode_ae_lp16f_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000fa;
}

static void
Opcode_ae_lp24_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x81d81;
}

static void
Opcode_ae_lp24_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40085a;
}

static void
Opcode_ae_lp24_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x81f01;
}

static void
Opcode_ae_lp24_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40089a;
}

static void
Opcode_ae_lp24_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x81f81;
}

static void
Opcode_ae_lp24_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4008ca;
}

static void
Opcode_ae_lp24_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5581;
}

static void
Opcode_ae_lp24_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4008fa;
}

static void
Opcode_ae_lp24f_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5701;
}

static void
Opcode_ae_lp24f_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40006a;
}

static void
Opcode_ae_lp24f_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5d01;
}

static void
Opcode_ae_lp24f_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000aa;
}

static void
Opcode_ae_lp24f_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x85501;
}

static void
Opcode_ae_lp24f_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000da;
}

static void
Opcode_ae_lp24f_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5781;
}

static void
Opcode_ae_lp24f_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000b;
}

static void
Opcode_ae_lp16x2f_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d81;
}

static void
Opcode_ae_lp16x2f_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40086a;
}

static void
Opcode_ae_lp16x2f_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f01;
}

static void
Opcode_ae_lp16x2f_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4008aa;
}

static void
Opcode_ae_lp16x2f_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x81d01;
}

static void
Opcode_ae_lp16x2f_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4008da;
}

static void
Opcode_ae_lp16x2f_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f81;
}

static void
Opcode_ae_lp16x2f_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40080b;
}

static void
Opcode_ae_lp24x2f_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x85701;
}

static void
Opcode_ae_lp24x2f_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40007a;
}

static void
Opcode_ae_lp24x2f_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x85d01;
}

static void
Opcode_ae_lp24x2f_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000ba;
}

static void
Opcode_ae_lp24x2f_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x85781;
}

static void
Opcode_ae_lp24x2f_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000ea;
}

static void
Opcode_ae_lp24x2f_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x85d81;
}

static void
Opcode_ae_lp24x2f_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40001b;
}

static void
Opcode_ae_lp24x2_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5d81;
}

static void
Opcode_ae_lp24x2_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40087a;
}

static void
Opcode_ae_lp24x2_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5f01;
}

static void
Opcode_ae_lp24x2_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4008ba;
}

static void
Opcode_ae_lp24x2_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5f81;
}

static void
Opcode_ae_lp24x2_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4008ea;
}

static void
Opcode_ae_lp24x2_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x85581;
}

static void
Opcode_ae_lp24x2_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40081b;
}

static void
Opcode_ae_sp16x2f_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3501;
}

static void
Opcode_ae_sp16x2f_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40002b;
}

static void
Opcode_ae_sp16x2f_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6501;
}

static void
Opcode_ae_sp16x2f_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40005b;
}

static void
Opcode_ae_sp16x2f_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x82581;
}

static void
Opcode_ae_sp16x2f_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40008b;
}

static void
Opcode_ae_sp16x2f_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2781;
}

static void
Opcode_ae_sp16x2f_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000bb;
}

static void
Opcode_ae_sp24x2s_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x83501;
}

static void
Opcode_ae_sp24x2s_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40082b;
}

static void
Opcode_ae_sp24x2s_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3781;
}

static void
Opcode_ae_sp24x2s_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40085b;
}

static void
Opcode_ae_sp24x2s_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d81;
}

static void
Opcode_ae_sp24x2s_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40088b;
}

static void
Opcode_ae_sp24x2s_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f01;
}

static void
Opcode_ae_sp24x2s_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4008bb;
}

static void
Opcode_ae_sp24x2f_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x82f81;
}

static void
Opcode_ae_sp24x2f_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40003b;
}

static void
Opcode_ae_sp24x2f_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3581;
}

static void
Opcode_ae_sp24x2f_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40006b;
}

static void
Opcode_ae_sp24x2f_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3701;
}

static void
Opcode_ae_sp24x2f_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40009b;
}

static void
Opcode_ae_sp24x2f_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d01;
}

static void
Opcode_ae_sp24x2f_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000cb;
}

static void
Opcode_ae_sp16f_l_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x85f81;
}

static void
Opcode_ae_sp16f_l_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40083b;
}

static void
Opcode_ae_sp16f_l_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2581;
}

static void
Opcode_ae_sp16f_l_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40086b;
}

static void
Opcode_ae_sp16f_l_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2701;
}

static void
Opcode_ae_sp16f_l_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40089b;
}

static void
Opcode_ae_sp16f_l_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d01;
}

static void
Opcode_ae_sp16f_l_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4008cb;
}

static void
Opcode_ae_sp24s_l_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x82d01;
}

static void
Opcode_ae_sp24s_l_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40004b;
}

static void
Opcode_ae_sp24s_l_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2f81;
}

static void
Opcode_ae_sp24s_l_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40007b;
}

static void
Opcode_ae_sp24s_l_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x82d81;
}

static void
Opcode_ae_sp24s_l_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000ab;
}

static void
Opcode_ae_sp24s_l_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x82f01;
}

static void
Opcode_ae_sp24s_l_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000db;
}

static void
Opcode_ae_sp24f_l_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x82701;
}

static void
Opcode_ae_sp24f_l_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40084b;
}

static void
Opcode_ae_sp24f_l_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x82781;
}

static void
Opcode_ae_sp24f_l_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40087b;
}

static void
Opcode_ae_sp24f_l_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d81;
}

static void
Opcode_ae_sp24f_l_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4008ab;
}

static void
Opcode_ae_sp24f_l_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2f01;
}

static void
Opcode_ae_sp24f_l_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4008db;
}

static void
Opcode_ae_lq56_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x206581;
}

static void
Opcode_ae_lq56_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40001c;
}

static void
Opcode_ae_lq56_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x406581;
}

static void
Opcode_ae_lq56_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40021c;
}

static void
Opcode_ae_lq56_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x606581;
}

static void
Opcode_ae_lq56_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40002c;
}

static void
Opcode_ae_lq56_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6781;
}

static void
Opcode_ae_lq56_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40022c;
}

static void
Opcode_ae_lq32f_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6581;
}

static void
Opcode_ae_lq32f_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40011c;
}

static void
Opcode_ae_lq32f_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6701;
}

static void
Opcode_ae_lq32f_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40031c;
}

static void
Opcode_ae_lq32f_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d01;
}

static void
Opcode_ae_lq32f_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40012c;
}

static void
Opcode_ae_lq32f_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7501;
}

static void
Opcode_ae_lq32f_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40032c;
}

static void
Opcode_ae_sq56s_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x83781;
}

static void
Opcode_ae_sq56s_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40003c;
}

static void
Opcode_ae_sq56s_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x183701;
}

static void
Opcode_ae_sq56s_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40083c;
}

static void
Opcode_ae_sq56s_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x183781;
}

static void
Opcode_ae_sq56s_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40004c;
}

static void
Opcode_ae_sq56s_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x83d81;
}

static void
Opcode_ae_sq56s_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40084c;
}

static void
Opcode_ae_sq32f_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x83581;
}

static void
Opcode_ae_sq32f_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40043c;
}

static void
Opcode_ae_sq32f_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x83701;
}

static void
Opcode_ae_sq32f_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400c3c;
}

static void
Opcode_ae_sq32f_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x83d01;
}

static void
Opcode_ae_sq32f_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40044c;
}

static void
Opcode_ae_sq32f_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x183581;
}

static void
Opcode_ae_sq32f_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400c4c;
}

static void
Opcode_ae_zerop48_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x46001;
}

static void
Opcode_ae_movp48_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x86001;
}

static void
Opcode_ae_movp48_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x86501;
}

static void
Opcode_ae_movp48_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40009c;
}

static void
Opcode_ae_selp24_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd081;
}

static void
Opcode_ae_selp24_ll_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x24000;
}

static void
Opcode_ae_selp24_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x89001;
}

static void
Opcode_ae_selp24_lh_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14000;
}

static void
Opcode_ae_selp24_hl_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd001;
}

static void
Opcode_ae_selp24_hl_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc000;
}

static void
Opcode_ae_selp24_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9081;
}

static void
Opcode_ae_selp24_hh_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000;
}

static void
Opcode_ae_movtp24x2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x402081;
}

static void
Opcode_ae_movfp24x2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x202081;
}

static void
Opcode_ae_movtp48_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2001;
}

static void
Opcode_ae_movfp48_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1001;
}

static void
Opcode_ae_movpa24x2_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x85f01;
}

static void
Opcode_ae_movpa24x2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000c;
}

static void
Opcode_ae_truncp24a32x2_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f81;
}

static void
Opcode_ae_truncp24a32x2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40080c;
}

static void
Opcode_ae_cvta32p24_l_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x83f81;
}

static void
Opcode_ae_cvta32p24_l_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000bc;
}

static void
Opcode_ae_cvta32p24_h_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x83f01;
}

static void
Opcode_ae_cvta32p24_h_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4008bc;
}

static void
Opcode_ae_cvtp24a16x2_ll_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5501;
}

static void
Opcode_ae_cvtp24a16x2_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000eb;
}

static void
Opcode_ae_cvtp24a16x2_lh_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d01;
}

static void
Opcode_ae_cvtp24a16x2_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4008eb;
}

static void
Opcode_ae_cvtp24a16x2_hl_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1701;
}

static void
Opcode_ae_cvtp24a16x2_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000fb;
}

static void
Opcode_ae_cvtp24a16x2_hh_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1581;
}

static void
Opcode_ae_cvtp24a16x2_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4008fb;
}

static void
Opcode_ae_truncp24q48x2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20005;
}

static void
Opcode_ae_truncp16_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x86e01;
}

static void
Opcode_ae_roundsp24q48sym_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3881;
}

static void
Opcode_ae_roundsp24q48asym_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3481;
}

static void
Opcode_ae_roundsp16q48sym_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3281;
}

static void
Opcode_ae_roundsp16q48asym_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3081;
}

static void
Opcode_ae_roundsp16sym_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x86401;
}

static void
Opcode_ae_roundsp16asym_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x86201;
}

static void
Opcode_ae_zeroq56_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x284581;
}

static void
Opcode_ae_movq56_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x380581;
}

static void
Opcode_ae_movq56_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xef01;
}

static void
Opcode_ae_movq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41409c;
}

static void
Opcode_ae_movtq56_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x806f81;
}

static void
Opcode_ae_movtq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41005e;
}

static void
Opcode_ae_movfq56_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6f81;
}

static void
Opcode_ae_movfq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41006e;
}

static void
Opcode_ae_cvtq48a32s_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x206701;
}

static void
Opcode_ae_cvtq48a32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x43027e;
}

static void
Opcode_ae_cvtq48p24s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300581;
}

static void
Opcode_ae_cvtq48p24s_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280581;
}

static void
Opcode_ae_satq48s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x488605;
}

static void
Opcode_ae_truncq32_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c0581;
}

static void
Opcode_ae_roundsq32sym_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a0581;
}

static void
Opcode_ae_roundsq32asym_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x390581;
}

static void
Opcode_ae_trunca32q48_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x183d81;
}

static void
Opcode_ae_trunca32q48_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41007e;
}

static void
Opcode_ae_movap24s_l_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1083f01;
}

static void
Opcode_ae_movap24s_l_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40007c;
}

static void
Opcode_ae_movap24s_h_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x883f01;
}

static void
Opcode_ae_movap24s_h_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40087c;
}

static void
Opcode_ae_trunca16p24s_l_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4083f01;
}

static void
Opcode_ae_trunca16p24s_l_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40008c;
}

static void
Opcode_ae_trunca16p24s_h_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2083f01;
}

static void
Opcode_ae_trunca16p24s_h_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40088c;
}

static void
Opcode_ae_addp24_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1081;
}

static void
Opcode_ae_subp24_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x89081;
}

static void
Opcode_ae_negp24_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16001;
}

static void
Opcode_ae_absp24_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6001;
}

static void
Opcode_ae_maxp24s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x81081;
}

static void
Opcode_ae_minp24s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5081;
}

static void
Opcode_ae_maxbp24s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1;
}

static void
Opcode_ae_minbp24s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x81;
}

static void
Opcode_ae_addsp24s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5001;
}

static void
Opcode_ae_subsp24s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8d001;
}

static void
Opcode_ae_negsp24s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x26001;
}

static void
Opcode_ae_abssp24s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa001;
}

static void
Opcode_ae_andp48_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9001;
}

static void
Opcode_ae_nandp48_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x85001;
}

static void
Opcode_ae_orp48_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x85081;
}

static void
Opcode_ae_xorp48_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8d081;
}

static void
Opcode_ae_ltp24s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x102081;
}

static void
Opcode_ae_lep24s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3001;
}

static void
Opcode_ae_eqp24_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2081;
}

static void
Opcode_ae_addq56_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40005;
}

static void
Opcode_ae_subq56_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280605;
}

static void
Opcode_ae_negq56_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600605;
}

static void
Opcode_ae_absq56_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x480605;
}

static void
Opcode_ae_maxq56s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100605;
}

static void
Opcode_ae_minq56s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200605;
}

static void
Opcode_ae_maxbq56s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5;
}

static void
Opcode_ae_minbq56s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x205;
}

static void
Opcode_ae_addsq56s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x605;
}

static void
Opcode_ae_subsq56s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300605;
}

static void
Opcode_ae_negsq56s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x484605;
}

static void
Opcode_ae_abssq56s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x500605;
}

static void
Opcode_ae_andq56_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80605;
}

static void
Opcode_ae_nandq56_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400605;
}

static void
Opcode_ae_orq56_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180605;
}

static void
Opcode_ae_xorq56_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x380605;
}

static void
Opcode_ae_sllip24_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x101;
}

static void
Opcode_ae_srlip24_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x501;
}

static void
Opcode_ae_sraip24_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x301;
}

static void
Opcode_ae_sllsp24_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x86801;
}

static void
Opcode_ae_srlsp24_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x86c01;
}

static void
Opcode_ae_srasp24_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x86a01;
}

static void
Opcode_ae_sllisp24s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x181;
}

static void
Opcode_ae_sllssp24s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x86601;
}

static void
Opcode_ae_slliq56_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d81;
}

static void
Opcode_ae_slliq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40005c;
}

static void
Opcode_ae_srliq56_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16d81;
}

static void
Opcode_ae_srliq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40105c;
}

static void
Opcode_ae_sraiq56_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xed81;
}

static void
Opcode_ae_sraiq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40205c;
}

static void
Opcode_ae_sllsq56_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16f01;
}

static void
Opcode_ae_sllsq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41009c;
}

static void
Opcode_ae_srlsq56_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80ef01;
}

static void
Opcode_ae_srlsq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41109c;
}

static void
Opcode_ae_srasq56_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4ef01;
}

static void
Opcode_ae_srasq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41209c;
}

static void
Opcode_ae_sllaq56_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1006f81;
}

static void
Opcode_ae_sllaq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41001e;
}

static void
Opcode_ae_srlaq56_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1806f81;
}

static void
Opcode_ae_srlaq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41002e;
}

static void
Opcode_ae_sraaq56_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4006f81;
}

static void
Opcode_ae_sraaq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41003e;
}

static void
Opcode_ae_sllisq56s_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6f01;
}

static void
Opcode_ae_sllisq56s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40305c;
}

static void
Opcode_ae_sllssq56s_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2ef01;
}

static void
Opcode_ae_sllssq56s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41309c;
}

static void
Opcode_ae_sllasq56s_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2006f81;
}

static void
Opcode_ae_sllasq56s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41004e;
}

static void
Opcode_ae_ltq56s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10005;
}

static void
Opcode_ae_leq56s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x805;
}

static void
Opcode_ae_eqq56_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x405;
}

static void
Opcode_ae_nsaq56s_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x183d01;
}

static void
Opcode_ae_nsaq56s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41047e;
}

static void
Opcode_ae_mulsrfq32sp24s_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x500901;
}

static void
Opcode_ae_mulsrfq32sp24s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300901;
}

static void
Opcode_ae_mularfq32sp24s_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600901;
}

static void
Opcode_ae_mularfq32sp24s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100901;
}

static void
Opcode_ae_mulrfq32sp24s_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400901;
}

static void
Opcode_ae_mulrfq32sp24s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200901;
}

static void
Opcode_ae_mulsfq32sp24s_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x680901;
}

static void
Opcode_ae_mulsfq32sp24s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180901;
}

static void
Opcode_ae_mulafq32sp24s_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x480901;
}

static void
Opcode_ae_mulafq32sp24s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280901;
}

static void
Opcode_ae_mulfq32sp24s_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700901;
}

static void
Opcode_ae_mulfq32sp24s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80901;
}

static void
Opcode_ae_mulfs32p16s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100086;
}

static void
Opcode_ae_mulfp24s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x88186;
}

static void
Opcode_ae_mulp24s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180006;
}

static void
Opcode_ae_mulfs32p16s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8c186;
}

static void
Opcode_ae_mulfp24s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8c006;
}

static void
Opcode_ae_mulp24s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x108006;
}

static void
Opcode_ae_mulfs32p16s_hl_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8c106;
}

static void
Opcode_ae_mulfp24s_hl_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x88106;
}

static void
Opcode_ae_mulp24s_hl_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x104006;
}

static void
Opcode_ae_mulfs32p16s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8c086;
}

static void
Opcode_ae_mulfp24s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x88086;
}

static void
Opcode_ae_mulp24s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100106;
}

static void
Opcode_ae_mulafs32p16s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4106;
}

static void
Opcode_ae_mulafp24s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200006;
}

static void
Opcode_ae_mulap24s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc186;
}

static void
Opcode_ae_mulafs32p16s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4086;
}

static void
Opcode_ae_mulafp24s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100006;
}

static void
Opcode_ae_mulap24s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc106;
}

static void
Opcode_ae_mulafs32p16s_hl_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x186;
}

static void
Opcode_ae_mulafp24s_hl_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80006;
}

static void
Opcode_ae_mulap24s_hl_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc086;
}

static void
Opcode_ae_mulafs32p16s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400006;
}

static void
Opcode_ae_mulafp24s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8006;
}

static void
Opcode_ae_mulap24s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8186;
}

static void
Opcode_ae_mulsfs32p16s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180086;
}

static void
Opcode_ae_mulsfp24s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x108186;
}

static void
Opcode_ae_mulsp24s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x188086;
}

static void
Opcode_ae_mulsfs32p16s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10c186;
}

static void
Opcode_ae_mulsfp24s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10c006;
}

static void
Opcode_ae_mulsp24s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x184186;
}

static void
Opcode_ae_mulsfs32p16s_hl_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10c106;
}

static void
Opcode_ae_mulsfp24s_hl_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x108106;
}

static void
Opcode_ae_mulsp24s_hl_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x184106;
}

static void
Opcode_ae_mulsfs32p16s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10c086;
}

static void
Opcode_ae_mulsfp24s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x108086;
}

static void
Opcode_ae_mulsp24s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x184086;
}

static void
Opcode_ae_mulafs56p24s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc006;
}

static void
Opcode_ae_mulas56p24s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x88006;
}

static void
Opcode_ae_mulafs56p24s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8106;
}

static void
Opcode_ae_mulas56p24s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x84006;
}

static void
Opcode_ae_mulafs56p24s_hl_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8086;
}

static void
Opcode_ae_mulas56p24s_hl_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80106;
}

static void
Opcode_ae_mulafs56p24s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4186;
}

static void
Opcode_ae_mulas56p24s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80086;
}

static void
Opcode_ae_mulsfs56p24s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180186;
}

static void
Opcode_ae_mulss56p24s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x18c086;
}

static void
Opcode_ae_mulsfs56p24s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x188006;
}

static void
Opcode_ae_mulss56p24s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x188186;
}

static void
Opcode_ae_mulsfs56p24s_hl_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x184006;
}

static void
Opcode_ae_mulss56p24s_hl_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x18c006;
}

static void
Opcode_ae_mulsfs56p24s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180106;
}

static void
Opcode_ae_mulss56p24s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x188106;
}

static void
Opcode_ae_mulfq32sp16s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x380381;
}

static void
Opcode_ae_mulfq32sp16s_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300381;
}

static void
Opcode_ae_mulfq32sp16u_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x500381;
}

static void
Opcode_ae_mulfq32sp16u_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x480381;
}

static void
Opcode_ae_mulq32sp16s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x580381;
}

static void
Opcode_ae_mulq32sp16s_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600381;
}

static void
Opcode_ae_mulq32sp16u_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700381;
}

static void
Opcode_ae_mulq32sp16u_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x680381;
}

static void
Opcode_ae_mulafq32sp16s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x381;
}

static void
Opcode_ae_mulafq32sp16s_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x901;
}

static void
Opcode_ae_mulafq32sp16u_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100381;
}

static void
Opcode_ae_mulafq32sp16u_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80381;
}

static void
Opcode_ae_mulaq32sp16s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400381;
}

static void
Opcode_ae_mulaq32sp16s_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200381;
}

static void
Opcode_ae_mulaq32sp16u_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280381;
}

static void
Opcode_ae_mulaq32sp16u_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180381;
}

static void
Opcode_ae_mulsfq32sp16s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x581;
}

static void
Opcode_ae_mulsfq32sp16s_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x780381;
}

static void
Opcode_ae_mulsfq32sp16u_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80581;
}

static void
Opcode_ae_mulsfq32sp16u_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x701;
}

static void
Opcode_ae_mulsq32sp16s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200581;
}

static void
Opcode_ae_mulsq32sp16s_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100581;
}

static void
Opcode_ae_mulsq32sp16u_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180581;
}

static void
Opcode_ae_mulsq32sp16u_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400581;
}

static void
Opcode_ae_mulzaaq32sp16s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x380002;
}

static void
Opcode_ae_mulzaafq32sp16s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100002;
}

static void
Opcode_ae_mulzaaq32sp16u_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600002;
}

static void
Opcode_ae_mulzaafq32sp16u_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180002;
}

static void
Opcode_ae_mulzaaq32sp16s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280002;
}

static void
Opcode_ae_mulzaafq32sp16s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2;
}

static void
Opcode_ae_mulzaaq32sp16u_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x480002;
}

static void
Opcode_ae_mulzaafq32sp16u_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200002;
}

static void
Opcode_ae_mulzaaq32sp16s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300002;
}

static void
Opcode_ae_mulzaafq32sp16s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80002;
}

static void
Opcode_ae_mulzaaq32sp16u_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x500002;
}

static void
Opcode_ae_mulzaafq32sp16u_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400002;
}

static void
Opcode_ae_mulzasq32sp16s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400003;
}

static void
Opcode_ae_mulzasfq32sp16s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700002;
}

static void
Opcode_ae_mulzasq32sp16u_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300003;
}

static void
Opcode_ae_mulzasfq32sp16u_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80003;
}

static void
Opcode_ae_mulzasq32sp16s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100003;
}

static void
Opcode_ae_mulzasfq32sp16s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x580002;
}

static void
Opcode_ae_mulzasq32sp16u_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180003;
}

static void
Opcode_ae_mulzasfq32sp16u_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x780002;
}

static void
Opcode_ae_mulzasq32sp16s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200003;
}

static void
Opcode_ae_mulzasfq32sp16s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x680002;
}

static void
Opcode_ae_mulzasq32sp16u_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280003;
}

static void
Opcode_ae_mulzasfq32sp16u_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3;
}

static void
Opcode_ae_mulzsaq32sp16s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4;
}

static void
Opcode_ae_mulzsafq32sp16s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x500003;
}

static void
Opcode_ae_mulzsaq32sp16u_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200004;
}

static void
Opcode_ae_mulzsafq32sp16u_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x680003;
}

static void
Opcode_ae_mulzsaq32sp16s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700003;
}

static void
Opcode_ae_mulzsafq32sp16s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x380003;
}

static void
Opcode_ae_mulzsaq32sp16u_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80004;
}

static void
Opcode_ae_mulzsafq32sp16u_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600003;
}

static void
Opcode_ae_mulzsaq32sp16s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x780003;
}

static void
Opcode_ae_mulzsafq32sp16s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x480003;
}

static void
Opcode_ae_mulzsaq32sp16u_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100004;
}

static void
Opcode_ae_mulzsafq32sp16u_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x580003;
}

static void
Opcode_ae_mulzssq32sp16s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x580004;
}

static void
Opcode_ae_mulzssfq32sp16s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280004;
}

static void
Opcode_ae_mulzssq32sp16u_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x780004;
}

static void
Opcode_ae_mulzssfq32sp16u_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x480004;
}

static void
Opcode_ae_mulzssq32sp16s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x500004;
}

static void
Opcode_ae_mulzssfq32sp16s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400004;
}

static void
Opcode_ae_mulzssq32sp16u_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x680004;
}

static void
Opcode_ae_mulzssfq32sp16u_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300004;
}

static void
Opcode_ae_mulzssq32sp16s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600004;
}

static void
Opcode_ae_mulzssfq32sp16s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180004;
}

static void
Opcode_ae_mulzssq32sp16u_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700004;
}

static void
Opcode_ae_mulzssfq32sp16u_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x380004;
}

static void
Opcode_ae_mulzaafp24s_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x204006;
}

static void
Opcode_ae_mulzaap24s_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280006;
}

static void
Opcode_ae_mulzaafp24s_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x208006;
}

static void
Opcode_ae_mulzaap24s_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300006;
}

static void
Opcode_ae_mulzasfp24s_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200186;
}

static void
Opcode_ae_mulzasp24s_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x204106;
}

static void
Opcode_ae_mulzasfp24s_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x204086;
}

static void
Opcode_ae_mulzasp24s_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x204186;
}

static void
Opcode_ae_mulzsafp24s_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x208086;
}

static void
Opcode_ae_mulzsap24s_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20c006;
}

static void
Opcode_ae_mulzsafp24s_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x208106;
}

static void
Opcode_ae_mulzsap24s_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x208186;
}

static void
Opcode_ae_mulzssfp24s_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20c086;
}

static void
Opcode_ae_mulzssp24s_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20c186;
}

static void
Opcode_ae_mulzssfp24s_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20c106;
}

static void
Opcode_ae_mulzssp24s_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280086;
}

static void
Opcode_ae_mulaafp24s_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6;
}

static void
Opcode_ae_mulaap24s_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x106;
}

static void
Opcode_ae_mulaafp24s_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x86;
}

static void
Opcode_ae_mulaap24s_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4006;
}

static void
Opcode_ae_mulasfp24s_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80186;
}

static void
Opcode_ae_mulasp24s_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x84106;
}

static void
Opcode_ae_mulasfp24s_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x84086;
}

static void
Opcode_ae_mulasp24s_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x84186;
}

static void
Opcode_ae_mulsafp24s_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100186;
}

static void
Opcode_ae_mulsap24s_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x104106;
}

static void
Opcode_ae_mulsafp24s_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x104086;
}

static void
Opcode_ae_mulsap24s_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x104186;
}

static void
Opcode_ae_mulssfp24s_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x18c106;
}

static void
Opcode_ae_mulssp24s_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200086;
}

static void
Opcode_ae_mulssfp24s_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x18c186;
}

static void
Opcode_ae_mulssp24s_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200106;
}

static void
Opcode_ae_sha32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41000e;
}

static void
Opcode_ae_vldl32t_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000a;
}

static void
Opcode_ae_vldl16t_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40001a;
}

static void
Opcode_ae_vldl16c_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x410e7e;
}

static void
Opcode_ae_vldsht_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4008ac;
}

static void
Opcode_ae_lb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40006c;
}

static void
Opcode_ae_lbi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x42000e;
}

static void
Opcode_ae_lbk_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40002a;
}

static void
Opcode_ae_lbki_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000e;
}

static void
Opcode_ae_db_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40010f;
}

static void
Opcode_ae_dbi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40020f;
}

static void
Opcode_ae_vlel32t_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40003a;
}

static void
Opcode_ae_vlel16t_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40004a;
}

static void
Opcode_ae_sb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40011f;
}

static void
Opcode_ae_sbi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000f;
}

static void
Opcode_ae_vles16c_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x410c7e;
}

static void
Opcode_ae_sbf_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x410d7e;
}

static void
Opcode_ae_slaasq56s_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6006f81;
}

static void
Opcode_ae_addbrba32_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_ae_minabssp24s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8e001;
}

static void
Opcode_ae_maxabssp24s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe001;
}

static void
Opcode_ae_minabssq56s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240005;
}

static void
Opcode_ae_maxabssq56s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x440005;
}

static void
Opcode_rur_ae_cbegin0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6f03e;
}

static void
Opcode_wur_ae_cbegin0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf63f;
}

static void
Opcode_rur_ae_cend0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7f03e;
}

static void
Opcode_wur_ae_cend0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf73f;
}

static void
Opcode_ae_lp24x2_c_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7f01;
}

static void
Opcode_ae_sp24x2s_c_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x87781;
}

static void
Opcode_ae_lp24x2f_c_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x87f01;
}

static void
Opcode_ae_sp24x2f_c_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7781;
}

static void
Opcode_ae_lp16x2f_c_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x87d01;
}

static void
Opcode_ae_sp16x2f_c_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x87581;
}

static void
Opcode_ae_lp24_c_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7701;
}

static void
Opcode_ae_sp24s_l_c_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x87d81;
}

static void
Opcode_ae_lp24f_c_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x87701;
}

static void
Opcode_ae_sp24f_l_c_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7d81;
}

static void
Opcode_ae_lp16f_c_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7d01;
}

static void
Opcode_ae_sp16f_l_c_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7581;
}

static void
Opcode_ae_lq56_c_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x207501;
}

static void
Opcode_ae_sq56s_c_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x87f81;
}

static void
Opcode_ae_lq32f_c_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x407501;
}

static void
Opcode_ae_sq32f_c_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7f81;
}

static void
Opcode_rur_expstate_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6e03e;
}

static void
Opcode_wur_expstate_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe63f;
}

static void
Opcode_read_impwire_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0;
}

static void
Opcode_setb_expstate_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e0;
}

static void
Opcode_clrb_expstate_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x21e0;
}

static void
Opcode_wrmsk_expstate_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e0;
}

static xtensa_opcode_encode_fn Opcode_excw_encode_fns[] = {
  Opcode_excw_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rfe_encode_fns[] = {
  Opcode_rfe_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rfde_encode_fns[] = {
  Opcode_rfde_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_syscall_encode_fns[] = {
  Opcode_syscall_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_call12_encode_fns[] = {
  Opcode_call12_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_call8_encode_fns[] = {
  Opcode_call8_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_call4_encode_fns[] = {
  Opcode_call4_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_callx12_encode_fns[] = {
  Opcode_callx12_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_callx8_encode_fns[] = {
  Opcode_callx8_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_callx4_encode_fns[] = {
  Opcode_callx4_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_entry_encode_fns[] = {
  Opcode_entry_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_movsp_encode_fns[] = {
  Opcode_movsp_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rotw_encode_fns[] = {
  Opcode_rotw_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_retw_encode_fns[] = {
  Opcode_retw_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_retw_n_encode_fns[] = {
  0, 0, Opcode_retw_n_Slot_inst16b_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rfwo_encode_fns[] = {
  Opcode_rfwo_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rfwu_encode_fns[] = {
  Opcode_rfwu_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_l32e_encode_fns[] = {
  Opcode_l32e_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_s32e_encode_fns[] = {
  Opcode_s32e_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_windowbase_encode_fns[] = {
  Opcode_rsr_windowbase_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_windowbase_encode_fns[] = {
  Opcode_wsr_windowbase_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_windowbase_encode_fns[] = {
  Opcode_xsr_windowbase_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_windowstart_encode_fns[] = {
  Opcode_rsr_windowstart_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_windowstart_encode_fns[] = {
  Opcode_wsr_windowstart_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_windowstart_encode_fns[] = {
  Opcode_xsr_windowstart_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_add_n_encode_fns[] = {
  0, Opcode_add_n_Slot_inst16a_encode, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_addi_n_encode_fns[] = {
  0, Opcode_addi_n_Slot_inst16a_encode, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_beqz_n_encode_fns[] = {
  0, 0, Opcode_beqz_n_Slot_inst16b_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bnez_n_encode_fns[] = {
  0, 0, Opcode_bnez_n_Slot_inst16b_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ill_n_encode_fns[] = {
  0, 0, Opcode_ill_n_Slot_inst16b_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_l32i_n_encode_fns[] = {
  0, Opcode_l32i_n_Slot_inst16a_encode, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mov_n_encode_fns[] = {
  0, 0, Opcode_mov_n_Slot_inst16b_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_movi_n_encode_fns[] = {
  0, 0, Opcode_movi_n_Slot_inst16b_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_nop_n_encode_fns[] = {
  0, 0, Opcode_nop_n_Slot_inst16b_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ret_n_encode_fns[] = {
  0, 0, Opcode_ret_n_Slot_inst16b_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_s32i_n_encode_fns[] = {
  0, Opcode_s32i_n_Slot_inst16a_encode, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_threadptr_encode_fns[] = {
  Opcode_rur_threadptr_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_threadptr_encode_fns[] = {
  Opcode_wur_threadptr_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_addi_encode_fns[] = {
  Opcode_addi_Slot_inst_encode, 0, 0, 0, Opcode_addi_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_addmi_encode_fns[] = {
  Opcode_addmi_Slot_inst_encode, 0, 0, 0, Opcode_addmi_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_add_encode_fns[] = {
  Opcode_add_Slot_inst_encode, 0, 0, 0, Opcode_add_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_sub_encode_fns[] = {
  Opcode_sub_Slot_inst_encode, 0, 0, 0, Opcode_sub_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_addx2_encode_fns[] = {
  Opcode_addx2_Slot_inst_encode, 0, 0, 0, Opcode_addx2_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_addx4_encode_fns[] = {
  Opcode_addx4_Slot_inst_encode, 0, 0, 0, Opcode_addx4_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_addx8_encode_fns[] = {
  Opcode_addx8_Slot_inst_encode, 0, 0, 0, Opcode_addx8_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_subx2_encode_fns[] = {
  Opcode_subx2_Slot_inst_encode, 0, 0, 0, Opcode_subx2_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_subx4_encode_fns[] = {
  Opcode_subx4_Slot_inst_encode, 0, 0, 0, Opcode_subx4_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_subx8_encode_fns[] = {
  Opcode_subx8_Slot_inst_encode, 0, 0, 0, Opcode_subx8_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_and_encode_fns[] = {
  Opcode_and_Slot_inst_encode, 0, 0, 0, Opcode_and_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_or_encode_fns[] = {
  Opcode_or_Slot_inst_encode, 0, 0, 0, Opcode_or_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_xor_encode_fns[] = {
  Opcode_xor_Slot_inst_encode, 0, 0, 0, Opcode_xor_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_beqi_encode_fns[] = {
  Opcode_beqi_Slot_inst_encode, 0, 0, 0, Opcode_beqi_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_bnei_encode_fns[] = {
  Opcode_bnei_Slot_inst_encode, 0, 0, 0, Opcode_bnei_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_bgei_encode_fns[] = {
  Opcode_bgei_Slot_inst_encode, 0, 0, 0, Opcode_bgei_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_blti_encode_fns[] = {
  Opcode_blti_Slot_inst_encode, 0, 0, 0, Opcode_blti_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_bbci_encode_fns[] = {
  Opcode_bbci_Slot_inst_encode, 0, 0, 0, Opcode_bbci_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_bbsi_encode_fns[] = {
  Opcode_bbsi_Slot_inst_encode, 0, 0, 0, Opcode_bbsi_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_bgeui_encode_fns[] = {
  Opcode_bgeui_Slot_inst_encode, 0, 0, 0, Opcode_bgeui_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_bltui_encode_fns[] = {
  Opcode_bltui_Slot_inst_encode, 0, 0, 0, Opcode_bltui_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_beq_encode_fns[] = {
  Opcode_beq_Slot_inst_encode, 0, 0, 0, Opcode_beq_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_bne_encode_fns[] = {
  Opcode_bne_Slot_inst_encode, 0, 0, 0, Opcode_bne_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_bge_encode_fns[] = {
  Opcode_bge_Slot_inst_encode, 0, 0, 0, Opcode_bge_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_blt_encode_fns[] = {
  Opcode_blt_Slot_inst_encode, 0, 0, 0, Opcode_blt_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_bgeu_encode_fns[] = {
  Opcode_bgeu_Slot_inst_encode, 0, 0, 0, Opcode_bgeu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_bltu_encode_fns[] = {
  Opcode_bltu_Slot_inst_encode, 0, 0, 0, Opcode_bltu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_bany_encode_fns[] = {
  Opcode_bany_Slot_inst_encode, 0, 0, 0, Opcode_bany_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_bnone_encode_fns[] = {
  Opcode_bnone_Slot_inst_encode, 0, 0, 0, Opcode_bnone_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ball_encode_fns[] = {
  Opcode_ball_Slot_inst_encode, 0, 0, 0, Opcode_ball_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_bnall_encode_fns[] = {
  Opcode_bnall_Slot_inst_encode, 0, 0, 0, Opcode_bnall_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_bbc_encode_fns[] = {
  Opcode_bbc_Slot_inst_encode, 0, 0, 0, Opcode_bbc_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_bbs_encode_fns[] = {
  Opcode_bbs_Slot_inst_encode, 0, 0, 0, Opcode_bbs_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_beqz_encode_fns[] = {
  Opcode_beqz_Slot_inst_encode, 0, 0, 0, Opcode_beqz_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_bnez_encode_fns[] = {
  Opcode_bnez_Slot_inst_encode, 0, 0, 0, Opcode_bnez_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_bgez_encode_fns[] = {
  Opcode_bgez_Slot_inst_encode, 0, 0, 0, Opcode_bgez_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_bltz_encode_fns[] = {
  Opcode_bltz_Slot_inst_encode, 0, 0, 0, Opcode_bltz_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_call0_encode_fns[] = {
  Opcode_call0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_callx0_encode_fns[] = {
  Opcode_callx0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_extui_encode_fns[] = {
  Opcode_extui_Slot_inst_encode, 0, 0, 0, Opcode_extui_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ill_encode_fns[] = {
  Opcode_ill_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_j_encode_fns[] = {
  Opcode_j_Slot_inst_encode, 0, 0, 0, Opcode_j_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_jx_encode_fns[] = {
  Opcode_jx_Slot_inst_encode, 0, 0, 0, Opcode_jx_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_l16ui_encode_fns[] = {
  Opcode_l16ui_Slot_inst_encode, 0, 0, 0, Opcode_l16ui_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_l16si_encode_fns[] = {
  Opcode_l16si_Slot_inst_encode, 0, 0, 0, Opcode_l16si_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_l32i_encode_fns[] = {
  Opcode_l32i_Slot_inst_encode, 0, 0, 0, Opcode_l32i_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_l32r_encode_fns[] = {
  Opcode_l32r_Slot_inst_encode, 0, 0, 0, Opcode_l32r_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_l8ui_encode_fns[] = {
  Opcode_l8ui_Slot_inst_encode, 0, 0, 0, Opcode_l8ui_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_loop_encode_fns[] = {
  Opcode_loop_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_loopnez_encode_fns[] = {
  Opcode_loopnez_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_loopgtz_encode_fns[] = {
  Opcode_loopgtz_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_movi_encode_fns[] = {
  Opcode_movi_Slot_inst_encode, 0, 0, 0, Opcode_movi_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_moveqz_encode_fns[] = {
  Opcode_moveqz_Slot_inst_encode, 0, 0, 0, Opcode_moveqz_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_movnez_encode_fns[] = {
  Opcode_movnez_Slot_inst_encode, 0, 0, 0, Opcode_movnez_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_movltz_encode_fns[] = {
  Opcode_movltz_Slot_inst_encode, 0, 0, 0, Opcode_movltz_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_movgez_encode_fns[] = {
  Opcode_movgez_Slot_inst_encode, 0, 0, 0, Opcode_movgez_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_neg_encode_fns[] = {
  Opcode_neg_Slot_inst_encode, 0, 0, 0, Opcode_neg_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_abs_encode_fns[] = {
  Opcode_abs_Slot_inst_encode, 0, 0, 0, Opcode_abs_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_nop_encode_fns[] = {
  Opcode_nop_Slot_inst_encode, 0, 0, Opcode_nop_Slot_ae_slot1_encode, Opcode_nop_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ret_encode_fns[] = {
  Opcode_ret_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_simcall_encode_fns[] = {
  Opcode_simcall_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_s16i_encode_fns[] = {
  Opcode_s16i_Slot_inst_encode, 0, 0, 0, Opcode_s16i_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_s32i_encode_fns[] = {
  Opcode_s32i_Slot_inst_encode, 0, 0, 0, Opcode_s32i_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_s32nb_encode_fns[] = {
  Opcode_s32nb_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_s8i_encode_fns[] = {
  Opcode_s8i_Slot_inst_encode, 0, 0, 0, Opcode_s8i_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ssr_encode_fns[] = {
  Opcode_ssr_Slot_inst_encode, 0, 0, 0, Opcode_ssr_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ssl_encode_fns[] = {
  Opcode_ssl_Slot_inst_encode, 0, 0, 0, Opcode_ssl_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ssa8l_encode_fns[] = {
  Opcode_ssa8l_Slot_inst_encode, 0, 0, 0, Opcode_ssa8l_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ssa8b_encode_fns[] = {
  Opcode_ssa8b_Slot_inst_encode, 0, 0, 0, Opcode_ssa8b_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ssai_encode_fns[] = {
  Opcode_ssai_Slot_inst_encode, 0, 0, 0, Opcode_ssai_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_sll_encode_fns[] = {
  Opcode_sll_Slot_inst_encode, 0, 0, 0, Opcode_sll_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_src_encode_fns[] = {
  Opcode_src_Slot_inst_encode, 0, 0, 0, Opcode_src_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_srl_encode_fns[] = {
  Opcode_srl_Slot_inst_encode, 0, 0, 0, Opcode_srl_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_sra_encode_fns[] = {
  Opcode_sra_Slot_inst_encode, 0, 0, 0, Opcode_sra_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_slli_encode_fns[] = {
  Opcode_slli_Slot_inst_encode, 0, 0, 0, Opcode_slli_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_srai_encode_fns[] = {
  Opcode_srai_Slot_inst_encode, 0, 0, 0, Opcode_srai_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_srli_encode_fns[] = {
  Opcode_srli_Slot_inst_encode, 0, 0, 0, Opcode_srli_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_memw_encode_fns[] = {
  Opcode_memw_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_extw_encode_fns[] = {
  Opcode_extw_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_isync_encode_fns[] = {
  Opcode_isync_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsync_encode_fns[] = {
  Opcode_rsync_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_esync_encode_fns[] = {
  Opcode_esync_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_dsync_encode_fns[] = {
  Opcode_dsync_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsil_encode_fns[] = {
  Opcode_rsil_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_lend_encode_fns[] = {
  Opcode_rsr_lend_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_lend_encode_fns[] = {
  Opcode_wsr_lend_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_lend_encode_fns[] = {
  Opcode_xsr_lend_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_lcount_encode_fns[] = {
  Opcode_rsr_lcount_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_lcount_encode_fns[] = {
  Opcode_wsr_lcount_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_lcount_encode_fns[] = {
  Opcode_xsr_lcount_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_lbeg_encode_fns[] = {
  Opcode_rsr_lbeg_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_lbeg_encode_fns[] = {
  Opcode_wsr_lbeg_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_lbeg_encode_fns[] = {
  Opcode_xsr_lbeg_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_sar_encode_fns[] = {
  Opcode_rsr_sar_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_sar_encode_fns[] = {
  Opcode_wsr_sar_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_sar_encode_fns[] = {
  Opcode_xsr_sar_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_memctl_encode_fns[] = {
  Opcode_rsr_memctl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_memctl_encode_fns[] = {
  Opcode_wsr_memctl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_memctl_encode_fns[] = {
  Opcode_xsr_memctl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_litbase_encode_fns[] = {
  Opcode_rsr_litbase_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_litbase_encode_fns[] = {
  Opcode_wsr_litbase_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_litbase_encode_fns[] = {
  Opcode_xsr_litbase_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_configid0_encode_fns[] = {
  Opcode_rsr_configid0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_configid0_encode_fns[] = {
  Opcode_wsr_configid0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_configid1_encode_fns[] = {
  Opcode_rsr_configid1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_243_encode_fns[] = {
  Opcode_rsr_243_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_ps_encode_fns[] = {
  Opcode_rsr_ps_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_ps_encode_fns[] = {
  Opcode_wsr_ps_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_ps_encode_fns[] = {
  Opcode_xsr_ps_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_epc1_encode_fns[] = {
  Opcode_rsr_epc1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_epc1_encode_fns[] = {
  Opcode_wsr_epc1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_epc1_encode_fns[] = {
  Opcode_xsr_epc1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_excsave1_encode_fns[] = {
  Opcode_rsr_excsave1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_excsave1_encode_fns[] = {
  Opcode_wsr_excsave1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_excsave1_encode_fns[] = {
  Opcode_xsr_excsave1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_epc2_encode_fns[] = {
  Opcode_rsr_epc2_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_epc2_encode_fns[] = {
  Opcode_wsr_epc2_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_epc2_encode_fns[] = {
  Opcode_xsr_epc2_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_excsave2_encode_fns[] = {
  Opcode_rsr_excsave2_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_excsave2_encode_fns[] = {
  Opcode_wsr_excsave2_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_excsave2_encode_fns[] = {
  Opcode_xsr_excsave2_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_epc3_encode_fns[] = {
  Opcode_rsr_epc3_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_epc3_encode_fns[] = {
  Opcode_wsr_epc3_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_epc3_encode_fns[] = {
  Opcode_xsr_epc3_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_excsave3_encode_fns[] = {
  Opcode_rsr_excsave3_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_excsave3_encode_fns[] = {
  Opcode_wsr_excsave3_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_excsave3_encode_fns[] = {
  Opcode_xsr_excsave3_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_epc4_encode_fns[] = {
  Opcode_rsr_epc4_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_epc4_encode_fns[] = {
  Opcode_wsr_epc4_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_epc4_encode_fns[] = {
  Opcode_xsr_epc4_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_excsave4_encode_fns[] = {
  Opcode_rsr_excsave4_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_excsave4_encode_fns[] = {
  Opcode_wsr_excsave4_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_excsave4_encode_fns[] = {
  Opcode_xsr_excsave4_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_epc5_encode_fns[] = {
  Opcode_rsr_epc5_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_epc5_encode_fns[] = {
  Opcode_wsr_epc5_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_epc5_encode_fns[] = {
  Opcode_xsr_epc5_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_excsave5_encode_fns[] = {
  Opcode_rsr_excsave5_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_excsave5_encode_fns[] = {
  Opcode_wsr_excsave5_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_excsave5_encode_fns[] = {
  Opcode_xsr_excsave5_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_epc6_encode_fns[] = {
  Opcode_rsr_epc6_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_epc6_encode_fns[] = {
  Opcode_wsr_epc6_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_epc6_encode_fns[] = {
  Opcode_xsr_epc6_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_excsave6_encode_fns[] = {
  Opcode_rsr_excsave6_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_excsave6_encode_fns[] = {
  Opcode_wsr_excsave6_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_excsave6_encode_fns[] = {
  Opcode_xsr_excsave6_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_epc7_encode_fns[] = {
  Opcode_rsr_epc7_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_epc7_encode_fns[] = {
  Opcode_wsr_epc7_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_epc7_encode_fns[] = {
  Opcode_xsr_epc7_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_excsave7_encode_fns[] = {
  Opcode_rsr_excsave7_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_excsave7_encode_fns[] = {
  Opcode_wsr_excsave7_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_excsave7_encode_fns[] = {
  Opcode_xsr_excsave7_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_eps2_encode_fns[] = {
  Opcode_rsr_eps2_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_eps2_encode_fns[] = {
  Opcode_wsr_eps2_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_eps2_encode_fns[] = {
  Opcode_xsr_eps2_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_eps3_encode_fns[] = {
  Opcode_rsr_eps3_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_eps3_encode_fns[] = {
  Opcode_wsr_eps3_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_eps3_encode_fns[] = {
  Opcode_xsr_eps3_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_eps4_encode_fns[] = {
  Opcode_rsr_eps4_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_eps4_encode_fns[] = {
  Opcode_wsr_eps4_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_eps4_encode_fns[] = {
  Opcode_xsr_eps4_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_eps5_encode_fns[] = {
  Opcode_rsr_eps5_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_eps5_encode_fns[] = {
  Opcode_wsr_eps5_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_eps5_encode_fns[] = {
  Opcode_xsr_eps5_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_eps6_encode_fns[] = {
  Opcode_rsr_eps6_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_eps6_encode_fns[] = {
  Opcode_wsr_eps6_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_eps6_encode_fns[] = {
  Opcode_xsr_eps6_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_eps7_encode_fns[] = {
  Opcode_rsr_eps7_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_eps7_encode_fns[] = {
  Opcode_wsr_eps7_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_eps7_encode_fns[] = {
  Opcode_xsr_eps7_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_excvaddr_encode_fns[] = {
  Opcode_rsr_excvaddr_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_excvaddr_encode_fns[] = {
  Opcode_wsr_excvaddr_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_excvaddr_encode_fns[] = {
  Opcode_xsr_excvaddr_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_depc_encode_fns[] = {
  Opcode_rsr_depc_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_depc_encode_fns[] = {
  Opcode_wsr_depc_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_depc_encode_fns[] = {
  Opcode_xsr_depc_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_exccause_encode_fns[] = {
  Opcode_rsr_exccause_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_exccause_encode_fns[] = {
  Opcode_wsr_exccause_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_exccause_encode_fns[] = {
  Opcode_xsr_exccause_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_misc0_encode_fns[] = {
  Opcode_rsr_misc0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_misc0_encode_fns[] = {
  Opcode_wsr_misc0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_misc0_encode_fns[] = {
  Opcode_xsr_misc0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_misc1_encode_fns[] = {
  Opcode_rsr_misc1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_misc1_encode_fns[] = {
  Opcode_wsr_misc1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_misc1_encode_fns[] = {
  Opcode_xsr_misc1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_prid_encode_fns[] = {
  Opcode_rsr_prid_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_vecbase_encode_fns[] = {
  Opcode_rsr_vecbase_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_vecbase_encode_fns[] = {
  Opcode_wsr_vecbase_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_vecbase_encode_fns[] = {
  Opcode_xsr_vecbase_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mul16u_encode_fns[] = {
  Opcode_mul16u_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mul16s_encode_fns[] = {
  Opcode_mul16s_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mull_encode_fns[] = {
  Opcode_mull_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_muluh_encode_fns[] = {
  Opcode_muluh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mulsh_encode_fns[] = {
  Opcode_mulsh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mul_aa_ll_encode_fns[] = {
  Opcode_mul_aa_ll_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mul_aa_hl_encode_fns[] = {
  Opcode_mul_aa_hl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mul_aa_lh_encode_fns[] = {
  Opcode_mul_aa_lh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mul_aa_hh_encode_fns[] = {
  Opcode_mul_aa_hh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_umul_aa_ll_encode_fns[] = {
  Opcode_umul_aa_ll_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_umul_aa_hl_encode_fns[] = {
  Opcode_umul_aa_hl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_umul_aa_lh_encode_fns[] = {
  Opcode_umul_aa_lh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_umul_aa_hh_encode_fns[] = {
  Opcode_umul_aa_hh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mul_ad_ll_encode_fns[] = {
  Opcode_mul_ad_ll_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mul_ad_hl_encode_fns[] = {
  Opcode_mul_ad_hl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mul_ad_lh_encode_fns[] = {
  Opcode_mul_ad_lh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mul_ad_hh_encode_fns[] = {
  Opcode_mul_ad_hh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mul_da_ll_encode_fns[] = {
  Opcode_mul_da_ll_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mul_da_hl_encode_fns[] = {
  Opcode_mul_da_hl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mul_da_lh_encode_fns[] = {
  Opcode_mul_da_lh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mul_da_hh_encode_fns[] = {
  Opcode_mul_da_hh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mul_dd_ll_encode_fns[] = {
  Opcode_mul_dd_ll_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mul_dd_hl_encode_fns[] = {
  Opcode_mul_dd_hl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mul_dd_lh_encode_fns[] = {
  Opcode_mul_dd_lh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mul_dd_hh_encode_fns[] = {
  Opcode_mul_dd_hh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_aa_ll_encode_fns[] = {
  Opcode_mula_aa_ll_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_aa_hl_encode_fns[] = {
  Opcode_mula_aa_hl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_aa_lh_encode_fns[] = {
  Opcode_mula_aa_lh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_aa_hh_encode_fns[] = {
  Opcode_mula_aa_hh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_muls_aa_ll_encode_fns[] = {
  Opcode_muls_aa_ll_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_muls_aa_hl_encode_fns[] = {
  Opcode_muls_aa_hl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_muls_aa_lh_encode_fns[] = {
  Opcode_muls_aa_lh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_muls_aa_hh_encode_fns[] = {
  Opcode_muls_aa_hh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_ad_ll_encode_fns[] = {
  Opcode_mula_ad_ll_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_ad_hl_encode_fns[] = {
  Opcode_mula_ad_hl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_ad_lh_encode_fns[] = {
  Opcode_mula_ad_lh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_ad_hh_encode_fns[] = {
  Opcode_mula_ad_hh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_muls_ad_ll_encode_fns[] = {
  Opcode_muls_ad_ll_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_muls_ad_hl_encode_fns[] = {
  Opcode_muls_ad_hl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_muls_ad_lh_encode_fns[] = {
  Opcode_muls_ad_lh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_muls_ad_hh_encode_fns[] = {
  Opcode_muls_ad_hh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_da_ll_encode_fns[] = {
  Opcode_mula_da_ll_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_da_hl_encode_fns[] = {
  Opcode_mula_da_hl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_da_lh_encode_fns[] = {
  Opcode_mula_da_lh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_da_hh_encode_fns[] = {
  Opcode_mula_da_hh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_muls_da_ll_encode_fns[] = {
  Opcode_muls_da_ll_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_muls_da_hl_encode_fns[] = {
  Opcode_muls_da_hl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_muls_da_lh_encode_fns[] = {
  Opcode_muls_da_lh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_muls_da_hh_encode_fns[] = {
  Opcode_muls_da_hh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_dd_ll_encode_fns[] = {
  Opcode_mula_dd_ll_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_dd_hl_encode_fns[] = {
  Opcode_mula_dd_hl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_dd_lh_encode_fns[] = {
  Opcode_mula_dd_lh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_dd_hh_encode_fns[] = {
  Opcode_mula_dd_hh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_muls_dd_ll_encode_fns[] = {
  Opcode_muls_dd_ll_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_muls_dd_hl_encode_fns[] = {
  Opcode_muls_dd_hl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_muls_dd_lh_encode_fns[] = {
  Opcode_muls_dd_lh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_muls_dd_hh_encode_fns[] = {
  Opcode_muls_dd_hh_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_da_ll_lddec_encode_fns[] = {
  Opcode_mula_da_ll_lddec_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_da_ll_ldinc_encode_fns[] = {
  Opcode_mula_da_ll_ldinc_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_da_hl_lddec_encode_fns[] = {
  Opcode_mula_da_hl_lddec_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_da_hl_ldinc_encode_fns[] = {
  Opcode_mula_da_hl_ldinc_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_da_lh_lddec_encode_fns[] = {
  Opcode_mula_da_lh_lddec_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_da_lh_ldinc_encode_fns[] = {
  Opcode_mula_da_lh_ldinc_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_da_hh_lddec_encode_fns[] = {
  Opcode_mula_da_hh_lddec_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_da_hh_ldinc_encode_fns[] = {
  Opcode_mula_da_hh_ldinc_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_dd_ll_lddec_encode_fns[] = {
  Opcode_mula_dd_ll_lddec_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_dd_ll_ldinc_encode_fns[] = {
  Opcode_mula_dd_ll_ldinc_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_dd_hl_lddec_encode_fns[] = {
  Opcode_mula_dd_hl_lddec_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_dd_hl_ldinc_encode_fns[] = {
  Opcode_mula_dd_hl_ldinc_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_dd_lh_lddec_encode_fns[] = {
  Opcode_mula_dd_lh_lddec_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_dd_lh_ldinc_encode_fns[] = {
  Opcode_mula_dd_lh_ldinc_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_dd_hh_lddec_encode_fns[] = {
  Opcode_mula_dd_hh_lddec_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mula_dd_hh_ldinc_encode_fns[] = {
  Opcode_mula_dd_hh_ldinc_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_lddec_encode_fns[] = {
  Opcode_lddec_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ldinc_encode_fns[] = {
  Opcode_ldinc_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_m0_encode_fns[] = {
  Opcode_rsr_m0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_m0_encode_fns[] = {
  Opcode_wsr_m0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_m0_encode_fns[] = {
  Opcode_xsr_m0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_m1_encode_fns[] = {
  Opcode_rsr_m1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_m1_encode_fns[] = {
  Opcode_wsr_m1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_m1_encode_fns[] = {
  Opcode_xsr_m1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_m2_encode_fns[] = {
  Opcode_rsr_m2_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_m2_encode_fns[] = {
  Opcode_wsr_m2_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_m2_encode_fns[] = {
  Opcode_xsr_m2_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_m3_encode_fns[] = {
  Opcode_rsr_m3_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_m3_encode_fns[] = {
  Opcode_wsr_m3_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_m3_encode_fns[] = {
  Opcode_xsr_m3_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_acclo_encode_fns[] = {
  Opcode_rsr_acclo_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_acclo_encode_fns[] = {
  Opcode_wsr_acclo_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_acclo_encode_fns[] = {
  Opcode_xsr_acclo_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_acchi_encode_fns[] = {
  Opcode_rsr_acchi_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_acchi_encode_fns[] = {
  Opcode_wsr_acchi_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_acchi_encode_fns[] = {
  Opcode_xsr_acchi_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rfi_encode_fns[] = {
  Opcode_rfi_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_waiti_encode_fns[] = {
  Opcode_waiti_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_interrupt_encode_fns[] = {
  Opcode_rsr_interrupt_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_intset_encode_fns[] = {
  Opcode_wsr_intset_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_intclear_encode_fns[] = {
  Opcode_wsr_intclear_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_intenable_encode_fns[] = {
  Opcode_rsr_intenable_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_intenable_encode_fns[] = {
  Opcode_wsr_intenable_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_intenable_encode_fns[] = {
  Opcode_xsr_intenable_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_break_encode_fns[] = {
  Opcode_break_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_break_n_encode_fns[] = {
  0, 0, Opcode_break_n_Slot_inst16b_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_dbreaka0_encode_fns[] = {
  Opcode_rsr_dbreaka0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_dbreaka0_encode_fns[] = {
  Opcode_wsr_dbreaka0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_dbreaka0_encode_fns[] = {
  Opcode_xsr_dbreaka0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_dbreakc0_encode_fns[] = {
  Opcode_rsr_dbreakc0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_dbreakc0_encode_fns[] = {
  Opcode_wsr_dbreakc0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_dbreakc0_encode_fns[] = {
  Opcode_xsr_dbreakc0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_dbreaka1_encode_fns[] = {
  Opcode_rsr_dbreaka1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_dbreaka1_encode_fns[] = {
  Opcode_wsr_dbreaka1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_dbreaka1_encode_fns[] = {
  Opcode_xsr_dbreaka1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_dbreakc1_encode_fns[] = {
  Opcode_rsr_dbreakc1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_dbreakc1_encode_fns[] = {
  Opcode_wsr_dbreakc1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_dbreakc1_encode_fns[] = {
  Opcode_xsr_dbreakc1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_ibreaka0_encode_fns[] = {
  Opcode_rsr_ibreaka0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_ibreaka0_encode_fns[] = {
  Opcode_wsr_ibreaka0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_ibreaka0_encode_fns[] = {
  Opcode_xsr_ibreaka0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_ibreaka1_encode_fns[] = {
  Opcode_rsr_ibreaka1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_ibreaka1_encode_fns[] = {
  Opcode_wsr_ibreaka1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_ibreaka1_encode_fns[] = {
  Opcode_xsr_ibreaka1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_ibreakenable_encode_fns[] = {
  Opcode_rsr_ibreakenable_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_ibreakenable_encode_fns[] = {
  Opcode_wsr_ibreakenable_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_ibreakenable_encode_fns[] = {
  Opcode_xsr_ibreakenable_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_debugcause_encode_fns[] = {
  Opcode_rsr_debugcause_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_debugcause_encode_fns[] = {
  Opcode_wsr_debugcause_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_debugcause_encode_fns[] = {
  Opcode_xsr_debugcause_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_icount_encode_fns[] = {
  Opcode_rsr_icount_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_icount_encode_fns[] = {
  Opcode_wsr_icount_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_icount_encode_fns[] = {
  Opcode_xsr_icount_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_icountlevel_encode_fns[] = {
  Opcode_rsr_icountlevel_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_icountlevel_encode_fns[] = {
  Opcode_wsr_icountlevel_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_icountlevel_encode_fns[] = {
  Opcode_xsr_icountlevel_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_ddr_encode_fns[] = {
  Opcode_rsr_ddr_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_ddr_encode_fns[] = {
  Opcode_wsr_ddr_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_ddr_encode_fns[] = {
  Opcode_xsr_ddr_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_lddr32_p_encode_fns[] = {
  Opcode_lddr32_p_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_sddr32_p_encode_fns[] = {
  Opcode_sddr32_p_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rfdo_encode_fns[] = {
  Opcode_rfdo_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rfdd_encode_fns[] = {
  Opcode_rfdd_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_mmid_encode_fns[] = {
  Opcode_wsr_mmid_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_andb_encode_fns[] = {
  Opcode_andb_Slot_inst_encode, 0, 0, 0, Opcode_andb_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_andbc_encode_fns[] = {
  Opcode_andbc_Slot_inst_encode, 0, 0, 0, Opcode_andbc_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_orb_encode_fns[] = {
  Opcode_orb_Slot_inst_encode, 0, 0, 0, Opcode_orb_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_orbc_encode_fns[] = {
  Opcode_orbc_Slot_inst_encode, 0, 0, 0, Opcode_orbc_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_xorb_encode_fns[] = {
  Opcode_xorb_Slot_inst_encode, 0, 0, 0, Opcode_xorb_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_any4_encode_fns[] = {
  Opcode_any4_Slot_inst_encode, 0, 0, 0, Opcode_any4_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_all4_encode_fns[] = {
  Opcode_all4_Slot_inst_encode, 0, 0, 0, Opcode_all4_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_any8_encode_fns[] = {
  Opcode_any8_Slot_inst_encode, 0, 0, 0, Opcode_any8_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_all8_encode_fns[] = {
  Opcode_all8_Slot_inst_encode, 0, 0, 0, Opcode_all8_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_bf_encode_fns[] = {
  Opcode_bf_Slot_inst_encode, 0, 0, 0, Opcode_bf_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_bt_encode_fns[] = {
  Opcode_bt_Slot_inst_encode, 0, 0, 0, Opcode_bt_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_movf_encode_fns[] = {
  Opcode_movf_Slot_inst_encode, 0, 0, 0, Opcode_movf_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_movt_encode_fns[] = {
  Opcode_movt_Slot_inst_encode, 0, 0, 0, Opcode_movt_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_rsr_br_encode_fns[] = {
  Opcode_rsr_br_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_br_encode_fns[] = {
  Opcode_wsr_br_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_br_encode_fns[] = {
  Opcode_xsr_br_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_ccount_encode_fns[] = {
  Opcode_rsr_ccount_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_ccount_encode_fns[] = {
  Opcode_wsr_ccount_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_ccount_encode_fns[] = {
  Opcode_xsr_ccount_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_ccompare0_encode_fns[] = {
  Opcode_rsr_ccompare0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_ccompare0_encode_fns[] = {
  Opcode_wsr_ccompare0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_ccompare0_encode_fns[] = {
  Opcode_xsr_ccompare0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_ccompare1_encode_fns[] = {
  Opcode_rsr_ccompare1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_ccompare1_encode_fns[] = {
  Opcode_wsr_ccompare1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_ccompare1_encode_fns[] = {
  Opcode_xsr_ccompare1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_ccompare2_encode_fns[] = {
  Opcode_rsr_ccompare2_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_ccompare2_encode_fns[] = {
  Opcode_wsr_ccompare2_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_ccompare2_encode_fns[] = {
  Opcode_xsr_ccompare2_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ipf_encode_fns[] = {
  Opcode_ipf_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ihi_encode_fns[] = {
  Opcode_ihi_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ipfl_encode_fns[] = {
  Opcode_ipfl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ihu_encode_fns[] = {
  Opcode_ihu_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_iiu_encode_fns[] = {
  Opcode_iiu_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_iii_encode_fns[] = {
  Opcode_iii_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_lict_encode_fns[] = {
  Opcode_lict_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_licw_encode_fns[] = {
  Opcode_licw_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_sict_encode_fns[] = {
  Opcode_sict_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_sicw_encode_fns[] = {
  Opcode_sicw_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_dhwb_encode_fns[] = {
  Opcode_dhwb_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_dhwbi_encode_fns[] = {
  Opcode_dhwbi_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_diwbui_p_encode_fns[] = {
  Opcode_diwbui_p_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_diwb_encode_fns[] = {
  Opcode_diwb_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_diwbi_encode_fns[] = {
  Opcode_diwbi_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_dhi_encode_fns[] = {
  Opcode_dhi_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_dii_encode_fns[] = {
  Opcode_dii_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_dpfr_encode_fns[] = {
  Opcode_dpfr_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_dpfw_encode_fns[] = {
  Opcode_dpfw_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_dpfro_encode_fns[] = {
  Opcode_dpfro_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_dpfwo_encode_fns[] = {
  Opcode_dpfwo_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_dpfl_encode_fns[] = {
  Opcode_dpfl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_dhu_encode_fns[] = {
  Opcode_dhu_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_diu_encode_fns[] = {
  Opcode_diu_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_sdct_encode_fns[] = {
  Opcode_sdct_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ldct_encode_fns[] = {
  Opcode_ldct_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_prefctl_encode_fns[] = {
  Opcode_rsr_prefctl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_prefctl_encode_fns[] = {
  Opcode_wsr_prefctl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_prefctl_encode_fns[] = {
  Opcode_xsr_prefctl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_ptevaddr_encode_fns[] = {
  Opcode_wsr_ptevaddr_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_ptevaddr_encode_fns[] = {
  Opcode_rsr_ptevaddr_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_ptevaddr_encode_fns[] = {
  Opcode_xsr_ptevaddr_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_rasid_encode_fns[] = {
  Opcode_rsr_rasid_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_rasid_encode_fns[] = {
  Opcode_wsr_rasid_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_rasid_encode_fns[] = {
  Opcode_xsr_rasid_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_itlbcfg_encode_fns[] = {
  Opcode_rsr_itlbcfg_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_itlbcfg_encode_fns[] = {
  Opcode_wsr_itlbcfg_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_itlbcfg_encode_fns[] = {
  Opcode_xsr_itlbcfg_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_dtlbcfg_encode_fns[] = {
  Opcode_rsr_dtlbcfg_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_dtlbcfg_encode_fns[] = {
  Opcode_wsr_dtlbcfg_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_dtlbcfg_encode_fns[] = {
  Opcode_xsr_dtlbcfg_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_idtlb_encode_fns[] = {
  Opcode_idtlb_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_pdtlb_encode_fns[] = {
  Opcode_pdtlb_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rdtlb0_encode_fns[] = {
  Opcode_rdtlb0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rdtlb1_encode_fns[] = {
  Opcode_rdtlb1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wdtlb_encode_fns[] = {
  Opcode_wdtlb_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_iitlb_encode_fns[] = {
  Opcode_iitlb_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_pitlb_encode_fns[] = {
  Opcode_pitlb_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ritlb0_encode_fns[] = {
  Opcode_ritlb0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ritlb1_encode_fns[] = {
  Opcode_ritlb1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_witlb_encode_fns[] = {
  Opcode_witlb_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ldpte_encode_fns[] = {
  Opcode_ldpte_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_hwwitlba_encode_fns[] = {
  Opcode_hwwitlba_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_hwwdtlba_encode_fns[] = {
  Opcode_hwwdtlba_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_cpenable_encode_fns[] = {
  Opcode_rsr_cpenable_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_cpenable_encode_fns[] = {
  Opcode_wsr_cpenable_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_cpenable_encode_fns[] = {
  Opcode_xsr_cpenable_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_clamps_encode_fns[] = {
  Opcode_clamps_Slot_inst_encode, 0, 0, 0, Opcode_clamps_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_min_encode_fns[] = {
  Opcode_min_Slot_inst_encode, 0, 0, 0, Opcode_min_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_max_encode_fns[] = {
  Opcode_max_Slot_inst_encode, 0, 0, 0, Opcode_max_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_minu_encode_fns[] = {
  Opcode_minu_Slot_inst_encode, 0, 0, 0, Opcode_minu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_maxu_encode_fns[] = {
  Opcode_maxu_Slot_inst_encode, 0, 0, 0, Opcode_maxu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_nsa_encode_fns[] = {
  Opcode_nsa_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_nsau_encode_fns[] = {
  Opcode_nsau_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_sext_encode_fns[] = {
  Opcode_sext_Slot_inst_encode, 0, 0, 0, Opcode_sext_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_l32ai_encode_fns[] = {
  Opcode_l32ai_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_s32ri_encode_fns[] = {
  Opcode_s32ri_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_s32c1i_encode_fns[] = {
  Opcode_s32c1i_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_scompare1_encode_fns[] = {
  Opcode_rsr_scompare1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_scompare1_encode_fns[] = {
  Opcode_wsr_scompare1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_scompare1_encode_fns[] = {
  Opcode_xsr_scompare1_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_atomctl_encode_fns[] = {
  Opcode_rsr_atomctl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_atomctl_encode_fns[] = {
  Opcode_wsr_atomctl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_atomctl_encode_fns[] = {
  Opcode_xsr_atomctl_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_quou_encode_fns[] = {
  Opcode_quou_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_quos_encode_fns[] = {
  Opcode_quos_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_remu_encode_fns[] = {
  Opcode_remu_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rems_encode_fns[] = {
  Opcode_rems_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rer_encode_fns[] = {
  Opcode_rer_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wer_encode_fns[] = {
  Opcode_wer_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_ovf_sar_encode_fns[] = {
  Opcode_rur_ae_ovf_sar_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_ovf_sar_encode_fns[] = {
  Opcode_wur_ae_ovf_sar_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_bithead_encode_fns[] = {
  Opcode_rur_ae_bithead_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_bithead_encode_fns[] = {
  Opcode_wur_ae_bithead_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_ts_fts_bu_bp_encode_fns[] = {
  Opcode_rur_ae_ts_fts_bu_bp_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_ts_fts_bu_bp_encode_fns[] = {
  Opcode_wur_ae_ts_fts_bu_bp_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_sd_no_encode_fns[] = {
  Opcode_rur_ae_sd_no_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_sd_no_encode_fns[] = {
  Opcode_wur_ae_sd_no_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_overflow_encode_fns[] = {
  Opcode_rur_ae_overflow_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_overflow_encode_fns[] = {
  Opcode_wur_ae_overflow_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_sar_encode_fns[] = {
  Opcode_rur_ae_sar_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_sar_encode_fns[] = {
  Opcode_wur_ae_sar_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_bitptr_encode_fns[] = {
  Opcode_rur_ae_bitptr_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_bitptr_encode_fns[] = {
  Opcode_wur_ae_bitptr_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_bitsused_encode_fns[] = {
  Opcode_rur_ae_bitsused_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_bitsused_encode_fns[] = {
  Opcode_wur_ae_bitsused_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_tablesize_encode_fns[] = {
  Opcode_rur_ae_tablesize_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_tablesize_encode_fns[] = {
  Opcode_wur_ae_tablesize_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_first_ts_encode_fns[] = {
  Opcode_rur_ae_first_ts_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_first_ts_encode_fns[] = {
  Opcode_wur_ae_first_ts_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_nextoffset_encode_fns[] = {
  Opcode_rur_ae_nextoffset_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_nextoffset_encode_fns[] = {
  Opcode_wur_ae_nextoffset_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_searchdone_encode_fns[] = {
  Opcode_rur_ae_searchdone_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_searchdone_encode_fns[] = {
  Opcode_wur_ae_searchdone_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_lp16f_i_encode_fns[] = {
  Opcode_ae_lp16f_i_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp16f_i_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp16f_iu_encode_fns[] = {
  Opcode_ae_lp16f_iu_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp16f_iu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp16f_x_encode_fns[] = {
  Opcode_ae_lp16f_x_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp16f_x_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp16f_xu_encode_fns[] = {
  Opcode_ae_lp16f_xu_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp16f_xu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp24_i_encode_fns[] = {
  Opcode_ae_lp24_i_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp24_i_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp24_iu_encode_fns[] = {
  Opcode_ae_lp24_iu_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp24_iu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp24_x_encode_fns[] = {
  Opcode_ae_lp24_x_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp24_x_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp24_xu_encode_fns[] = {
  Opcode_ae_lp24_xu_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp24_xu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp24f_i_encode_fns[] = {
  Opcode_ae_lp24f_i_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp24f_i_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp24f_iu_encode_fns[] = {
  Opcode_ae_lp24f_iu_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp24f_iu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp24f_x_encode_fns[] = {
  Opcode_ae_lp24f_x_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp24f_x_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp24f_xu_encode_fns[] = {
  Opcode_ae_lp24f_xu_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp24f_xu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp16x2f_i_encode_fns[] = {
  Opcode_ae_lp16x2f_i_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp16x2f_i_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp16x2f_iu_encode_fns[] = {
  Opcode_ae_lp16x2f_iu_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp16x2f_iu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp16x2f_x_encode_fns[] = {
  Opcode_ae_lp16x2f_x_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp16x2f_x_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp16x2f_xu_encode_fns[] = {
  Opcode_ae_lp16x2f_xu_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp16x2f_xu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp24x2f_i_encode_fns[] = {
  Opcode_ae_lp24x2f_i_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp24x2f_i_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp24x2f_iu_encode_fns[] = {
  Opcode_ae_lp24x2f_iu_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp24x2f_iu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp24x2f_x_encode_fns[] = {
  Opcode_ae_lp24x2f_x_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp24x2f_x_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp24x2f_xu_encode_fns[] = {
  Opcode_ae_lp24x2f_xu_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp24x2f_xu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp24x2_i_encode_fns[] = {
  Opcode_ae_lp24x2_i_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp24x2_i_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp24x2_iu_encode_fns[] = {
  Opcode_ae_lp24x2_iu_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp24x2_iu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp24x2_x_encode_fns[] = {
  Opcode_ae_lp24x2_x_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp24x2_x_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp24x2_xu_encode_fns[] = {
  Opcode_ae_lp24x2_xu_Slot_inst_encode, 0, 0, 0, Opcode_ae_lp24x2_xu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp16x2f_i_encode_fns[] = {
  Opcode_ae_sp16x2f_i_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp16x2f_i_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp16x2f_iu_encode_fns[] = {
  Opcode_ae_sp16x2f_iu_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp16x2f_iu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp16x2f_x_encode_fns[] = {
  Opcode_ae_sp16x2f_x_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp16x2f_x_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp16x2f_xu_encode_fns[] = {
  Opcode_ae_sp16x2f_xu_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp16x2f_xu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp24x2s_i_encode_fns[] = {
  Opcode_ae_sp24x2s_i_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp24x2s_i_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp24x2s_iu_encode_fns[] = {
  Opcode_ae_sp24x2s_iu_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp24x2s_iu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp24x2s_x_encode_fns[] = {
  Opcode_ae_sp24x2s_x_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp24x2s_x_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp24x2s_xu_encode_fns[] = {
  Opcode_ae_sp24x2s_xu_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp24x2s_xu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp24x2f_i_encode_fns[] = {
  Opcode_ae_sp24x2f_i_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp24x2f_i_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp24x2f_iu_encode_fns[] = {
  Opcode_ae_sp24x2f_iu_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp24x2f_iu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp24x2f_x_encode_fns[] = {
  Opcode_ae_sp24x2f_x_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp24x2f_x_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp24x2f_xu_encode_fns[] = {
  Opcode_ae_sp24x2f_xu_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp24x2f_xu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp16f_l_i_encode_fns[] = {
  Opcode_ae_sp16f_l_i_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp16f_l_i_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp16f_l_iu_encode_fns[] = {
  Opcode_ae_sp16f_l_iu_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp16f_l_iu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp16f_l_x_encode_fns[] = {
  Opcode_ae_sp16f_l_x_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp16f_l_x_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp16f_l_xu_encode_fns[] = {
  Opcode_ae_sp16f_l_xu_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp16f_l_xu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp24s_l_i_encode_fns[] = {
  Opcode_ae_sp24s_l_i_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp24s_l_i_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp24s_l_iu_encode_fns[] = {
  Opcode_ae_sp24s_l_iu_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp24s_l_iu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp24s_l_x_encode_fns[] = {
  Opcode_ae_sp24s_l_x_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp24s_l_x_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp24s_l_xu_encode_fns[] = {
  Opcode_ae_sp24s_l_xu_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp24s_l_xu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp24f_l_i_encode_fns[] = {
  Opcode_ae_sp24f_l_i_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp24f_l_i_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp24f_l_iu_encode_fns[] = {
  Opcode_ae_sp24f_l_iu_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp24f_l_iu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp24f_l_x_encode_fns[] = {
  Opcode_ae_sp24f_l_x_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp24f_l_x_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp24f_l_xu_encode_fns[] = {
  Opcode_ae_sp24f_l_xu_Slot_inst_encode, 0, 0, 0, Opcode_ae_sp24f_l_xu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lq56_i_encode_fns[] = {
  Opcode_ae_lq56_i_Slot_inst_encode, 0, 0, 0, Opcode_ae_lq56_i_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lq56_iu_encode_fns[] = {
  Opcode_ae_lq56_iu_Slot_inst_encode, 0, 0, 0, Opcode_ae_lq56_iu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lq56_x_encode_fns[] = {
  Opcode_ae_lq56_x_Slot_inst_encode, 0, 0, 0, Opcode_ae_lq56_x_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lq56_xu_encode_fns[] = {
  Opcode_ae_lq56_xu_Slot_inst_encode, 0, 0, 0, Opcode_ae_lq56_xu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lq32f_i_encode_fns[] = {
  Opcode_ae_lq32f_i_Slot_inst_encode, 0, 0, 0, Opcode_ae_lq32f_i_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lq32f_iu_encode_fns[] = {
  Opcode_ae_lq32f_iu_Slot_inst_encode, 0, 0, 0, Opcode_ae_lq32f_iu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lq32f_x_encode_fns[] = {
  Opcode_ae_lq32f_x_Slot_inst_encode, 0, 0, 0, Opcode_ae_lq32f_x_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lq32f_xu_encode_fns[] = {
  Opcode_ae_lq32f_xu_Slot_inst_encode, 0, 0, 0, Opcode_ae_lq32f_xu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sq56s_i_encode_fns[] = {
  Opcode_ae_sq56s_i_Slot_inst_encode, 0, 0, 0, Opcode_ae_sq56s_i_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sq56s_iu_encode_fns[] = {
  Opcode_ae_sq56s_iu_Slot_inst_encode, 0, 0, 0, Opcode_ae_sq56s_iu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sq56s_x_encode_fns[] = {
  Opcode_ae_sq56s_x_Slot_inst_encode, 0, 0, 0, Opcode_ae_sq56s_x_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sq56s_xu_encode_fns[] = {
  Opcode_ae_sq56s_xu_Slot_inst_encode, 0, 0, 0, Opcode_ae_sq56s_xu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sq32f_i_encode_fns[] = {
  Opcode_ae_sq32f_i_Slot_inst_encode, 0, 0, 0, Opcode_ae_sq32f_i_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sq32f_iu_encode_fns[] = {
  Opcode_ae_sq32f_iu_Slot_inst_encode, 0, 0, 0, Opcode_ae_sq32f_iu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sq32f_x_encode_fns[] = {
  Opcode_ae_sq32f_x_Slot_inst_encode, 0, 0, 0, Opcode_ae_sq32f_x_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sq32f_xu_encode_fns[] = {
  Opcode_ae_sq32f_xu_Slot_inst_encode, 0, 0, 0, Opcode_ae_sq32f_xu_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_zerop48_encode_fns[] = {
  0, 0, 0, Opcode_ae_zerop48_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_movp48_encode_fns[] = {
  Opcode_ae_movp48_Slot_inst_encode, 0, 0, Opcode_ae_movp48_Slot_ae_slot1_encode, Opcode_ae_movp48_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_selp24_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_selp24_ll_Slot_ae_slot1_encode, Opcode_ae_selp24_ll_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_selp24_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_selp24_lh_Slot_ae_slot1_encode, Opcode_ae_selp24_lh_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_selp24_hl_encode_fns[] = {
  0, 0, 0, Opcode_ae_selp24_hl_Slot_ae_slot1_encode, Opcode_ae_selp24_hl_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_selp24_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_selp24_hh_Slot_ae_slot1_encode, Opcode_ae_selp24_hh_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_movtp24x2_encode_fns[] = {
  0, 0, 0, Opcode_ae_movtp24x2_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_movfp24x2_encode_fns[] = {
  0, 0, 0, Opcode_ae_movfp24x2_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_movtp48_encode_fns[] = {
  0, 0, 0, Opcode_ae_movtp48_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_movfp48_encode_fns[] = {
  0, 0, 0, Opcode_ae_movfp48_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_movpa24x2_encode_fns[] = {
  Opcode_ae_movpa24x2_Slot_inst_encode, 0, 0, 0, Opcode_ae_movpa24x2_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_truncp24a32x2_encode_fns[] = {
  Opcode_ae_truncp24a32x2_Slot_inst_encode, 0, 0, 0, Opcode_ae_truncp24a32x2_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_cvta32p24_l_encode_fns[] = {
  Opcode_ae_cvta32p24_l_Slot_inst_encode, 0, 0, 0, Opcode_ae_cvta32p24_l_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_cvta32p24_h_encode_fns[] = {
  Opcode_ae_cvta32p24_h_Slot_inst_encode, 0, 0, 0, Opcode_ae_cvta32p24_h_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_cvtp24a16x2_ll_encode_fns[] = {
  Opcode_ae_cvtp24a16x2_ll_Slot_inst_encode, 0, 0, 0, Opcode_ae_cvtp24a16x2_ll_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_cvtp24a16x2_lh_encode_fns[] = {
  Opcode_ae_cvtp24a16x2_lh_Slot_inst_encode, 0, 0, 0, Opcode_ae_cvtp24a16x2_lh_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_cvtp24a16x2_hl_encode_fns[] = {
  Opcode_ae_cvtp24a16x2_hl_Slot_inst_encode, 0, 0, 0, Opcode_ae_cvtp24a16x2_hl_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_cvtp24a16x2_hh_encode_fns[] = {
  Opcode_ae_cvtp24a16x2_hh_Slot_inst_encode, 0, 0, 0, Opcode_ae_cvtp24a16x2_hh_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_truncp24q48x2_encode_fns[] = {
  0, 0, 0, Opcode_ae_truncp24q48x2_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_truncp16_encode_fns[] = {
  0, 0, 0, Opcode_ae_truncp16_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_roundsp24q48sym_encode_fns[] = {
  0, 0, 0, Opcode_ae_roundsp24q48sym_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_roundsp24q48asym_encode_fns[] = {
  0, 0, 0, Opcode_ae_roundsp24q48asym_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_roundsp16q48sym_encode_fns[] = {
  0, 0, 0, Opcode_ae_roundsp16q48sym_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_roundsp16q48asym_encode_fns[] = {
  0, 0, 0, Opcode_ae_roundsp16q48asym_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_roundsp16sym_encode_fns[] = {
  0, 0, 0, Opcode_ae_roundsp16sym_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_roundsp16asym_encode_fns[] = {
  0, 0, 0, Opcode_ae_roundsp16asym_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_zeroq56_encode_fns[] = {
  0, 0, 0, Opcode_ae_zeroq56_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_movq56_encode_fns[] = {
  Opcode_ae_movq56_Slot_inst_encode, 0, 0, Opcode_ae_movq56_Slot_ae_slot1_encode, Opcode_ae_movq56_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_movtq56_encode_fns[] = {
  Opcode_ae_movtq56_Slot_inst_encode, 0, 0, 0, Opcode_ae_movtq56_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_movfq56_encode_fns[] = {
  Opcode_ae_movfq56_Slot_inst_encode, 0, 0, 0, Opcode_ae_movfq56_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_cvtq48a32s_encode_fns[] = {
  Opcode_ae_cvtq48a32s_Slot_inst_encode, 0, 0, 0, Opcode_ae_cvtq48a32s_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_cvtq48p24s_l_encode_fns[] = {
  0, 0, 0, Opcode_ae_cvtq48p24s_l_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_cvtq48p24s_h_encode_fns[] = {
  0, 0, 0, Opcode_ae_cvtq48p24s_h_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_satq48s_encode_fns[] = {
  0, 0, 0, Opcode_ae_satq48s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_truncq32_encode_fns[] = {
  0, 0, 0, Opcode_ae_truncq32_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_roundsq32sym_encode_fns[] = {
  0, 0, 0, Opcode_ae_roundsq32sym_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_roundsq32asym_encode_fns[] = {
  0, 0, 0, Opcode_ae_roundsq32asym_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_trunca32q48_encode_fns[] = {
  Opcode_ae_trunca32q48_Slot_inst_encode, 0, 0, 0, Opcode_ae_trunca32q48_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_movap24s_l_encode_fns[] = {
  Opcode_ae_movap24s_l_Slot_inst_encode, 0, 0, 0, Opcode_ae_movap24s_l_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_movap24s_h_encode_fns[] = {
  Opcode_ae_movap24s_h_Slot_inst_encode, 0, 0, 0, Opcode_ae_movap24s_h_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_trunca16p24s_l_encode_fns[] = {
  Opcode_ae_trunca16p24s_l_Slot_inst_encode, 0, 0, 0, Opcode_ae_trunca16p24s_l_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_trunca16p24s_h_encode_fns[] = {
  Opcode_ae_trunca16p24s_h_Slot_inst_encode, 0, 0, 0, Opcode_ae_trunca16p24s_h_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_addp24_encode_fns[] = {
  0, 0, 0, Opcode_ae_addp24_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_subp24_encode_fns[] = {
  0, 0, 0, Opcode_ae_subp24_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_negp24_encode_fns[] = {
  0, 0, 0, Opcode_ae_negp24_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_absp24_encode_fns[] = {
  0, 0, 0, Opcode_ae_absp24_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_maxp24s_encode_fns[] = {
  0, 0, 0, Opcode_ae_maxp24s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_minp24s_encode_fns[] = {
  0, 0, 0, Opcode_ae_minp24s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_maxbp24s_encode_fns[] = {
  0, 0, 0, Opcode_ae_maxbp24s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_minbp24s_encode_fns[] = {
  0, 0, 0, Opcode_ae_minbp24s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_addsp24s_encode_fns[] = {
  0, 0, 0, Opcode_ae_addsp24s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_subsp24s_encode_fns[] = {
  0, 0, 0, Opcode_ae_subsp24s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_negsp24s_encode_fns[] = {
  0, 0, 0, Opcode_ae_negsp24s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_abssp24s_encode_fns[] = {
  0, 0, 0, Opcode_ae_abssp24s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_andp48_encode_fns[] = {
  0, 0, 0, Opcode_ae_andp48_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_nandp48_encode_fns[] = {
  0, 0, 0, Opcode_ae_nandp48_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_orp48_encode_fns[] = {
  0, 0, 0, Opcode_ae_orp48_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_xorp48_encode_fns[] = {
  0, 0, 0, Opcode_ae_xorp48_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_ltp24s_encode_fns[] = {
  0, 0, 0, Opcode_ae_ltp24s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_lep24s_encode_fns[] = {
  0, 0, 0, Opcode_ae_lep24s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_eqp24_encode_fns[] = {
  0, 0, 0, Opcode_ae_eqp24_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_addq56_encode_fns[] = {
  0, 0, 0, Opcode_ae_addq56_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_subq56_encode_fns[] = {
  0, 0, 0, Opcode_ae_subq56_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_negq56_encode_fns[] = {
  0, 0, 0, Opcode_ae_negq56_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_absq56_encode_fns[] = {
  0, 0, 0, Opcode_ae_absq56_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_maxq56s_encode_fns[] = {
  0, 0, 0, Opcode_ae_maxq56s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_minq56s_encode_fns[] = {
  0, 0, 0, Opcode_ae_minq56s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_maxbq56s_encode_fns[] = {
  0, 0, 0, Opcode_ae_maxbq56s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_minbq56s_encode_fns[] = {
  0, 0, 0, Opcode_ae_minbq56s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_addsq56s_encode_fns[] = {
  0, 0, 0, Opcode_ae_addsq56s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_subsq56s_encode_fns[] = {
  0, 0, 0, Opcode_ae_subsq56s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_negsq56s_encode_fns[] = {
  0, 0, 0, Opcode_ae_negsq56s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_abssq56s_encode_fns[] = {
  0, 0, 0, Opcode_ae_abssq56s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_andq56_encode_fns[] = {
  0, 0, 0, Opcode_ae_andq56_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_nandq56_encode_fns[] = {
  0, 0, 0, Opcode_ae_nandq56_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_orq56_encode_fns[] = {
  0, 0, 0, Opcode_ae_orq56_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_xorq56_encode_fns[] = {
  0, 0, 0, Opcode_ae_xorq56_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_sllip24_encode_fns[] = {
  0, 0, 0, Opcode_ae_sllip24_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_srlip24_encode_fns[] = {
  0, 0, 0, Opcode_ae_srlip24_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_sraip24_encode_fns[] = {
  0, 0, 0, Opcode_ae_sraip24_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_sllsp24_encode_fns[] = {
  0, 0, 0, Opcode_ae_sllsp24_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_srlsp24_encode_fns[] = {
  0, 0, 0, Opcode_ae_srlsp24_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_srasp24_encode_fns[] = {
  0, 0, 0, Opcode_ae_srasp24_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_sllisp24s_encode_fns[] = {
  0, 0, 0, Opcode_ae_sllisp24s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_sllssp24s_encode_fns[] = {
  0, 0, 0, Opcode_ae_sllssp24s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_slliq56_encode_fns[] = {
  Opcode_ae_slliq56_Slot_inst_encode, 0, 0, 0, Opcode_ae_slliq56_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_srliq56_encode_fns[] = {
  Opcode_ae_srliq56_Slot_inst_encode, 0, 0, 0, Opcode_ae_srliq56_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sraiq56_encode_fns[] = {
  Opcode_ae_sraiq56_Slot_inst_encode, 0, 0, 0, Opcode_ae_sraiq56_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sllsq56_encode_fns[] = {
  Opcode_ae_sllsq56_Slot_inst_encode, 0, 0, 0, Opcode_ae_sllsq56_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_srlsq56_encode_fns[] = {
  Opcode_ae_srlsq56_Slot_inst_encode, 0, 0, 0, Opcode_ae_srlsq56_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_srasq56_encode_fns[] = {
  Opcode_ae_srasq56_Slot_inst_encode, 0, 0, 0, Opcode_ae_srasq56_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sllaq56_encode_fns[] = {
  Opcode_ae_sllaq56_Slot_inst_encode, 0, 0, 0, Opcode_ae_sllaq56_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_srlaq56_encode_fns[] = {
  Opcode_ae_srlaq56_Slot_inst_encode, 0, 0, 0, Opcode_ae_srlaq56_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sraaq56_encode_fns[] = {
  Opcode_ae_sraaq56_Slot_inst_encode, 0, 0, 0, Opcode_ae_sraaq56_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sllisq56s_encode_fns[] = {
  Opcode_ae_sllisq56s_Slot_inst_encode, 0, 0, 0, Opcode_ae_sllisq56s_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sllssq56s_encode_fns[] = {
  Opcode_ae_sllssq56s_Slot_inst_encode, 0, 0, 0, Opcode_ae_sllssq56s_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sllasq56s_encode_fns[] = {
  Opcode_ae_sllasq56s_Slot_inst_encode, 0, 0, 0, Opcode_ae_sllasq56s_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_ltq56s_encode_fns[] = {
  0, 0, 0, Opcode_ae_ltq56s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_leq56s_encode_fns[] = {
  0, 0, 0, Opcode_ae_leq56s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_eqq56_encode_fns[] = {
  0, 0, 0, Opcode_ae_eqq56_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_nsaq56s_encode_fns[] = {
  Opcode_ae_nsaq56s_Slot_inst_encode, 0, 0, 0, Opcode_ae_nsaq56s_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_mulsrfq32sp24s_h_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsrfq32sp24s_h_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsrfq32sp24s_l_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsrfq32sp24s_l_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mularfq32sp24s_h_encode_fns[] = {
  0, 0, 0, Opcode_ae_mularfq32sp24s_h_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mularfq32sp24s_l_encode_fns[] = {
  0, 0, 0, Opcode_ae_mularfq32sp24s_l_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulrfq32sp24s_h_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulrfq32sp24s_h_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulrfq32sp24s_l_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulrfq32sp24s_l_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsfq32sp24s_h_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsfq32sp24s_h_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsfq32sp24s_l_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsfq32sp24s_l_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulafq32sp24s_h_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulafq32sp24s_h_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulafq32sp24s_l_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulafq32sp24s_l_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulfq32sp24s_h_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulfq32sp24s_h_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulfq32sp24s_l_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulfq32sp24s_l_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulfs32p16s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulfs32p16s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulfp24s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulfp24s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulp24s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulp24s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulfs32p16s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulfs32p16s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulfp24s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulfp24s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulp24s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulp24s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulfs32p16s_hl_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulfs32p16s_hl_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulfp24s_hl_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulfp24s_hl_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulp24s_hl_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulp24s_hl_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulfs32p16s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulfs32p16s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulfp24s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulfp24s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulp24s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulp24s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulafs32p16s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulafs32p16s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulafp24s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulafp24s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulap24s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulap24s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulafs32p16s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulafs32p16s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulafp24s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulafp24s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulap24s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulap24s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulafs32p16s_hl_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulafs32p16s_hl_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulafp24s_hl_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulafp24s_hl_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulap24s_hl_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulap24s_hl_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulafs32p16s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulafs32p16s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulafp24s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulafp24s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulap24s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulap24s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsfs32p16s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsfs32p16s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsfp24s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsfp24s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsp24s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsp24s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsfs32p16s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsfs32p16s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsfp24s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsfp24s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsp24s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsp24s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsfs32p16s_hl_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsfs32p16s_hl_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsfp24s_hl_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsfp24s_hl_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsp24s_hl_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsp24s_hl_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsfs32p16s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsfs32p16s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsfp24s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsfp24s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsp24s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsp24s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulafs56p24s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulafs56p24s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulas56p24s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulas56p24s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulafs56p24s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulafs56p24s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulas56p24s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulas56p24s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulafs56p24s_hl_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulafs56p24s_hl_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulas56p24s_hl_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulas56p24s_hl_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulafs56p24s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulafs56p24s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulas56p24s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulas56p24s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsfs56p24s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsfs56p24s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulss56p24s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulss56p24s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsfs56p24s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsfs56p24s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulss56p24s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulss56p24s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsfs56p24s_hl_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsfs56p24s_hl_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulss56p24s_hl_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulss56p24s_hl_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsfs56p24s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsfs56p24s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulss56p24s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulss56p24s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulfq32sp16s_l_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulfq32sp16s_l_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulfq32sp16s_h_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulfq32sp16s_h_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulfq32sp16u_l_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulfq32sp16u_l_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulfq32sp16u_h_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulfq32sp16u_h_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulq32sp16s_l_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulq32sp16s_l_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulq32sp16s_h_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulq32sp16s_h_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulq32sp16u_l_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulq32sp16u_l_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulq32sp16u_h_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulq32sp16u_h_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulafq32sp16s_l_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulafq32sp16s_l_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulafq32sp16s_h_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulafq32sp16s_h_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulafq32sp16u_l_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulafq32sp16u_l_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulafq32sp16u_h_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulafq32sp16u_h_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulaq32sp16s_l_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulaq32sp16s_l_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulaq32sp16s_h_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulaq32sp16s_h_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulaq32sp16u_l_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulaq32sp16u_l_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulaq32sp16u_h_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulaq32sp16u_h_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsfq32sp16s_l_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsfq32sp16s_l_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsfq32sp16s_h_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsfq32sp16s_h_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsfq32sp16u_l_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsfq32sp16u_l_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsfq32sp16u_h_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsfq32sp16u_h_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsq32sp16s_l_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsq32sp16s_l_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsq32sp16s_h_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsq32sp16s_h_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsq32sp16u_l_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsq32sp16u_l_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsq32sp16u_h_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsq32sp16u_h_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzaaq32sp16s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzaaq32sp16s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzaafq32sp16s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzaafq32sp16s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzaaq32sp16u_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzaaq32sp16u_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzaafq32sp16u_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzaafq32sp16u_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzaaq32sp16s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzaaq32sp16s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzaafq32sp16s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzaafq32sp16s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzaaq32sp16u_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzaaq32sp16u_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzaafq32sp16u_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzaafq32sp16u_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzaaq32sp16s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzaaq32sp16s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzaafq32sp16s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzaafq32sp16s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzaaq32sp16u_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzaaq32sp16u_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzaafq32sp16u_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzaafq32sp16u_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzasq32sp16s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzasq32sp16s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzasfq32sp16s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzasfq32sp16s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzasq32sp16u_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzasq32sp16u_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzasfq32sp16u_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzasfq32sp16u_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzasq32sp16s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzasq32sp16s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzasfq32sp16s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzasfq32sp16s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzasq32sp16u_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzasq32sp16u_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzasfq32sp16u_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzasfq32sp16u_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzasq32sp16s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzasq32sp16s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzasfq32sp16s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzasfq32sp16s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzasq32sp16u_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzasq32sp16u_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzasfq32sp16u_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzasfq32sp16u_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzsaq32sp16s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzsaq32sp16s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzsafq32sp16s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzsafq32sp16s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzsaq32sp16u_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzsaq32sp16u_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzsafq32sp16u_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzsafq32sp16u_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzsaq32sp16s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzsaq32sp16s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzsafq32sp16s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzsafq32sp16s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzsaq32sp16u_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzsaq32sp16u_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzsafq32sp16u_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzsafq32sp16u_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzsaq32sp16s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzsaq32sp16s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzsafq32sp16s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzsafq32sp16s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzsaq32sp16u_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzsaq32sp16u_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzsafq32sp16u_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzsafq32sp16u_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzssq32sp16s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzssq32sp16s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzssfq32sp16s_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzssfq32sp16s_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzssq32sp16u_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzssq32sp16u_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzssfq32sp16u_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzssfq32sp16u_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzssq32sp16s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzssq32sp16s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzssfq32sp16s_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzssfq32sp16s_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzssq32sp16u_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzssq32sp16u_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzssfq32sp16u_hh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzssfq32sp16u_hh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzssq32sp16s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzssq32sp16s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzssfq32sp16s_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzssfq32sp16s_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzssq32sp16u_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzssq32sp16u_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzssfq32sp16u_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzssfq32sp16u_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzaafp24s_hh_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzaafp24s_hh_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzaap24s_hh_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzaap24s_hh_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzaafp24s_hl_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzaafp24s_hl_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzaap24s_hl_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzaap24s_hl_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzasfp24s_hh_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzasfp24s_hh_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzasp24s_hh_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzasp24s_hh_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzasfp24s_hl_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzasfp24s_hl_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzasp24s_hl_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzasp24s_hl_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzsafp24s_hh_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzsafp24s_hh_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzsap24s_hh_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzsap24s_hh_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzsafp24s_hl_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzsafp24s_hl_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzsap24s_hl_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzsap24s_hl_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzssfp24s_hh_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzssfp24s_hh_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzssp24s_hh_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzssp24s_hh_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzssfp24s_hl_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzssfp24s_hl_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulzssp24s_hl_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulzssp24s_hl_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulaafp24s_hh_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulaafp24s_hh_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulaap24s_hh_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulaap24s_hh_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulaafp24s_hl_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulaafp24s_hl_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulaap24s_hl_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulaap24s_hl_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulasfp24s_hh_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulasfp24s_hh_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulasp24s_hh_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulasp24s_hh_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulasfp24s_hl_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulasfp24s_hl_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulasp24s_hl_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulasp24s_hl_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsafp24s_hh_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsafp24s_hh_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsap24s_hh_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsap24s_hh_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsafp24s_hl_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsafp24s_hl_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulsap24s_hl_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulsap24s_hl_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulssfp24s_hh_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulssfp24s_hh_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulssp24s_hh_ll_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulssp24s_hh_ll_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulssfp24s_hl_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulssfp24s_hl_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_mulssp24s_hl_lh_encode_fns[] = {
  0, 0, 0, Opcode_ae_mulssp24s_hl_lh_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_sha32_encode_fns[] = {
  Opcode_ae_sha32_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_vldl32t_encode_fns[] = {
  Opcode_ae_vldl32t_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_vldl16t_encode_fns[] = {
  Opcode_ae_vldl16t_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_vldl16c_encode_fns[] = {
  Opcode_ae_vldl16c_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_vldsht_encode_fns[] = {
  Opcode_ae_vldsht_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_lb_encode_fns[] = {
  Opcode_ae_lb_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_lbi_encode_fns[] = {
  Opcode_ae_lbi_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_lbk_encode_fns[] = {
  Opcode_ae_lbk_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_lbki_encode_fns[] = {
  Opcode_ae_lbki_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_db_encode_fns[] = {
  Opcode_ae_db_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_dbi_encode_fns[] = {
  Opcode_ae_dbi_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_vlel32t_encode_fns[] = {
  Opcode_ae_vlel32t_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_vlel16t_encode_fns[] = {
  Opcode_ae_vlel16t_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_sb_encode_fns[] = {
  Opcode_ae_sb_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_sbi_encode_fns[] = {
  Opcode_ae_sbi_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_vles16c_encode_fns[] = {
  Opcode_ae_vles16c_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_sbf_encode_fns[] = {
  Opcode_ae_sbf_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_slaasq56s_encode_fns[] = {
  0, 0, 0, 0, Opcode_ae_slaasq56s_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_addbrba32_encode_fns[] = {
  0, 0, 0, 0, Opcode_ae_addbrba32_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_minabssp24s_encode_fns[] = {
  0, 0, 0, Opcode_ae_minabssp24s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_maxabssp24s_encode_fns[] = {
  0, 0, 0, Opcode_ae_maxabssp24s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_minabssq56s_encode_fns[] = {
  0, 0, 0, Opcode_ae_minabssq56s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_ae_maxabssq56s_encode_fns[] = {
  0, 0, 0, Opcode_ae_maxabssq56s_Slot_ae_slot1_encode, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_cbegin0_encode_fns[] = {
  Opcode_rur_ae_cbegin0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_cbegin0_encode_fns[] = {
  Opcode_wur_ae_cbegin0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_cend0_encode_fns[] = {
  Opcode_rur_ae_cend0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_cend0_encode_fns[] = {
  Opcode_wur_ae_cend0_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_lp24x2_c_encode_fns[] = {
  0, 0, 0, 0, Opcode_ae_lp24x2_c_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp24x2s_c_encode_fns[] = {
  0, 0, 0, 0, Opcode_ae_sp24x2s_c_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp24x2f_c_encode_fns[] = {
  0, 0, 0, 0, Opcode_ae_lp24x2f_c_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp24x2f_c_encode_fns[] = {
  0, 0, 0, 0, Opcode_ae_sp24x2f_c_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp16x2f_c_encode_fns[] = {
  0, 0, 0, 0, Opcode_ae_lp16x2f_c_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp16x2f_c_encode_fns[] = {
  0, 0, 0, 0, Opcode_ae_sp16x2f_c_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp24_c_encode_fns[] = {
  0, 0, 0, 0, Opcode_ae_lp24_c_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp24s_l_c_encode_fns[] = {
  0, 0, 0, 0, Opcode_ae_sp24s_l_c_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp24f_c_encode_fns[] = {
  0, 0, 0, 0, Opcode_ae_lp24f_c_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp24f_l_c_encode_fns[] = {
  0, 0, 0, 0, Opcode_ae_sp24f_l_c_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lp16f_c_encode_fns[] = {
  0, 0, 0, 0, Opcode_ae_lp16f_c_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sp16f_l_c_encode_fns[] = {
  0, 0, 0, 0, Opcode_ae_sp16f_l_c_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lq56_c_encode_fns[] = {
  0, 0, 0, 0, Opcode_ae_lq56_c_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sq56s_c_encode_fns[] = {
  0, 0, 0, 0, Opcode_ae_sq56s_c_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_lq32f_c_encode_fns[] = {
  0, 0, 0, 0, Opcode_ae_lq32f_c_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_ae_sq32f_c_encode_fns[] = {
  0, 0, 0, 0, Opcode_ae_sq32f_c_Slot_ae_slot0_encode
};

static xtensa_opcode_encode_fn Opcode_rur_expstate_encode_fns[] = {
  Opcode_rur_expstate_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_expstate_encode_fns[] = {
  Opcode_wur_expstate_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_read_impwire_encode_fns[] = {
  Opcode_read_impwire_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_setb_expstate_encode_fns[] = {
  Opcode_setb_expstate_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_clrb_expstate_encode_fns[] = {
  Opcode_clrb_expstate_Slot_inst_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wrmsk_expstate_encode_fns[] = {
  Opcode_wrmsk_expstate_Slot_inst_encode, 0, 0, 0, 0
};





/* Opcode table.  */

static xtensa_funcUnit_use Opcode_ae_vldl32t_funcUnit_uses[] = {
  { FUNCUNIT_ae_add32, 3 }
};

static xtensa_funcUnit_use Opcode_ae_vldl16t_funcUnit_uses[] = {
  { FUNCUNIT_ae_add32, 3 }
};

static xtensa_funcUnit_use Opcode_ae_vldl16c_funcUnit_uses[] = {
  { FUNCUNIT_ae_shift32x4, 2 },
  { FUNCUNIT_ae_shift32x5, 3 },
  { FUNCUNIT_ae_add32, 3 }
};

static xtensa_funcUnit_use Opcode_ae_vldsht_funcUnit_uses[] = {
  { FUNCUNIT_ae_shift32x4, 2 },
  { FUNCUNIT_ae_shift32x5, 3 },
  { FUNCUNIT_ae_add32, 3 }
};

static xtensa_funcUnit_use Opcode_ae_lb_funcUnit_uses[] = {
  { FUNCUNIT_ae_subshift, 2 }
};

static xtensa_funcUnit_use Opcode_ae_lbi_funcUnit_uses[] = {
  { FUNCUNIT_ae_subshift, 2 }
};

static xtensa_funcUnit_use Opcode_ae_lbk_funcUnit_uses[] = {
  { FUNCUNIT_ae_subshift, 2 }
};

static xtensa_funcUnit_use Opcode_ae_lbki_funcUnit_uses[] = {
  { FUNCUNIT_ae_subshift, 2 }
};

static xtensa_funcUnit_use Opcode_ae_db_funcUnit_uses[] = {
  { FUNCUNIT_ae_shift32x4, 2 },
  { FUNCUNIT_ae_subshift, 2 }
};

static xtensa_funcUnit_use Opcode_ae_dbi_funcUnit_uses[] = {
  { FUNCUNIT_ae_shift32x4, 2 },
  { FUNCUNIT_ae_subshift, 2 }
};

static xtensa_funcUnit_use Opcode_ae_vlel32t_funcUnit_uses[] = {
  { FUNCUNIT_ae_add32, 3 }
};

static xtensa_funcUnit_use Opcode_ae_vlel16t_funcUnit_uses[] = {
  { FUNCUNIT_ae_add32, 3 }
};

static xtensa_funcUnit_use Opcode_ae_sb_funcUnit_uses[] = {
  { FUNCUNIT_ae_shift32x4, 2 },
  { FUNCUNIT_ae_subshift, 2 }
};

static xtensa_funcUnit_use Opcode_ae_sbi_funcUnit_uses[] = {
  { FUNCUNIT_ae_shift32x4, 2 },
  { FUNCUNIT_ae_subshift, 2 }
};

static xtensa_funcUnit_use Opcode_ae_vles16c_funcUnit_uses[] = {
  { FUNCUNIT_ae_shift32x4, 2 },
  { FUNCUNIT_ae_subshift, 2 }
};

static xtensa_funcUnit_use Opcode_ae_sbf_funcUnit_uses[] = {
  { FUNCUNIT_ae_shift32x4, 2 },
  { FUNCUNIT_ae_subshift, 2 }
};

static xtensa_opcode_internal opcodes[] = {
  { "excw", ICLASS_xt_iclass_excw,
    0,
    Opcode_excw_encode_fns, 0, 0 },
  { "rfe", ICLASS_xt_iclass_rfe,
    XTENSA_OPCODE_IS_JUMP,
    Opcode_rfe_encode_fns, 0, 0 },
  { "rfde", ICLASS_xt_iclass_rfde,
    XTENSA_OPCODE_IS_JUMP,
    Opcode_rfde_encode_fns, 0, 0 },
  { "syscall", ICLASS_xt_iclass_syscall,
    0,
    Opcode_syscall_encode_fns, 0, 0 },
  { "call12", ICLASS_xt_iclass_call12,
    XTENSA_OPCODE_IS_CALL,
    Opcode_call12_encode_fns, 0, 0 },
  { "call8", ICLASS_xt_iclass_call8,
    XTENSA_OPCODE_IS_CALL,
    Opcode_call8_encode_fns, 0, 0 },
  { "call4", ICLASS_xt_iclass_call4,
    XTENSA_OPCODE_IS_CALL,
    Opcode_call4_encode_fns, 0, 0 },
  { "callx12", ICLASS_xt_iclass_callx12,
    XTENSA_OPCODE_IS_CALL,
    Opcode_callx12_encode_fns, 0, 0 },
  { "callx8", ICLASS_xt_iclass_callx8,
    XTENSA_OPCODE_IS_CALL,
    Opcode_callx8_encode_fns, 0, 0 },
  { "callx4", ICLASS_xt_iclass_callx4,
    XTENSA_OPCODE_IS_CALL,
    Opcode_callx4_encode_fns, 0, 0 },
  { "entry", ICLASS_xt_iclass_entry,
    0,
    Opcode_entry_encode_fns, 0, 0 },
  { "movsp", ICLASS_xt_iclass_movsp,
    0,
    Opcode_movsp_encode_fns, 0, 0 },
  { "rotw", ICLASS_xt_iclass_rotw,
    0,
    Opcode_rotw_encode_fns, 0, 0 },
  { "retw", ICLASS_xt_iclass_retw,
    XTENSA_OPCODE_IS_JUMP,
    Opcode_retw_encode_fns, 0, 0 },
  { "retw.n", ICLASS_xt_iclass_retw,
    XTENSA_OPCODE_IS_JUMP,
    Opcode_retw_n_encode_fns, 0, 0 },
  { "rfwo", ICLASS_xt_iclass_rfwou,
    XTENSA_OPCODE_IS_JUMP,
    Opcode_rfwo_encode_fns, 0, 0 },
  { "rfwu", ICLASS_xt_iclass_rfwou,
    XTENSA_OPCODE_IS_JUMP,
    Opcode_rfwu_encode_fns, 0, 0 },
  { "l32e", ICLASS_xt_iclass_l32e,
    0,
    Opcode_l32e_encode_fns, 0, 0 },
  { "s32e", ICLASS_xt_iclass_s32e,
    0,
    Opcode_s32e_encode_fns, 0, 0 },
  { "rsr.windowbase", ICLASS_xt_iclass_rsr_windowbase,
    0,
    Opcode_rsr_windowbase_encode_fns, 0, 0 },
  { "wsr.windowbase", ICLASS_xt_iclass_wsr_windowbase,
    0,
    Opcode_wsr_windowbase_encode_fns, 0, 0 },
  { "xsr.windowbase", ICLASS_xt_iclass_xsr_windowbase,
    0,
    Opcode_xsr_windowbase_encode_fns, 0, 0 },
  { "rsr.windowstart", ICLASS_xt_iclass_rsr_windowstart,
    0,
    Opcode_rsr_windowstart_encode_fns, 0, 0 },
  { "wsr.windowstart", ICLASS_xt_iclass_wsr_windowstart,
    0,
    Opcode_wsr_windowstart_encode_fns, 0, 0 },
  { "xsr.windowstart", ICLASS_xt_iclass_xsr_windowstart,
    0,
    Opcode_xsr_windowstart_encode_fns, 0, 0 },
  { "add.n", ICLASS_xt_iclass_add_n,
    0,
    Opcode_add_n_encode_fns, 0, 0 },
  { "addi.n", ICLASS_xt_iclass_addi_n,
    0,
    Opcode_addi_n_encode_fns, 0, 0 },
  { "beqz.n", ICLASS_xt_iclass_bz6,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_beqz_n_encode_fns, 0, 0 },
  { "bnez.n", ICLASS_xt_iclass_bz6,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bnez_n_encode_fns, 0, 0 },
  { "ill.n", ICLASS_xt_iclass_ill_n,
    0,
    Opcode_ill_n_encode_fns, 0, 0 },
  { "l32i.n", ICLASS_xt_iclass_loadi4,
    0,
    Opcode_l32i_n_encode_fns, 0, 0 },
  { "mov.n", ICLASS_xt_iclass_mov_n,
    0,
    Opcode_mov_n_encode_fns, 0, 0 },
  { "movi.n", ICLASS_xt_iclass_movi_n,
    0,
    Opcode_movi_n_encode_fns, 0, 0 },
  { "nop.n", ICLASS_xt_iclass_nopn,
    0,
    Opcode_nop_n_encode_fns, 0, 0 },
  { "ret.n", ICLASS_xt_iclass_retn,
    XTENSA_OPCODE_IS_JUMP,
    Opcode_ret_n_encode_fns, 0, 0 },
  { "s32i.n", ICLASS_xt_iclass_storei4,
    0,
    Opcode_s32i_n_encode_fns, 0, 0 },
  { "rur.threadptr", ICLASS_rur_threadptr,
    0,
    Opcode_rur_threadptr_encode_fns, 0, 0 },
  { "wur.threadptr", ICLASS_wur_threadptr,
    0,
    Opcode_wur_threadptr_encode_fns, 0, 0 },
  { "addi", ICLASS_xt_iclass_addi,
    0,
    Opcode_addi_encode_fns, 0, 0 },
  { "addmi", ICLASS_xt_iclass_addmi,
    0,
    Opcode_addmi_encode_fns, 0, 0 },
  { "add", ICLASS_xt_iclass_addsub,
    0,
    Opcode_add_encode_fns, 0, 0 },
  { "sub", ICLASS_xt_iclass_addsub,
    0,
    Opcode_sub_encode_fns, 0, 0 },
  { "addx2", ICLASS_xt_iclass_addsub,
    0,
    Opcode_addx2_encode_fns, 0, 0 },
  { "addx4", ICLASS_xt_iclass_addsub,
    0,
    Opcode_addx4_encode_fns, 0, 0 },
  { "addx8", ICLASS_xt_iclass_addsub,
    0,
    Opcode_addx8_encode_fns, 0, 0 },
  { "subx2", ICLASS_xt_iclass_addsub,
    0,
    Opcode_subx2_encode_fns, 0, 0 },
  { "subx4", ICLASS_xt_iclass_addsub,
    0,
    Opcode_subx4_encode_fns, 0, 0 },
  { "subx8", ICLASS_xt_iclass_addsub,
    0,
    Opcode_subx8_encode_fns, 0, 0 },
  { "and", ICLASS_xt_iclass_bit,
    0,
    Opcode_and_encode_fns, 0, 0 },
  { "or", ICLASS_xt_iclass_bit,
    0,
    Opcode_or_encode_fns, 0, 0 },
  { "xor", ICLASS_xt_iclass_bit,
    0,
    Opcode_xor_encode_fns, 0, 0 },
  { "beqi", ICLASS_xt_iclass_bsi8,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_beqi_encode_fns, 0, 0 },
  { "bnei", ICLASS_xt_iclass_bsi8,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bnei_encode_fns, 0, 0 },
  { "bgei", ICLASS_xt_iclass_bsi8,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bgei_encode_fns, 0, 0 },
  { "blti", ICLASS_xt_iclass_bsi8,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_blti_encode_fns, 0, 0 },
  { "bbci", ICLASS_xt_iclass_bsi8b,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bbci_encode_fns, 0, 0 },
  { "bbsi", ICLASS_xt_iclass_bsi8b,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bbsi_encode_fns, 0, 0 },
  { "bgeui", ICLASS_xt_iclass_bsi8u,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bgeui_encode_fns, 0, 0 },
  { "bltui", ICLASS_xt_iclass_bsi8u,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bltui_encode_fns, 0, 0 },
  { "beq", ICLASS_xt_iclass_bst8,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_beq_encode_fns, 0, 0 },
  { "bne", ICLASS_xt_iclass_bst8,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bne_encode_fns, 0, 0 },
  { "bge", ICLASS_xt_iclass_bst8,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bge_encode_fns, 0, 0 },
  { "blt", ICLASS_xt_iclass_bst8,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_blt_encode_fns, 0, 0 },
  { "bgeu", ICLASS_xt_iclass_bst8,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bgeu_encode_fns, 0, 0 },
  { "bltu", ICLASS_xt_iclass_bst8,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bltu_encode_fns, 0, 0 },
  { "bany", ICLASS_xt_iclass_bst8,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bany_encode_fns, 0, 0 },
  { "bnone", ICLASS_xt_iclass_bst8,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bnone_encode_fns, 0, 0 },
  { "ball", ICLASS_xt_iclass_bst8,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_ball_encode_fns, 0, 0 },
  { "bnall", ICLASS_xt_iclass_bst8,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bnall_encode_fns, 0, 0 },
  { "bbc", ICLASS_xt_iclass_bst8,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bbc_encode_fns, 0, 0 },
  { "bbs", ICLASS_xt_iclass_bst8,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bbs_encode_fns, 0, 0 },
  { "beqz", ICLASS_xt_iclass_bsz12,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_beqz_encode_fns, 0, 0 },
  { "bnez", ICLASS_xt_iclass_bsz12,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bnez_encode_fns, 0, 0 },
  { "bgez", ICLASS_xt_iclass_bsz12,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bgez_encode_fns, 0, 0 },
  { "bltz", ICLASS_xt_iclass_bsz12,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bltz_encode_fns, 0, 0 },
  { "call0", ICLASS_xt_iclass_call0,
    XTENSA_OPCODE_IS_CALL,
    Opcode_call0_encode_fns, 0, 0 },
  { "callx0", ICLASS_xt_iclass_callx0,
    XTENSA_OPCODE_IS_CALL,
    Opcode_callx0_encode_fns, 0, 0 },
  { "extui", ICLASS_xt_iclass_exti,
    0,
    Opcode_extui_encode_fns, 0, 0 },
  { "ill", ICLASS_xt_iclass_ill,
    0,
    Opcode_ill_encode_fns, 0, 0 },
  { "j", ICLASS_xt_iclass_jump,
    XTENSA_OPCODE_IS_JUMP,
    Opcode_j_encode_fns, 0, 0 },
  { "jx", ICLASS_xt_iclass_jumpx,
    XTENSA_OPCODE_IS_JUMP,
    Opcode_jx_encode_fns, 0, 0 },
  { "l16ui", ICLASS_xt_iclass_l16ui,
    0,
    Opcode_l16ui_encode_fns, 0, 0 },
  { "l16si", ICLASS_xt_iclass_l16si,
    0,
    Opcode_l16si_encode_fns, 0, 0 },
  { "l32i", ICLASS_xt_iclass_l32i,
    0,
    Opcode_l32i_encode_fns, 0, 0 },
  { "l32r", ICLASS_xt_iclass_l32r,
    0,
    Opcode_l32r_encode_fns, 0, 0 },
  { "l8ui", ICLASS_xt_iclass_l8i,
    0,
    Opcode_l8ui_encode_fns, 0, 0 },
  { "loop", ICLASS_xt_iclass_loop,
    XTENSA_OPCODE_IS_LOOP,
    Opcode_loop_encode_fns, 0, 0 },
  { "loopnez", ICLASS_xt_iclass_loopz,
    XTENSA_OPCODE_IS_LOOP,
    Opcode_loopnez_encode_fns, 0, 0 },
  { "loopgtz", ICLASS_xt_iclass_loopz,
    XTENSA_OPCODE_IS_LOOP,
    Opcode_loopgtz_encode_fns, 0, 0 },
  { "movi", ICLASS_xt_iclass_movi,
    0,
    Opcode_movi_encode_fns, 0, 0 },
  { "moveqz", ICLASS_xt_iclass_movz,
    0,
    Opcode_moveqz_encode_fns, 0, 0 },
  { "movnez", ICLASS_xt_iclass_movz,
    0,
    Opcode_movnez_encode_fns, 0, 0 },
  { "movltz", ICLASS_xt_iclass_movz,
    0,
    Opcode_movltz_encode_fns, 0, 0 },
  { "movgez", ICLASS_xt_iclass_movz,
    0,
    Opcode_movgez_encode_fns, 0, 0 },
  { "neg", ICLASS_xt_iclass_neg,
    0,
    Opcode_neg_encode_fns, 0, 0 },
  { "abs", ICLASS_xt_iclass_neg,
    0,
    Opcode_abs_encode_fns, 0, 0 },
  { "nop", ICLASS_xt_iclass_nop,
    0,
    Opcode_nop_encode_fns, 0, 0 },
  { "ret", ICLASS_xt_iclass_return,
    XTENSA_OPCODE_IS_JUMP,
    Opcode_ret_encode_fns, 0, 0 },
  { "simcall", ICLASS_xt_iclass_simcall,
    0,
    Opcode_simcall_encode_fns, 0, 0 },
  { "s16i", ICLASS_xt_iclass_s16i,
    0,
    Opcode_s16i_encode_fns, 0, 0 },
  { "s32i", ICLASS_xt_iclass_s32i,
    0,
    Opcode_s32i_encode_fns, 0, 0 },
  { "s32nb", ICLASS_xt_iclass_s32nb,
    0,
    Opcode_s32nb_encode_fns, 0, 0 },
  { "s8i", ICLASS_xt_iclass_s8i,
    0,
    Opcode_s8i_encode_fns, 0, 0 },
  { "ssr", ICLASS_xt_iclass_sar,
    0,
    Opcode_ssr_encode_fns, 0, 0 },
  { "ssl", ICLASS_xt_iclass_sar,
    0,
    Opcode_ssl_encode_fns, 0, 0 },
  { "ssa8l", ICLASS_xt_iclass_sar,
    0,
    Opcode_ssa8l_encode_fns, 0, 0 },
  { "ssa8b", ICLASS_xt_iclass_sar,
    0,
    Opcode_ssa8b_encode_fns, 0, 0 },
  { "ssai", ICLASS_xt_iclass_sari,
    0,
    Opcode_ssai_encode_fns, 0, 0 },
  { "sll", ICLASS_xt_iclass_shifts,
    0,
    Opcode_sll_encode_fns, 0, 0 },
  { "src", ICLASS_xt_iclass_shiftst,
    0,
    Opcode_src_encode_fns, 0, 0 },
  { "srl", ICLASS_xt_iclass_shiftt,
    0,
    Opcode_srl_encode_fns, 0, 0 },
  { "sra", ICLASS_xt_iclass_shiftt,
    0,
    Opcode_sra_encode_fns, 0, 0 },
  { "slli", ICLASS_xt_iclass_slli,
    0,
    Opcode_slli_encode_fns, 0, 0 },
  { "srai", ICLASS_xt_iclass_srai,
    0,
    Opcode_srai_encode_fns, 0, 0 },
  { "srli", ICLASS_xt_iclass_srli,
    0,
    Opcode_srli_encode_fns, 0, 0 },
  { "memw", ICLASS_xt_iclass_memw,
    0,
    Opcode_memw_encode_fns, 0, 0 },
  { "extw", ICLASS_xt_iclass_extw,
    0,
    Opcode_extw_encode_fns, 0, 0 },
  { "isync", ICLASS_xt_iclass_isync,
    0,
    Opcode_isync_encode_fns, 0, 0 },
  { "rsync", ICLASS_xt_iclass_sync,
    0,
    Opcode_rsync_encode_fns, 0, 0 },
  { "esync", ICLASS_xt_iclass_sync,
    0,
    Opcode_esync_encode_fns, 0, 0 },
  { "dsync", ICLASS_xt_iclass_sync,
    0,
    Opcode_dsync_encode_fns, 0, 0 },
  { "rsil", ICLASS_xt_iclass_rsil,
    0,
    Opcode_rsil_encode_fns, 0, 0 },
  { "rsr.lend", ICLASS_xt_iclass_rsr_lend,
    0,
    Opcode_rsr_lend_encode_fns, 0, 0 },
  { "wsr.lend", ICLASS_xt_iclass_wsr_lend,
    0,
    Opcode_wsr_lend_encode_fns, 0, 0 },
  { "xsr.lend", ICLASS_xt_iclass_xsr_lend,
    0,
    Opcode_xsr_lend_encode_fns, 0, 0 },
  { "rsr.lcount", ICLASS_xt_iclass_rsr_lcount,
    0,
    Opcode_rsr_lcount_encode_fns, 0, 0 },
  { "wsr.lcount", ICLASS_xt_iclass_wsr_lcount,
    0,
    Opcode_wsr_lcount_encode_fns, 0, 0 },
  { "xsr.lcount", ICLASS_xt_iclass_xsr_lcount,
    0,
    Opcode_xsr_lcount_encode_fns, 0, 0 },
  { "rsr.lbeg", ICLASS_xt_iclass_rsr_lbeg,
    0,
    Opcode_rsr_lbeg_encode_fns, 0, 0 },
  { "wsr.lbeg", ICLASS_xt_iclass_wsr_lbeg,
    0,
    Opcode_wsr_lbeg_encode_fns, 0, 0 },
  { "xsr.lbeg", ICLASS_xt_iclass_xsr_lbeg,
    0,
    Opcode_xsr_lbeg_encode_fns, 0, 0 },
  { "rsr.sar", ICLASS_xt_iclass_rsr_sar,
    0,
    Opcode_rsr_sar_encode_fns, 0, 0 },
  { "wsr.sar", ICLASS_xt_iclass_wsr_sar,
    0,
    Opcode_wsr_sar_encode_fns, 0, 0 },
  { "xsr.sar", ICLASS_xt_iclass_xsr_sar,
    0,
    Opcode_xsr_sar_encode_fns, 0, 0 },
  { "rsr.memctl", ICLASS_xt_iclass_rsr_memctl,
    0,
    Opcode_rsr_memctl_encode_fns, 0, 0 },
  { "wsr.memctl", ICLASS_xt_iclass_wsr_memctl,
    0,
    Opcode_wsr_memctl_encode_fns, 0, 0 },
  { "xsr.memctl", ICLASS_xt_iclass_xsr_memctl,
    0,
    Opcode_xsr_memctl_encode_fns, 0, 0 },
  { "rsr.litbase", ICLASS_xt_iclass_rsr_litbase,
    0,
    Opcode_rsr_litbase_encode_fns, 0, 0 },
  { "wsr.litbase", ICLASS_xt_iclass_wsr_litbase,
    0,
    Opcode_wsr_litbase_encode_fns, 0, 0 },
  { "xsr.litbase", ICLASS_xt_iclass_xsr_litbase,
    0,
    Opcode_xsr_litbase_encode_fns, 0, 0 },
  { "rsr.configid0", ICLASS_xt_iclass_rsr_configid0,
    0,
    Opcode_rsr_configid0_encode_fns, 0, 0 },
  { "wsr.configid0", ICLASS_xt_iclass_wsr_configid0,
    0,
    Opcode_wsr_configid0_encode_fns, 0, 0 },
  { "rsr.configid1", ICLASS_xt_iclass_rsr_configid1,
    0,
    Opcode_rsr_configid1_encode_fns, 0, 0 },
  { "rsr.243", ICLASS_xt_iclass_rsr_243,
    0,
    Opcode_rsr_243_encode_fns, 0, 0 },
  { "rsr.ps", ICLASS_xt_iclass_rsr_ps,
    0,
    Opcode_rsr_ps_encode_fns, 0, 0 },
  { "wsr.ps", ICLASS_xt_iclass_wsr_ps,
    0,
    Opcode_wsr_ps_encode_fns, 0, 0 },
  { "xsr.ps", ICLASS_xt_iclass_xsr_ps,
    0,
    Opcode_xsr_ps_encode_fns, 0, 0 },
  { "rsr.epc1", ICLASS_xt_iclass_rsr_epc1,
    0,
    Opcode_rsr_epc1_encode_fns, 0, 0 },
  { "wsr.epc1", ICLASS_xt_iclass_wsr_epc1,
    0,
    Opcode_wsr_epc1_encode_fns, 0, 0 },
  { "xsr.epc1", ICLASS_xt_iclass_xsr_epc1,
    0,
    Opcode_xsr_epc1_encode_fns, 0, 0 },
  { "rsr.excsave1", ICLASS_xt_iclass_rsr_excsave1,
    0,
    Opcode_rsr_excsave1_encode_fns, 0, 0 },
  { "wsr.excsave1", ICLASS_xt_iclass_wsr_excsave1,
    0,
    Opcode_wsr_excsave1_encode_fns, 0, 0 },
  { "xsr.excsave1", ICLASS_xt_iclass_xsr_excsave1,
    0,
    Opcode_xsr_excsave1_encode_fns, 0, 0 },
  { "rsr.epc2", ICLASS_xt_iclass_rsr_epc2,
    0,
    Opcode_rsr_epc2_encode_fns, 0, 0 },
  { "wsr.epc2", ICLASS_xt_iclass_wsr_epc2,
    0,
    Opcode_wsr_epc2_encode_fns, 0, 0 },
  { "xsr.epc2", ICLASS_xt_iclass_xsr_epc2,
    0,
    Opcode_xsr_epc2_encode_fns, 0, 0 },
  { "rsr.excsave2", ICLASS_xt_iclass_rsr_excsave2,
    0,
    Opcode_rsr_excsave2_encode_fns, 0, 0 },
  { "wsr.excsave2", ICLASS_xt_iclass_wsr_excsave2,
    0,
    Opcode_wsr_excsave2_encode_fns, 0, 0 },
  { "xsr.excsave2", ICLASS_xt_iclass_xsr_excsave2,
    0,
    Opcode_xsr_excsave2_encode_fns, 0, 0 },
  { "rsr.epc3", ICLASS_xt_iclass_rsr_epc3,
    0,
    Opcode_rsr_epc3_encode_fns, 0, 0 },
  { "wsr.epc3", ICLASS_xt_iclass_wsr_epc3,
    0,
    Opcode_wsr_epc3_encode_fns, 0, 0 },
  { "xsr.epc3", ICLASS_xt_iclass_xsr_epc3,
    0,
    Opcode_xsr_epc3_encode_fns, 0, 0 },
  { "rsr.excsave3", ICLASS_xt_iclass_rsr_excsave3,
    0,
    Opcode_rsr_excsave3_encode_fns, 0, 0 },
  { "wsr.excsave3", ICLASS_xt_iclass_wsr_excsave3,
    0,
    Opcode_wsr_excsave3_encode_fns, 0, 0 },
  { "xsr.excsave3", ICLASS_xt_iclass_xsr_excsave3,
    0,
    Opcode_xsr_excsave3_encode_fns, 0, 0 },
  { "rsr.epc4", ICLASS_xt_iclass_rsr_epc4,
    0,
    Opcode_rsr_epc4_encode_fns, 0, 0 },
  { "wsr.epc4", ICLASS_xt_iclass_wsr_epc4,
    0,
    Opcode_wsr_epc4_encode_fns, 0, 0 },
  { "xsr.epc4", ICLASS_xt_iclass_xsr_epc4,
    0,
    Opcode_xsr_epc4_encode_fns, 0, 0 },
  { "rsr.excsave4", ICLASS_xt_iclass_rsr_excsave4,
    0,
    Opcode_rsr_excsave4_encode_fns, 0, 0 },
  { "wsr.excsave4", ICLASS_xt_iclass_wsr_excsave4,
    0,
    Opcode_wsr_excsave4_encode_fns, 0, 0 },
  { "xsr.excsave4", ICLASS_xt_iclass_xsr_excsave4,
    0,
    Opcode_xsr_excsave4_encode_fns, 0, 0 },
  { "rsr.epc5", ICLASS_xt_iclass_rsr_epc5,
    0,
    Opcode_rsr_epc5_encode_fns, 0, 0 },
  { "wsr.epc5", ICLASS_xt_iclass_wsr_epc5,
    0,
    Opcode_wsr_epc5_encode_fns, 0, 0 },
  { "xsr.epc5", ICLASS_xt_iclass_xsr_epc5,
    0,
    Opcode_xsr_epc5_encode_fns, 0, 0 },
  { "rsr.excsave5", ICLASS_xt_iclass_rsr_excsave5,
    0,
    Opcode_rsr_excsave5_encode_fns, 0, 0 },
  { "wsr.excsave5", ICLASS_xt_iclass_wsr_excsave5,
    0,
    Opcode_wsr_excsave5_encode_fns, 0, 0 },
  { "xsr.excsave5", ICLASS_xt_iclass_xsr_excsave5,
    0,
    Opcode_xsr_excsave5_encode_fns, 0, 0 },
  { "rsr.epc6", ICLASS_xt_iclass_rsr_epc6,
    0,
    Opcode_rsr_epc6_encode_fns, 0, 0 },
  { "wsr.epc6", ICLASS_xt_iclass_wsr_epc6,
    0,
    Opcode_wsr_epc6_encode_fns, 0, 0 },
  { "xsr.epc6", ICLASS_xt_iclass_xsr_epc6,
    0,
    Opcode_xsr_epc6_encode_fns, 0, 0 },
  { "rsr.excsave6", ICLASS_xt_iclass_rsr_excsave6,
    0,
    Opcode_rsr_excsave6_encode_fns, 0, 0 },
  { "wsr.excsave6", ICLASS_xt_iclass_wsr_excsave6,
    0,
    Opcode_wsr_excsave6_encode_fns, 0, 0 },
  { "xsr.excsave6", ICLASS_xt_iclass_xsr_excsave6,
    0,
    Opcode_xsr_excsave6_encode_fns, 0, 0 },
  { "rsr.epc7", ICLASS_xt_iclass_rsr_epc7,
    0,
    Opcode_rsr_epc7_encode_fns, 0, 0 },
  { "wsr.epc7", ICLASS_xt_iclass_wsr_epc7,
    0,
    Opcode_wsr_epc7_encode_fns, 0, 0 },
  { "xsr.epc7", ICLASS_xt_iclass_xsr_epc7,
    0,
    Opcode_xsr_epc7_encode_fns, 0, 0 },
  { "rsr.excsave7", ICLASS_xt_iclass_rsr_excsave7,
    0,
    Opcode_rsr_excsave7_encode_fns, 0, 0 },
  { "wsr.excsave7", ICLASS_xt_iclass_wsr_excsave7,
    0,
    Opcode_wsr_excsave7_encode_fns, 0, 0 },
  { "xsr.excsave7", ICLASS_xt_iclass_xsr_excsave7,
    0,
    Opcode_xsr_excsave7_encode_fns, 0, 0 },
  { "rsr.eps2", ICLASS_xt_iclass_rsr_eps2,
    0,
    Opcode_rsr_eps2_encode_fns, 0, 0 },
  { "wsr.eps2", ICLASS_xt_iclass_wsr_eps2,
    0,
    Opcode_wsr_eps2_encode_fns, 0, 0 },
  { "xsr.eps2", ICLASS_xt_iclass_xsr_eps2,
    0,
    Opcode_xsr_eps2_encode_fns, 0, 0 },
  { "rsr.eps3", ICLASS_xt_iclass_rsr_eps3,
    0,
    Opcode_rsr_eps3_encode_fns, 0, 0 },
  { "wsr.eps3", ICLASS_xt_iclass_wsr_eps3,
    0,
    Opcode_wsr_eps3_encode_fns, 0, 0 },
  { "xsr.eps3", ICLASS_xt_iclass_xsr_eps3,
    0,
    Opcode_xsr_eps3_encode_fns, 0, 0 },
  { "rsr.eps4", ICLASS_xt_iclass_rsr_eps4,
    0,
    Opcode_rsr_eps4_encode_fns, 0, 0 },
  { "wsr.eps4", ICLASS_xt_iclass_wsr_eps4,
    0,
    Opcode_wsr_eps4_encode_fns, 0, 0 },
  { "xsr.eps4", ICLASS_xt_iclass_xsr_eps4,
    0,
    Opcode_xsr_eps4_encode_fns, 0, 0 },
  { "rsr.eps5", ICLASS_xt_iclass_rsr_eps5,
    0,
    Opcode_rsr_eps5_encode_fns, 0, 0 },
  { "wsr.eps5", ICLASS_xt_iclass_wsr_eps5,
    0,
    Opcode_wsr_eps5_encode_fns, 0, 0 },
  { "xsr.eps5", ICLASS_xt_iclass_xsr_eps5,
    0,
    Opcode_xsr_eps5_encode_fns, 0, 0 },
  { "rsr.eps6", ICLASS_xt_iclass_rsr_eps6,
    0,
    Opcode_rsr_eps6_encode_fns, 0, 0 },
  { "wsr.eps6", ICLASS_xt_iclass_wsr_eps6,
    0,
    Opcode_wsr_eps6_encode_fns, 0, 0 },
  { "xsr.eps6", ICLASS_xt_iclass_xsr_eps6,
    0,
    Opcode_xsr_eps6_encode_fns, 0, 0 },
  { "rsr.eps7", ICLASS_xt_iclass_rsr_eps7,
    0,
    Opcode_rsr_eps7_encode_fns, 0, 0 },
  { "wsr.eps7", ICLASS_xt_iclass_wsr_eps7,
    0,
    Opcode_wsr_eps7_encode_fns, 0, 0 },
  { "xsr.eps7", ICLASS_xt_iclass_xsr_eps7,
    0,
    Opcode_xsr_eps7_encode_fns, 0, 0 },
  { "rsr.excvaddr", ICLASS_xt_iclass_rsr_excvaddr,
    0,
    Opcode_rsr_excvaddr_encode_fns, 0, 0 },
  { "wsr.excvaddr", ICLASS_xt_iclass_wsr_excvaddr,
    0,
    Opcode_wsr_excvaddr_encode_fns, 0, 0 },
  { "xsr.excvaddr", ICLASS_xt_iclass_xsr_excvaddr,
    0,
    Opcode_xsr_excvaddr_encode_fns, 0, 0 },
  { "rsr.depc", ICLASS_xt_iclass_rsr_depc,
    0,
    Opcode_rsr_depc_encode_fns, 0, 0 },
  { "wsr.depc", ICLASS_xt_iclass_wsr_depc,
    0,
    Opcode_wsr_depc_encode_fns, 0, 0 },
  { "xsr.depc", ICLASS_xt_iclass_xsr_depc,
    0,
    Opcode_xsr_depc_encode_fns, 0, 0 },
  { "rsr.exccause", ICLASS_xt_iclass_rsr_exccause,
    0,
    Opcode_rsr_exccause_encode_fns, 0, 0 },
  { "wsr.exccause", ICLASS_xt_iclass_wsr_exccause,
    0,
    Opcode_wsr_exccause_encode_fns, 0, 0 },
  { "xsr.exccause", ICLASS_xt_iclass_xsr_exccause,
    0,
    Opcode_xsr_exccause_encode_fns, 0, 0 },
  { "rsr.misc0", ICLASS_xt_iclass_rsr_misc0,
    0,
    Opcode_rsr_misc0_encode_fns, 0, 0 },
  { "wsr.misc0", ICLASS_xt_iclass_wsr_misc0,
    0,
    Opcode_wsr_misc0_encode_fns, 0, 0 },
  { "xsr.misc0", ICLASS_xt_iclass_xsr_misc0,
    0,
    Opcode_xsr_misc0_encode_fns, 0, 0 },
  { "rsr.misc1", ICLASS_xt_iclass_rsr_misc1,
    0,
    Opcode_rsr_misc1_encode_fns, 0, 0 },
  { "wsr.misc1", ICLASS_xt_iclass_wsr_misc1,
    0,
    Opcode_wsr_misc1_encode_fns, 0, 0 },
  { "xsr.misc1", ICLASS_xt_iclass_xsr_misc1,
    0,
    Opcode_xsr_misc1_encode_fns, 0, 0 },
  { "rsr.prid", ICLASS_xt_iclass_rsr_prid,
    0,
    Opcode_rsr_prid_encode_fns, 0, 0 },
  { "rsr.vecbase", ICLASS_xt_iclass_rsr_vecbase,
    0,
    Opcode_rsr_vecbase_encode_fns, 0, 0 },
  { "wsr.vecbase", ICLASS_xt_iclass_wsr_vecbase,
    0,
    Opcode_wsr_vecbase_encode_fns, 0, 0 },
  { "xsr.vecbase", ICLASS_xt_iclass_xsr_vecbase,
    0,
    Opcode_xsr_vecbase_encode_fns, 0, 0 },
  { "mul16u", ICLASS_xt_mul16,
    0,
    Opcode_mul16u_encode_fns, 0, 0 },
  { "mul16s", ICLASS_xt_mul16,
    0,
    Opcode_mul16s_encode_fns, 0, 0 },
  { "mull", ICLASS_xt_mul32,
    0,
    Opcode_mull_encode_fns, 0, 0 },
  { "muluh", ICLASS_xt_mul32h,
    0,
    Opcode_muluh_encode_fns, 0, 0 },
  { "mulsh", ICLASS_xt_mul32h,
    0,
    Opcode_mulsh_encode_fns, 0, 0 },
  { "mul.aa.ll", ICLASS_xt_iclass_mac16_aa,
    0,
    Opcode_mul_aa_ll_encode_fns, 0, 0 },
  { "mul.aa.hl", ICLASS_xt_iclass_mac16_aa,
    0,
    Opcode_mul_aa_hl_encode_fns, 0, 0 },
  { "mul.aa.lh", ICLASS_xt_iclass_mac16_aa,
    0,
    Opcode_mul_aa_lh_encode_fns, 0, 0 },
  { "mul.aa.hh", ICLASS_xt_iclass_mac16_aa,
    0,
    Opcode_mul_aa_hh_encode_fns, 0, 0 },
  { "umul.aa.ll", ICLASS_xt_iclass_mac16_aa,
    0,
    Opcode_umul_aa_ll_encode_fns, 0, 0 },
  { "umul.aa.hl", ICLASS_xt_iclass_mac16_aa,
    0,
    Opcode_umul_aa_hl_encode_fns, 0, 0 },
  { "umul.aa.lh", ICLASS_xt_iclass_mac16_aa,
    0,
    Opcode_umul_aa_lh_encode_fns, 0, 0 },
  { "umul.aa.hh", ICLASS_xt_iclass_mac16_aa,
    0,
    Opcode_umul_aa_hh_encode_fns, 0, 0 },
  { "mul.ad.ll", ICLASS_xt_iclass_mac16_ad,
    0,
    Opcode_mul_ad_ll_encode_fns, 0, 0 },
  { "mul.ad.hl", ICLASS_xt_iclass_mac16_ad,
    0,
    Opcode_mul_ad_hl_encode_fns, 0, 0 },
  { "mul.ad.lh", ICLASS_xt_iclass_mac16_ad,
    0,
    Opcode_mul_ad_lh_encode_fns, 0, 0 },
  { "mul.ad.hh", ICLASS_xt_iclass_mac16_ad,
    0,
    Opcode_mul_ad_hh_encode_fns, 0, 0 },
  { "mul.da.ll", ICLASS_xt_iclass_mac16_da,
    0,
    Opcode_mul_da_ll_encode_fns, 0, 0 },
  { "mul.da.hl", ICLASS_xt_iclass_mac16_da,
    0,
    Opcode_mul_da_hl_encode_fns, 0, 0 },
  { "mul.da.lh", ICLASS_xt_iclass_mac16_da,
    0,
    Opcode_mul_da_lh_encode_fns, 0, 0 },
  { "mul.da.hh", ICLASS_xt_iclass_mac16_da,
    0,
    Opcode_mul_da_hh_encode_fns, 0, 0 },
  { "mul.dd.ll", ICLASS_xt_iclass_mac16_dd,
    0,
    Opcode_mul_dd_ll_encode_fns, 0, 0 },
  { "mul.dd.hl", ICLASS_xt_iclass_mac16_dd,
    0,
    Opcode_mul_dd_hl_encode_fns, 0, 0 },
  { "mul.dd.lh", ICLASS_xt_iclass_mac16_dd,
    0,
    Opcode_mul_dd_lh_encode_fns, 0, 0 },
  { "mul.dd.hh", ICLASS_xt_iclass_mac16_dd,
    0,
    Opcode_mul_dd_hh_encode_fns, 0, 0 },
  { "mula.aa.ll", ICLASS_xt_iclass_mac16a_aa,
    0,
    Opcode_mula_aa_ll_encode_fns, 0, 0 },
  { "mula.aa.hl", ICLASS_xt_iclass_mac16a_aa,
    0,
    Opcode_mula_aa_hl_encode_fns, 0, 0 },
  { "mula.aa.lh", ICLASS_xt_iclass_mac16a_aa,
    0,
    Opcode_mula_aa_lh_encode_fns, 0, 0 },
  { "mula.aa.hh", ICLASS_xt_iclass_mac16a_aa,
    0,
    Opcode_mula_aa_hh_encode_fns, 0, 0 },
  { "muls.aa.ll", ICLASS_xt_iclass_mac16a_aa,
    0,
    Opcode_muls_aa_ll_encode_fns, 0, 0 },
  { "muls.aa.hl", ICLASS_xt_iclass_mac16a_aa,
    0,
    Opcode_muls_aa_hl_encode_fns, 0, 0 },
  { "muls.aa.lh", ICLASS_xt_iclass_mac16a_aa,
    0,
    Opcode_muls_aa_lh_encode_fns, 0, 0 },
  { "muls.aa.hh", ICLASS_xt_iclass_mac16a_aa,
    0,
    Opcode_muls_aa_hh_encode_fns, 0, 0 },
  { "mula.ad.ll", ICLASS_xt_iclass_mac16a_ad,
    0,
    Opcode_mula_ad_ll_encode_fns, 0, 0 },
  { "mula.ad.hl", ICLASS_xt_iclass_mac16a_ad,
    0,
    Opcode_mula_ad_hl_encode_fns, 0, 0 },
  { "mula.ad.lh", ICLASS_xt_iclass_mac16a_ad,
    0,
    Opcode_mula_ad_lh_encode_fns, 0, 0 },
  { "mula.ad.hh", ICLASS_xt_iclass_mac16a_ad,
    0,
    Opcode_mula_ad_hh_encode_fns, 0, 0 },
  { "muls.ad.ll", ICLASS_xt_iclass_mac16a_ad,
    0,
    Opcode_muls_ad_ll_encode_fns, 0, 0 },
  { "muls.ad.hl", ICLASS_xt_iclass_mac16a_ad,
    0,
    Opcode_muls_ad_hl_encode_fns, 0, 0 },
  { "muls.ad.lh", ICLASS_xt_iclass_mac16a_ad,
    0,
    Opcode_muls_ad_lh_encode_fns, 0, 0 },
  { "muls.ad.hh", ICLASS_xt_iclass_mac16a_ad,
    0,
    Opcode_muls_ad_hh_encode_fns, 0, 0 },
  { "mula.da.ll", ICLASS_xt_iclass_mac16a_da,
    0,
    Opcode_mula_da_ll_encode_fns, 0, 0 },
  { "mula.da.hl", ICLASS_xt_iclass_mac16a_da,
    0,
    Opcode_mula_da_hl_encode_fns, 0, 0 },
  { "mula.da.lh", ICLASS_xt_iclass_mac16a_da,
    0,
    Opcode_mula_da_lh_encode_fns, 0, 0 },
  { "mula.da.hh", ICLASS_xt_iclass_mac16a_da,
    0,
    Opcode_mula_da_hh_encode_fns, 0, 0 },
  { "muls.da.ll", ICLASS_xt_iclass_mac16a_da,
    0,
    Opcode_muls_da_ll_encode_fns, 0, 0 },
  { "muls.da.hl", ICLASS_xt_iclass_mac16a_da,
    0,
    Opcode_muls_da_hl_encode_fns, 0, 0 },
  { "muls.da.lh", ICLASS_xt_iclass_mac16a_da,
    0,
    Opcode_muls_da_lh_encode_fns, 0, 0 },
  { "muls.da.hh", ICLASS_xt_iclass_mac16a_da,
    0,
    Opcode_muls_da_hh_encode_fns, 0, 0 },
  { "mula.dd.ll", ICLASS_xt_iclass_mac16a_dd,
    0,
    Opcode_mula_dd_ll_encode_fns, 0, 0 },
  { "mula.dd.hl", ICLASS_xt_iclass_mac16a_dd,
    0,
    Opcode_mula_dd_hl_encode_fns, 0, 0 },
  { "mula.dd.lh", ICLASS_xt_iclass_mac16a_dd,
    0,
    Opcode_mula_dd_lh_encode_fns, 0, 0 },
  { "mula.dd.hh", ICLASS_xt_iclass_mac16a_dd,
    0,
    Opcode_mula_dd_hh_encode_fns, 0, 0 },
  { "muls.dd.ll", ICLASS_xt_iclass_mac16a_dd,
    0,
    Opcode_muls_dd_ll_encode_fns, 0, 0 },
  { "muls.dd.hl", ICLASS_xt_iclass_mac16a_dd,
    0,
    Opcode_muls_dd_hl_encode_fns, 0, 0 },
  { "muls.dd.lh", ICLASS_xt_iclass_mac16a_dd,
    0,
    Opcode_muls_dd_lh_encode_fns, 0, 0 },
  { "muls.dd.hh", ICLASS_xt_iclass_mac16a_dd,
    0,
    Opcode_muls_dd_hh_encode_fns, 0, 0 },
  { "mula.da.ll.lddec", ICLASS_xt_iclass_mac16al_da,
    0,
    Opcode_mula_da_ll_lddec_encode_fns, 0, 0 },
  { "mula.da.ll.ldinc", ICLASS_xt_iclass_mac16al_da,
    0,
    Opcode_mula_da_ll_ldinc_encode_fns, 0, 0 },
  { "mula.da.hl.lddec", ICLASS_xt_iclass_mac16al_da,
    0,
    Opcode_mula_da_hl_lddec_encode_fns, 0, 0 },
  { "mula.da.hl.ldinc", ICLASS_xt_iclass_mac16al_da,
    0,
    Opcode_mula_da_hl_ldinc_encode_fns, 0, 0 },
  { "mula.da.lh.lddec", ICLASS_xt_iclass_mac16al_da,
    0,
    Opcode_mula_da_lh_lddec_encode_fns, 0, 0 },
  { "mula.da.lh.ldinc", ICLASS_xt_iclass_mac16al_da,
    0,
    Opcode_mula_da_lh_ldinc_encode_fns, 0, 0 },
  { "mula.da.hh.lddec", ICLASS_xt_iclass_mac16al_da,
    0,
    Opcode_mula_da_hh_lddec_encode_fns, 0, 0 },
  { "mula.da.hh.ldinc", ICLASS_xt_iclass_mac16al_da,
    0,
    Opcode_mula_da_hh_ldinc_encode_fns, 0, 0 },
  { "mula.dd.ll.lddec", ICLASS_xt_iclass_mac16al_dd,
    0,
    Opcode_mula_dd_ll_lddec_encode_fns, 0, 0 },
  { "mula.dd.ll.ldinc", ICLASS_xt_iclass_mac16al_dd,
    0,
    Opcode_mula_dd_ll_ldinc_encode_fns, 0, 0 },
  { "mula.dd.hl.lddec", ICLASS_xt_iclass_mac16al_dd,
    0,
    Opcode_mula_dd_hl_lddec_encode_fns, 0, 0 },
  { "mula.dd.hl.ldinc", ICLASS_xt_iclass_mac16al_dd,
    0,
    Opcode_mula_dd_hl_ldinc_encode_fns, 0, 0 },
  { "mula.dd.lh.lddec", ICLASS_xt_iclass_mac16al_dd,
    0,
    Opcode_mula_dd_lh_lddec_encode_fns, 0, 0 },
  { "mula.dd.lh.ldinc", ICLASS_xt_iclass_mac16al_dd,
    0,
    Opcode_mula_dd_lh_ldinc_encode_fns, 0, 0 },
  { "mula.dd.hh.lddec", ICLASS_xt_iclass_mac16al_dd,
    0,
    Opcode_mula_dd_hh_lddec_encode_fns, 0, 0 },
  { "mula.dd.hh.ldinc", ICLASS_xt_iclass_mac16al_dd,
    0,
    Opcode_mula_dd_hh_ldinc_encode_fns, 0, 0 },
  { "lddec", ICLASS_xt_iclass_mac16_l,
    0,
    Opcode_lddec_encode_fns, 0, 0 },
  { "ldinc", ICLASS_xt_iclass_mac16_l,
    0,
    Opcode_ldinc_encode_fns, 0, 0 },
  { "rsr.m0", ICLASS_xt_iclass_rsr_m0,
    0,
    Opcode_rsr_m0_encode_fns, 0, 0 },
  { "wsr.m0", ICLASS_xt_iclass_wsr_m0,
    0,
    Opcode_wsr_m0_encode_fns, 0, 0 },
  { "xsr.m0", ICLASS_xt_iclass_xsr_m0,
    0,
    Opcode_xsr_m0_encode_fns, 0, 0 },
  { "rsr.m1", ICLASS_xt_iclass_rsr_m1,
    0,
    Opcode_rsr_m1_encode_fns, 0, 0 },
  { "wsr.m1", ICLASS_xt_iclass_wsr_m1,
    0,
    Opcode_wsr_m1_encode_fns, 0, 0 },
  { "xsr.m1", ICLASS_xt_iclass_xsr_m1,
    0,
    Opcode_xsr_m1_encode_fns, 0, 0 },
  { "rsr.m2", ICLASS_xt_iclass_rsr_m2,
    0,
    Opcode_rsr_m2_encode_fns, 0, 0 },
  { "wsr.m2", ICLASS_xt_iclass_wsr_m2,
    0,
    Opcode_wsr_m2_encode_fns, 0, 0 },
  { "xsr.m2", ICLASS_xt_iclass_xsr_m2,
    0,
    Opcode_xsr_m2_encode_fns, 0, 0 },
  { "rsr.m3", ICLASS_xt_iclass_rsr_m3,
    0,
    Opcode_rsr_m3_encode_fns, 0, 0 },
  { "wsr.m3", ICLASS_xt_iclass_wsr_m3,
    0,
    Opcode_wsr_m3_encode_fns, 0, 0 },
  { "xsr.m3", ICLASS_xt_iclass_xsr_m3,
    0,
    Opcode_xsr_m3_encode_fns, 0, 0 },
  { "rsr.acclo", ICLASS_xt_iclass_rsr_acclo,
    0,
    Opcode_rsr_acclo_encode_fns, 0, 0 },
  { "wsr.acclo", ICLASS_xt_iclass_wsr_acclo,
    0,
    Opcode_wsr_acclo_encode_fns, 0, 0 },
  { "xsr.acclo", ICLASS_xt_iclass_xsr_acclo,
    0,
    Opcode_xsr_acclo_encode_fns, 0, 0 },
  { "rsr.acchi", ICLASS_xt_iclass_rsr_acchi,
    0,
    Opcode_rsr_acchi_encode_fns, 0, 0 },
  { "wsr.acchi", ICLASS_xt_iclass_wsr_acchi,
    0,
    Opcode_wsr_acchi_encode_fns, 0, 0 },
  { "xsr.acchi", ICLASS_xt_iclass_xsr_acchi,
    0,
    Opcode_xsr_acchi_encode_fns, 0, 0 },
  { "rfi", ICLASS_xt_iclass_rfi,
    XTENSA_OPCODE_IS_JUMP,
    Opcode_rfi_encode_fns, 0, 0 },
  { "waiti", ICLASS_xt_iclass_wait,
    0,
    Opcode_waiti_encode_fns, 0, 0 },
  { "rsr.interrupt", ICLASS_xt_iclass_rsr_interrupt,
    0,
    Opcode_rsr_interrupt_encode_fns, 0, 0 },
  { "wsr.intset", ICLASS_xt_iclass_wsr_intset,
    0,
    Opcode_wsr_intset_encode_fns, 0, 0 },
  { "wsr.intclear", ICLASS_xt_iclass_wsr_intclear,
    0,
    Opcode_wsr_intclear_encode_fns, 0, 0 },
  { "rsr.intenable", ICLASS_xt_iclass_rsr_intenable,
    0,
    Opcode_rsr_intenable_encode_fns, 0, 0 },
  { "wsr.intenable", ICLASS_xt_iclass_wsr_intenable,
    0,
    Opcode_wsr_intenable_encode_fns, 0, 0 },
  { "xsr.intenable", ICLASS_xt_iclass_xsr_intenable,
    0,
    Opcode_xsr_intenable_encode_fns, 0, 0 },
  { "break", ICLASS_xt_iclass_break,
    0,
    Opcode_break_encode_fns, 0, 0 },
  { "break.n", ICLASS_xt_iclass_break_n,
    0,
    Opcode_break_n_encode_fns, 0, 0 },
  { "rsr.dbreaka0", ICLASS_xt_iclass_rsr_dbreaka0,
    0,
    Opcode_rsr_dbreaka0_encode_fns, 0, 0 },
  { "wsr.dbreaka0", ICLASS_xt_iclass_wsr_dbreaka0,
    0,
    Opcode_wsr_dbreaka0_encode_fns, 0, 0 },
  { "xsr.dbreaka0", ICLASS_xt_iclass_xsr_dbreaka0,
    0,
    Opcode_xsr_dbreaka0_encode_fns, 0, 0 },
  { "rsr.dbreakc0", ICLASS_xt_iclass_rsr_dbreakc0,
    0,
    Opcode_rsr_dbreakc0_encode_fns, 0, 0 },
  { "wsr.dbreakc0", ICLASS_xt_iclass_wsr_dbreakc0,
    0,
    Opcode_wsr_dbreakc0_encode_fns, 0, 0 },
  { "xsr.dbreakc0", ICLASS_xt_iclass_xsr_dbreakc0,
    0,
    Opcode_xsr_dbreakc0_encode_fns, 0, 0 },
  { "rsr.dbreaka1", ICLASS_xt_iclass_rsr_dbreaka1,
    0,
    Opcode_rsr_dbreaka1_encode_fns, 0, 0 },
  { "wsr.dbreaka1", ICLASS_xt_iclass_wsr_dbreaka1,
    0,
    Opcode_wsr_dbreaka1_encode_fns, 0, 0 },
  { "xsr.dbreaka1", ICLASS_xt_iclass_xsr_dbreaka1,
    0,
    Opcode_xsr_dbreaka1_encode_fns, 0, 0 },
  { "rsr.dbreakc1", ICLASS_xt_iclass_rsr_dbreakc1,
    0,
    Opcode_rsr_dbreakc1_encode_fns, 0, 0 },
  { "wsr.dbreakc1", ICLASS_xt_iclass_wsr_dbreakc1,
    0,
    Opcode_wsr_dbreakc1_encode_fns, 0, 0 },
  { "xsr.dbreakc1", ICLASS_xt_iclass_xsr_dbreakc1,
    0,
    Opcode_xsr_dbreakc1_encode_fns, 0, 0 },
  { "rsr.ibreaka0", ICLASS_xt_iclass_rsr_ibreaka0,
    0,
    Opcode_rsr_ibreaka0_encode_fns, 0, 0 },
  { "wsr.ibreaka0", ICLASS_xt_iclass_wsr_ibreaka0,
    0,
    Opcode_wsr_ibreaka0_encode_fns, 0, 0 },
  { "xsr.ibreaka0", ICLASS_xt_iclass_xsr_ibreaka0,
    0,
    Opcode_xsr_ibreaka0_encode_fns, 0, 0 },
  { "rsr.ibreaka1", ICLASS_xt_iclass_rsr_ibreaka1,
    0,
    Opcode_rsr_ibreaka1_encode_fns, 0, 0 },
  { "wsr.ibreaka1", ICLASS_xt_iclass_wsr_ibreaka1,
    0,
    Opcode_wsr_ibreaka1_encode_fns, 0, 0 },
  { "xsr.ibreaka1", ICLASS_xt_iclass_xsr_ibreaka1,
    0,
    Opcode_xsr_ibreaka1_encode_fns, 0, 0 },
  { "rsr.ibreakenable", ICLASS_xt_iclass_rsr_ibreakenable,
    0,
    Opcode_rsr_ibreakenable_encode_fns, 0, 0 },
  { "wsr.ibreakenable", ICLASS_xt_iclass_wsr_ibreakenable,
    0,
    Opcode_wsr_ibreakenable_encode_fns, 0, 0 },
  { "xsr.ibreakenable", ICLASS_xt_iclass_xsr_ibreakenable,
    0,
    Opcode_xsr_ibreakenable_encode_fns, 0, 0 },
  { "rsr.debugcause", ICLASS_xt_iclass_rsr_debugcause,
    0,
    Opcode_rsr_debugcause_encode_fns, 0, 0 },
  { "wsr.debugcause", ICLASS_xt_iclass_wsr_debugcause,
    0,
    Opcode_wsr_debugcause_encode_fns, 0, 0 },
  { "xsr.debugcause", ICLASS_xt_iclass_xsr_debugcause,
    0,
    Opcode_xsr_debugcause_encode_fns, 0, 0 },
  { "rsr.icount", ICLASS_xt_iclass_rsr_icount,
    0,
    Opcode_rsr_icount_encode_fns, 0, 0 },
  { "wsr.icount", ICLASS_xt_iclass_wsr_icount,
    0,
    Opcode_wsr_icount_encode_fns, 0, 0 },
  { "xsr.icount", ICLASS_xt_iclass_xsr_icount,
    0,
    Opcode_xsr_icount_encode_fns, 0, 0 },
  { "rsr.icountlevel", ICLASS_xt_iclass_rsr_icountlevel,
    0,
    Opcode_rsr_icountlevel_encode_fns, 0, 0 },
  { "wsr.icountlevel", ICLASS_xt_iclass_wsr_icountlevel,
    0,
    Opcode_wsr_icountlevel_encode_fns, 0, 0 },
  { "xsr.icountlevel", ICLASS_xt_iclass_xsr_icountlevel,
    0,
    Opcode_xsr_icountlevel_encode_fns, 0, 0 },
  { "rsr.ddr", ICLASS_xt_iclass_rsr_ddr,
    0,
    Opcode_rsr_ddr_encode_fns, 0, 0 },
  { "wsr.ddr", ICLASS_xt_iclass_wsr_ddr,
    0,
    Opcode_wsr_ddr_encode_fns, 0, 0 },
  { "xsr.ddr", ICLASS_xt_iclass_xsr_ddr,
    0,
    Opcode_xsr_ddr_encode_fns, 0, 0 },
  { "lddr32.p", ICLASS_xt_iclass_lddr32_p,
    0,
    Opcode_lddr32_p_encode_fns, 0, 0 },
  { "sddr32.p", ICLASS_xt_iclass_sddr32_p,
    0,
    Opcode_sddr32_p_encode_fns, 0, 0 },
  { "rfdo", ICLASS_xt_iclass_rfdo,
    XTENSA_OPCODE_IS_JUMP,
    Opcode_rfdo_encode_fns, 0, 0 },
  { "rfdd", ICLASS_xt_iclass_rfdd,
    XTENSA_OPCODE_IS_JUMP,
    Opcode_rfdd_encode_fns, 0, 0 },
  { "wsr.mmid", ICLASS_xt_iclass_wsr_mmid,
    0,
    Opcode_wsr_mmid_encode_fns, 0, 0 },
  { "andb", ICLASS_xt_iclass_bbool1,
    0,
    Opcode_andb_encode_fns, 0, 0 },
  { "andbc", ICLASS_xt_iclass_bbool1,
    0,
    Opcode_andbc_encode_fns, 0, 0 },
  { "orb", ICLASS_xt_iclass_bbool1,
    0,
    Opcode_orb_encode_fns, 0, 0 },
  { "orbc", ICLASS_xt_iclass_bbool1,
    0,
    Opcode_orbc_encode_fns, 0, 0 },
  { "xorb", ICLASS_xt_iclass_bbool1,
    0,
    Opcode_xorb_encode_fns, 0, 0 },
  { "any4", ICLASS_xt_iclass_bbool4,
    0,
    Opcode_any4_encode_fns, 0, 0 },
  { "all4", ICLASS_xt_iclass_bbool4,
    0,
    Opcode_all4_encode_fns, 0, 0 },
  { "any8", ICLASS_xt_iclass_bbool8,
    0,
    Opcode_any8_encode_fns, 0, 0 },
  { "all8", ICLASS_xt_iclass_bbool8,
    0,
    Opcode_all8_encode_fns, 0, 0 },
  { "bf", ICLASS_xt_iclass_bbranch,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bf_encode_fns, 0, 0 },
  { "bt", ICLASS_xt_iclass_bbranch,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_bt_encode_fns, 0, 0 },
  { "movf", ICLASS_xt_iclass_bmove,
    0,
    Opcode_movf_encode_fns, 0, 0 },
  { "movt", ICLASS_xt_iclass_bmove,
    0,
    Opcode_movt_encode_fns, 0, 0 },
  { "rsr.br", ICLASS_xt_iclass_RSR_BR,
    0,
    Opcode_rsr_br_encode_fns, 0, 0 },
  { "wsr.br", ICLASS_xt_iclass_WSR_BR,
    0,
    Opcode_wsr_br_encode_fns, 0, 0 },
  { "xsr.br", ICLASS_xt_iclass_XSR_BR,
    0,
    Opcode_xsr_br_encode_fns, 0, 0 },
  { "rsr.ccount", ICLASS_xt_iclass_rsr_ccount,
    0,
    Opcode_rsr_ccount_encode_fns, 0, 0 },
  { "wsr.ccount", ICLASS_xt_iclass_wsr_ccount,
    0,
    Opcode_wsr_ccount_encode_fns, 0, 0 },
  { "xsr.ccount", ICLASS_xt_iclass_xsr_ccount,
    0,
    Opcode_xsr_ccount_encode_fns, 0, 0 },
  { "rsr.ccompare0", ICLASS_xt_iclass_rsr_ccompare0,
    0,
    Opcode_rsr_ccompare0_encode_fns, 0, 0 },
  { "wsr.ccompare0", ICLASS_xt_iclass_wsr_ccompare0,
    0,
    Opcode_wsr_ccompare0_encode_fns, 0, 0 },
  { "xsr.ccompare0", ICLASS_xt_iclass_xsr_ccompare0,
    0,
    Opcode_xsr_ccompare0_encode_fns, 0, 0 },
  { "rsr.ccompare1", ICLASS_xt_iclass_rsr_ccompare1,
    0,
    Opcode_rsr_ccompare1_encode_fns, 0, 0 },
  { "wsr.ccompare1", ICLASS_xt_iclass_wsr_ccompare1,
    0,
    Opcode_wsr_ccompare1_encode_fns, 0, 0 },
  { "xsr.ccompare1", ICLASS_xt_iclass_xsr_ccompare1,
    0,
    Opcode_xsr_ccompare1_encode_fns, 0, 0 },
  { "rsr.ccompare2", ICLASS_xt_iclass_rsr_ccompare2,
    0,
    Opcode_rsr_ccompare2_encode_fns, 0, 0 },
  { "wsr.ccompare2", ICLASS_xt_iclass_wsr_ccompare2,
    0,
    Opcode_wsr_ccompare2_encode_fns, 0, 0 },
  { "xsr.ccompare2", ICLASS_xt_iclass_xsr_ccompare2,
    0,
    Opcode_xsr_ccompare2_encode_fns, 0, 0 },
  { "ipf", ICLASS_xt_iclass_icache,
    0,
    Opcode_ipf_encode_fns, 0, 0 },
  { "ihi", ICLASS_xt_iclass_icache,
    0,
    Opcode_ihi_encode_fns, 0, 0 },
  { "ipfl", ICLASS_xt_iclass_icache_lock,
    0,
    Opcode_ipfl_encode_fns, 0, 0 },
  { "ihu", ICLASS_xt_iclass_icache_lock,
    0,
    Opcode_ihu_encode_fns, 0, 0 },
  { "iiu", ICLASS_xt_iclass_icache_lock,
    0,
    Opcode_iiu_encode_fns, 0, 0 },
  { "iii", ICLASS_xt_iclass_icache_inv,
    0,
    Opcode_iii_encode_fns, 0, 0 },
  { "lict", ICLASS_xt_iclass_licx,
    0,
    Opcode_lict_encode_fns, 0, 0 },
  { "licw", ICLASS_xt_iclass_licx,
    0,
    Opcode_licw_encode_fns, 0, 0 },
  { "sict", ICLASS_xt_iclass_sicx,
    0,
    Opcode_sict_encode_fns, 0, 0 },
  { "sicw", ICLASS_xt_iclass_sicx,
    0,
    Opcode_sicw_encode_fns, 0, 0 },
  { "dhwb", ICLASS_xt_iclass_dcache,
    0,
    Opcode_dhwb_encode_fns, 0, 0 },
  { "dhwbi", ICLASS_xt_iclass_dcache,
    0,
    Opcode_dhwbi_encode_fns, 0, 0 },
  { "diwbui.p", ICLASS_xt_iclass_dcache_dyn,
    0,
    Opcode_diwbui_p_encode_fns, 0, 0 },
  { "diwb", ICLASS_xt_iclass_dcache_ind,
    0,
    Opcode_diwb_encode_fns, 0, 0 },
  { "diwbi", ICLASS_xt_iclass_dcache_ind,
    0,
    Opcode_diwbi_encode_fns, 0, 0 },
  { "dhi", ICLASS_xt_iclass_dcache_inv,
    0,
    Opcode_dhi_encode_fns, 0, 0 },
  { "dii", ICLASS_xt_iclass_dcache_inv,
    0,
    Opcode_dii_encode_fns, 0, 0 },
  { "dpfr", ICLASS_xt_iclass_dpf,
    0,
    Opcode_dpfr_encode_fns, 0, 0 },
  { "dpfw", ICLASS_xt_iclass_dpf,
    0,
    Opcode_dpfw_encode_fns, 0, 0 },
  { "dpfro", ICLASS_xt_iclass_dpf,
    0,
    Opcode_dpfro_encode_fns, 0, 0 },
  { "dpfwo", ICLASS_xt_iclass_dpf,
    0,
    Opcode_dpfwo_encode_fns, 0, 0 },
  { "dpfl", ICLASS_xt_iclass_dcache_lock,
    0,
    Opcode_dpfl_encode_fns, 0, 0 },
  { "dhu", ICLASS_xt_iclass_dcache_lock,
    0,
    Opcode_dhu_encode_fns, 0, 0 },
  { "diu", ICLASS_xt_iclass_dcache_lock,
    0,
    Opcode_diu_encode_fns, 0, 0 },
  { "sdct", ICLASS_xt_iclass_sdct,
    0,
    Opcode_sdct_encode_fns, 0, 0 },
  { "ldct", ICLASS_xt_iclass_ldct,
    0,
    Opcode_ldct_encode_fns, 0, 0 },
  { "rsr.prefctl", ICLASS_xt_iclass_rsr_prefctl,
    0,
    Opcode_rsr_prefctl_encode_fns, 0, 0 },
  { "wsr.prefctl", ICLASS_xt_iclass_wsr_prefctl,
    0,
    Opcode_wsr_prefctl_encode_fns, 0, 0 },
  { "xsr.prefctl", ICLASS_xt_iclass_xsr_prefctl,
    0,
    Opcode_xsr_prefctl_encode_fns, 0, 0 },
  { "wsr.ptevaddr", ICLASS_xt_iclass_wsr_ptevaddr,
    0,
    Opcode_wsr_ptevaddr_encode_fns, 0, 0 },
  { "rsr.ptevaddr", ICLASS_xt_iclass_rsr_ptevaddr,
    0,
    Opcode_rsr_ptevaddr_encode_fns, 0, 0 },
  { "xsr.ptevaddr", ICLASS_xt_iclass_xsr_ptevaddr,
    0,
    Opcode_xsr_ptevaddr_encode_fns, 0, 0 },
  { "rsr.rasid", ICLASS_xt_iclass_rsr_rasid,
    0,
    Opcode_rsr_rasid_encode_fns, 0, 0 },
  { "wsr.rasid", ICLASS_xt_iclass_wsr_rasid,
    0,
    Opcode_wsr_rasid_encode_fns, 0, 0 },
  { "xsr.rasid", ICLASS_xt_iclass_xsr_rasid,
    0,
    Opcode_xsr_rasid_encode_fns, 0, 0 },
  { "rsr.itlbcfg", ICLASS_xt_iclass_rsr_itlbcfg,
    0,
    Opcode_rsr_itlbcfg_encode_fns, 0, 0 },
  { "wsr.itlbcfg", ICLASS_xt_iclass_wsr_itlbcfg,
    0,
    Opcode_wsr_itlbcfg_encode_fns, 0, 0 },
  { "xsr.itlbcfg", ICLASS_xt_iclass_xsr_itlbcfg,
    0,
    Opcode_xsr_itlbcfg_encode_fns, 0, 0 },
  { "rsr.dtlbcfg", ICLASS_xt_iclass_rsr_dtlbcfg,
    0,
    Opcode_rsr_dtlbcfg_encode_fns, 0, 0 },
  { "wsr.dtlbcfg", ICLASS_xt_iclass_wsr_dtlbcfg,
    0,
    Opcode_wsr_dtlbcfg_encode_fns, 0, 0 },
  { "xsr.dtlbcfg", ICLASS_xt_iclass_xsr_dtlbcfg,
    0,
    Opcode_xsr_dtlbcfg_encode_fns, 0, 0 },
  { "idtlb", ICLASS_xt_iclass_idtlb,
    0,
    Opcode_idtlb_encode_fns, 0, 0 },
  { "pdtlb", ICLASS_xt_iclass_rdtlb,
    0,
    Opcode_pdtlb_encode_fns, 0, 0 },
  { "rdtlb0", ICLASS_xt_iclass_rdtlb,
    0,
    Opcode_rdtlb0_encode_fns, 0, 0 },
  { "rdtlb1", ICLASS_xt_iclass_rdtlb,
    0,
    Opcode_rdtlb1_encode_fns, 0, 0 },
  { "wdtlb", ICLASS_xt_iclass_wdtlb,
    0,
    Opcode_wdtlb_encode_fns, 0, 0 },
  { "iitlb", ICLASS_xt_iclass_iitlb,
    0,
    Opcode_iitlb_encode_fns, 0, 0 },
  { "pitlb", ICLASS_xt_iclass_ritlb,
    0,
    Opcode_pitlb_encode_fns, 0, 0 },
  { "ritlb0", ICLASS_xt_iclass_ritlb,
    0,
    Opcode_ritlb0_encode_fns, 0, 0 },
  { "ritlb1", ICLASS_xt_iclass_ritlb,
    0,
    Opcode_ritlb1_encode_fns, 0, 0 },
  { "witlb", ICLASS_xt_iclass_witlb,
    0,
    Opcode_witlb_encode_fns, 0, 0 },
  { "ldpte", ICLASS_xt_iclass_ldpte,
    0,
    Opcode_ldpte_encode_fns, 0, 0 },
  { "hwwitlba", ICLASS_xt_iclass_hwwitlba,
    XTENSA_OPCODE_IS_BRANCH,
    Opcode_hwwitlba_encode_fns, 0, 0 },
  { "hwwdtlba", ICLASS_xt_iclass_hwwdtlba,
    0,
    Opcode_hwwdtlba_encode_fns, 0, 0 },
  { "rsr.cpenable", ICLASS_xt_iclass_rsr_cpenable,
    0,
    Opcode_rsr_cpenable_encode_fns, 0, 0 },
  { "wsr.cpenable", ICLASS_xt_iclass_wsr_cpenable,
    0,
    Opcode_wsr_cpenable_encode_fns, 0, 0 },
  { "xsr.cpenable", ICLASS_xt_iclass_xsr_cpenable,
    0,
    Opcode_xsr_cpenable_encode_fns, 0, 0 },
  { "clamps", ICLASS_xt_iclass_clamp,
    0,
    Opcode_clamps_encode_fns, 0, 0 },
  { "min", ICLASS_xt_iclass_minmax,
    0,
    Opcode_min_encode_fns, 0, 0 },
  { "max", ICLASS_xt_iclass_minmax,
    0,
    Opcode_max_encode_fns, 0, 0 },
  { "minu", ICLASS_xt_iclass_minmax,
    0,
    Opcode_minu_encode_fns, 0, 0 },
  { "maxu", ICLASS_xt_iclass_minmax,
    0,
    Opcode_maxu_encode_fns, 0, 0 },
  { "nsa", ICLASS_xt_iclass_nsa,
    0,
    Opcode_nsa_encode_fns, 0, 0 },
  { "nsau", ICLASS_xt_iclass_nsa,
    0,
    Opcode_nsau_encode_fns, 0, 0 },
  { "sext", ICLASS_xt_iclass_sx,
    0,
    Opcode_sext_encode_fns, 0, 0 },
  { "l32ai", ICLASS_xt_iclass_l32ai,
    0,
    Opcode_l32ai_encode_fns, 0, 0 },
  { "s32ri", ICLASS_xt_iclass_s32ri,
    0,
    Opcode_s32ri_encode_fns, 0, 0 },
  { "s32c1i", ICLASS_xt_iclass_s32c1i,
    0,
    Opcode_s32c1i_encode_fns, 0, 0 },
  { "rsr.scompare1", ICLASS_xt_iclass_rsr_scompare1,
    0,
    Opcode_rsr_scompare1_encode_fns, 0, 0 },
  { "wsr.scompare1", ICLASS_xt_iclass_wsr_scompare1,
    0,
    Opcode_wsr_scompare1_encode_fns, 0, 0 },
  { "xsr.scompare1", ICLASS_xt_iclass_xsr_scompare1,
    0,
    Opcode_xsr_scompare1_encode_fns, 0, 0 },
  { "rsr.atomctl", ICLASS_xt_iclass_rsr_atomctl,
    0,
    Opcode_rsr_atomctl_encode_fns, 0, 0 },
  { "wsr.atomctl", ICLASS_xt_iclass_wsr_atomctl,
    0,
    Opcode_wsr_atomctl_encode_fns, 0, 0 },
  { "xsr.atomctl", ICLASS_xt_iclass_xsr_atomctl,
    0,
    Opcode_xsr_atomctl_encode_fns, 0, 0 },
  { "quou", ICLASS_xt_iclass_div,
    0,
    Opcode_quou_encode_fns, 0, 0 },
  { "quos", ICLASS_xt_iclass_div,
    0,
    Opcode_quos_encode_fns, 0, 0 },
  { "remu", ICLASS_xt_iclass_div,
    0,
    Opcode_remu_encode_fns, 0, 0 },
  { "rems", ICLASS_xt_iclass_div,
    0,
    Opcode_rems_encode_fns, 0, 0 },
  { "rer", ICLASS_xt_iclass_rer,
    0,
    Opcode_rer_encode_fns, 0, 0 },
  { "wer", ICLASS_xt_iclass_wer,
    0,
    Opcode_wer_encode_fns, 0, 0 },
  { "rur.ae_ovf_sar", ICLASS_rur_ae_ovf_sar,
    0,
    Opcode_rur_ae_ovf_sar_encode_fns, 0, 0 },
  { "wur.ae_ovf_sar", ICLASS_wur_ae_ovf_sar,
    0,
    Opcode_wur_ae_ovf_sar_encode_fns, 0, 0 },
  { "rur.ae_bithead", ICLASS_rur_ae_bithead,
    0,
    Opcode_rur_ae_bithead_encode_fns, 0, 0 },
  { "wur.ae_bithead", ICLASS_wur_ae_bithead,
    0,
    Opcode_wur_ae_bithead_encode_fns, 0, 0 },
  { "rur.ae_ts_fts_bu_bp", ICLASS_rur_ae_ts_fts_bu_bp,
    0,
    Opcode_rur_ae_ts_fts_bu_bp_encode_fns, 0, 0 },
  { "wur.ae_ts_fts_bu_bp", ICLASS_wur_ae_ts_fts_bu_bp,
    0,
    Opcode_wur_ae_ts_fts_bu_bp_encode_fns, 0, 0 },
  { "rur.ae_sd_no", ICLASS_rur_ae_sd_no,
    0,
    Opcode_rur_ae_sd_no_encode_fns, 0, 0 },
  { "wur.ae_sd_no", ICLASS_wur_ae_sd_no,
    0,
    Opcode_wur_ae_sd_no_encode_fns, 0, 0 },
  { "rur.ae_overflow", ICLASS_ae_iclass_rur_ae_overflow,
    0,
    Opcode_rur_ae_overflow_encode_fns, 0, 0 },
  { "wur.ae_overflow", ICLASS_ae_iclass_wur_ae_overflow,
    0,
    Opcode_wur_ae_overflow_encode_fns, 0, 0 },
  { "rur.ae_sar", ICLASS_ae_iclass_rur_ae_sar,
    0,
    Opcode_rur_ae_sar_encode_fns, 0, 0 },
  { "wur.ae_sar", ICLASS_ae_iclass_wur_ae_sar,
    0,
    Opcode_wur_ae_sar_encode_fns, 0, 0 },
  { "rur.ae_bitptr", ICLASS_ae_iclass_rur_ae_bitptr,
    0,
    Opcode_rur_ae_bitptr_encode_fns, 0, 0 },
  { "wur.ae_bitptr", ICLASS_ae_iclass_wur_ae_bitptr,
    0,
    Opcode_wur_ae_bitptr_encode_fns, 0, 0 },
  { "rur.ae_bitsused", ICLASS_ae_iclass_rur_ae_bitsused,
    0,
    Opcode_rur_ae_bitsused_encode_fns, 0, 0 },
  { "wur.ae_bitsused", ICLASS_ae_iclass_wur_ae_bitsused,
    0,
    Opcode_wur_ae_bitsused_encode_fns, 0, 0 },
  { "rur.ae_tablesize", ICLASS_ae_iclass_rur_ae_tablesize,
    0,
    Opcode_rur_ae_tablesize_encode_fns, 0, 0 },
  { "wur.ae_tablesize", ICLASS_ae_iclass_wur_ae_tablesize,
    0,
    Opcode_wur_ae_tablesize_encode_fns, 0, 0 },
  { "rur.ae_first_ts", ICLASS_ae_iclass_rur_ae_first_ts,
    0,
    Opcode_rur_ae_first_ts_encode_fns, 0, 0 },
  { "wur.ae_first_ts", ICLASS_ae_iclass_wur_ae_first_ts,
    0,
    Opcode_wur_ae_first_ts_encode_fns, 0, 0 },
  { "rur.ae_nextoffset", ICLASS_ae_iclass_rur_ae_nextoffset,
    0,
    Opcode_rur_ae_nextoffset_encode_fns, 0, 0 },
  { "wur.ae_nextoffset", ICLASS_ae_iclass_wur_ae_nextoffset,
    0,
    Opcode_wur_ae_nextoffset_encode_fns, 0, 0 },
  { "rur.ae_searchdone", ICLASS_ae_iclass_rur_ae_searchdone,
    0,
    Opcode_rur_ae_searchdone_encode_fns, 0, 0 },
  { "wur.ae_searchdone", ICLASS_ae_iclass_wur_ae_searchdone,
    0,
    Opcode_wur_ae_searchdone_encode_fns, 0, 0 },
  { "ae_lp16f.i", ICLASS_ae_iclass_lp16f_i,
    0,
    Opcode_ae_lp16f_i_encode_fns, 0, 0 },
  { "ae_lp16f.iu", ICLASS_ae_iclass_lp16f_iu,
    0,
    Opcode_ae_lp16f_iu_encode_fns, 0, 0 },
  { "ae_lp16f.x", ICLASS_ae_iclass_lp16f_x,
    0,
    Opcode_ae_lp16f_x_encode_fns, 0, 0 },
  { "ae_lp16f.xu", ICLASS_ae_iclass_lp16f_xu,
    0,
    Opcode_ae_lp16f_xu_encode_fns, 0, 0 },
  { "ae_lp24.i", ICLASS_ae_iclass_lp24_i,
    0,
    Opcode_ae_lp24_i_encode_fns, 0, 0 },
  { "ae_lp24.iu", ICLASS_ae_iclass_lp24_iu,
    0,
    Opcode_ae_lp24_iu_encode_fns, 0, 0 },
  { "ae_lp24.x", ICLASS_ae_iclass_lp24_x,
    0,
    Opcode_ae_lp24_x_encode_fns, 0, 0 },
  { "ae_lp24.xu", ICLASS_ae_iclass_lp24_xu,
    0,
    Opcode_ae_lp24_xu_encode_fns, 0, 0 },
  { "ae_lp24f.i", ICLASS_ae_iclass_lp24f_i,
    0,
    Opcode_ae_lp24f_i_encode_fns, 0, 0 },
  { "ae_lp24f.iu", ICLASS_ae_iclass_lp24f_iu,
    0,
    Opcode_ae_lp24f_iu_encode_fns, 0, 0 },
  { "ae_lp24f.x", ICLASS_ae_iclass_lp24f_x,
    0,
    Opcode_ae_lp24f_x_encode_fns, 0, 0 },
  { "ae_lp24f.xu", ICLASS_ae_iclass_lp24f_xu,
    0,
    Opcode_ae_lp24f_xu_encode_fns, 0, 0 },
  { "ae_lp16x2f.i", ICLASS_ae_iclass_lp16x2f_i,
    0,
    Opcode_ae_lp16x2f_i_encode_fns, 0, 0 },
  { "ae_lp16x2f.iu", ICLASS_ae_iclass_lp16x2f_iu,
    0,
    Opcode_ae_lp16x2f_iu_encode_fns, 0, 0 },
  { "ae_lp16x2f.x", ICLASS_ae_iclass_lp16x2f_x,
    0,
    Opcode_ae_lp16x2f_x_encode_fns, 0, 0 },
  { "ae_lp16x2f.xu", ICLASS_ae_iclass_lp16x2f_xu,
    0,
    Opcode_ae_lp16x2f_xu_encode_fns, 0, 0 },
  { "ae_lp24x2f.i", ICLASS_ae_iclass_lp24x2f_i,
    0,
    Opcode_ae_lp24x2f_i_encode_fns, 0, 0 },
  { "ae_lp24x2f.iu", ICLASS_ae_iclass_lp24x2f_iu,
    0,
    Opcode_ae_lp24x2f_iu_encode_fns, 0, 0 },
  { "ae_lp24x2f.x", ICLASS_ae_iclass_lp24x2f_x,
    0,
    Opcode_ae_lp24x2f_x_encode_fns, 0, 0 },
  { "ae_lp24x2f.xu", ICLASS_ae_iclass_lp24x2f_xu,
    0,
    Opcode_ae_lp24x2f_xu_encode_fns, 0, 0 },
  { "ae_lp24x2.i", ICLASS_ae_iclass_lp24x2_i,
    0,
    Opcode_ae_lp24x2_i_encode_fns, 0, 0 },
  { "ae_lp24x2.iu", ICLASS_ae_iclass_lp24x2_iu,
    0,
    Opcode_ae_lp24x2_iu_encode_fns, 0, 0 },
  { "ae_lp24x2.x", ICLASS_ae_iclass_lp24x2_x,
    0,
    Opcode_ae_lp24x2_x_encode_fns, 0, 0 },
  { "ae_lp24x2.xu", ICLASS_ae_iclass_lp24x2_xu,
    0,
    Opcode_ae_lp24x2_xu_encode_fns, 0, 0 },
  { "ae_sp16x2f.i", ICLASS_ae_iclass_sp16x2f_i,
    0,
    Opcode_ae_sp16x2f_i_encode_fns, 0, 0 },
  { "ae_sp16x2f.iu", ICLASS_ae_iclass_sp16x2f_iu,
    0,
    Opcode_ae_sp16x2f_iu_encode_fns, 0, 0 },
  { "ae_sp16x2f.x", ICLASS_ae_iclass_sp16x2f_x,
    0,
    Opcode_ae_sp16x2f_x_encode_fns, 0, 0 },
  { "ae_sp16x2f.xu", ICLASS_ae_iclass_sp16x2f_xu,
    0,
    Opcode_ae_sp16x2f_xu_encode_fns, 0, 0 },
  { "ae_sp24x2s.i", ICLASS_ae_iclass_sp24x2s_i,
    0,
    Opcode_ae_sp24x2s_i_encode_fns, 0, 0 },
  { "ae_sp24x2s.iu", ICLASS_ae_iclass_sp24x2s_iu,
    0,
    Opcode_ae_sp24x2s_iu_encode_fns, 0, 0 },
  { "ae_sp24x2s.x", ICLASS_ae_iclass_sp24x2s_x,
    0,
    Opcode_ae_sp24x2s_x_encode_fns, 0, 0 },
  { "ae_sp24x2s.xu", ICLASS_ae_iclass_sp24x2s_xu,
    0,
    Opcode_ae_sp24x2s_xu_encode_fns, 0, 0 },
  { "ae_sp24x2f.i", ICLASS_ae_iclass_sp24x2f_i,
    0,
    Opcode_ae_sp24x2f_i_encode_fns, 0, 0 },
  { "ae_sp24x2f.iu", ICLASS_ae_iclass_sp24x2f_iu,
    0,
    Opcode_ae_sp24x2f_iu_encode_fns, 0, 0 },
  { "ae_sp24x2f.x", ICLASS_ae_iclass_sp24x2f_x,
    0,
    Opcode_ae_sp24x2f_x_encode_fns, 0, 0 },
  { "ae_sp24x2f.xu", ICLASS_ae_iclass_sp24x2f_xu,
    0,
    Opcode_ae_sp24x2f_xu_encode_fns, 0, 0 },
  { "ae_sp16f.l.i", ICLASS_ae_iclass_sp16f_l_i,
    0,
    Opcode_ae_sp16f_l_i_encode_fns, 0, 0 },
  { "ae_sp16f.l.iu", ICLASS_ae_iclass_sp16f_l_iu,
    0,
    Opcode_ae_sp16f_l_iu_encode_fns, 0, 0 },
  { "ae_sp16f.l.x", ICLASS_ae_iclass_sp16f_l_x,
    0,
    Opcode_ae_sp16f_l_x_encode_fns, 0, 0 },
  { "ae_sp16f.l.xu", ICLASS_ae_iclass_sp16f_l_xu,
    0,
    Opcode_ae_sp16f_l_xu_encode_fns, 0, 0 },
  { "ae_sp24s.l.i", ICLASS_ae_iclass_sp24s_l_i,
    0,
    Opcode_ae_sp24s_l_i_encode_fns, 0, 0 },
  { "ae_sp24s.l.iu", ICLASS_ae_iclass_sp24s_l_iu,
    0,
    Opcode_ae_sp24s_l_iu_encode_fns, 0, 0 },
  { "ae_sp24s.l.x", ICLASS_ae_iclass_sp24s_l_x,
    0,
    Opcode_ae_sp24s_l_x_encode_fns, 0, 0 },
  { "ae_sp24s.l.xu", ICLASS_ae_iclass_sp24s_l_xu,
    0,
    Opcode_ae_sp24s_l_xu_encode_fns, 0, 0 },
  { "ae_sp24f.l.i", ICLASS_ae_iclass_sp24f_l_i,
    0,
    Opcode_ae_sp24f_l_i_encode_fns, 0, 0 },
  { "ae_sp24f.l.iu", ICLASS_ae_iclass_sp24f_l_iu,
    0,
    Opcode_ae_sp24f_l_iu_encode_fns, 0, 0 },
  { "ae_sp24f.l.x", ICLASS_ae_iclass_sp24f_l_x,
    0,
    Opcode_ae_sp24f_l_x_encode_fns, 0, 0 },
  { "ae_sp24f.l.xu", ICLASS_ae_iclass_sp24f_l_xu,
    0,
    Opcode_ae_sp24f_l_xu_encode_fns, 0, 0 },
  { "ae_lq56.i", ICLASS_ae_iclass_lq56_i,
    0,
    Opcode_ae_lq56_i_encode_fns, 0, 0 },
  { "ae_lq56.iu", ICLASS_ae_iclass_lq56_iu,
    0,
    Opcode_ae_lq56_iu_encode_fns, 0, 0 },
  { "ae_lq56.x", ICLASS_ae_iclass_lq56_x,
    0,
    Opcode_ae_lq56_x_encode_fns, 0, 0 },
  { "ae_lq56.xu", ICLASS_ae_iclass_lq56_xu,
    0,
    Opcode_ae_lq56_xu_encode_fns, 0, 0 },
  { "ae_lq32f.i", ICLASS_ae_iclass_lq32f_i,
    0,
    Opcode_ae_lq32f_i_encode_fns, 0, 0 },
  { "ae_lq32f.iu", ICLASS_ae_iclass_lq32f_iu,
    0,
    Opcode_ae_lq32f_iu_encode_fns, 0, 0 },
  { "ae_lq32f.x", ICLASS_ae_iclass_lq32f_x,
    0,
    Opcode_ae_lq32f_x_encode_fns, 0, 0 },
  { "ae_lq32f.xu", ICLASS_ae_iclass_lq32f_xu,
    0,
    Opcode_ae_lq32f_xu_encode_fns, 0, 0 },
  { "ae_sq56s.i", ICLASS_ae_iclass_sq56s_i,
    0,
    Opcode_ae_sq56s_i_encode_fns, 0, 0 },
  { "ae_sq56s.iu", ICLASS_ae_iclass_sq56s_iu,
    0,
    Opcode_ae_sq56s_iu_encode_fns, 0, 0 },
  { "ae_sq56s.x", ICLASS_ae_iclass_sq56s_x,
    0,
    Opcode_ae_sq56s_x_encode_fns, 0, 0 },
  { "ae_sq56s.xu", ICLASS_ae_iclass_sq56s_xu,
    0,
    Opcode_ae_sq56s_xu_encode_fns, 0, 0 },
  { "ae_sq32f.i", ICLASS_ae_iclass_sq32f_i,
    0,
    Opcode_ae_sq32f_i_encode_fns, 0, 0 },
  { "ae_sq32f.iu", ICLASS_ae_iclass_sq32f_iu,
    0,
    Opcode_ae_sq32f_iu_encode_fns, 0, 0 },
  { "ae_sq32f.x", ICLASS_ae_iclass_sq32f_x,
    0,
    Opcode_ae_sq32f_x_encode_fns, 0, 0 },
  { "ae_sq32f.xu", ICLASS_ae_iclass_sq32f_xu,
    0,
    Opcode_ae_sq32f_xu_encode_fns, 0, 0 },
  { "ae_zerop48", ICLASS_ae_iclass_zerop48,
    0,
    Opcode_ae_zerop48_encode_fns, 0, 0 },
  { "ae_movp48", ICLASS_ae_iclass_movp48,
    0,
    Opcode_ae_movp48_encode_fns, 0, 0 },
  { "ae_selp24.ll", ICLASS_ae_iclass_selp24_ll,
    0,
    Opcode_ae_selp24_ll_encode_fns, 0, 0 },
  { "ae_selp24.lh", ICLASS_ae_iclass_selp24_lh,
    0,
    Opcode_ae_selp24_lh_encode_fns, 0, 0 },
  { "ae_selp24.hl", ICLASS_ae_iclass_selp24_hl,
    0,
    Opcode_ae_selp24_hl_encode_fns, 0, 0 },
  { "ae_selp24.hh", ICLASS_ae_iclass_selp24_hh,
    0,
    Opcode_ae_selp24_hh_encode_fns, 0, 0 },
  { "ae_movtp24x2", ICLASS_ae_iclass_movtp24x2,
    0,
    Opcode_ae_movtp24x2_encode_fns, 0, 0 },
  { "ae_movfp24x2", ICLASS_ae_iclass_movfp24x2,
    0,
    Opcode_ae_movfp24x2_encode_fns, 0, 0 },
  { "ae_movtp48", ICLASS_ae_iclass_movtp48,
    0,
    Opcode_ae_movtp48_encode_fns, 0, 0 },
  { "ae_movfp48", ICLASS_ae_iclass_movfp48,
    0,
    Opcode_ae_movfp48_encode_fns, 0, 0 },
  { "ae_movpa24x2", ICLASS_ae_iclass_movpa24x2,
    0,
    Opcode_ae_movpa24x2_encode_fns, 0, 0 },
  { "ae_truncp24a32x2", ICLASS_ae_iclass_truncp24a32x2,
    0,
    Opcode_ae_truncp24a32x2_encode_fns, 0, 0 },
  { "ae_cvta32p24.l", ICLASS_ae_iclass_cvta32p24_l,
    0,
    Opcode_ae_cvta32p24_l_encode_fns, 0, 0 },
  { "ae_cvta32p24.h", ICLASS_ae_iclass_cvta32p24_h,
    0,
    Opcode_ae_cvta32p24_h_encode_fns, 0, 0 },
  { "ae_cvtp24a16x2.ll", ICLASS_ae_iclass_cvtp24a16x2_ll,
    0,
    Opcode_ae_cvtp24a16x2_ll_encode_fns, 0, 0 },
  { "ae_cvtp24a16x2.lh", ICLASS_ae_iclass_cvtp24a16x2_lh,
    0,
    Opcode_ae_cvtp24a16x2_lh_encode_fns, 0, 0 },
  { "ae_cvtp24a16x2.hl", ICLASS_ae_iclass_cvtp24a16x2_hl,
    0,
    Opcode_ae_cvtp24a16x2_hl_encode_fns, 0, 0 },
  { "ae_cvtp24a16x2.hh", ICLASS_ae_iclass_cvtp24a16x2_hh,
    0,
    Opcode_ae_cvtp24a16x2_hh_encode_fns, 0, 0 },
  { "ae_truncp24q48x2", ICLASS_ae_iclass_truncp24q48x2,
    0,
    Opcode_ae_truncp24q48x2_encode_fns, 0, 0 },
  { "ae_truncp16", ICLASS_ae_iclass_truncp16,
    0,
    Opcode_ae_truncp16_encode_fns, 0, 0 },
  { "ae_roundsp24q48sym", ICLASS_ae_iclass_roundsp24q48sym,
    0,
    Opcode_ae_roundsp24q48sym_encode_fns, 0, 0 },
  { "ae_roundsp24q48asym", ICLASS_ae_iclass_roundsp24q48asym,
    0,
    Opcode_ae_roundsp24q48asym_encode_fns, 0, 0 },
  { "ae_roundsp16q48sym", ICLASS_ae_iclass_roundsp16q48sym,
    0,
    Opcode_ae_roundsp16q48sym_encode_fns, 0, 0 },
  { "ae_roundsp16q48asym", ICLASS_ae_iclass_roundsp16q48asym,
    0,
    Opcode_ae_roundsp16q48asym_encode_fns, 0, 0 },
  { "ae_roundsp16sym", ICLASS_ae_iclass_roundsp16sym,
    0,
    Opcode_ae_roundsp16sym_encode_fns, 0, 0 },
  { "ae_roundsp16asym", ICLASS_ae_iclass_roundsp16asym,
    0,
    Opcode_ae_roundsp16asym_encode_fns, 0, 0 },
  { "ae_zeroq56", ICLASS_ae_iclass_zeroq56,
    0,
    Opcode_ae_zeroq56_encode_fns, 0, 0 },
  { "ae_movq56", ICLASS_ae_iclass_movq56,
    0,
    Opcode_ae_movq56_encode_fns, 0, 0 },
  { "ae_movtq56", ICLASS_ae_iclass_movtq56,
    0,
    Opcode_ae_movtq56_encode_fns, 0, 0 },
  { "ae_movfq56", ICLASS_ae_iclass_movfq56,
    0,
    Opcode_ae_movfq56_encode_fns, 0, 0 },
  { "ae_cvtq48a32s", ICLASS_ae_iclass_cvtq48a32s,
    0,
    Opcode_ae_cvtq48a32s_encode_fns, 0, 0 },
  { "ae_cvtq48p24s.l", ICLASS_ae_iclass_cvtq48p24s_l,
    0,
    Opcode_ae_cvtq48p24s_l_encode_fns, 0, 0 },
  { "ae_cvtq48p24s.h", ICLASS_ae_iclass_cvtq48p24s_h,
    0,
    Opcode_ae_cvtq48p24s_h_encode_fns, 0, 0 },
  { "ae_satq48s", ICLASS_ae_iclass_satq48s,
    0,
    Opcode_ae_satq48s_encode_fns, 0, 0 },
  { "ae_truncq32", ICLASS_ae_iclass_truncq32,
    0,
    Opcode_ae_truncq32_encode_fns, 0, 0 },
  { "ae_roundsq32sym", ICLASS_ae_iclass_roundsq32sym,
    0,
    Opcode_ae_roundsq32sym_encode_fns, 0, 0 },
  { "ae_roundsq32asym", ICLASS_ae_iclass_roundsq32asym,
    0,
    Opcode_ae_roundsq32asym_encode_fns, 0, 0 },
  { "ae_trunca32q48", ICLASS_ae_iclass_trunca32q48,
    0,
    Opcode_ae_trunca32q48_encode_fns, 0, 0 },
  { "ae_movap24s.l", ICLASS_ae_iclass_movap24s_l,
    0,
    Opcode_ae_movap24s_l_encode_fns, 0, 0 },
  { "ae_movap24s.h", ICLASS_ae_iclass_movap24s_h,
    0,
    Opcode_ae_movap24s_h_encode_fns, 0, 0 },
  { "ae_trunca16p24s.l", ICLASS_ae_iclass_trunca16p24s_l,
    0,
    Opcode_ae_trunca16p24s_l_encode_fns, 0, 0 },
  { "ae_trunca16p24s.h", ICLASS_ae_iclass_trunca16p24s_h,
    0,
    Opcode_ae_trunca16p24s_h_encode_fns, 0, 0 },
  { "ae_addp24", ICLASS_ae_iclass_addp24,
    0,
    Opcode_ae_addp24_encode_fns, 0, 0 },
  { "ae_subp24", ICLASS_ae_iclass_subp24,
    0,
    Opcode_ae_subp24_encode_fns, 0, 0 },
  { "ae_negp24", ICLASS_ae_iclass_negp24,
    0,
    Opcode_ae_negp24_encode_fns, 0, 0 },
  { "ae_absp24", ICLASS_ae_iclass_absp24,
    0,
    Opcode_ae_absp24_encode_fns, 0, 0 },
  { "ae_maxp24s", ICLASS_ae_iclass_maxp24s,
    0,
    Opcode_ae_maxp24s_encode_fns, 0, 0 },
  { "ae_minp24s", ICLASS_ae_iclass_minp24s,
    0,
    Opcode_ae_minp24s_encode_fns, 0, 0 },
  { "ae_maxbp24s", ICLASS_ae_iclass_maxbp24s,
    0,
    Opcode_ae_maxbp24s_encode_fns, 0, 0 },
  { "ae_minbp24s", ICLASS_ae_iclass_minbp24s,
    0,
    Opcode_ae_minbp24s_encode_fns, 0, 0 },
  { "ae_addsp24s", ICLASS_ae_iclass_addsp24s,
    0,
    Opcode_ae_addsp24s_encode_fns, 0, 0 },
  { "ae_subsp24s", ICLASS_ae_iclass_subsp24s,
    0,
    Opcode_ae_subsp24s_encode_fns, 0, 0 },
  { "ae_negsp24s", ICLASS_ae_iclass_negsp24s,
    0,
    Opcode_ae_negsp24s_encode_fns, 0, 0 },
  { "ae_abssp24s", ICLASS_ae_iclass_abssp24s,
    0,
    Opcode_ae_abssp24s_encode_fns, 0, 0 },
  { "ae_andp48", ICLASS_ae_iclass_andp48,
    0,
    Opcode_ae_andp48_encode_fns, 0, 0 },
  { "ae_nandp48", ICLASS_ae_iclass_nandp48,
    0,
    Opcode_ae_nandp48_encode_fns, 0, 0 },
  { "ae_orp48", ICLASS_ae_iclass_orp48,
    0,
    Opcode_ae_orp48_encode_fns, 0, 0 },
  { "ae_xorp48", ICLASS_ae_iclass_xorp48,
    0,
    Opcode_ae_xorp48_encode_fns, 0, 0 },
  { "ae_ltp24s", ICLASS_ae_iclass_ltp24s,
    0,
    Opcode_ae_ltp24s_encode_fns, 0, 0 },
  { "ae_lep24s", ICLASS_ae_iclass_lep24s,
    0,
    Opcode_ae_lep24s_encode_fns, 0, 0 },
  { "ae_eqp24", ICLASS_ae_iclass_eqp24,
    0,
    Opcode_ae_eqp24_encode_fns, 0, 0 },
  { "ae_addq56", ICLASS_ae_iclass_addq56,
    0,
    Opcode_ae_addq56_encode_fns, 0, 0 },
  { "ae_subq56", ICLASS_ae_iclass_subq56,
    0,
    Opcode_ae_subq56_encode_fns, 0, 0 },
  { "ae_negq56", ICLASS_ae_iclass_negq56,
    0,
    Opcode_ae_negq56_encode_fns, 0, 0 },
  { "ae_absq56", ICLASS_ae_iclass_absq56,
    0,
    Opcode_ae_absq56_encode_fns, 0, 0 },
  { "ae_maxq56s", ICLASS_ae_iclass_maxq56s,
    0,
    Opcode_ae_maxq56s_encode_fns, 0, 0 },
  { "ae_minq56s", ICLASS_ae_iclass_minq56s,
    0,
    Opcode_ae_minq56s_encode_fns, 0, 0 },
  { "ae_maxbq56s", ICLASS_ae_iclass_maxbq56s,
    0,
    Opcode_ae_maxbq56s_encode_fns, 0, 0 },
  { "ae_minbq56s", ICLASS_ae_iclass_minbq56s,
    0,
    Opcode_ae_minbq56s_encode_fns, 0, 0 },
  { "ae_addsq56s", ICLASS_ae_iclass_addsq56s,
    0,
    Opcode_ae_addsq56s_encode_fns, 0, 0 },
  { "ae_subsq56s", ICLASS_ae_iclass_subsq56s,
    0,
    Opcode_ae_subsq56s_encode_fns, 0, 0 },
  { "ae_negsq56s", ICLASS_ae_iclass_negsq56s,
    0,
    Opcode_ae_negsq56s_encode_fns, 0, 0 },
  { "ae_abssq56s", ICLASS_ae_iclass_abssq56s,
    0,
    Opcode_ae_abssq56s_encode_fns, 0, 0 },
  { "ae_andq56", ICLASS_ae_iclass_andq56,
    0,
    Opcode_ae_andq56_encode_fns, 0, 0 },
  { "ae_nandq56", ICLASS_ae_iclass_nandq56,
    0,
    Opcode_ae_nandq56_encode_fns, 0, 0 },
  { "ae_orq56", ICLASS_ae_iclass_orq56,
    0,
    Opcode_ae_orq56_encode_fns, 0, 0 },
  { "ae_xorq56", ICLASS_ae_iclass_xorq56,
    0,
    Opcode_ae_xorq56_encode_fns, 0, 0 },
  { "ae_sllip24", ICLASS_ae_iclass_sllip24,
    0,
    Opcode_ae_sllip24_encode_fns, 0, 0 },
  { "ae_srlip24", ICLASS_ae_iclass_srlip24,
    0,
    Opcode_ae_srlip24_encode_fns, 0, 0 },
  { "ae_sraip24", ICLASS_ae_iclass_sraip24,
    0,
    Opcode_ae_sraip24_encode_fns, 0, 0 },
  { "ae_sllsp24", ICLASS_ae_iclass_sllsp24,
    0,
    Opcode_ae_sllsp24_encode_fns, 0, 0 },
  { "ae_srlsp24", ICLASS_ae_iclass_srlsp24,
    0,
    Opcode_ae_srlsp24_encode_fns, 0, 0 },
  { "ae_srasp24", ICLASS_ae_iclass_srasp24,
    0,
    Opcode_ae_srasp24_encode_fns, 0, 0 },
  { "ae_sllisp24s", ICLASS_ae_iclass_sllisp24s,
    0,
    Opcode_ae_sllisp24s_encode_fns, 0, 0 },
  { "ae_sllssp24s", ICLASS_ae_iclass_sllssp24s,
    0,
    Opcode_ae_sllssp24s_encode_fns, 0, 0 },
  { "ae_slliq56", ICLASS_ae_iclass_slliq56,
    0,
    Opcode_ae_slliq56_encode_fns, 0, 0 },
  { "ae_srliq56", ICLASS_ae_iclass_srliq56,
    0,
    Opcode_ae_srliq56_encode_fns, 0, 0 },
  { "ae_sraiq56", ICLASS_ae_iclass_sraiq56,
    0,
    Opcode_ae_sraiq56_encode_fns, 0, 0 },
  { "ae_sllsq56", ICLASS_ae_iclass_sllsq56,
    0,
    Opcode_ae_sllsq56_encode_fns, 0, 0 },
  { "ae_srlsq56", ICLASS_ae_iclass_srlsq56,
    0,
    Opcode_ae_srlsq56_encode_fns, 0, 0 },
  { "ae_srasq56", ICLASS_ae_iclass_srasq56,
    0,
    Opcode_ae_srasq56_encode_fns, 0, 0 },
  { "ae_sllaq56", ICLASS_ae_iclass_sllaq56,
    0,
    Opcode_ae_sllaq56_encode_fns, 0, 0 },
  { "ae_srlaq56", ICLASS_ae_iclass_srlaq56,
    0,
    Opcode_ae_srlaq56_encode_fns, 0, 0 },
  { "ae_sraaq56", ICLASS_ae_iclass_sraaq56,
    0,
    Opcode_ae_sraaq56_encode_fns, 0, 0 },
  { "ae_sllisq56s", ICLASS_ae_iclass_sllisq56s,
    0,
    Opcode_ae_sllisq56s_encode_fns, 0, 0 },
  { "ae_sllssq56s", ICLASS_ae_iclass_sllssq56s,
    0,
    Opcode_ae_sllssq56s_encode_fns, 0, 0 },
  { "ae_sllasq56s", ICLASS_ae_iclass_sllasq56s,
    0,
    Opcode_ae_sllasq56s_encode_fns, 0, 0 },
  { "ae_ltq56s", ICLASS_ae_iclass_ltq56s,
    0,
    Opcode_ae_ltq56s_encode_fns, 0, 0 },
  { "ae_leq56s", ICLASS_ae_iclass_leq56s,
    0,
    Opcode_ae_leq56s_encode_fns, 0, 0 },
  { "ae_eqq56", ICLASS_ae_iclass_eqq56,
    0,
    Opcode_ae_eqq56_encode_fns, 0, 0 },
  { "ae_nsaq56s", ICLASS_ae_iclass_nsaq56s,
    0,
    Opcode_ae_nsaq56s_encode_fns, 0, 0 },
  { "ae_mulsrfq32sp24s.h", ICLASS_ae_iclass_mulsrfq32sp24s_h,
    0,
    Opcode_ae_mulsrfq32sp24s_h_encode_fns, 0, 0 },
  { "ae_mulsrfq32sp24s.l", ICLASS_ae_iclass_mulsrfq32sp24s_l,
    0,
    Opcode_ae_mulsrfq32sp24s_l_encode_fns, 0, 0 },
  { "ae_mularfq32sp24s.h", ICLASS_ae_iclass_mularfq32sp24s_h,
    0,
    Opcode_ae_mularfq32sp24s_h_encode_fns, 0, 0 },
  { "ae_mularfq32sp24s.l", ICLASS_ae_iclass_mularfq32sp24s_l,
    0,
    Opcode_ae_mularfq32sp24s_l_encode_fns, 0, 0 },
  { "ae_mulrfq32sp24s.h", ICLASS_ae_iclass_mulrfq32sp24s_h,
    0,
    Opcode_ae_mulrfq32sp24s_h_encode_fns, 0, 0 },
  { "ae_mulrfq32sp24s.l", ICLASS_ae_iclass_mulrfq32sp24s_l,
    0,
    Opcode_ae_mulrfq32sp24s_l_encode_fns, 0, 0 },
  { "ae_mulsfq32sp24s.h", ICLASS_ae_iclass_mulsfq32sp24s_h,
    0,
    Opcode_ae_mulsfq32sp24s_h_encode_fns, 0, 0 },
  { "ae_mulsfq32sp24s.l", ICLASS_ae_iclass_mulsfq32sp24s_l,
    0,
    Opcode_ae_mulsfq32sp24s_l_encode_fns, 0, 0 },
  { "ae_mulafq32sp24s.h", ICLASS_ae_iclass_mulafq32sp24s_h,
    0,
    Opcode_ae_mulafq32sp24s_h_encode_fns, 0, 0 },
  { "ae_mulafq32sp24s.l", ICLASS_ae_iclass_mulafq32sp24s_l,
    0,
    Opcode_ae_mulafq32sp24s_l_encode_fns, 0, 0 },
  { "ae_mulfq32sp24s.h", ICLASS_ae_iclass_mulfq32sp24s_h,
    0,
    Opcode_ae_mulfq32sp24s_h_encode_fns, 0, 0 },
  { "ae_mulfq32sp24s.l", ICLASS_ae_iclass_mulfq32sp24s_l,
    0,
    Opcode_ae_mulfq32sp24s_l_encode_fns, 0, 0 },
  { "ae_mulfs32p16s.ll", ICLASS_ae_iclass_mulfs32p16s_ll,
    0,
    Opcode_ae_mulfs32p16s_ll_encode_fns, 0, 0 },
  { "ae_mulfp24s.ll", ICLASS_ae_iclass_mulfp24s_ll,
    0,
    Opcode_ae_mulfp24s_ll_encode_fns, 0, 0 },
  { "ae_mulp24s.ll", ICLASS_ae_iclass_mulp24s_ll,
    0,
    Opcode_ae_mulp24s_ll_encode_fns, 0, 0 },
  { "ae_mulfs32p16s.lh", ICLASS_ae_iclass_mulfs32p16s_lh,
    0,
    Opcode_ae_mulfs32p16s_lh_encode_fns, 0, 0 },
  { "ae_mulfp24s.lh", ICLASS_ae_iclass_mulfp24s_lh,
    0,
    Opcode_ae_mulfp24s_lh_encode_fns, 0, 0 },
  { "ae_mulp24s.lh", ICLASS_ae_iclass_mulp24s_lh,
    0,
    Opcode_ae_mulp24s_lh_encode_fns, 0, 0 },
  { "ae_mulfs32p16s.hl", ICLASS_ae_iclass_mulfs32p16s_hl,
    0,
    Opcode_ae_mulfs32p16s_hl_encode_fns, 0, 0 },
  { "ae_mulfp24s.hl", ICLASS_ae_iclass_mulfp24s_hl,
    0,
    Opcode_ae_mulfp24s_hl_encode_fns, 0, 0 },
  { "ae_mulp24s.hl", ICLASS_ae_iclass_mulp24s_hl,
    0,
    Opcode_ae_mulp24s_hl_encode_fns, 0, 0 },
  { "ae_mulfs32p16s.hh", ICLASS_ae_iclass_mulfs32p16s_hh,
    0,
    Opcode_ae_mulfs32p16s_hh_encode_fns, 0, 0 },
  { "ae_mulfp24s.hh", ICLASS_ae_iclass_mulfp24s_hh,
    0,
    Opcode_ae_mulfp24s_hh_encode_fns, 0, 0 },
  { "ae_mulp24s.hh", ICLASS_ae_iclass_mulp24s_hh,
    0,
    Opcode_ae_mulp24s_hh_encode_fns, 0, 0 },
  { "ae_mulafs32p16s.ll", ICLASS_ae_iclass_mulafs32p16s_ll,
    0,
    Opcode_ae_mulafs32p16s_ll_encode_fns, 0, 0 },
  { "ae_mulafp24s.ll", ICLASS_ae_iclass_mulafp24s_ll,
    0,
    Opcode_ae_mulafp24s_ll_encode_fns, 0, 0 },
  { "ae_mulap24s.ll", ICLASS_ae_iclass_mulap24s_ll,
    0,
    Opcode_ae_mulap24s_ll_encode_fns, 0, 0 },
  { "ae_mulafs32p16s.lh", ICLASS_ae_iclass_mulafs32p16s_lh,
    0,
    Opcode_ae_mulafs32p16s_lh_encode_fns, 0, 0 },
  { "ae_mulafp24s.lh", ICLASS_ae_iclass_mulafp24s_lh,
    0,
    Opcode_ae_mulafp24s_lh_encode_fns, 0, 0 },
  { "ae_mulap24s.lh", ICLASS_ae_iclass_mulap24s_lh,
    0,
    Opcode_ae_mulap24s_lh_encode_fns, 0, 0 },
  { "ae_mulafs32p16s.hl", ICLASS_ae_iclass_mulafs32p16s_hl,
    0,
    Opcode_ae_mulafs32p16s_hl_encode_fns, 0, 0 },
  { "ae_mulafp24s.hl", ICLASS_ae_iclass_mulafp24s_hl,
    0,
    Opcode_ae_mulafp24s_hl_encode_fns, 0, 0 },
  { "ae_mulap24s.hl", ICLASS_ae_iclass_mulap24s_hl,
    0,
    Opcode_ae_mulap24s_hl_encode_fns, 0, 0 },
  { "ae_mulafs32p16s.hh", ICLASS_ae_iclass_mulafs32p16s_hh,
    0,
    Opcode_ae_mulafs32p16s_hh_encode_fns, 0, 0 },
  { "ae_mulafp24s.hh", ICLASS_ae_iclass_mulafp24s_hh,
    0,
    Opcode_ae_mulafp24s_hh_encode_fns, 0, 0 },
  { "ae_mulap24s.hh", ICLASS_ae_iclass_mulap24s_hh,
    0,
    Opcode_ae_mulap24s_hh_encode_fns, 0, 0 },
  { "ae_mulsfs32p16s.ll", ICLASS_ae_iclass_mulsfs32p16s_ll,
    0,
    Opcode_ae_mulsfs32p16s_ll_encode_fns, 0, 0 },
  { "ae_mulsfp24s.ll", ICLASS_ae_iclass_mulsfp24s_ll,
    0,
    Opcode_ae_mulsfp24s_ll_encode_fns, 0, 0 },
  { "ae_mulsp24s.ll", ICLASS_ae_iclass_mulsp24s_ll,
    0,
    Opcode_ae_mulsp24s_ll_encode_fns, 0, 0 },
  { "ae_mulsfs32p16s.lh", ICLASS_ae_iclass_mulsfs32p16s_lh,
    0,
    Opcode_ae_mulsfs32p16s_lh_encode_fns, 0, 0 },
  { "ae_mulsfp24s.lh", ICLASS_ae_iclass_mulsfp24s_lh,
    0,
    Opcode_ae_mulsfp24s_lh_encode_fns, 0, 0 },
  { "ae_mulsp24s.lh", ICLASS_ae_iclass_mulsp24s_lh,
    0,
    Opcode_ae_mulsp24s_lh_encode_fns, 0, 0 },
  { "ae_mulsfs32p16s.hl", ICLASS_ae_iclass_mulsfs32p16s_hl,
    0,
    Opcode_ae_mulsfs32p16s_hl_encode_fns, 0, 0 },
  { "ae_mulsfp24s.hl", ICLASS_ae_iclass_mulsfp24s_hl,
    0,
    Opcode_ae_mulsfp24s_hl_encode_fns, 0, 0 },
  { "ae_mulsp24s.hl", ICLASS_ae_iclass_mulsp24s_hl,
    0,
    Opcode_ae_mulsp24s_hl_encode_fns, 0, 0 },
  { "ae_mulsfs32p16s.hh", ICLASS_ae_iclass_mulsfs32p16s_hh,
    0,
    Opcode_ae_mulsfs32p16s_hh_encode_fns, 0, 0 },
  { "ae_mulsfp24s.hh", ICLASS_ae_iclass_mulsfp24s_hh,
    0,
    Opcode_ae_mulsfp24s_hh_encode_fns, 0, 0 },
  { "ae_mulsp24s.hh", ICLASS_ae_iclass_mulsp24s_hh,
    0,
    Opcode_ae_mulsp24s_hh_encode_fns, 0, 0 },
  { "ae_mulafs56p24s.ll", ICLASS_ae_iclass_mulafs56p24s_ll,
    0,
    Opcode_ae_mulafs56p24s_ll_encode_fns, 0, 0 },
  { "ae_mulas56p24s.ll", ICLASS_ae_iclass_mulas56p24s_ll,
    0,
    Opcode_ae_mulas56p24s_ll_encode_fns, 0, 0 },
  { "ae_mulafs56p24s.lh", ICLASS_ae_iclass_mulafs56p24s_lh,
    0,
    Opcode_ae_mulafs56p24s_lh_encode_fns, 0, 0 },
  { "ae_mulas56p24s.lh", ICLASS_ae_iclass_mulas56p24s_lh,
    0,
    Opcode_ae_mulas56p24s_lh_encode_fns, 0, 0 },
  { "ae_mulafs56p24s.hl", ICLASS_ae_iclass_mulafs56p24s_hl,
    0,
    Opcode_ae_mulafs56p24s_hl_encode_fns, 0, 0 },
  { "ae_mulas56p24s.hl", ICLASS_ae_iclass_mulas56p24s_hl,
    0,
    Opcode_ae_mulas56p24s_hl_encode_fns, 0, 0 },
  { "ae_mulafs56p24s.hh", ICLASS_ae_iclass_mulafs56p24s_hh,
    0,
    Opcode_ae_mulafs56p24s_hh_encode_fns, 0, 0 },
  { "ae_mulas56p24s.hh", ICLASS_ae_iclass_mulas56p24s_hh,
    0,
    Opcode_ae_mulas56p24s_hh_encode_fns, 0, 0 },
  { "ae_mulsfs56p24s.ll", ICLASS_ae_iclass_mulsfs56p24s_ll,
    0,
    Opcode_ae_mulsfs56p24s_ll_encode_fns, 0, 0 },
  { "ae_mulss56p24s.ll", ICLASS_ae_iclass_mulss56p24s_ll,
    0,
    Opcode_ae_mulss56p24s_ll_encode_fns, 0, 0 },
  { "ae_mulsfs56p24s.lh", ICLASS_ae_iclass_mulsfs56p24s_lh,
    0,
    Opcode_ae_mulsfs56p24s_lh_encode_fns, 0, 0 },
  { "ae_mulss56p24s.lh", ICLASS_ae_iclass_mulss56p24s_lh,
    0,
    Opcode_ae_mulss56p24s_lh_encode_fns, 0, 0 },
  { "ae_mulsfs56p24s.hl", ICLASS_ae_iclass_mulsfs56p24s_hl,
    0,
    Opcode_ae_mulsfs56p24s_hl_encode_fns, 0, 0 },
  { "ae_mulss56p24s.hl", ICLASS_ae_iclass_mulss56p24s_hl,
    0,
    Opcode_ae_mulss56p24s_hl_encode_fns, 0, 0 },
  { "ae_mulsfs56p24s.hh", ICLASS_ae_iclass_mulsfs56p24s_hh,
    0,
    Opcode_ae_mulsfs56p24s_hh_encode_fns, 0, 0 },
  { "ae_mulss56p24s.hh", ICLASS_ae_iclass_mulss56p24s_hh,
    0,
    Opcode_ae_mulss56p24s_hh_encode_fns, 0, 0 },
  { "ae_mulfq32sp16s.l", ICLASS_ae_iclass_mulfq32sp16s_l,
    0,
    Opcode_ae_mulfq32sp16s_l_encode_fns, 0, 0 },
  { "ae_mulfq32sp16s.h", ICLASS_ae_iclass_mulfq32sp16s_h,
    0,
    Opcode_ae_mulfq32sp16s_h_encode_fns, 0, 0 },
  { "ae_mulfq32sp16u.l", ICLASS_ae_iclass_mulfq32sp16u_l,
    0,
    Opcode_ae_mulfq32sp16u_l_encode_fns, 0, 0 },
  { "ae_mulfq32sp16u.h", ICLASS_ae_iclass_mulfq32sp16u_h,
    0,
    Opcode_ae_mulfq32sp16u_h_encode_fns, 0, 0 },
  { "ae_mulq32sp16s.l", ICLASS_ae_iclass_mulq32sp16s_l,
    0,
    Opcode_ae_mulq32sp16s_l_encode_fns, 0, 0 },
  { "ae_mulq32sp16s.h", ICLASS_ae_iclass_mulq32sp16s_h,
    0,
    Opcode_ae_mulq32sp16s_h_encode_fns, 0, 0 },
  { "ae_mulq32sp16u.l", ICLASS_ae_iclass_mulq32sp16u_l,
    0,
    Opcode_ae_mulq32sp16u_l_encode_fns, 0, 0 },
  { "ae_mulq32sp16u.h", ICLASS_ae_iclass_mulq32sp16u_h,
    0,
    Opcode_ae_mulq32sp16u_h_encode_fns, 0, 0 },
  { "ae_mulafq32sp16s.l", ICLASS_ae_iclass_mulafq32sp16s_l,
    0,
    Opcode_ae_mulafq32sp16s_l_encode_fns, 0, 0 },
  { "ae_mulafq32sp16s.h", ICLASS_ae_iclass_mulafq32sp16s_h,
    0,
    Opcode_ae_mulafq32sp16s_h_encode_fns, 0, 0 },
  { "ae_mulafq32sp16u.l", ICLASS_ae_iclass_mulafq32sp16u_l,
    0,
    Opcode_ae_mulafq32sp16u_l_encode_fns, 0, 0 },
  { "ae_mulafq32sp16u.h", ICLASS_ae_iclass_mulafq32sp16u_h,
    0,
    Opcode_ae_mulafq32sp16u_h_encode_fns, 0, 0 },
  { "ae_mulaq32sp16s.l", ICLASS_ae_iclass_mulaq32sp16s_l,
    0,
    Opcode_ae_mulaq32sp16s_l_encode_fns, 0, 0 },
  { "ae_mulaq32sp16s.h", ICLASS_ae_iclass_mulaq32sp16s_h,
    0,
    Opcode_ae_mulaq32sp16s_h_encode_fns, 0, 0 },
  { "ae_mulaq32sp16u.l", ICLASS_ae_iclass_mulaq32sp16u_l,
    0,
    Opcode_ae_mulaq32sp16u_l_encode_fns, 0, 0 },
  { "ae_mulaq32sp16u.h", ICLASS_ae_iclass_mulaq32sp16u_h,
    0,
    Opcode_ae_mulaq32sp16u_h_encode_fns, 0, 0 },
  { "ae_mulsfq32sp16s.l", ICLASS_ae_iclass_mulsfq32sp16s_l,
    0,
    Opcode_ae_mulsfq32sp16s_l_encode_fns, 0, 0 },
  { "ae_mulsfq32sp16s.h", ICLASS_ae_iclass_mulsfq32sp16s_h,
    0,
    Opcode_ae_mulsfq32sp16s_h_encode_fns, 0, 0 },
  { "ae_mulsfq32sp16u.l", ICLASS_ae_iclass_mulsfq32sp16u_l,
    0,
    Opcode_ae_mulsfq32sp16u_l_encode_fns, 0, 0 },
  { "ae_mulsfq32sp16u.h", ICLASS_ae_iclass_mulsfq32sp16u_h,
    0,
    Opcode_ae_mulsfq32sp16u_h_encode_fns, 0, 0 },
  { "ae_mulsq32sp16s.l", ICLASS_ae_iclass_mulsq32sp16s_l,
    0,
    Opcode_ae_mulsq32sp16s_l_encode_fns, 0, 0 },
  { "ae_mulsq32sp16s.h", ICLASS_ae_iclass_mulsq32sp16s_h,
    0,
    Opcode_ae_mulsq32sp16s_h_encode_fns, 0, 0 },
  { "ae_mulsq32sp16u.l", ICLASS_ae_iclass_mulsq32sp16u_l,
    0,
    Opcode_ae_mulsq32sp16u_l_encode_fns, 0, 0 },
  { "ae_mulsq32sp16u.h", ICLASS_ae_iclass_mulsq32sp16u_h,
    0,
    Opcode_ae_mulsq32sp16u_h_encode_fns, 0, 0 },
  { "ae_mulzaaq32sp16s.ll", ICLASS_ae_iclass_mulzaaq32sp16s_ll,
    0,
    Opcode_ae_mulzaaq32sp16s_ll_encode_fns, 0, 0 },
  { "ae_mulzaafq32sp16s.ll", ICLASS_ae_iclass_mulzaafq32sp16s_ll,
    0,
    Opcode_ae_mulzaafq32sp16s_ll_encode_fns, 0, 0 },
  { "ae_mulzaaq32sp16u.ll", ICLASS_ae_iclass_mulzaaq32sp16u_ll,
    0,
    Opcode_ae_mulzaaq32sp16u_ll_encode_fns, 0, 0 },
  { "ae_mulzaafq32sp16u.ll", ICLASS_ae_iclass_mulzaafq32sp16u_ll,
    0,
    Opcode_ae_mulzaafq32sp16u_ll_encode_fns, 0, 0 },
  { "ae_mulzaaq32sp16s.hh", ICLASS_ae_iclass_mulzaaq32sp16s_hh,
    0,
    Opcode_ae_mulzaaq32sp16s_hh_encode_fns, 0, 0 },
  { "ae_mulzaafq32sp16s.hh", ICLASS_ae_iclass_mulzaafq32sp16s_hh,
    0,
    Opcode_ae_mulzaafq32sp16s_hh_encode_fns, 0, 0 },
  { "ae_mulzaaq32sp16u.hh", ICLASS_ae_iclass_mulzaaq32sp16u_hh,
    0,
    Opcode_ae_mulzaaq32sp16u_hh_encode_fns, 0, 0 },
  { "ae_mulzaafq32sp16u.hh", ICLASS_ae_iclass_mulzaafq32sp16u_hh,
    0,
    Opcode_ae_mulzaafq32sp16u_hh_encode_fns, 0, 0 },
  { "ae_mulzaaq32sp16s.lh", ICLASS_ae_iclass_mulzaaq32sp16s_lh,
    0,
    Opcode_ae_mulzaaq32sp16s_lh_encode_fns, 0, 0 },
  { "ae_mulzaafq32sp16s.lh", ICLASS_ae_iclass_mulzaafq32sp16s_lh,
    0,
    Opcode_ae_mulzaafq32sp16s_lh_encode_fns, 0, 0 },
  { "ae_mulzaaq32sp16u.lh", ICLASS_ae_iclass_mulzaaq32sp16u_lh,
    0,
    Opcode_ae_mulzaaq32sp16u_lh_encode_fns, 0, 0 },
  { "ae_mulzaafq32sp16u.lh", ICLASS_ae_iclass_mulzaafq32sp16u_lh,
    0,
    Opcode_ae_mulzaafq32sp16u_lh_encode_fns, 0, 0 },
  { "ae_mulzasq32sp16s.ll", ICLASS_ae_iclass_mulzasq32sp16s_ll,
    0,
    Opcode_ae_mulzasq32sp16s_ll_encode_fns, 0, 0 },
  { "ae_mulzasfq32sp16s.ll", ICLASS_ae_iclass_mulzasfq32sp16s_ll,
    0,
    Opcode_ae_mulzasfq32sp16s_ll_encode_fns, 0, 0 },
  { "ae_mulzasq32sp16u.ll", ICLASS_ae_iclass_mulzasq32sp16u_ll,
    0,
    Opcode_ae_mulzasq32sp16u_ll_encode_fns, 0, 0 },
  { "ae_mulzasfq32sp16u.ll", ICLASS_ae_iclass_mulzasfq32sp16u_ll,
    0,
    Opcode_ae_mulzasfq32sp16u_ll_encode_fns, 0, 0 },
  { "ae_mulzasq32sp16s.hh", ICLASS_ae_iclass_mulzasq32sp16s_hh,
    0,
    Opcode_ae_mulzasq32sp16s_hh_encode_fns, 0, 0 },
  { "ae_mulzasfq32sp16s.hh", ICLASS_ae_iclass_mulzasfq32sp16s_hh,
    0,
    Opcode_ae_mulzasfq32sp16s_hh_encode_fns, 0, 0 },
  { "ae_mulzasq32sp16u.hh", ICLASS_ae_iclass_mulzasq32sp16u_hh,
    0,
    Opcode_ae_mulzasq32sp16u_hh_encode_fns, 0, 0 },
  { "ae_mulzasfq32sp16u.hh", ICLASS_ae_iclass_mulzasfq32sp16u_hh,
    0,
    Opcode_ae_mulzasfq32sp16u_hh_encode_fns, 0, 0 },
  { "ae_mulzasq32sp16s.lh", ICLASS_ae_iclass_mulzasq32sp16s_lh,
    0,
    Opcode_ae_mulzasq32sp16s_lh_encode_fns, 0, 0 },
  { "ae_mulzasfq32sp16s.lh", ICLASS_ae_iclass_mulzasfq32sp16s_lh,
    0,
    Opcode_ae_mulzasfq32sp16s_lh_encode_fns, 0, 0 },
  { "ae_mulzasq32sp16u.lh", ICLASS_ae_iclass_mulzasq32sp16u_lh,
    0,
    Opcode_ae_mulzasq32sp16u_lh_encode_fns, 0, 0 },
  { "ae_mulzasfq32sp16u.lh", ICLASS_ae_iclass_mulzasfq32sp16u_lh,
    0,
    Opcode_ae_mulzasfq32sp16u_lh_encode_fns, 0, 0 },
  { "ae_mulzsaq32sp16s.ll", ICLASS_ae_iclass_mulzsaq32sp16s_ll,
    0,
    Opcode_ae_mulzsaq32sp16s_ll_encode_fns, 0, 0 },
  { "ae_mulzsafq32sp16s.ll", ICLASS_ae_iclass_mulzsafq32sp16s_ll,
    0,
    Opcode_ae_mulzsafq32sp16s_ll_encode_fns, 0, 0 },
  { "ae_mulzsaq32sp16u.ll", ICLASS_ae_iclass_mulzsaq32sp16u_ll,
    0,
    Opcode_ae_mulzsaq32sp16u_ll_encode_fns, 0, 0 },
  { "ae_mulzsafq32sp16u.ll", ICLASS_ae_iclass_mulzsafq32sp16u_ll,
    0,
    Opcode_ae_mulzsafq32sp16u_ll_encode_fns, 0, 0 },
  { "ae_mulzsaq32sp16s.hh", ICLASS_ae_iclass_mulzsaq32sp16s_hh,
    0,
    Opcode_ae_mulzsaq32sp16s_hh_encode_fns, 0, 0 },
  { "ae_mulzsafq32sp16s.hh", ICLASS_ae_iclass_mulzsafq32sp16s_hh,
    0,
    Opcode_ae_mulzsafq32sp16s_hh_encode_fns, 0, 0 },
  { "ae_mulzsaq32sp16u.hh", ICLASS_ae_iclass_mulzsaq32sp16u_hh,
    0,
    Opcode_ae_mulzsaq32sp16u_hh_encode_fns, 0, 0 },
  { "ae_mulzsafq32sp16u.hh", ICLASS_ae_iclass_mulzsafq32sp16u_hh,
    0,
    Opcode_ae_mulzsafq32sp16u_hh_encode_fns, 0, 0 },
  { "ae_mulzsaq32sp16s.lh", ICLASS_ae_iclass_mulzsaq32sp16s_lh,
    0,
    Opcode_ae_mulzsaq32sp16s_lh_encode_fns, 0, 0 },
  { "ae_mulzsafq32sp16s.lh", ICLASS_ae_iclass_mulzsafq32sp16s_lh,
    0,
    Opcode_ae_mulzsafq32sp16s_lh_encode_fns, 0, 0 },
  { "ae_mulzsaq32sp16u.lh", ICLASS_ae_iclass_mulzsaq32sp16u_lh,
    0,
    Opcode_ae_mulzsaq32sp16u_lh_encode_fns, 0, 0 },
  { "ae_mulzsafq32sp16u.lh", ICLASS_ae_iclass_mulzsafq32sp16u_lh,
    0,
    Opcode_ae_mulzsafq32sp16u_lh_encode_fns, 0, 0 },
  { "ae_mulzssq32sp16s.ll", ICLASS_ae_iclass_mulzssq32sp16s_ll,
    0,
    Opcode_ae_mulzssq32sp16s_ll_encode_fns, 0, 0 },
  { "ae_mulzssfq32sp16s.ll", ICLASS_ae_iclass_mulzssfq32sp16s_ll,
    0,
    Opcode_ae_mulzssfq32sp16s_ll_encode_fns, 0, 0 },
  { "ae_mulzssq32sp16u.ll", ICLASS_ae_iclass_mulzssq32sp16u_ll,
    0,
    Opcode_ae_mulzssq32sp16u_ll_encode_fns, 0, 0 },
  { "ae_mulzssfq32sp16u.ll", ICLASS_ae_iclass_mulzssfq32sp16u_ll,
    0,
    Opcode_ae_mulzssfq32sp16u_ll_encode_fns, 0, 0 },
  { "ae_mulzssq32sp16s.hh", ICLASS_ae_iclass_mulzssq32sp16s_hh,
    0,
    Opcode_ae_mulzssq32sp16s_hh_encode_fns, 0, 0 },
  { "ae_mulzssfq32sp16s.hh", ICLASS_ae_iclass_mulzssfq32sp16s_hh,
    0,
    Opcode_ae_mulzssfq32sp16s_hh_encode_fns, 0, 0 },
  { "ae_mulzssq32sp16u.hh", ICLASS_ae_iclass_mulzssq32sp16u_hh,
    0,
    Opcode_ae_mulzssq32sp16u_hh_encode_fns, 0, 0 },
  { "ae_mulzssfq32sp16u.hh", ICLASS_ae_iclass_mulzssfq32sp16u_hh,
    0,
    Opcode_ae_mulzssfq32sp16u_hh_encode_fns, 0, 0 },
  { "ae_mulzssq32sp16s.lh", ICLASS_ae_iclass_mulzssq32sp16s_lh,
    0,
    Opcode_ae_mulzssq32sp16s_lh_encode_fns, 0, 0 },
  { "ae_mulzssfq32sp16s.lh", ICLASS_ae_iclass_mulzssfq32sp16s_lh,
    0,
    Opcode_ae_mulzssfq32sp16s_lh_encode_fns, 0, 0 },
  { "ae_mulzssq32sp16u.lh", ICLASS_ae_iclass_mulzssq32sp16u_lh,
    0,
    Opcode_ae_mulzssq32sp16u_lh_encode_fns, 0, 0 },
  { "ae_mulzssfq32sp16u.lh", ICLASS_ae_iclass_mulzssfq32sp16u_lh,
    0,
    Opcode_ae_mulzssfq32sp16u_lh_encode_fns, 0, 0 },
  { "ae_mulzaafp24s.hh.ll", ICLASS_ae_iclass_mulzaafp24s_hh_ll,
    0,
    Opcode_ae_mulzaafp24s_hh_ll_encode_fns, 0, 0 },
  { "ae_mulzaap24s.hh.ll", ICLASS_ae_iclass_mulzaap24s_hh_ll,
    0,
    Opcode_ae_mulzaap24s_hh_ll_encode_fns, 0, 0 },
  { "ae_mulzaafp24s.hl.lh", ICLASS_ae_iclass_mulzaafp24s_hl_lh,
    0,
    Opcode_ae_mulzaafp24s_hl_lh_encode_fns, 0, 0 },
  { "ae_mulzaap24s.hl.lh", ICLASS_ae_iclass_mulzaap24s_hl_lh,
    0,
    Opcode_ae_mulzaap24s_hl_lh_encode_fns, 0, 0 },
  { "ae_mulzasfp24s.hh.ll", ICLASS_ae_iclass_mulzasfp24s_hh_ll,
    0,
    Opcode_ae_mulzasfp24s_hh_ll_encode_fns, 0, 0 },
  { "ae_mulzasp24s.hh.ll", ICLASS_ae_iclass_mulzasp24s_hh_ll,
    0,
    Opcode_ae_mulzasp24s_hh_ll_encode_fns, 0, 0 },
  { "ae_mulzasfp24s.hl.lh", ICLASS_ae_iclass_mulzasfp24s_hl_lh,
    0,
    Opcode_ae_mulzasfp24s_hl_lh_encode_fns, 0, 0 },
  { "ae_mulzasp24s.hl.lh", ICLASS_ae_iclass_mulzasp24s_hl_lh,
    0,
    Opcode_ae_mulzasp24s_hl_lh_encode_fns, 0, 0 },
  { "ae_mulzsafp24s.hh.ll", ICLASS_ae_iclass_mulzsafp24s_hh_ll,
    0,
    Opcode_ae_mulzsafp24s_hh_ll_encode_fns, 0, 0 },
  { "ae_mulzsap24s.hh.ll", ICLASS_ae_iclass_mulzsap24s_hh_ll,
    0,
    Opcode_ae_mulzsap24s_hh_ll_encode_fns, 0, 0 },
  { "ae_mulzsafp24s.hl.lh", ICLASS_ae_iclass_mulzsafp24s_hl_lh,
    0,
    Opcode_ae_mulzsafp24s_hl_lh_encode_fns, 0, 0 },
  { "ae_mulzsap24s.hl.lh", ICLASS_ae_iclass_mulzsap24s_hl_lh,
    0,
    Opcode_ae_mulzsap24s_hl_lh_encode_fns, 0, 0 },
  { "ae_mulzssfp24s.hh.ll", ICLASS_ae_iclass_mulzssfp24s_hh_ll,
    0,
    Opcode_ae_mulzssfp24s_hh_ll_encode_fns, 0, 0 },
  { "ae_mulzssp24s.hh.ll", ICLASS_ae_iclass_mulzssp24s_hh_ll,
    0,
    Opcode_ae_mulzssp24s_hh_ll_encode_fns, 0, 0 },
  { "ae_mulzssfp24s.hl.lh", ICLASS_ae_iclass_mulzssfp24s_hl_lh,
    0,
    Opcode_ae_mulzssfp24s_hl_lh_encode_fns, 0, 0 },
  { "ae_mulzssp24s.hl.lh", ICLASS_ae_iclass_mulzssp24s_hl_lh,
    0,
    Opcode_ae_mulzssp24s_hl_lh_encode_fns, 0, 0 },
  { "ae_mulaafp24s.hh.ll", ICLASS_ae_iclass_mulaafp24s_hh_ll,
    0,
    Opcode_ae_mulaafp24s_hh_ll_encode_fns, 0, 0 },
  { "ae_mulaap24s.hh.ll", ICLASS_ae_iclass_mulaap24s_hh_ll,
    0,
    Opcode_ae_mulaap24s_hh_ll_encode_fns, 0, 0 },
  { "ae_mulaafp24s.hl.lh", ICLASS_ae_iclass_mulaafp24s_hl_lh,
    0,
    Opcode_ae_mulaafp24s_hl_lh_encode_fns, 0, 0 },
  { "ae_mulaap24s.hl.lh", ICLASS_ae_iclass_mulaap24s_hl_lh,
    0,
    Opcode_ae_mulaap24s_hl_lh_encode_fns, 0, 0 },
  { "ae_mulasfp24s.hh.ll", ICLASS_ae_iclass_mulasfp24s_hh_ll,
    0,
    Opcode_ae_mulasfp24s_hh_ll_encode_fns, 0, 0 },
  { "ae_mulasp24s.hh.ll", ICLASS_ae_iclass_mulasp24s_hh_ll,
    0,
    Opcode_ae_mulasp24s_hh_ll_encode_fns, 0, 0 },
  { "ae_mulasfp24s.hl.lh", ICLASS_ae_iclass_mulasfp24s_hl_lh,
    0,
    Opcode_ae_mulasfp24s_hl_lh_encode_fns, 0, 0 },
  { "ae_mulasp24s.hl.lh", ICLASS_ae_iclass_mulasp24s_hl_lh,
    0,
    Opcode_ae_mulasp24s_hl_lh_encode_fns, 0, 0 },
  { "ae_mulsafp24s.hh.ll", ICLASS_ae_iclass_mulsafp24s_hh_ll,
    0,
    Opcode_ae_mulsafp24s_hh_ll_encode_fns, 0, 0 },
  { "ae_mulsap24s.hh.ll", ICLASS_ae_iclass_mulsap24s_hh_ll,
    0,
    Opcode_ae_mulsap24s_hh_ll_encode_fns, 0, 0 },
  { "ae_mulsafp24s.hl.lh", ICLASS_ae_iclass_mulsafp24s_hl_lh,
    0,
    Opcode_ae_mulsafp24s_hl_lh_encode_fns, 0, 0 },
  { "ae_mulsap24s.hl.lh", ICLASS_ae_iclass_mulsap24s_hl_lh,
    0,
    Opcode_ae_mulsap24s_hl_lh_encode_fns, 0, 0 },
  { "ae_mulssfp24s.hh.ll", ICLASS_ae_iclass_mulssfp24s_hh_ll,
    0,
    Opcode_ae_mulssfp24s_hh_ll_encode_fns, 0, 0 },
  { "ae_mulssp24s.hh.ll", ICLASS_ae_iclass_mulssp24s_hh_ll,
    0,
    Opcode_ae_mulssp24s_hh_ll_encode_fns, 0, 0 },
  { "ae_mulssfp24s.hl.lh", ICLASS_ae_iclass_mulssfp24s_hl_lh,
    0,
    Opcode_ae_mulssfp24s_hl_lh_encode_fns, 0, 0 },
  { "ae_mulssp24s.hl.lh", ICLASS_ae_iclass_mulssp24s_hl_lh,
    0,
    Opcode_ae_mulssp24s_hl_lh_encode_fns, 0, 0 },
  { "ae_sha32", ICLASS_ae_iclass_sha32,
    0,
    Opcode_ae_sha32_encode_fns, 0, 0 },
  { "ae_vldl32t", ICLASS_ae_iclass_vldl32t,
    0,
    Opcode_ae_vldl32t_encode_fns, 1, Opcode_ae_vldl32t_funcUnit_uses },
  { "ae_vldl16t", ICLASS_ae_iclass_vldl16t,
    0,
    Opcode_ae_vldl16t_encode_fns, 1, Opcode_ae_vldl16t_funcUnit_uses },
  { "ae_vldl16c", ICLASS_ae_iclass_vldl16c,
    0,
    Opcode_ae_vldl16c_encode_fns, 3, Opcode_ae_vldl16c_funcUnit_uses },
  { "ae_vldsht", ICLASS_ae_iclass_vldsht,
    0,
    Opcode_ae_vldsht_encode_fns, 3, Opcode_ae_vldsht_funcUnit_uses },
  { "ae_lb", ICLASS_ae_iclass_lb,
    0,
    Opcode_ae_lb_encode_fns, 1, Opcode_ae_lb_funcUnit_uses },
  { "ae_lbi", ICLASS_ae_iclass_lbi,
    0,
    Opcode_ae_lbi_encode_fns, 1, Opcode_ae_lbi_funcUnit_uses },
  { "ae_lbk", ICLASS_ae_iclass_lbk,
    0,
    Opcode_ae_lbk_encode_fns, 1, Opcode_ae_lbk_funcUnit_uses },
  { "ae_lbki", ICLASS_ae_iclass_lbki,
    0,
    Opcode_ae_lbki_encode_fns, 1, Opcode_ae_lbki_funcUnit_uses },
  { "ae_db", ICLASS_ae_iclass_db,
    0,
    Opcode_ae_db_encode_fns, 2, Opcode_ae_db_funcUnit_uses },
  { "ae_dbi", ICLASS_ae_iclass_dbi,
    0,
    Opcode_ae_dbi_encode_fns, 2, Opcode_ae_dbi_funcUnit_uses },
  { "ae_vlel32t", ICLASS_ae_iclass_vlel32t,
    0,
    Opcode_ae_vlel32t_encode_fns, 1, Opcode_ae_vlel32t_funcUnit_uses },
  { "ae_vlel16t", ICLASS_ae_iclass_vlel16t,
    0,
    Opcode_ae_vlel16t_encode_fns, 1, Opcode_ae_vlel16t_funcUnit_uses },
  { "ae_sb", ICLASS_ae_iclass_sb,
    0,
    Opcode_ae_sb_encode_fns, 2, Opcode_ae_sb_funcUnit_uses },
  { "ae_sbi", ICLASS_ae_iclass_sbi,
    0,
    Opcode_ae_sbi_encode_fns, 2, Opcode_ae_sbi_funcUnit_uses },
  { "ae_vles16c", ICLASS_ae_iclass_vles16c,
    0,
    Opcode_ae_vles16c_encode_fns, 2, Opcode_ae_vles16c_funcUnit_uses },
  { "ae_sbf", ICLASS_ae_iclass_sbf,
    0,
    Opcode_ae_sbf_encode_fns, 2, Opcode_ae_sbf_funcUnit_uses },
  { "ae_slaasq56s", ICLASS_icls_AE_SLAASQ56S,
    0,
    Opcode_ae_slaasq56s_encode_fns, 0, 0 },
  { "ae_addbrba32", ICLASS_icls_AE_ADDBRBA32,
    0,
    Opcode_ae_addbrba32_encode_fns, 0, 0 },
  { "ae_minabssp24s", ICLASS_icls_AE_MINABSSP24S,
    0,
    Opcode_ae_minabssp24s_encode_fns, 0, 0 },
  { "ae_maxabssp24s", ICLASS_icls_AE_MAXABSSP24S,
    0,
    Opcode_ae_maxabssp24s_encode_fns, 0, 0 },
  { "ae_minabssq56s", ICLASS_icls_AE_MINABSSQ56S,
    0,
    Opcode_ae_minabssq56s_encode_fns, 0, 0 },
  { "ae_maxabssq56s", ICLASS_icls_AE_MAXABSSQ56S,
    0,
    Opcode_ae_maxabssq56s_encode_fns, 0, 0 },
  { "rur.ae_cbegin0", ICLASS_rur_ae_cbegin0,
    0,
    Opcode_rur_ae_cbegin0_encode_fns, 0, 0 },
  { "wur.ae_cbegin0", ICLASS_wur_ae_cbegin0,
    0,
    Opcode_wur_ae_cbegin0_encode_fns, 0, 0 },
  { "rur.ae_cend0", ICLASS_rur_ae_cend0,
    0,
    Opcode_rur_ae_cend0_encode_fns, 0, 0 },
  { "wur.ae_cend0", ICLASS_wur_ae_cend0,
    0,
    Opcode_wur_ae_cend0_encode_fns, 0, 0 },
  { "ae_lp24x2.c", ICLASS_icls_AE_LP24X2_C,
    0,
    Opcode_ae_lp24x2_c_encode_fns, 0, 0 },
  { "ae_sp24x2s.c", ICLASS_icls_AE_SP24X2S_C,
    0,
    Opcode_ae_sp24x2s_c_encode_fns, 0, 0 },
  { "ae_lp24x2f.c", ICLASS_icls_AE_LP24X2F_C,
    0,
    Opcode_ae_lp24x2f_c_encode_fns, 0, 0 },
  { "ae_sp24x2f.c", ICLASS_icls_AE_SP24X2F_C,
    0,
    Opcode_ae_sp24x2f_c_encode_fns, 0, 0 },
  { "ae_lp16x2f.c", ICLASS_icls_AE_LP16X2F_C,
    0,
    Opcode_ae_lp16x2f_c_encode_fns, 0, 0 },
  { "ae_sp16x2f.c", ICLASS_icls_AE_SP16X2F_C,
    0,
    Opcode_ae_sp16x2f_c_encode_fns, 0, 0 },
  { "ae_lp24.c", ICLASS_icls_AE_LP24_C,
    0,
    Opcode_ae_lp24_c_encode_fns, 0, 0 },
  { "ae_sp24s.l.c", ICLASS_icls_AE_SP24S_L_C,
    0,
    Opcode_ae_sp24s_l_c_encode_fns, 0, 0 },
  { "ae_lp24f.c", ICLASS_icls_AE_LP24F_C,
    0,
    Opcode_ae_lp24f_c_encode_fns, 0, 0 },
  { "ae_sp24f.l.c", ICLASS_icls_AE_SP24F_L_C,
    0,
    Opcode_ae_sp24f_l_c_encode_fns, 0, 0 },
  { "ae_lp16f.c", ICLASS_icls_AE_LP16F_C,
    0,
    Opcode_ae_lp16f_c_encode_fns, 0, 0 },
  { "ae_sp16f.l.c", ICLASS_icls_AE_SP16F_L_C,
    0,
    Opcode_ae_sp16f_l_c_encode_fns, 0, 0 },
  { "ae_lq56.c", ICLASS_icls_AE_LQ56_C,
    0,
    Opcode_ae_lq56_c_encode_fns, 0, 0 },
  { "ae_sq56s.c", ICLASS_icls_AE_SQ56S_C,
    0,
    Opcode_ae_sq56s_c_encode_fns, 0, 0 },
  { "ae_lq32f.c", ICLASS_icls_AE_LQ32F_C,
    0,
    Opcode_ae_lq32f_c_encode_fns, 0, 0 },
  { "ae_sq32f.c", ICLASS_icls_AE_SQ32F_C,
    0,
    Opcode_ae_sq32f_c_encode_fns, 0, 0 },
  { "rur.expstate", ICLASS_rur_expstate,
    0,
    Opcode_rur_expstate_encode_fns, 0, 0 },
  { "wur.expstate", ICLASS_wur_expstate,
    0,
    Opcode_wur_expstate_encode_fns, 0, 0 },
  { "read_impwire", ICLASS_iclass_READ_IMPWIRE,
    0,
    Opcode_read_impwire_encode_fns, 0, 0 },
  { "setb_expstate", ICLASS_iclass_SETB_EXPSTATE,
    0,
    Opcode_setb_expstate_encode_fns, 0, 0 },
  { "clrb_expstate", ICLASS_iclass_CLRB_EXPSTATE,
    0,
    Opcode_clrb_expstate_encode_fns, 0, 0 },
  { "wrmsk_expstate", ICLASS_iclass_WRMSK_EXPSTATE,
    0,
    Opcode_wrmsk_expstate_encode_fns, 0, 0 }
};

enum xtensa_opcode_id {
  OPCODE_EXCW,
  OPCODE_RFE,
  OPCODE_RFDE,
  OPCODE_SYSCALL,
  OPCODE_CALL12,
  OPCODE_CALL8,
  OPCODE_CALL4,
  OPCODE_CALLX12,
  OPCODE_CALLX8,
  OPCODE_CALLX4,
  OPCODE_ENTRY,
  OPCODE_MOVSP,
  OPCODE_ROTW,
  OPCODE_RETW,
  OPCODE_RETW_N,
  OPCODE_RFWO,
  OPCODE_RFWU,
  OPCODE_L32E,
  OPCODE_S32E,
  OPCODE_RSR_WINDOWBASE,
  OPCODE_WSR_WINDOWBASE,
  OPCODE_XSR_WINDOWBASE,
  OPCODE_RSR_WINDOWSTART,
  OPCODE_WSR_WINDOWSTART,
  OPCODE_XSR_WINDOWSTART,
  OPCODE_ADD_N,
  OPCODE_ADDI_N,
  OPCODE_BEQZ_N,
  OPCODE_BNEZ_N,
  OPCODE_ILL_N,
  OPCODE_L32I_N,
  OPCODE_MOV_N,
  OPCODE_MOVI_N,
  OPCODE_NOP_N,
  OPCODE_RET_N,
  OPCODE_S32I_N,
  OPCODE_RUR_THREADPTR,
  OPCODE_WUR_THREADPTR,
  OPCODE_ADDI,
  OPCODE_ADDMI,
  OPCODE_ADD,
  OPCODE_SUB,
  OPCODE_ADDX2,
  OPCODE_ADDX4,
  OPCODE_ADDX8,
  OPCODE_SUBX2,
  OPCODE_SUBX4,
  OPCODE_SUBX8,
  OPCODE_AND,
  OPCODE_OR,
  OPCODE_XOR,
  OPCODE_BEQI,
  OPCODE_BNEI,
  OPCODE_BGEI,
  OPCODE_BLTI,
  OPCODE_BBCI,
  OPCODE_BBSI,
  OPCODE_BGEUI,
  OPCODE_BLTUI,
  OPCODE_BEQ,
  OPCODE_BNE,
  OPCODE_BGE,
  OPCODE_BLT,
  OPCODE_BGEU,
  OPCODE_BLTU,
  OPCODE_BANY,
  OPCODE_BNONE,
  OPCODE_BALL,
  OPCODE_BNALL,
  OPCODE_BBC,
  OPCODE_BBS,
  OPCODE_BEQZ,
  OPCODE_BNEZ,
  OPCODE_BGEZ,
  OPCODE_BLTZ,
  OPCODE_CALL0,
  OPCODE_CALLX0,
  OPCODE_EXTUI,
  OPCODE_ILL,
  OPCODE_J,
  OPCODE_JX,
  OPCODE_L16UI,
  OPCODE_L16SI,
  OPCODE_L32I,
  OPCODE_L32R,
  OPCODE_L8UI,
  OPCODE_LOOP,
  OPCODE_LOOPNEZ,
  OPCODE_LOOPGTZ,
  OPCODE_MOVI,
  OPCODE_MOVEQZ,
  OPCODE_MOVNEZ,
  OPCODE_MOVLTZ,
  OPCODE_MOVGEZ,
  OPCODE_NEG,
  OPCODE_ABS,
  OPCODE_NOP,
  OPCODE_RET,
  OPCODE_SIMCALL,
  OPCODE_S16I,
  OPCODE_S32I,
  OPCODE_S32NB,
  OPCODE_S8I,
  OPCODE_SSR,
  OPCODE_SSL,
  OPCODE_SSA8L,
  OPCODE_SSA8B,
  OPCODE_SSAI,
  OPCODE_SLL,
  OPCODE_SRC,
  OPCODE_SRL,
  OPCODE_SRA,
  OPCODE_SLLI,
  OPCODE_SRAI,
  OPCODE_SRLI,
  OPCODE_MEMW,
  OPCODE_EXTW,
  OPCODE_ISYNC,
  OPCODE_RSYNC,
  OPCODE_ESYNC,
  OPCODE_DSYNC,
  OPCODE_RSIL,
  OPCODE_RSR_LEND,
  OPCODE_WSR_LEND,
  OPCODE_XSR_LEND,
  OPCODE_RSR_LCOUNT,
  OPCODE_WSR_LCOUNT,
  OPCODE_XSR_LCOUNT,
  OPCODE_RSR_LBEG,
  OPCODE_WSR_LBEG,
  OPCODE_XSR_LBEG,
  OPCODE_RSR_SAR,
  OPCODE_WSR_SAR,
  OPCODE_XSR_SAR,
  OPCODE_RSR_MEMCTL,
  OPCODE_WSR_MEMCTL,
  OPCODE_XSR_MEMCTL,
  OPCODE_RSR_LITBASE,
  OPCODE_WSR_LITBASE,
  OPCODE_XSR_LITBASE,
  OPCODE_RSR_CONFIGID0,
  OPCODE_WSR_CONFIGID0,
  OPCODE_RSR_CONFIGID1,
  OPCODE_RSR_243,
  OPCODE_RSR_PS,
  OPCODE_WSR_PS,
  OPCODE_XSR_PS,
  OPCODE_RSR_EPC1,
  OPCODE_WSR_EPC1,
  OPCODE_XSR_EPC1,
  OPCODE_RSR_EXCSAVE1,
  OPCODE_WSR_EXCSAVE1,
  OPCODE_XSR_EXCSAVE1,
  OPCODE_RSR_EPC2,
  OPCODE_WSR_EPC2,
  OPCODE_XSR_EPC2,
  OPCODE_RSR_EXCSAVE2,
  OPCODE_WSR_EXCSAVE2,
  OPCODE_XSR_EXCSAVE2,
  OPCODE_RSR_EPC3,
  OPCODE_WSR_EPC3,
  OPCODE_XSR_EPC3,
  OPCODE_RSR_EXCSAVE3,
  OPCODE_WSR_EXCSAVE3,
  OPCODE_XSR_EXCSAVE3,
  OPCODE_RSR_EPC4,
  OPCODE_WSR_EPC4,
  OPCODE_XSR_EPC4,
  OPCODE_RSR_EXCSAVE4,
  OPCODE_WSR_EXCSAVE4,
  OPCODE_XSR_EXCSAVE4,
  OPCODE_RSR_EPC5,
  OPCODE_WSR_EPC5,
  OPCODE_XSR_EPC5,
  OPCODE_RSR_EXCSAVE5,
  OPCODE_WSR_EXCSAVE5,
  OPCODE_XSR_EXCSAVE5,
  OPCODE_RSR_EPC6,
  OPCODE_WSR_EPC6,
  OPCODE_XSR_EPC6,
  OPCODE_RSR_EXCSAVE6,
  OPCODE_WSR_EXCSAVE6,
  OPCODE_XSR_EXCSAVE6,
  OPCODE_RSR_EPC7,
  OPCODE_WSR_EPC7,
  OPCODE_XSR_EPC7,
  OPCODE_RSR_EXCSAVE7,
  OPCODE_WSR_EXCSAVE7,
  OPCODE_XSR_EXCSAVE7,
  OPCODE_RSR_EPS2,
  OPCODE_WSR_EPS2,
  OPCODE_XSR_EPS2,
  OPCODE_RSR_EPS3,
  OPCODE_WSR_EPS3,
  OPCODE_XSR_EPS3,
  OPCODE_RSR_EPS4,
  OPCODE_WSR_EPS4,
  OPCODE_XSR_EPS4,
  OPCODE_RSR_EPS5,
  OPCODE_WSR_EPS5,
  OPCODE_XSR_EPS5,
  OPCODE_RSR_EPS6,
  OPCODE_WSR_EPS6,
  OPCODE_XSR_EPS6,
  OPCODE_RSR_EPS7,
  OPCODE_WSR_EPS7,
  OPCODE_XSR_EPS7,
  OPCODE_RSR_EXCVADDR,
  OPCODE_WSR_EXCVADDR,
  OPCODE_XSR_EXCVADDR,
  OPCODE_RSR_DEPC,
  OPCODE_WSR_DEPC,
  OPCODE_XSR_DEPC,
  OPCODE_RSR_EXCCAUSE,
  OPCODE_WSR_EXCCAUSE,
  OPCODE_XSR_EXCCAUSE,
  OPCODE_RSR_MISC0,
  OPCODE_WSR_MISC0,
  OPCODE_XSR_MISC0,
  OPCODE_RSR_MISC1,
  OPCODE_WSR_MISC1,
  OPCODE_XSR_MISC1,
  OPCODE_RSR_PRID,
  OPCODE_RSR_VECBASE,
  OPCODE_WSR_VECBASE,
  OPCODE_XSR_VECBASE,
  OPCODE_MUL16U,
  OPCODE_MUL16S,
  OPCODE_MULL,
  OPCODE_MULUH,
  OPCODE_MULSH,
  OPCODE_MUL_AA_LL,
  OPCODE_MUL_AA_HL,
  OPCODE_MUL_AA_LH,
  OPCODE_MUL_AA_HH,
  OPCODE_UMUL_AA_LL,
  OPCODE_UMUL_AA_HL,
  OPCODE_UMUL_AA_LH,
  OPCODE_UMUL_AA_HH,
  OPCODE_MUL_AD_LL,
  OPCODE_MUL_AD_HL,
  OPCODE_MUL_AD_LH,
  OPCODE_MUL_AD_HH,
  OPCODE_MUL_DA_LL,
  OPCODE_MUL_DA_HL,
  OPCODE_MUL_DA_LH,
  OPCODE_MUL_DA_HH,
  OPCODE_MUL_DD_LL,
  OPCODE_MUL_DD_HL,
  OPCODE_MUL_DD_LH,
  OPCODE_MUL_DD_HH,
  OPCODE_MULA_AA_LL,
  OPCODE_MULA_AA_HL,
  OPCODE_MULA_AA_LH,
  OPCODE_MULA_AA_HH,
  OPCODE_MULS_AA_LL,
  OPCODE_MULS_AA_HL,
  OPCODE_MULS_AA_LH,
  OPCODE_MULS_AA_HH,
  OPCODE_MULA_AD_LL,
  OPCODE_MULA_AD_HL,
  OPCODE_MULA_AD_LH,
  OPCODE_MULA_AD_HH,
  OPCODE_MULS_AD_LL,
  OPCODE_MULS_AD_HL,
  OPCODE_MULS_AD_LH,
  OPCODE_MULS_AD_HH,
  OPCODE_MULA_DA_LL,
  OPCODE_MULA_DA_HL,
  OPCODE_MULA_DA_LH,
  OPCODE_MULA_DA_HH,
  OPCODE_MULS_DA_LL,
  OPCODE_MULS_DA_HL,
  OPCODE_MULS_DA_LH,
  OPCODE_MULS_DA_HH,
  OPCODE_MULA_DD_LL,
  OPCODE_MULA_DD_HL,
  OPCODE_MULA_DD_LH,
  OPCODE_MULA_DD_HH,
  OPCODE_MULS_DD_LL,
  OPCODE_MULS_DD_HL,
  OPCODE_MULS_DD_LH,
  OPCODE_MULS_DD_HH,
  OPCODE_MULA_DA_LL_LDDEC,
  OPCODE_MULA_DA_LL_LDINC,
  OPCODE_MULA_DA_HL_LDDEC,
  OPCODE_MULA_DA_HL_LDINC,
  OPCODE_MULA_DA_LH_LDDEC,
  OPCODE_MULA_DA_LH_LDINC,
  OPCODE_MULA_DA_HH_LDDEC,
  OPCODE_MULA_DA_HH_LDINC,
  OPCODE_MULA_DD_LL_LDDEC,
  OPCODE_MULA_DD_LL_LDINC,
  OPCODE_MULA_DD_HL_LDDEC,
  OPCODE_MULA_DD_HL_LDINC,
  OPCODE_MULA_DD_LH_LDDEC,
  OPCODE_MULA_DD_LH_LDINC,
  OPCODE_MULA_DD_HH_LDDEC,
  OPCODE_MULA_DD_HH_LDINC,
  OPCODE_LDDEC,
  OPCODE_LDINC,
  OPCODE_RSR_M0,
  OPCODE_WSR_M0,
  OPCODE_XSR_M0,
  OPCODE_RSR_M1,
  OPCODE_WSR_M1,
  OPCODE_XSR_M1,
  OPCODE_RSR_M2,
  OPCODE_WSR_M2,
  OPCODE_XSR_M2,
  OPCODE_RSR_M3,
  OPCODE_WSR_M3,
  OPCODE_XSR_M3,
  OPCODE_RSR_ACCLO,
  OPCODE_WSR_ACCLO,
  OPCODE_XSR_ACCLO,
  OPCODE_RSR_ACCHI,
  OPCODE_WSR_ACCHI,
  OPCODE_XSR_ACCHI,
  OPCODE_RFI,
  OPCODE_WAITI,
  OPCODE_RSR_INTERRUPT,
  OPCODE_WSR_INTSET,
  OPCODE_WSR_INTCLEAR,
  OPCODE_RSR_INTENABLE,
  OPCODE_WSR_INTENABLE,
  OPCODE_XSR_INTENABLE,
  OPCODE_BREAK,
  OPCODE_BREAK_N,
  OPCODE_RSR_DBREAKA0,
  OPCODE_WSR_DBREAKA0,
  OPCODE_XSR_DBREAKA0,
  OPCODE_RSR_DBREAKC0,
  OPCODE_WSR_DBREAKC0,
  OPCODE_XSR_DBREAKC0,
  OPCODE_RSR_DBREAKA1,
  OPCODE_WSR_DBREAKA1,
  OPCODE_XSR_DBREAKA1,
  OPCODE_RSR_DBREAKC1,
  OPCODE_WSR_DBREAKC1,
  OPCODE_XSR_DBREAKC1,
  OPCODE_RSR_IBREAKA0,
  OPCODE_WSR_IBREAKA0,
  OPCODE_XSR_IBREAKA0,
  OPCODE_RSR_IBREAKA1,
  OPCODE_WSR_IBREAKA1,
  OPCODE_XSR_IBREAKA1,
  OPCODE_RSR_IBREAKENABLE,
  OPCODE_WSR_IBREAKENABLE,
  OPCODE_XSR_IBREAKENABLE,
  OPCODE_RSR_DEBUGCAUSE,
  OPCODE_WSR_DEBUGCAUSE,
  OPCODE_XSR_DEBUGCAUSE,
  OPCODE_RSR_ICOUNT,
  OPCODE_WSR_ICOUNT,
  OPCODE_XSR_ICOUNT,
  OPCODE_RSR_ICOUNTLEVEL,
  OPCODE_WSR_ICOUNTLEVEL,
  OPCODE_XSR_ICOUNTLEVEL,
  OPCODE_RSR_DDR,
  OPCODE_WSR_DDR,
  OPCODE_XSR_DDR,
  OPCODE_LDDR32_P,
  OPCODE_SDDR32_P,
  OPCODE_RFDO,
  OPCODE_RFDD,
  OPCODE_WSR_MMID,
  OPCODE_ANDB,
  OPCODE_ANDBC,
  OPCODE_ORB,
  OPCODE_ORBC,
  OPCODE_XORB,
  OPCODE_ANY4,
  OPCODE_ALL4,
  OPCODE_ANY8,
  OPCODE_ALL8,
  OPCODE_BF,
  OPCODE_BT,
  OPCODE_MOVF,
  OPCODE_MOVT,
  OPCODE_RSR_BR,
  OPCODE_WSR_BR,
  OPCODE_XSR_BR,
  OPCODE_RSR_CCOUNT,
  OPCODE_WSR_CCOUNT,
  OPCODE_XSR_CCOUNT,
  OPCODE_RSR_CCOMPARE0,
  OPCODE_WSR_CCOMPARE0,
  OPCODE_XSR_CCOMPARE0,
  OPCODE_RSR_CCOMPARE1,
  OPCODE_WSR_CCOMPARE1,
  OPCODE_XSR_CCOMPARE1,
  OPCODE_RSR_CCOMPARE2,
  OPCODE_WSR_CCOMPARE2,
  OPCODE_XSR_CCOMPARE2,
  OPCODE_IPF,
  OPCODE_IHI,
  OPCODE_IPFL,
  OPCODE_IHU,
  OPCODE_IIU,
  OPCODE_III,
  OPCODE_LICT,
  OPCODE_LICW,
  OPCODE_SICT,
  OPCODE_SICW,
  OPCODE_DHWB,
  OPCODE_DHWBI,
  OPCODE_DIWBUI_P,
  OPCODE_DIWB,
  OPCODE_DIWBI,
  OPCODE_DHI,
  OPCODE_DII,
  OPCODE_DPFR,
  OPCODE_DPFW,
  OPCODE_DPFRO,
  OPCODE_DPFWO,
  OPCODE_DPFL,
  OPCODE_DHU,
  OPCODE_DIU,
  OPCODE_SDCT,
  OPCODE_LDCT,
  OPCODE_RSR_PREFCTL,
  OPCODE_WSR_PREFCTL,
  OPCODE_XSR_PREFCTL,
  OPCODE_WSR_PTEVADDR,
  OPCODE_RSR_PTEVADDR,
  OPCODE_XSR_PTEVADDR,
  OPCODE_RSR_RASID,
  OPCODE_WSR_RASID,
  OPCODE_XSR_RASID,
  OPCODE_RSR_ITLBCFG,
  OPCODE_WSR_ITLBCFG,
  OPCODE_XSR_ITLBCFG,
  OPCODE_RSR_DTLBCFG,
  OPCODE_WSR_DTLBCFG,
  OPCODE_XSR_DTLBCFG,
  OPCODE_IDTLB,
  OPCODE_PDTLB,
  OPCODE_RDTLB0,
  OPCODE_RDTLB1,
  OPCODE_WDTLB,
  OPCODE_IITLB,
  OPCODE_PITLB,
  OPCODE_RITLB0,
  OPCODE_RITLB1,
  OPCODE_WITLB,
  OPCODE_LDPTE,
  OPCODE_HWWITLBA,
  OPCODE_HWWDTLBA,
  OPCODE_RSR_CPENABLE,
  OPCODE_WSR_CPENABLE,
  OPCODE_XSR_CPENABLE,
  OPCODE_CLAMPS,
  OPCODE_MIN,
  OPCODE_MAX,
  OPCODE_MINU,
  OPCODE_MAXU,
  OPCODE_NSA,
  OPCODE_NSAU,
  OPCODE_SEXT,
  OPCODE_L32AI,
  OPCODE_S32RI,
  OPCODE_S32C1I,
  OPCODE_RSR_SCOMPARE1,
  OPCODE_WSR_SCOMPARE1,
  OPCODE_XSR_SCOMPARE1,
  OPCODE_RSR_ATOMCTL,
  OPCODE_WSR_ATOMCTL,
  OPCODE_XSR_ATOMCTL,
  OPCODE_QUOU,
  OPCODE_QUOS,
  OPCODE_REMU,
  OPCODE_REMS,
  OPCODE_RER,
  OPCODE_WER,
  OPCODE_RUR_AE_OVF_SAR,
  OPCODE_WUR_AE_OVF_SAR,
  OPCODE_RUR_AE_BITHEAD,
  OPCODE_WUR_AE_BITHEAD,
  OPCODE_RUR_AE_TS_FTS_BU_BP,
  OPCODE_WUR_AE_TS_FTS_BU_BP,
  OPCODE_RUR_AE_SD_NO,
  OPCODE_WUR_AE_SD_NO,
  OPCODE_RUR_AE_OVERFLOW,
  OPCODE_WUR_AE_OVERFLOW,
  OPCODE_RUR_AE_SAR,
  OPCODE_WUR_AE_SAR,
  OPCODE_RUR_AE_BITPTR,
  OPCODE_WUR_AE_BITPTR,
  OPCODE_RUR_AE_BITSUSED,
  OPCODE_WUR_AE_BITSUSED,
  OPCODE_RUR_AE_TABLESIZE,
  OPCODE_WUR_AE_TABLESIZE,
  OPCODE_RUR_AE_FIRST_TS,
  OPCODE_WUR_AE_FIRST_TS,
  OPCODE_RUR_AE_NEXTOFFSET,
  OPCODE_WUR_AE_NEXTOFFSET,
  OPCODE_RUR_AE_SEARCHDONE,
  OPCODE_WUR_AE_SEARCHDONE,
  OPCODE_AE_LP16F_I,
  OPCODE_AE_LP16F_IU,
  OPCODE_AE_LP16F_X,
  OPCODE_AE_LP16F_XU,
  OPCODE_AE_LP24_I,
  OPCODE_AE_LP24_IU,
  OPCODE_AE_LP24_X,
  OPCODE_AE_LP24_XU,
  OPCODE_AE_LP24F_I,
  OPCODE_AE_LP24F_IU,
  OPCODE_AE_LP24F_X,
  OPCODE_AE_LP24F_XU,
  OPCODE_AE_LP16X2F_I,
  OPCODE_AE_LP16X2F_IU,
  OPCODE_AE_LP16X2F_X,
  OPCODE_AE_LP16X2F_XU,
  OPCODE_AE_LP24X2F_I,
  OPCODE_AE_LP24X2F_IU,
  OPCODE_AE_LP24X2F_X,
  OPCODE_AE_LP24X2F_XU,
  OPCODE_AE_LP24X2_I,
  OPCODE_AE_LP24X2_IU,
  OPCODE_AE_LP24X2_X,
  OPCODE_AE_LP24X2_XU,
  OPCODE_AE_SP16X2F_I,
  OPCODE_AE_SP16X2F_IU,
  OPCODE_AE_SP16X2F_X,
  OPCODE_AE_SP16X2F_XU,
  OPCODE_AE_SP24X2S_I,
  OPCODE_AE_SP24X2S_IU,
  OPCODE_AE_SP24X2S_X,
  OPCODE_AE_SP24X2S_XU,
  OPCODE_AE_SP24X2F_I,
  OPCODE_AE_SP24X2F_IU,
  OPCODE_AE_SP24X2F_X,
  OPCODE_AE_SP24X2F_XU,
  OPCODE_AE_SP16F_L_I,
  OPCODE_AE_SP16F_L_IU,
  OPCODE_AE_SP16F_L_X,
  OPCODE_AE_SP16F_L_XU,
  OPCODE_AE_SP24S_L_I,
  OPCODE_AE_SP24S_L_IU,
  OPCODE_AE_SP24S_L_X,
  OPCODE_AE_SP24S_L_XU,
  OPCODE_AE_SP24F_L_I,
  OPCODE_AE_SP24F_L_IU,
  OPCODE_AE_SP24F_L_X,
  OPCODE_AE_SP24F_L_XU,
  OPCODE_AE_LQ56_I,
  OPCODE_AE_LQ56_IU,
  OPCODE_AE_LQ56_X,
  OPCODE_AE_LQ56_XU,
  OPCODE_AE_LQ32F_I,
  OPCODE_AE_LQ32F_IU,
  OPCODE_AE_LQ32F_X,
  OPCODE_AE_LQ32F_XU,
  OPCODE_AE_SQ56S_I,
  OPCODE_AE_SQ56S_IU,
  OPCODE_AE_SQ56S_X,
  OPCODE_AE_SQ56S_XU,
  OPCODE_AE_SQ32F_I,
  OPCODE_AE_SQ32F_IU,
  OPCODE_AE_SQ32F_X,
  OPCODE_AE_SQ32F_XU,
  OPCODE_AE_ZEROP48,
  OPCODE_AE_MOVP48,
  OPCODE_AE_SELP24_LL,
  OPCODE_AE_SELP24_LH,
  OPCODE_AE_SELP24_HL,
  OPCODE_AE_SELP24_HH,
  OPCODE_AE_MOVTP24X2,
  OPCODE_AE_MOVFP24X2,
  OPCODE_AE_MOVTP48,
  OPCODE_AE_MOVFP48,
  OPCODE_AE_MOVPA24X2,
  OPCODE_AE_TRUNCP24A32X2,
  OPCODE_AE_CVTA32P24_L,
  OPCODE_AE_CVTA32P24_H,
  OPCODE_AE_CVTP24A16X2_LL,
  OPCODE_AE_CVTP24A16X2_LH,
  OPCODE_AE_CVTP24A16X2_HL,
  OPCODE_AE_CVTP24A16X2_HH,
  OPCODE_AE_TRUNCP24Q48X2,
  OPCODE_AE_TRUNCP16,
  OPCODE_AE_ROUNDSP24Q48SYM,
  OPCODE_AE_ROUNDSP24Q48ASYM,
  OPCODE_AE_ROUNDSP16Q48SYM,
  OPCODE_AE_ROUNDSP16Q48ASYM,
  OPCODE_AE_ROUNDSP16SYM,
  OPCODE_AE_ROUNDSP16ASYM,
  OPCODE_AE_ZEROQ56,
  OPCODE_AE_MOVQ56,
  OPCODE_AE_MOVTQ56,
  OPCODE_AE_MOVFQ56,
  OPCODE_AE_CVTQ48A32S,
  OPCODE_AE_CVTQ48P24S_L,
  OPCODE_AE_CVTQ48P24S_H,
  OPCODE_AE_SATQ48S,
  OPCODE_AE_TRUNCQ32,
  OPCODE_AE_ROUNDSQ32SYM,
  OPCODE_AE_ROUNDSQ32ASYM,
  OPCODE_AE_TRUNCA32Q48,
  OPCODE_AE_MOVAP24S_L,
  OPCODE_AE_MOVAP24S_H,
  OPCODE_AE_TRUNCA16P24S_L,
  OPCODE_AE_TRUNCA16P24S_H,
  OPCODE_AE_ADDP24,
  OPCODE_AE_SUBP24,
  OPCODE_AE_NEGP24,
  OPCODE_AE_ABSP24,
  OPCODE_AE_MAXP24S,
  OPCODE_AE_MINP24S,
  OPCODE_AE_MAXBP24S,
  OPCODE_AE_MINBP24S,
  OPCODE_AE_ADDSP24S,
  OPCODE_AE_SUBSP24S,
  OPCODE_AE_NEGSP24S,
  OPCODE_AE_ABSSP24S,
  OPCODE_AE_ANDP48,
  OPCODE_AE_NANDP48,
  OPCODE_AE_ORP48,
  OPCODE_AE_XORP48,
  OPCODE_AE_LTP24S,
  OPCODE_AE_LEP24S,
  OPCODE_AE_EQP24,
  OPCODE_AE_ADDQ56,
  OPCODE_AE_SUBQ56,
  OPCODE_AE_NEGQ56,
  OPCODE_AE_ABSQ56,
  OPCODE_AE_MAXQ56S,
  OPCODE_AE_MINQ56S,
  OPCODE_AE_MAXBQ56S,
  OPCODE_AE_MINBQ56S,
  OPCODE_AE_ADDSQ56S,
  OPCODE_AE_SUBSQ56S,
  OPCODE_AE_NEGSQ56S,
  OPCODE_AE_ABSSQ56S,
  OPCODE_AE_ANDQ56,
  OPCODE_AE_NANDQ56,
  OPCODE_AE_ORQ56,
  OPCODE_AE_XORQ56,
  OPCODE_AE_SLLIP24,
  OPCODE_AE_SRLIP24,
  OPCODE_AE_SRAIP24,
  OPCODE_AE_SLLSP24,
  OPCODE_AE_SRLSP24,
  OPCODE_AE_SRASP24,
  OPCODE_AE_SLLISP24S,
  OPCODE_AE_SLLSSP24S,
  OPCODE_AE_SLLIQ56,
  OPCODE_AE_SRLIQ56,
  OPCODE_AE_SRAIQ56,
  OPCODE_AE_SLLSQ56,
  OPCODE_AE_SRLSQ56,
  OPCODE_AE_SRASQ56,
  OPCODE_AE_SLLAQ56,
  OPCODE_AE_SRLAQ56,
  OPCODE_AE_SRAAQ56,
  OPCODE_AE_SLLISQ56S,
  OPCODE_AE_SLLSSQ56S,
  OPCODE_AE_SLLASQ56S,
  OPCODE_AE_LTQ56S,
  OPCODE_AE_LEQ56S,
  OPCODE_AE_EQQ56,
  OPCODE_AE_NSAQ56S,
  OPCODE_AE_MULSRFQ32SP24S_H,
  OPCODE_AE_MULSRFQ32SP24S_L,
  OPCODE_AE_MULARFQ32SP24S_H,
  OPCODE_AE_MULARFQ32SP24S_L,
  OPCODE_AE_MULRFQ32SP24S_H,
  OPCODE_AE_MULRFQ32SP24S_L,
  OPCODE_AE_MULSFQ32SP24S_H,
  OPCODE_AE_MULSFQ32SP24S_L,
  OPCODE_AE_MULAFQ32SP24S_H,
  OPCODE_AE_MULAFQ32SP24S_L,
  OPCODE_AE_MULFQ32SP24S_H,
  OPCODE_AE_MULFQ32SP24S_L,
  OPCODE_AE_MULFS32P16S_LL,
  OPCODE_AE_MULFP24S_LL,
  OPCODE_AE_MULP24S_LL,
  OPCODE_AE_MULFS32P16S_LH,
  OPCODE_AE_MULFP24S_LH,
  OPCODE_AE_MULP24S_LH,
  OPCODE_AE_MULFS32P16S_HL,
  OPCODE_AE_MULFP24S_HL,
  OPCODE_AE_MULP24S_HL,
  OPCODE_AE_MULFS32P16S_HH,
  OPCODE_AE_MULFP24S_HH,
  OPCODE_AE_MULP24S_HH,
  OPCODE_AE_MULAFS32P16S_LL,
  OPCODE_AE_MULAFP24S_LL,
  OPCODE_AE_MULAP24S_LL,
  OPCODE_AE_MULAFS32P16S_LH,
  OPCODE_AE_MULAFP24S_LH,
  OPCODE_AE_MULAP24S_LH,
  OPCODE_AE_MULAFS32P16S_HL,
  OPCODE_AE_MULAFP24S_HL,
  OPCODE_AE_MULAP24S_HL,
  OPCODE_AE_MULAFS32P16S_HH,
  OPCODE_AE_MULAFP24S_HH,
  OPCODE_AE_MULAP24S_HH,
  OPCODE_AE_MULSFS32P16S_LL,
  OPCODE_AE_MULSFP24S_LL,
  OPCODE_AE_MULSP24S_LL,
  OPCODE_AE_MULSFS32P16S_LH,
  OPCODE_AE_MULSFP24S_LH,
  OPCODE_AE_MULSP24S_LH,
  OPCODE_AE_MULSFS32P16S_HL,
  OPCODE_AE_MULSFP24S_HL,
  OPCODE_AE_MULSP24S_HL,
  OPCODE_AE_MULSFS32P16S_HH,
  OPCODE_AE_MULSFP24S_HH,
  OPCODE_AE_MULSP24S_HH,
  OPCODE_AE_MULAFS56P24S_LL,
  OPCODE_AE_MULAS56P24S_LL,
  OPCODE_AE_MULAFS56P24S_LH,
  OPCODE_AE_MULAS56P24S_LH,
  OPCODE_AE_MULAFS56P24S_HL,
  OPCODE_AE_MULAS56P24S_HL,
  OPCODE_AE_MULAFS56P24S_HH,
  OPCODE_AE_MULAS56P24S_HH,
  OPCODE_AE_MULSFS56P24S_LL,
  OPCODE_AE_MULSS56P24S_LL,
  OPCODE_AE_MULSFS56P24S_LH,
  OPCODE_AE_MULSS56P24S_LH,
  OPCODE_AE_MULSFS56P24S_HL,
  OPCODE_AE_MULSS56P24S_HL,
  OPCODE_AE_MULSFS56P24S_HH,
  OPCODE_AE_MULSS56P24S_HH,
  OPCODE_AE_MULFQ32SP16S_L,
  OPCODE_AE_MULFQ32SP16S_H,
  OPCODE_AE_MULFQ32SP16U_L,
  OPCODE_AE_MULFQ32SP16U_H,
  OPCODE_AE_MULQ32SP16S_L,
  OPCODE_AE_MULQ32SP16S_H,
  OPCODE_AE_MULQ32SP16U_L,
  OPCODE_AE_MULQ32SP16U_H,
  OPCODE_AE_MULAFQ32SP16S_L,
  OPCODE_AE_MULAFQ32SP16S_H,
  OPCODE_AE_MULAFQ32SP16U_L,
  OPCODE_AE_MULAFQ32SP16U_H,
  OPCODE_AE_MULAQ32SP16S_L,
  OPCODE_AE_MULAQ32SP16S_H,
  OPCODE_AE_MULAQ32SP16U_L,
  OPCODE_AE_MULAQ32SP16U_H,
  OPCODE_AE_MULSFQ32SP16S_L,
  OPCODE_AE_MULSFQ32SP16S_H,
  OPCODE_AE_MULSFQ32SP16U_L,
  OPCODE_AE_MULSFQ32SP16U_H,
  OPCODE_AE_MULSQ32SP16S_L,
  OPCODE_AE_MULSQ32SP16S_H,
  OPCODE_AE_MULSQ32SP16U_L,
  OPCODE_AE_MULSQ32SP16U_H,
  OPCODE_AE_MULZAAQ32SP16S_LL,
  OPCODE_AE_MULZAAFQ32SP16S_LL,
  OPCODE_AE_MULZAAQ32SP16U_LL,
  OPCODE_AE_MULZAAFQ32SP16U_LL,
  OPCODE_AE_MULZAAQ32SP16S_HH,
  OPCODE_AE_MULZAAFQ32SP16S_HH,
  OPCODE_AE_MULZAAQ32SP16U_HH,
  OPCODE_AE_MULZAAFQ32SP16U_HH,
  OPCODE_AE_MULZAAQ32SP16S_LH,
  OPCODE_AE_MULZAAFQ32SP16S_LH,
  OPCODE_AE_MULZAAQ32SP16U_LH,
  OPCODE_AE_MULZAAFQ32SP16U_LH,
  OPCODE_AE_MULZASQ32SP16S_LL,
  OPCODE_AE_MULZASFQ32SP16S_LL,
  OPCODE_AE_MULZASQ32SP16U_LL,
  OPCODE_AE_MULZASFQ32SP16U_LL,
  OPCODE_AE_MULZASQ32SP16S_HH,
  OPCODE_AE_MULZASFQ32SP16S_HH,
  OPCODE_AE_MULZASQ32SP16U_HH,
  OPCODE_AE_MULZASFQ32SP16U_HH,
  OPCODE_AE_MULZASQ32SP16S_LH,
  OPCODE_AE_MULZASFQ32SP16S_LH,
  OPCODE_AE_MULZASQ32SP16U_LH,
  OPCODE_AE_MULZASFQ32SP16U_LH,
  OPCODE_AE_MULZSAQ32SP16S_LL,
  OPCODE_AE_MULZSAFQ32SP16S_LL,
  OPCODE_AE_MULZSAQ32SP16U_LL,
  OPCODE_AE_MULZSAFQ32SP16U_LL,
  OPCODE_AE_MULZSAQ32SP16S_HH,
  OPCODE_AE_MULZSAFQ32SP16S_HH,
  OPCODE_AE_MULZSAQ32SP16U_HH,
  OPCODE_AE_MULZSAFQ32SP16U_HH,
  OPCODE_AE_MULZSAQ32SP16S_LH,
  OPCODE_AE_MULZSAFQ32SP16S_LH,
  OPCODE_AE_MULZSAQ32SP16U_LH,
  OPCODE_AE_MULZSAFQ32SP16U_LH,
  OPCODE_AE_MULZSSQ32SP16S_LL,
  OPCODE_AE_MULZSSFQ32SP16S_LL,
  OPCODE_AE_MULZSSQ32SP16U_LL,
  OPCODE_AE_MULZSSFQ32SP16U_LL,
  OPCODE_AE_MULZSSQ32SP16S_HH,
  OPCODE_AE_MULZSSFQ32SP16S_HH,
  OPCODE_AE_MULZSSQ32SP16U_HH,
  OPCODE_AE_MULZSSFQ32SP16U_HH,
  OPCODE_AE_MULZSSQ32SP16S_LH,
  OPCODE_AE_MULZSSFQ32SP16S_LH,
  OPCODE_AE_MULZSSQ32SP16U_LH,
  OPCODE_AE_MULZSSFQ32SP16U_LH,
  OPCODE_AE_MULZAAFP24S_HH_LL,
  OPCODE_AE_MULZAAP24S_HH_LL,
  OPCODE_AE_MULZAAFP24S_HL_LH,
  OPCODE_AE_MULZAAP24S_HL_LH,
  OPCODE_AE_MULZASFP24S_HH_LL,
  OPCODE_AE_MULZASP24S_HH_LL,
  OPCODE_AE_MULZASFP24S_HL_LH,
  OPCODE_AE_MULZASP24S_HL_LH,
  OPCODE_AE_MULZSAFP24S_HH_LL,
  OPCODE_AE_MULZSAP24S_HH_LL,
  OPCODE_AE_MULZSAFP24S_HL_LH,
  OPCODE_AE_MULZSAP24S_HL_LH,
  OPCODE_AE_MULZSSFP24S_HH_LL,
  OPCODE_AE_MULZSSP24S_HH_LL,
  OPCODE_AE_MULZSSFP24S_HL_LH,
  OPCODE_AE_MULZSSP24S_HL_LH,
  OPCODE_AE_MULAAFP24S_HH_LL,
  OPCODE_AE_MULAAP24S_HH_LL,
  OPCODE_AE_MULAAFP24S_HL_LH,
  OPCODE_AE_MULAAP24S_HL_LH,
  OPCODE_AE_MULASFP24S_HH_LL,
  OPCODE_AE_MULASP24S_HH_LL,
  OPCODE_AE_MULASFP24S_HL_LH,
  OPCODE_AE_MULASP24S_HL_LH,
  OPCODE_AE_MULSAFP24S_HH_LL,
  OPCODE_AE_MULSAP24S_HH_LL,
  OPCODE_AE_MULSAFP24S_HL_LH,
  OPCODE_AE_MULSAP24S_HL_LH,
  OPCODE_AE_MULSSFP24S_HH_LL,
  OPCODE_AE_MULSSP24S_HH_LL,
  OPCODE_AE_MULSSFP24S_HL_LH,
  OPCODE_AE_MULSSP24S_HL_LH,
  OPCODE_AE_SHA32,
  OPCODE_AE_VLDL32T,
  OPCODE_AE_VLDL16T,
  OPCODE_AE_VLDL16C,
  OPCODE_AE_VLDSHT,
  OPCODE_AE_LB,
  OPCODE_AE_LBI,
  OPCODE_AE_LBK,
  OPCODE_AE_LBKI,
  OPCODE_AE_DB,
  OPCODE_AE_DBI,
  OPCODE_AE_VLEL32T,
  OPCODE_AE_VLEL16T,
  OPCODE_AE_SB,
  OPCODE_AE_SBI,
  OPCODE_AE_VLES16C,
  OPCODE_AE_SBF,
  OPCODE_AE_SLAASQ56S,
  OPCODE_AE_ADDBRBA32,
  OPCODE_AE_MINABSSP24S,
  OPCODE_AE_MAXABSSP24S,
  OPCODE_AE_MINABSSQ56S,
  OPCODE_AE_MAXABSSQ56S,
  OPCODE_RUR_AE_CBEGIN0,
  OPCODE_WUR_AE_CBEGIN0,
  OPCODE_RUR_AE_CEND0,
  OPCODE_WUR_AE_CEND0,
  OPCODE_AE_LP24X2_C,
  OPCODE_AE_SP24X2S_C,
  OPCODE_AE_LP24X2F_C,
  OPCODE_AE_SP24X2F_C,
  OPCODE_AE_LP16X2F_C,
  OPCODE_AE_SP16X2F_C,
  OPCODE_AE_LP24_C,
  OPCODE_AE_SP24S_L_C,
  OPCODE_AE_LP24F_C,
  OPCODE_AE_SP24F_L_C,
  OPCODE_AE_LP16F_C,
  OPCODE_AE_SP16F_L_C,
  OPCODE_AE_LQ56_C,
  OPCODE_AE_SQ56S_C,
  OPCODE_AE_LQ32F_C,
  OPCODE_AE_SQ32F_C,
  OPCODE_RUR_EXPSTATE,
  OPCODE_WUR_EXPSTATE,
  OPCODE_READ_IMPWIRE,
  OPCODE_SETB_EXPSTATE,
  OPCODE_CLRB_EXPSTATE,
  OPCODE_WRMSK_EXPSTATE
};


/* Slot-specific opcode decode functions.  */

static int
Slot_inst_decode (const xtensa_insnbuf insn)
{
  if (Field_op0_Slot_inst_get (insn) == 0)
    {
      if (Field_op1_Slot_inst_get (insn) == 0)
	{
	  if (Field_op2_Slot_inst_get (insn) == 0)
	    {
	      if (Field_r_Slot_inst_get (insn) == 0)
		{
		  if (Field_m_Slot_inst_get (insn) == 0 &&
		      Field_s_Slot_inst_get (insn) == 0 &&
		      Field_n_Slot_inst_get (insn) == 0)
		    return OPCODE_ILL;
		  if (Field_m_Slot_inst_get (insn) == 2)
		    {
		      if (Field_n_Slot_inst_get (insn) == 0)
			return OPCODE_RET;
		      if (Field_n_Slot_inst_get (insn) == 1)
			return OPCODE_RETW;
		      if (Field_n_Slot_inst_get (insn) == 2)
			return OPCODE_JX;
		    }
		  if (Field_m_Slot_inst_get (insn) == 3)
		    {
		      if (Field_n_Slot_inst_get (insn) == 0)
			return OPCODE_CALLX0;
		      if (Field_n_Slot_inst_get (insn) == 1)
			return OPCODE_CALLX4;
		      if (Field_n_Slot_inst_get (insn) == 2)
			return OPCODE_CALLX8;
		      if (Field_n_Slot_inst_get (insn) == 3)
			return OPCODE_CALLX12;
		    }
		}
	      if (Field_r_Slot_inst_get (insn) == 1)
		return OPCODE_MOVSP;
	      if (Field_r_Slot_inst_get (insn) == 2)
		{
		  if (Field_s_Slot_inst_get (insn) == 0)
		    {
		      if (Field_t_Slot_inst_get (insn) == 0)
			return OPCODE_ISYNC;
		      if (Field_t_Slot_inst_get (insn) == 1)
			return OPCODE_RSYNC;
		      if (Field_t_Slot_inst_get (insn) == 2)
			return OPCODE_ESYNC;
		      if (Field_t_Slot_inst_get (insn) == 3)
			return OPCODE_DSYNC;
		      if (Field_t_Slot_inst_get (insn) == 8)
			return OPCODE_EXCW;
		      if (Field_t_Slot_inst_get (insn) == 12)
			return OPCODE_MEMW;
		      if (Field_t_Slot_inst_get (insn) == 13)
			return OPCODE_EXTW;
		      if (Field_t_Slot_inst_get (insn) == 15)
			return OPCODE_NOP;
		    }
		}
	      if (Field_r_Slot_inst_get (insn) == 3)
		{
		  if (Field_t_Slot_inst_get (insn) == 0)
		    {
		      if (Field_s_Slot_inst_get (insn) == 0)
			return OPCODE_RFE;
		      if (Field_s_Slot_inst_get (insn) == 2)
			return OPCODE_RFDE;
		      if (Field_s_Slot_inst_get (insn) == 4)
			return OPCODE_RFWO;
		      if (Field_s_Slot_inst_get (insn) == 5)
			return OPCODE_RFWU;
		    }
		  if (Field_t_Slot_inst_get (insn) == 1)
		    return OPCODE_RFI;
		}
	      if (Field_r_Slot_inst_get (insn) == 4)
		return OPCODE_BREAK;
	      if (Field_r_Slot_inst_get (insn) == 5)
		{
		  if (Field_s_Slot_inst_get (insn) == 0 &&
		      Field_t_Slot_inst_get (insn) == 0)
		    return OPCODE_SYSCALL;
		  if (Field_s_Slot_inst_get (insn) == 1 &&
		      Field_t_Slot_inst_get (insn) == 0)
		    return OPCODE_SIMCALL;
		}
	      if (Field_r_Slot_inst_get (insn) == 6)
		return OPCODE_RSIL;
	      if (Field_r_Slot_inst_get (insn) == 7 &&
		  Field_t_Slot_inst_get (insn) == 0)
		return OPCODE_WAITI;
	      if (Field_r_Slot_inst_get (insn) == 7)
		{
		  if (Field_t_Slot_inst_get (insn) == 14)
		    return OPCODE_LDDR32_P;
		  if (Field_t_Slot_inst_get (insn) == 15)
		    return OPCODE_SDDR32_P;
		}
	      if (Field_r_Slot_inst_get (insn) == 8)
		return OPCODE_ANY4;
	      if (Field_r_Slot_inst_get (insn) == 9)
		return OPCODE_ALL4;
	      if (Field_r_Slot_inst_get (insn) == 10)
		return OPCODE_ANY8;
	      if (Field_r_Slot_inst_get (insn) == 11)
		return OPCODE_ALL8;
	    }
	  if (Field_op2_Slot_inst_get (insn) == 1)
	    return OPCODE_AND;
	  if (Field_op2_Slot_inst_get (insn) == 2)
	    return OPCODE_OR;
	  if (Field_op2_Slot_inst_get (insn) == 3)
	    return OPCODE_XOR;
	  if (Field_op2_Slot_inst_get (insn) == 4)
	    {
	      if (Field_r_Slot_inst_get (insn) == 0 &&
		  Field_t_Slot_inst_get (insn) == 0)
		return OPCODE_SSR;
	      if (Field_r_Slot_inst_get (insn) == 1 &&
		  Field_t_Slot_inst_get (insn) == 0)
		return OPCODE_SSL;
	      if (Field_r_Slot_inst_get (insn) == 2 &&
		  Field_t_Slot_inst_get (insn) == 0)
		return OPCODE_SSA8L;
	      if (Field_r_Slot_inst_get (insn) == 3 &&
		  Field_t_Slot_inst_get (insn) == 0)
		return OPCODE_SSA8B;
	      if (Field_r_Slot_inst_get (insn) == 4 &&
		  Field_thi3_Slot_inst_get (insn) == 0)
		return OPCODE_SSAI;
	      if (Field_r_Slot_inst_get (insn) == 6)
		return OPCODE_RER;
	      if (Field_r_Slot_inst_get (insn) == 7)
		return OPCODE_WER;
	      if (Field_r_Slot_inst_get (insn) == 8 &&
		  Field_s_Slot_inst_get (insn) == 0)
		return OPCODE_ROTW;
	      if (Field_r_Slot_inst_get (insn) == 14)
		return OPCODE_NSA;
	      if (Field_r_Slot_inst_get (insn) == 15)
		return OPCODE_NSAU;
	    }
	  if (Field_op2_Slot_inst_get (insn) == 5)
	    {
	      if (Field_r_Slot_inst_get (insn) == 1)
		return OPCODE_HWWITLBA;
	      if (Field_r_Slot_inst_get (insn) == 3)
		return OPCODE_RITLB0;
	      if (Field_r_Slot_inst_get (insn) == 4 &&
		  Field_t_Slot_inst_get (insn) == 0)
		return OPCODE_IITLB;
	      if (Field_r_Slot_inst_get (insn) == 5)
		return OPCODE_PITLB;
	      if (Field_r_Slot_inst_get (insn) == 6)
		return OPCODE_WITLB;
	      if (Field_r_Slot_inst_get (insn) == 7)
		return OPCODE_RITLB1;
	      if (Field_r_Slot_inst_get (insn) == 9)
		return OPCODE_HWWDTLBA;
	      if (Field_r_Slot_inst_get (insn) == 11)
		return OPCODE_RDTLB0;
	      if (Field_r_Slot_inst_get (insn) == 12 &&
		  Field_t_Slot_inst_get (insn) == 0)
		return OPCODE_IDTLB;
	      if (Field_r_Slot_inst_get (insn) == 13)
		return OPCODE_PDTLB;
	      if (Field_r_Slot_inst_get (insn) == 14)
		return OPCODE_WDTLB;
	      if (Field_r_Slot_inst_get (insn) == 15)
		return OPCODE_RDTLB1;
	    }
	  if (Field_op2_Slot_inst_get (insn) == 6)
	    {
	      if (Field_s_Slot_inst_get (insn) == 0)
		return OPCODE_NEG;
	      if (Field_s_Slot_inst_get (insn) == 1)
		return OPCODE_ABS;
	    }
	  if (Field_op2_Slot_inst_get (insn) == 8)
	    return OPCODE_ADD;
	  if (Field_op2_Slot_inst_get (insn) == 9)
	    return OPCODE_ADDX2;
	  if (Field_op2_Slot_inst_get (insn) == 10)
	    return OPCODE_ADDX4;
	  if (Field_op2_Slot_inst_get (insn) == 11)
	    return OPCODE_ADDX8;
	  if (Field_op2_Slot_inst_get (insn) == 12)
	    return OPCODE_SUB;
	  if (Field_op2_Slot_inst_get (insn) == 13)
	    return OPCODE_SUBX2;
	  if (Field_op2_Slot_inst_get (insn) == 14)
	    return OPCODE_SUBX4;
	  if (Field_op2_Slot_inst_get (insn) == 15)
	    return OPCODE_SUBX8;
	}
      if (Field_op1_Slot_inst_get (insn) == 1)
	{
	  if ((Field_op2_Slot_inst_get (insn) == 0 ||
	       Field_op2_Slot_inst_get (insn) == 1))
	    return OPCODE_SLLI;
	  if ((Field_op2_Slot_inst_get (insn) == 2 ||
	       Field_op2_Slot_inst_get (insn) == 3))
	    return OPCODE_SRAI;
	  if (Field_op2_Slot_inst_get (insn) == 4)
	    return OPCODE_SRLI;
	  if (Field_op2_Slot_inst_get (insn) == 6)
	    {
	      if (Field_sr_Slot_inst_get (insn) == 0)
		return OPCODE_XSR_LBEG;
	      if (Field_sr_Slot_inst_get (insn) == 1)
		return OPCODE_XSR_LEND;
	      if (Field_sr_Slot_inst_get (insn) == 2)
		return OPCODE_XSR_LCOUNT;
	      if (Field_sr_Slot_inst_get (insn) == 3)
		return OPCODE_XSR_SAR;
	      if (Field_sr_Slot_inst_get (insn) == 4)
		return OPCODE_XSR_BR;
	      if (Field_sr_Slot_inst_get (insn) == 5)
		return OPCODE_XSR_LITBASE;
	      if (Field_sr_Slot_inst_get (insn) == 12)
		return OPCODE_XSR_SCOMPARE1;
	      if (Field_sr_Slot_inst_get (insn) == 16)
		return OPCODE_XSR_ACCLO;
	      if (Field_sr_Slot_inst_get (insn) == 17)
		return OPCODE_XSR_ACCHI;
	      if (Field_sr_Slot_inst_get (insn) == 32)
		return OPCODE_XSR_M0;
	      if (Field_sr_Slot_inst_get (insn) == 33)
		return OPCODE_XSR_M1;
	      if (Field_sr_Slot_inst_get (insn) == 34)
		return OPCODE_XSR_M2;
	      if (Field_sr_Slot_inst_get (insn) == 35)
		return OPCODE_XSR_M3;
	      if (Field_sr_Slot_inst_get (insn) == 40)
		return OPCODE_XSR_PREFCTL;
	      if (Field_sr_Slot_inst_get (insn) == 72)
		return OPCODE_XSR_WINDOWBASE;
	      if (Field_sr_Slot_inst_get (insn) == 73)
		return OPCODE_XSR_WINDOWSTART;
	      if (Field_sr_Slot_inst_get (insn) == 83)
		return OPCODE_XSR_PTEVADDR;
	      if (Field_sr_Slot_inst_get (insn) == 90)
		return OPCODE_XSR_RASID;
	      if (Field_sr_Slot_inst_get (insn) == 91)
		return OPCODE_XSR_ITLBCFG;
	      if (Field_sr_Slot_inst_get (insn) == 92)
		return OPCODE_XSR_DTLBCFG;
	      if (Field_sr_Slot_inst_get (insn) == 96)
		return OPCODE_XSR_IBREAKENABLE;
	      if (Field_sr_Slot_inst_get (insn) == 97)
		return OPCODE_XSR_MEMCTL;
	      if (Field_sr_Slot_inst_get (insn) == 99)
		return OPCODE_XSR_ATOMCTL;
	      if (Field_sr_Slot_inst_get (insn) == 104)
		return OPCODE_XSR_DDR;
	      if (Field_sr_Slot_inst_get (insn) == 128)
		return OPCODE_XSR_IBREAKA0;
	      if (Field_sr_Slot_inst_get (insn) == 129)
		return OPCODE_XSR_IBREAKA1;
	      if (Field_sr_Slot_inst_get (insn) == 144)
		return OPCODE_XSR_DBREAKA0;
	      if (Field_sr_Slot_inst_get (insn) == 145)
		return OPCODE_XSR_DBREAKA1;
	      if (Field_sr_Slot_inst_get (insn) == 160)
		return OPCODE_XSR_DBREAKC0;
	      if (Field_sr_Slot_inst_get (insn) == 161)
		return OPCODE_XSR_DBREAKC1;
	      if (Field_sr_Slot_inst_get (insn) == 177)
		return OPCODE_XSR_EPC1;
	      if (Field_sr_Slot_inst_get (insn) == 178)
		return OPCODE_XSR_EPC2;
	      if (Field_sr_Slot_inst_get (insn) == 179)
		return OPCODE_XSR_EPC3;
	      if (Field_sr_Slot_inst_get (insn) == 180)
		return OPCODE_XSR_EPC4;
	      if (Field_sr_Slot_inst_get (insn) == 181)
		return OPCODE_XSR_EPC5;
	      if (Field_sr_Slot_inst_get (insn) == 182)
		return OPCODE_XSR_EPC6;
	      if (Field_sr_Slot_inst_get (insn) == 183)
		return OPCODE_XSR_EPC7;
	      if (Field_sr_Slot_inst_get (insn) == 192)
		return OPCODE_XSR_DEPC;
	      if (Field_sr_Slot_inst_get (insn) == 194)
		return OPCODE_XSR_EPS2;
	      if (Field_sr_Slot_inst_get (insn) == 195)
		return OPCODE_XSR_EPS3;
	      if (Field_sr_Slot_inst_get (insn) == 196)
		return OPCODE_XSR_EPS4;
	      if (Field_sr_Slot_inst_get (insn) == 197)
		return OPCODE_XSR_EPS5;
	      if (Field_sr_Slot_inst_get (insn) == 198)
		return OPCODE_XSR_EPS6;
	      if (Field_sr_Slot_inst_get (insn) == 199)
		return OPCODE_XSR_EPS7;
	      if (Field_sr_Slot_inst_get (insn) == 209)
		return OPCODE_XSR_EXCSAVE1;
	      if (Field_sr_Slot_inst_get (insn) == 210)
		return OPCODE_XSR_EXCSAVE2;
	      if (Field_sr_Slot_inst_get (insn) == 211)
		return OPCODE_XSR_EXCSAVE3;
	      if (Field_sr_Slot_inst_get (insn) == 212)
		return OPCODE_XSR_EXCSAVE4;
	      if (Field_sr_Slot_inst_get (insn) == 213)
		return OPCODE_XSR_EXCSAVE5;
	      if (Field_sr_Slot_inst_get (insn) == 214)
		return OPCODE_XSR_EXCSAVE6;
	      if (Field_sr_Slot_inst_get (insn) == 215)
		return OPCODE_XSR_EXCSAVE7;
	      if (Field_sr_Slot_inst_get (insn) == 224)
		return OPCODE_XSR_CPENABLE;
	      if (Field_sr_Slot_inst_get (insn) == 228)
		return OPCODE_XSR_INTENABLE;
	      if (Field_sr_Slot_inst_get (insn) == 230)
		return OPCODE_XSR_PS;
	      if (Field_sr_Slot_inst_get (insn) == 231)
		return OPCODE_XSR_VECBASE;
	      if (Field_sr_Slot_inst_get (insn) == 232)
		return OPCODE_XSR_EXCCAUSE;
	      if (Field_sr_Slot_inst_get (insn) == 233)
		return OPCODE_XSR_DEBUGCAUSE;
	      if (Field_sr_Slot_inst_get (insn) == 234)
		return OPCODE_XSR_CCOUNT;
	      if (Field_sr_Slot_inst_get (insn) == 236)
		return OPCODE_XSR_ICOUNT;
	      if (Field_sr_Slot_inst_get (insn) == 237)
		return OPCODE_XSR_ICOUNTLEVEL;
	      if (Field_sr_Slot_inst_get (insn) == 238)
		return OPCODE_XSR_EXCVADDR;
	      if (Field_sr_Slot_inst_get (insn) == 240)
		return OPCODE_XSR_CCOMPARE0;
	      if (Field_sr_Slot_inst_get (insn) == 241)
		return OPCODE_XSR_CCOMPARE1;
	      if (Field_sr_Slot_inst_get (insn) == 242)
		return OPCODE_XSR_CCOMPARE2;
	      if (Field_sr_Slot_inst_get (insn) == 244)
		return OPCODE_XSR_MISC0;
	      if (Field_sr_Slot_inst_get (insn) == 245)
		return OPCODE_XSR_MISC1;
	    }
	  if (Field_op2_Slot_inst_get (insn) == 8)
	    return OPCODE_SRC;
	  if (Field_op2_Slot_inst_get (insn) == 9 &&
	      Field_s_Slot_inst_get (insn) == 0)
	    return OPCODE_SRL;
	  if (Field_op2_Slot_inst_get (insn) == 10 &&
	      Field_t_Slot_inst_get (insn) == 0)
	    return OPCODE_SLL;
	  if (Field_op2_Slot_inst_get (insn) == 11 &&
	      Field_s_Slot_inst_get (insn) == 0)
	    return OPCODE_SRA;
	  if (Field_op2_Slot_inst_get (insn) == 12)
	    return OPCODE_MUL16U;
	  if (Field_op2_Slot_inst_get (insn) == 13)
	    return OPCODE_MUL16S;
	  if (Field_op2_Slot_inst_get (insn) == 15)
	    {
	      if (Field_r_Slot_inst_get (insn) == 0)
		return OPCODE_LICT;
	      if (Field_r_Slot_inst_get (insn) == 1)
		return OPCODE_SICT;
	      if (Field_r_Slot_inst_get (insn) == 2)
		return OPCODE_LICW;
	      if (Field_r_Slot_inst_get (insn) == 3)
		return OPCODE_SICW;
	      if (Field_r_Slot_inst_get (insn) == 8)
		return OPCODE_LDCT;
	      if (Field_r_Slot_inst_get (insn) == 9)
		return OPCODE_SDCT;
	      if (Field_r_Slot_inst_get (insn) == 14 &&
		  Field_t_Slot_inst_get (insn) == 0)
		return OPCODE_RFDO;
	      if (Field_r_Slot_inst_get (insn) == 14 &&
		  Field_t_Slot_inst_get (insn) == 1)
		return OPCODE_RFDD;
	      if (Field_r_Slot_inst_get (insn) == 15)
		return OPCODE_LDPTE;
	    }
	}
      if (Field_op1_Slot_inst_get (insn) == 2)
	{
	  if (Field_op2_Slot_inst_get (insn) == 0)
	    return OPCODE_ANDB;
	  if (Field_op2_Slot_inst_get (insn) == 1)
	    return OPCODE_ANDBC;
	  if (Field_op2_Slot_inst_get (insn) == 2)
	    return OPCODE_ORB;
	  if (Field_op2_Slot_inst_get (insn) == 3)
	    return OPCODE_ORBC;
	  if (Field_op2_Slot_inst_get (insn) == 4)
	    return OPCODE_XORB;
	  if (Field_op2_Slot_inst_get (insn) == 8)
	    return OPCODE_MULL;
	  if (Field_op2_Slot_inst_get (insn) == 10)
	    return OPCODE_MULUH;
	  if (Field_op2_Slot_inst_get (insn) == 11)
	    return OPCODE_MULSH;
	  if (Field_op2_Slot_inst_get (insn) == 12)
	    return OPCODE_QUOU;
	  if (Field_op2_Slot_inst_get (insn) == 13)
	    return OPCODE_QUOS;
	  if (Field_op2_Slot_inst_get (insn) == 14)
	    return OPCODE_REMU;
	  if (Field_op2_Slot_inst_get (insn) == 15)
	    return OPCODE_REMS;
	}
      if (Field_op1_Slot_inst_get (insn) == 3)
	{
	  if (Field_op2_Slot_inst_get (insn) == 0)
	    {
	      if (Field_sr_Slot_inst_get (insn) == 0)
		return OPCODE_RSR_LBEG;
	      if (Field_sr_Slot_inst_get (insn) == 1)
		return OPCODE_RSR_LEND;
	      if (Field_sr_Slot_inst_get (insn) == 2)
		return OPCODE_RSR_LCOUNT;
	      if (Field_sr_Slot_inst_get (insn) == 3)
		return OPCODE_RSR_SAR;
	      if (Field_sr_Slot_inst_get (insn) == 4)
		return OPCODE_RSR_BR;
	      if (Field_sr_Slot_inst_get (insn) == 5)
		return OPCODE_RSR_LITBASE;
	      if (Field_sr_Slot_inst_get (insn) == 12)
		return OPCODE_RSR_SCOMPARE1;
	      if (Field_sr_Slot_inst_get (insn) == 16)
		return OPCODE_RSR_ACCLO;
	      if (Field_sr_Slot_inst_get (insn) == 17)
		return OPCODE_RSR_ACCHI;
	      if (Field_sr_Slot_inst_get (insn) == 32)
		return OPCODE_RSR_M0;
	      if (Field_sr_Slot_inst_get (insn) == 33)
		return OPCODE_RSR_M1;
	      if (Field_sr_Slot_inst_get (insn) == 34)
		return OPCODE_RSR_M2;
	      if (Field_sr_Slot_inst_get (insn) == 35)
		return OPCODE_RSR_M3;
	      if (Field_sr_Slot_inst_get (insn) == 40)
		return OPCODE_RSR_PREFCTL;
	      if (Field_sr_Slot_inst_get (insn) == 72)
		return OPCODE_RSR_WINDOWBASE;
	      if (Field_sr_Slot_inst_get (insn) == 73)
		return OPCODE_RSR_WINDOWSTART;
	      if (Field_sr_Slot_inst_get (insn) == 83)
		return OPCODE_RSR_PTEVADDR;
	      if (Field_sr_Slot_inst_get (insn) == 90)
		return OPCODE_RSR_RASID;
	      if (Field_sr_Slot_inst_get (insn) == 91)
		return OPCODE_RSR_ITLBCFG;
	      if (Field_sr_Slot_inst_get (insn) == 92)
		return OPCODE_RSR_DTLBCFG;
	      if (Field_sr_Slot_inst_get (insn) == 96)
		return OPCODE_RSR_IBREAKENABLE;
	      if (Field_sr_Slot_inst_get (insn) == 97)
		return OPCODE_RSR_MEMCTL;
	      if (Field_sr_Slot_inst_get (insn) == 99)
		return OPCODE_RSR_ATOMCTL;
	      if (Field_sr_Slot_inst_get (insn) == 104)
		return OPCODE_RSR_DDR;
	      if (Field_sr_Slot_inst_get (insn) == 128)
		return OPCODE_RSR_IBREAKA0;
	      if (Field_sr_Slot_inst_get (insn) == 129)
		return OPCODE_RSR_IBREAKA1;
	      if (Field_sr_Slot_inst_get (insn) == 144)
		return OPCODE_RSR_DBREAKA0;
	      if (Field_sr_Slot_inst_get (insn) == 145)
		return OPCODE_RSR_DBREAKA1;
	      if (Field_sr_Slot_inst_get (insn) == 160)
		return OPCODE_RSR_DBREAKC0;
	      if (Field_sr_Slot_inst_get (insn) == 161)
		return OPCODE_RSR_DBREAKC1;
	      if (Field_sr_Slot_inst_get (insn) == 176)
		return OPCODE_RSR_CONFIGID0;
	      if (Field_sr_Slot_inst_get (insn) == 177)
		return OPCODE_RSR_EPC1;
	      if (Field_sr_Slot_inst_get (insn) == 178)
		return OPCODE_RSR_EPC2;
	      if (Field_sr_Slot_inst_get (insn) == 179)
		return OPCODE_RSR_EPC3;
	      if (Field_sr_Slot_inst_get (insn) == 180)
		return OPCODE_RSR_EPC4;
	      if (Field_sr_Slot_inst_get (insn) == 181)
		return OPCODE_RSR_EPC5;
	      if (Field_sr_Slot_inst_get (insn) == 182)
		return OPCODE_RSR_EPC6;
	      if (Field_sr_Slot_inst_get (insn) == 183)
		return OPCODE_RSR_EPC7;
	      if (Field_sr_Slot_inst_get (insn) == 192)
		return OPCODE_RSR_DEPC;
	      if (Field_sr_Slot_inst_get (insn) == 194)
		return OPCODE_RSR_EPS2;
	      if (Field_sr_Slot_inst_get (insn) == 195)
		return OPCODE_RSR_EPS3;
	      if (Field_sr_Slot_inst_get (insn) == 196)
		return OPCODE_RSR_EPS4;
	      if (Field_sr_Slot_inst_get (insn) == 197)
		return OPCODE_RSR_EPS5;
	      if (Field_sr_Slot_inst_get (insn) == 198)
		return OPCODE_RSR_EPS6;
	      if (Field_sr_Slot_inst_get (insn) == 199)
		return OPCODE_RSR_EPS7;
	      if (Field_sr_Slot_inst_get (insn) == 208)
		return OPCODE_RSR_CONFIGID1;
	      if (Field_sr_Slot_inst_get (insn) == 209)
		return OPCODE_RSR_EXCSAVE1;
	      if (Field_sr_Slot_inst_get (insn) == 210)
		return OPCODE_RSR_EXCSAVE2;
	      if (Field_sr_Slot_inst_get (insn) == 211)
		return OPCODE_RSR_EXCSAVE3;
	      if (Field_sr_Slot_inst_get (insn) == 212)
		return OPCODE_RSR_EXCSAVE4;
	      if (Field_sr_Slot_inst_get (insn) == 213)
		return OPCODE_RSR_EXCSAVE5;
	      if (Field_sr_Slot_inst_get (insn) == 214)
		return OPCODE_RSR_EXCSAVE6;
	      if (Field_sr_Slot_inst_get (insn) == 215)
		return OPCODE_RSR_EXCSAVE7;
	      if (Field_sr_Slot_inst_get (insn) == 224)
		return OPCODE_RSR_CPENABLE;
	      if (Field_sr_Slot_inst_get (insn) == 226)
		return OPCODE_RSR_INTERRUPT;
	      if (Field_sr_Slot_inst_get (insn) == 228)
		return OPCODE_RSR_INTENABLE;
	      if (Field_sr_Slot_inst_get (insn) == 230)
		return OPCODE_RSR_PS;
	      if (Field_sr_Slot_inst_get (insn) == 231)
		return OPCODE_RSR_VECBASE;
	      if (Field_sr_Slot_inst_get (insn) == 232)
		return OPCODE_RSR_EXCCAUSE;
	      if (Field_sr_Slot_inst_get (insn) == 233)
		return OPCODE_RSR_DEBUGCAUSE;
	      if (Field_sr_Slot_inst_get (insn) == 234)
		return OPCODE_RSR_CCOUNT;
	      if (Field_sr_Slot_inst_get (insn) == 235)
		return OPCODE_RSR_PRID;
	      if (Field_sr_Slot_inst_get (insn) == 236)
		return OPCODE_RSR_ICOUNT;
	      if (Field_sr_Slot_inst_get (insn) == 237)
		return OPCODE_RSR_ICOUNTLEVEL;
	      if (Field_sr_Slot_inst_get (insn) == 238)
		return OPCODE_RSR_EXCVADDR;
	      if (Field_sr_Slot_inst_get (insn) == 240)
		return OPCODE_RSR_CCOMPARE0;
	      if (Field_sr_Slot_inst_get (insn) == 241)
		return OPCODE_RSR_CCOMPARE1;
	      if (Field_sr_Slot_inst_get (insn) == 242)
		return OPCODE_RSR_CCOMPARE2;
	      if (Field_sr_Slot_inst_get (insn) == 243)
		return OPCODE_RSR_243;
	      if (Field_sr_Slot_inst_get (insn) == 244)
		return OPCODE_RSR_MISC0;
	      if (Field_sr_Slot_inst_get (insn) == 245)
		return OPCODE_RSR_MISC1;
	    }
	  if (Field_op2_Slot_inst_get (insn) == 1)
	    {
	      if (Field_sr_Slot_inst_get (insn) == 0)
		return OPCODE_WSR_LBEG;
	      if (Field_sr_Slot_inst_get (insn) == 1)
		return OPCODE_WSR_LEND;
	      if (Field_sr_Slot_inst_get (insn) == 2)
		return OPCODE_WSR_LCOUNT;
	      if (Field_sr_Slot_inst_get (insn) == 3)
		return OPCODE_WSR_SAR;
	      if (Field_sr_Slot_inst_get (insn) == 4)
		return OPCODE_WSR_BR;
	      if (Field_sr_Slot_inst_get (insn) == 5)
		return OPCODE_WSR_LITBASE;
	      if (Field_sr_Slot_inst_get (insn) == 12)
		return OPCODE_WSR_SCOMPARE1;
	      if (Field_sr_Slot_inst_get (insn) == 16)
		return OPCODE_WSR_ACCLO;
	      if (Field_sr_Slot_inst_get (insn) == 17)
		return OPCODE_WSR_ACCHI;
	      if (Field_sr_Slot_inst_get (insn) == 32)
		return OPCODE_WSR_M0;
	      if (Field_sr_Slot_inst_get (insn) == 33)
		return OPCODE_WSR_M1;
	      if (Field_sr_Slot_inst_get (insn) == 34)
		return OPCODE_WSR_M2;
	      if (Field_sr_Slot_inst_get (insn) == 35)
		return OPCODE_WSR_M3;
	      if (Field_sr_Slot_inst_get (insn) == 40)
		return OPCODE_WSR_PREFCTL;
	      if (Field_sr_Slot_inst_get (insn) == 72)
		return OPCODE_WSR_WINDOWBASE;
	      if (Field_sr_Slot_inst_get (insn) == 73)
		return OPCODE_WSR_WINDOWSTART;
	      if (Field_sr_Slot_inst_get (insn) == 83)
		return OPCODE_WSR_PTEVADDR;
	      if (Field_sr_Slot_inst_get (insn) == 89)
		return OPCODE_WSR_MMID;
	      if (Field_sr_Slot_inst_get (insn) == 90)
		return OPCODE_WSR_RASID;
	      if (Field_sr_Slot_inst_get (insn) == 91)
		return OPCODE_WSR_ITLBCFG;
	      if (Field_sr_Slot_inst_get (insn) == 92)
		return OPCODE_WSR_DTLBCFG;
	      if (Field_sr_Slot_inst_get (insn) == 96)
		return OPCODE_WSR_IBREAKENABLE;
	      if (Field_sr_Slot_inst_get (insn) == 97)
		return OPCODE_WSR_MEMCTL;
	      if (Field_sr_Slot_inst_get (insn) == 99)
		return OPCODE_WSR_ATOMCTL;
	      if (Field_sr_Slot_inst_get (insn) == 104)
		return OPCODE_WSR_DDR;
	      if (Field_sr_Slot_inst_get (insn) == 128)
		return OPCODE_WSR_IBREAKA0;
	      if (Field_sr_Slot_inst_get (insn) == 129)
		return OPCODE_WSR_IBREAKA1;
	      if (Field_sr_Slot_inst_get (insn) == 144)
		return OPCODE_WSR_DBREAKA0;
	      if (Field_sr_Slot_inst_get (insn) == 145)
		return OPCODE_WSR_DBREAKA1;
	      if (Field_sr_Slot_inst_get (insn) == 160)
		return OPCODE_WSR_DBREAKC0;
	      if (Field_sr_Slot_inst_get (insn) == 161)
		return OPCODE_WSR_DBREAKC1;
	      if (Field_sr_Slot_inst_get (insn) == 176)
		return OPCODE_WSR_CONFIGID0;
	      if (Field_sr_Slot_inst_get (insn) == 177)
		return OPCODE_WSR_EPC1;
	      if (Field_sr_Slot_inst_get (insn) == 178)
		return OPCODE_WSR_EPC2;
	      if (Field_sr_Slot_inst_get (insn) == 179)
		return OPCODE_WSR_EPC3;
	      if (Field_sr_Slot_inst_get (insn) == 180)
		return OPCODE_WSR_EPC4;
	      if (Field_sr_Slot_inst_get (insn) == 181)
		return OPCODE_WSR_EPC5;
	      if (Field_sr_Slot_inst_get (insn) == 182)
		return OPCODE_WSR_EPC6;
	      if (Field_sr_Slot_inst_get (insn) == 183)
		return OPCODE_WSR_EPC7;
	      if (Field_sr_Slot_inst_get (insn) == 192)
		return OPCODE_WSR_DEPC;
	      if (Field_sr_Slot_inst_get (insn) == 194)
		return OPCODE_WSR_EPS2;
	      if (Field_sr_Slot_inst_get (insn) == 195)
		return OPCODE_WSR_EPS3;
	      if (Field_sr_Slot_inst_get (insn) == 196)
		return OPCODE_WSR_EPS4;
	      if (Field_sr_Slot_inst_get (insn) == 197)
		return OPCODE_WSR_EPS5;
	      if (Field_sr_Slot_inst_get (insn) == 198)
		return OPCODE_WSR_EPS6;
	      if (Field_sr_Slot_inst_get (insn) == 199)
		return OPCODE_WSR_EPS7;
	      if (Field_sr_Slot_inst_get (insn) == 209)
		return OPCODE_WSR_EXCSAVE1;
	      if (Field_sr_Slot_inst_get (insn) == 210)
		return OPCODE_WSR_EXCSAVE2;
	      if (Field_sr_Slot_inst_get (insn) == 211)
		return OPCODE_WSR_EXCSAVE3;
	      if (Field_sr_Slot_inst_get (insn) == 212)
		return OPCODE_WSR_EXCSAVE4;
	      if (Field_sr_Slot_inst_get (insn) == 213)
		return OPCODE_WSR_EXCSAVE5;
	      if (Field_sr_Slot_inst_get (insn) == 214)
		return OPCODE_WSR_EXCSAVE6;
	      if (Field_sr_Slot_inst_get (insn) == 215)
		return OPCODE_WSR_EXCSAVE7;
	      if (Field_sr_Slot_inst_get (insn) == 224)
		return OPCODE_WSR_CPENABLE;
	      if (Field_sr_Slot_inst_get (insn) == 226)
		return OPCODE_WSR_INTSET;
	      if (Field_sr_Slot_inst_get (insn) == 227)
		return OPCODE_WSR_INTCLEAR;
	      if (Field_sr_Slot_inst_get (insn) == 228)
		return OPCODE_WSR_INTENABLE;
	      if (Field_sr_Slot_inst_get (insn) == 230)
		return OPCODE_WSR_PS;
	      if (Field_sr_Slot_inst_get (insn) == 231)
		return OPCODE_WSR_VECBASE;
	      if (Field_sr_Slot_inst_get (insn) == 232)
		return OPCODE_WSR_EXCCAUSE;
	      if (Field_sr_Slot_inst_get (insn) == 233)
		return OPCODE_WSR_DEBUGCAUSE;
	      if (Field_sr_Slot_inst_get (insn) == 234)
		return OPCODE_WSR_CCOUNT;
	      if (Field_sr_Slot_inst_get (insn) == 236)
		return OPCODE_WSR_ICOUNT;
	      if (Field_sr_Slot_inst_get (insn) == 237)
		return OPCODE_WSR_ICOUNTLEVEL;
	      if (Field_sr_Slot_inst_get (insn) == 238)
		return OPCODE_WSR_EXCVADDR;
	      if (Field_sr_Slot_inst_get (insn) == 240)
		return OPCODE_WSR_CCOMPARE0;
	      if (Field_sr_Slot_inst_get (insn) == 241)
		return OPCODE_WSR_CCOMPARE1;
	      if (Field_sr_Slot_inst_get (insn) == 242)
		return OPCODE_WSR_CCOMPARE2;
	      if (Field_sr_Slot_inst_get (insn) == 244)
		return OPCODE_WSR_MISC0;
	      if (Field_sr_Slot_inst_get (insn) == 245)
		return OPCODE_WSR_MISC1;
	    }
	  if (Field_op2_Slot_inst_get (insn) == 2)
	    return OPCODE_SEXT;
	  if (Field_op2_Slot_inst_get (insn) == 3)
	    return OPCODE_CLAMPS;
	  if (Field_op2_Slot_inst_get (insn) == 4)
	    return OPCODE_MIN;
	  if (Field_op2_Slot_inst_get (insn) == 5)
	    return OPCODE_MAX;
	  if (Field_op2_Slot_inst_get (insn) == 6)
	    return OPCODE_MINU;
	  if (Field_op2_Slot_inst_get (insn) == 7)
	    return OPCODE_MAXU;
	  if (Field_op2_Slot_inst_get (insn) == 8)
	    return OPCODE_MOVEQZ;
	  if (Field_op2_Slot_inst_get (insn) == 9)
	    return OPCODE_MOVNEZ;
	  if (Field_op2_Slot_inst_get (insn) == 10)
	    return OPCODE_MOVLTZ;
	  if (Field_op2_Slot_inst_get (insn) == 11)
	    return OPCODE_MOVGEZ;
	  if (Field_op2_Slot_inst_get (insn) == 12)
	    return OPCODE_MOVF;
	  if (Field_op2_Slot_inst_get (insn) == 13)
	    return OPCODE_MOVT;
	  if (Field_op2_Slot_inst_get (insn) == 14)
	    {
	      if (Field_st_Slot_inst_get (insn) == 230)
		return OPCODE_RUR_EXPSTATE;
	      if (Field_st_Slot_inst_get (insn) == 231)
		return OPCODE_RUR_THREADPTR;
	      if (Field_st_Slot_inst_get (insn) == 240)
		return OPCODE_RUR_AE_OVF_SAR;
	      if (Field_st_Slot_inst_get (insn) == 241)
		return OPCODE_RUR_AE_BITHEAD;
	      if (Field_st_Slot_inst_get (insn) == 242)
		return OPCODE_RUR_AE_TS_FTS_BU_BP;
	      if (Field_st_Slot_inst_get (insn) == 243)
		return OPCODE_RUR_AE_SD_NO;
	      if (Field_st_Slot_inst_get (insn) == 246)
		return OPCODE_RUR_AE_CBEGIN0;
	      if (Field_st_Slot_inst_get (insn) == 247)
		return OPCODE_RUR_AE_CEND0;
	    }
	  if (Field_op2_Slot_inst_get (insn) == 15)
	    {
	      if (Field_sr_Slot_inst_get (insn) == 230)
		return OPCODE_WUR_EXPSTATE;
	      if (Field_sr_Slot_inst_get (insn) == 231)
		return OPCODE_WUR_THREADPTR;
	      if (Field_sr_Slot_inst_get (insn) == 240)
		return OPCODE_WUR_AE_OVF_SAR;
	      if (Field_sr_Slot_inst_get (insn) == 241)
		return OPCODE_WUR_AE_BITHEAD;
	      if (Field_sr_Slot_inst_get (insn) == 242)
		return OPCODE_WUR_AE_TS_FTS_BU_BP;
	      if (Field_sr_Slot_inst_get (insn) == 243)
		return OPCODE_WUR_AE_SD_NO;
	      if (Field_sr_Slot_inst_get (insn) == 246)
		return OPCODE_WUR_AE_CBEGIN0;
	      if (Field_sr_Slot_inst_get (insn) == 247)
		return OPCODE_WUR_AE_CEND0;
	    }
	}
      if ((Field_op1_Slot_inst_get (insn) == 4 ||
	   Field_op1_Slot_inst_get (insn) == 5))
	return OPCODE_EXTUI;
      if (Field_op1_Slot_inst_get (insn) == 9)
	{
	  if (Field_op2_Slot_inst_get (insn) == 0)
	    return OPCODE_L32E;
	  if (Field_op2_Slot_inst_get (insn) == 4)
	    return OPCODE_S32E;
	  if (Field_op2_Slot_inst_get (insn) == 5)
	    return OPCODE_S32NB;
	}
      if (Field_r_Slot_inst_get (insn) == 0 &&
	  Field_s_Slot_inst_get (insn) == 0 &&
	  Field_op2_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 14)
	return OPCODE_READ_IMPWIRE;
      if (Field_r_Slot_inst_get (insn) == 1 &&
	  Field_s3to1_Slot_inst_get (insn) == 0 &&
	  Field_op2_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 14)
	return OPCODE_SETB_EXPSTATE;
      if (Field_r_Slot_inst_get (insn) == 1 &&
	  Field_s3to1_Slot_inst_get (insn) == 1 &&
	  Field_op2_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 14)
	return OPCODE_CLRB_EXPSTATE;
      if (Field_r_Slot_inst_get (insn) == 2 &&
	  Field_op2_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 14)
	return OPCODE_WRMSK_EXPSTATE;
    }
  if (Field_op0_Slot_inst_get (insn) == 1)
    return OPCODE_L32R;
  if (Field_op0_Slot_inst_get (insn) == 2)
    {
      if (Field_r_Slot_inst_get (insn) == 0)
	return OPCODE_L8UI;
      if (Field_r_Slot_inst_get (insn) == 1)
	return OPCODE_L16UI;
      if (Field_r_Slot_inst_get (insn) == 2)
	return OPCODE_L32I;
      if (Field_r_Slot_inst_get (insn) == 4)
	return OPCODE_S8I;
      if (Field_r_Slot_inst_get (insn) == 5)
	return OPCODE_S16I;
      if (Field_r_Slot_inst_get (insn) == 6)
	return OPCODE_S32I;
      if (Field_r_Slot_inst_get (insn) == 7)
	{
	  if (Field_t_Slot_inst_get (insn) == 0)
	    return OPCODE_DPFR;
	  if (Field_t_Slot_inst_get (insn) == 1)
	    return OPCODE_DPFW;
	  if (Field_t_Slot_inst_get (insn) == 2)
	    return OPCODE_DPFRO;
	  if (Field_t_Slot_inst_get (insn) == 3)
	    return OPCODE_DPFWO;
	  if (Field_t_Slot_inst_get (insn) == 4)
	    return OPCODE_DHWB;
	  if (Field_t_Slot_inst_get (insn) == 5)
	    return OPCODE_DHWBI;
	  if (Field_t_Slot_inst_get (insn) == 6)
	    return OPCODE_DHI;
	  if (Field_t_Slot_inst_get (insn) == 7)
	    return OPCODE_DII;
	  if (Field_t_Slot_inst_get (insn) == 8)
	    {
	      if (Field_op1_Slot_inst_get (insn) == 0)
		return OPCODE_DPFL;
	      if (Field_op1_Slot_inst_get (insn) == 2)
		return OPCODE_DHU;
	      if (Field_op1_Slot_inst_get (insn) == 3)
		return OPCODE_DIU;
	      if (Field_op1_Slot_inst_get (insn) == 4)
		return OPCODE_DIWB;
	      if (Field_op1_Slot_inst_get (insn) == 5)
		return OPCODE_DIWBI;
	      if (Field_op1_Slot_inst_get (insn) == 15 &&
		  Field_op2_Slot_inst_get (insn) == 0)
		return OPCODE_DIWBUI_P;
	    }
	  if (Field_t_Slot_inst_get (insn) == 12)
	    return OPCODE_IPF;
	  if (Field_t_Slot_inst_get (insn) == 13)
	    {
	      if (Field_op1_Slot_inst_get (insn) == 0)
		return OPCODE_IPFL;
	      if (Field_op1_Slot_inst_get (insn) == 2)
		return OPCODE_IHU;
	      if (Field_op1_Slot_inst_get (insn) == 3)
		return OPCODE_IIU;
	    }
	  if (Field_t_Slot_inst_get (insn) == 14)
	    return OPCODE_IHI;
	  if (Field_t_Slot_inst_get (insn) == 15)
	    return OPCODE_III;
	}
      if (Field_r_Slot_inst_get (insn) == 9)
	return OPCODE_L16SI;
      if (Field_r_Slot_inst_get (insn) == 10)
	return OPCODE_MOVI;
      if (Field_r_Slot_inst_get (insn) == 11)
	return OPCODE_L32AI;
      if (Field_r_Slot_inst_get (insn) == 12)
	return OPCODE_ADDI;
      if (Field_r_Slot_inst_get (insn) == 13)
	return OPCODE_ADDMI;
      if (Field_r_Slot_inst_get (insn) == 14)
	return OPCODE_S32C1I;
      if (Field_r_Slot_inst_get (insn) == 15)
	return OPCODE_S32RI;
    }
  if (Field_op0_Slot_inst_get (insn) == 4)
    {
      if (Field_ae_r10_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 1 &&
	  Field_op2_Slot_inst_get (insn) == 12)
	return OPCODE_AE_LQ56_I;
      if (Field_ae_r10_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 2 &&
	  Field_op2_Slot_inst_get (insn) == 12)
	return OPCODE_AE_LQ56_X;
      if (Field_ae_r10_Slot_inst_get (insn) == 1 &&
	  Field_op1_Slot_inst_get (insn) == 1 &&
	  Field_op2_Slot_inst_get (insn) == 12)
	return OPCODE_AE_LQ32F_I;
      if (Field_ae_r10_Slot_inst_get (insn) == 1 &&
	  Field_op1_Slot_inst_get (insn) == 2 &&
	  Field_op2_Slot_inst_get (insn) == 12)
	return OPCODE_AE_LQ32F_X;
      if (Field_ae_r10_Slot_inst_get (insn) == 2 &&
	  Field_op1_Slot_inst_get (insn) == 1 &&
	  Field_op2_Slot_inst_get (insn) == 12)
	return OPCODE_AE_LQ56_IU;
      if (Field_ae_r10_Slot_inst_get (insn) == 2 &&
	  Field_op1_Slot_inst_get (insn) == 2 &&
	  Field_op2_Slot_inst_get (insn) == 12)
	return OPCODE_AE_LQ56_XU;
      if (Field_ae_r10_Slot_inst_get (insn) == 2 &&
	  Field_op1_Slot_inst_get (insn) == 7 &&
	  Field_t_Slot_inst_get (insn) == 3 &&
	  Field_op2_Slot_inst_get (insn) == 14)
	return OPCODE_AE_CVTQ48A32S;
      if (Field_ae_r10_Slot_inst_get (insn) == 3 &&
	  Field_op1_Slot_inst_get (insn) == 1 &&
	  Field_op2_Slot_inst_get (insn) == 12)
	return OPCODE_AE_LQ32F_IU;
      if (Field_ae_r10_Slot_inst_get (insn) == 3 &&
	  Field_op1_Slot_inst_get (insn) == 2 &&
	  Field_op2_Slot_inst_get (insn) == 12)
	return OPCODE_AE_LQ32F_XU;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 5 &&
	  Field_op2_Slot_inst_get (insn) == 10)
	return OPCODE_AE_LP16F_I;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 9 &&
	  Field_op2_Slot_inst_get (insn) == 10)
	return OPCODE_AE_LP16F_IU;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 12 &&
	  Field_op2_Slot_inst_get (insn) == 10)
	return OPCODE_AE_LP16F_X;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 15 &&
	  Field_op2_Slot_inst_get (insn) == 10)
	return OPCODE_AE_LP16F_XU;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 6 &&
	  Field_op2_Slot_inst_get (insn) == 10)
	return OPCODE_AE_LP24F_I;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 10 &&
	  Field_op2_Slot_inst_get (insn) == 10)
	return OPCODE_AE_LP24F_IU;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 13 &&
	  Field_op2_Slot_inst_get (insn) == 10)
	return OPCODE_AE_LP24F_X;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 0 &&
	  Field_op2_Slot_inst_get (insn) == 11)
	return OPCODE_AE_LP24F_XU;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 7 &&
	  Field_op2_Slot_inst_get (insn) == 10)
	return OPCODE_AE_LP24X2F_I;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 11 &&
	  Field_op2_Slot_inst_get (insn) == 10)
	return OPCODE_AE_LP24X2F_IU;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 14 &&
	  Field_op2_Slot_inst_get (insn) == 10)
	return OPCODE_AE_LP24X2F_X;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 1 &&
	  Field_op2_Slot_inst_get (insn) == 11)
	return OPCODE_AE_LP24X2F_XU;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 2 &&
	  Field_op2_Slot_inst_get (insn) == 11)
	return OPCODE_AE_SP16X2F_I;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 5 &&
	  Field_op2_Slot_inst_get (insn) == 11)
	return OPCODE_AE_SP16X2F_IU;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 8 &&
	  Field_op2_Slot_inst_get (insn) == 11)
	return OPCODE_AE_SP16X2F_X;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 11 &&
	  Field_op2_Slot_inst_get (insn) == 11)
	return OPCODE_AE_SP16X2F_XU;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 3 &&
	  Field_op2_Slot_inst_get (insn) == 11)
	return OPCODE_AE_SP24X2F_I;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 6 &&
	  Field_op2_Slot_inst_get (insn) == 11)
	return OPCODE_AE_SP24X2F_IU;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 9 &&
	  Field_op2_Slot_inst_get (insn) == 11)
	return OPCODE_AE_SP24X2F_X;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 12 &&
	  Field_op2_Slot_inst_get (insn) == 11)
	return OPCODE_AE_SP24X2F_XU;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 4 &&
	  Field_op2_Slot_inst_get (insn) == 11)
	return OPCODE_AE_SP24S_L_I;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 7 &&
	  Field_op2_Slot_inst_get (insn) == 11)
	return OPCODE_AE_SP24S_L_IU;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 10 &&
	  Field_op2_Slot_inst_get (insn) == 11)
	return OPCODE_AE_SP24S_L_X;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 13 &&
	  Field_op2_Slot_inst_get (insn) == 11)
	return OPCODE_AE_SP24S_L_XU;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_ae_s3_Slot_inst_get (insn) == 0 &&
	  Field_t_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 9 &&
	  Field_op2_Slot_inst_get (insn) == 12)
	return OPCODE_AE_MOVP48;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_inst_get (insn) == 0 &&
	  Field_op2_Slot_inst_get (insn) == 12)
	return OPCODE_AE_MOVPA24X2;
      if (Field_ae_r3_Slot_inst_get (insn) == 0 &&
	  Field_t_Slot_inst_get (insn) == 0 &&
	  Field_op1_Slot_in