# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.storagecache.aio import StorageCacheManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestStorageCacheManagementAmlFilesystemsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(StorageCacheManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_aml_filesystems_list(self, resource_group):
        response = self.client.aml_filesystems.list(
            api_version="2025-07-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_aml_filesystems_list_by_resource_group(self, resource_group):
        response = self.client.aml_filesystems.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-07-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_aml_filesystems_begin_delete(self, resource_group):
        response = await (
            await self.client.aml_filesystems.begin_delete(
                resource_group_name=resource_group.name,
                aml_filesystem_name="str",
                api_version="2025-07-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_aml_filesystems_get(self, resource_group):
        response = await self.client.aml_filesystems.get(
            resource_group_name=resource_group.name,
            aml_filesystem_name="str",
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_aml_filesystems_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.aml_filesystems.begin_create_or_update(
                resource_group_name=resource_group.name,
                aml_filesystem_name="str",
                aml_filesystem={
                    "location": "str",
                    "clientInfo": {
                        "containerStorageInterface": {
                            "persistentVolume": "str",
                            "persistentVolumeClaim": "str",
                            "storageClass": "str",
                        },
                        "lustreVersion": "str",
                        "mgsAddress": "str",
                        "mountCommand": "str",
                    },
                    "encryptionSettings": {"keyEncryptionKey": {"keyUrl": "str", "sourceVault": {"id": "str"}}},
                    "filesystemSubnet": "str",
                    "health": {"state": "str", "statusCode": "str", "statusDescription": "str"},
                    "hsm": {
                        "archiveStatus": [
                            {
                                "filesystemPath": "str",
                                "status": {
                                    "errorCode": "str",
                                    "errorMessage": "str",
                                    "lastCompletionTime": "2020-02-20 00:00:00",
                                    "lastStartedTime": "2020-02-20 00:00:00",
                                    "percentComplete": 0,
                                    "state": "str",
                                },
                            }
                        ],
                        "settings": {
                            "container": "str",
                            "loggingContainer": "str",
                            "importPrefix": "/",
                            "importPrefixesInitial": ["str"],
                        },
                    },
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "maintenanceWindow": {"dayOfWeek": "str", "timeOfDayUTC": "str"},
                    "name": "str",
                    "provisioningState": "str",
                    "rootSquashSettings": {
                        "mode": "str",
                        "noSquashNidLists": "str",
                        "squashGID": 0,
                        "squashUID": 0,
                        "status": "str",
                    },
                    "sku": {"name": "str"},
                    "storageCapacityTiB": 0.0,
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "throughputProvisionedMBps": 0,
                    "type": "str",
                    "zones": ["str"],
                },
                api_version="2025-07-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_aml_filesystems_begin_update(self, resource_group):
        response = await (
            await self.client.aml_filesystems.begin_update(
                resource_group_name=resource_group.name,
                aml_filesystem_name="str",
                aml_filesystem={
                    "encryptionSettings": {"keyEncryptionKey": {"keyUrl": "str", "sourceVault": {"id": "str"}}},
                    "maintenanceWindow": {"dayOfWeek": "str", "timeOfDayUTC": "str"},
                    "rootSquashSettings": {
                        "mode": "str",
                        "noSquashNidLists": "str",
                        "squashGID": 0,
                        "squashUID": 0,
                        "status": "str",
                    },
                    "tags": {"str": "str"},
                },
                api_version="2025-07-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_aml_filesystems_archive(self, resource_group):
        response = await self.client.aml_filesystems.archive(
            resource_group_name=resource_group.name,
            aml_filesystem_name="str",
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_aml_filesystems_cancel_archive(self, resource_group):
        response = await self.client.aml_filesystems.cancel_archive(
            resource_group_name=resource_group.name,
            aml_filesystem_name="str",
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...
